/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.service.IProConsoleService;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.jumpmind.properties.TypedProperties;

public abstract class y
extends Dialog {
    private static final long serialVersionUID = 1L;
    protected I controller;
    protected IProConsoleService consoleService;
    protected long reminderInterval;
    protected static final String[] ITEMS = new String[]{"Tomorrow", "Next Week", "Never"};

    public y(I controller, long msUntilExpiration) {
        this.controller = controller;
        this.consoleService = controller.getProConsoleService();
        TypedProperties settings = this.consoleService.getSettings(controller.getConsoleUser().getUserId());
        this.setHeight("250px");
        this.setEnabled(true);
        this.setCloseOnEsc(false);
        this.setCloseOnOutsideClick(false);
        this.setResizable(false);
        VerticalLayout updateReminderLayout = new VerticalLayout();
        HorizontalLayout textLayout = new HorizontalLayout();
        HorizontalLayout comboBoxLayout = new HorizontalLayout();
        H3 message = new H3("");
        long days = msUntilExpiration / 86400000L;
        long hours = msUntilExpiration % 86400000L / 3600000L;
        message.getElement().setProperty("innerHTML", String.format(this.getReminderMessage(), days, days == 1L ? "" : "s", hours, hours == 1L ? "" : "s"));
        textLayout.add(new Component[]{message});
        textLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{message});
        HashMap<String, Long> stringToTimeMap = new HashMap<String, Long>();
        stringToTimeMap.put(ITEMS[0], 86400000L);
        stringToTimeMap.put(ITEMS[1], 604800000L);
        stringToTimeMap.put(ITEMS[2], -1L);
        String reminderIntervalString = this.getLastRemindInterval(settings);
        this.reminderInterval = reminderIntervalString != null ? Long.parseLong(reminderIntervalString) : 604800000L;
        ArrayList<String> itemList = new ArrayList<String>();
        String selectedItem = null;
        for (String item : ITEMS) {
            if (this.reminderInterval == (Long)stringToTimeMap.get(item)) {
                itemList.add(item);
                selectedItem = item;
                continue;
            }
            if (msUntilExpiration < (Long)stringToTimeMap.get(item)) continue;
            itemList.add(item);
        }
        if (selectedItem == null) {
            itemList.add(controller.getMessage("Later", new Object[0]));
            selectedItem = controller.getMessage("Later", new Object[0]);
        }
        Select remindIntervalField = new Select();
        remindIntervalField.setItems(itemList);
        remindIntervalField.setWidth("130px");
        remindIntervalField.setValue((Object)selectedItem);
        remindIntervalField.setEmptySelectionAllowed(false);
        Button dismiss = new Button("Dismiss", (ComponentEventListener & Serializable)event -> {
            String string = (String)remindIntervalField.getValue();
            if (!string.equalsIgnoreCase("Later")) {
                this.reminderInterval = (Long)stringToTimeMap.get(string);
            }
            TypedProperties newSettings = this.consoleService.getSettings(controller.getConsoleUser().getUserId());
            this.setLastRemindInterval(newSettings, this.reminderInterval);
            this.setLastRemindTime(newSettings, new Date().toString());
            this.consoleService.saveSettings(newSettings, controller.getConsoleUser().getUserId());
            this.close();
        });
        this.getFooter().add(new Component[]{dismiss});
        Span nextRemind = new Span("Remind me again:");
        comboBoxLayout.add(new Component[]{nextRemind});
        comboBoxLayout.add(new Component[]{remindIntervalField});
        comboBoxLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{nextRemind, remindIntervalField});
        updateReminderLayout.setHeight("150px");
        updateReminderLayout.setWidth("450px");
        updateReminderLayout.add(new Component[]{textLayout});
        updateReminderLayout.add(new Component[]{comboBoxLayout});
        updateReminderLayout.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{textLayout, comboBoxLayout});
        this.add(new Component[]{updateReminderLayout});
    }

    public long getReminderInterval() {
        return this.reminderInterval;
    }

    abstract String getReminderMessage();

    public abstract long getLastRemindTime(TypedProperties var1);

    abstract void setLastRemindTime(TypedProperties var1, String var2);

    abstract String getLastRemindInterval(TypedProperties var1);

    abstract void setLastRemindInterval(TypedProperties var1, long var2);
}

