/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Pre;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import java.io.Serializable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jumpmind.symmetric.web.FailedEngineInfo;
import org.jumpmind.symmetric.web.SymmetricEngineHolder;
import org.jumpmind.vaadin.ui.common.ResizableDialog;

public class x
extends ResizableDialog {
    private static final long serialVersionUID = 1L;

    public x(SymmetricEngineHolder holder, FailedEngineInfo info) {
        super("Engine Startup Failure");
        this.setHeight("700px");
        this.setWidth("800px");
        String engineName = info.getEngineName();
        this.add((Component)new HorizontalLayout(new Component[]{this.newSpan("Engine Name:"), new Span(engineName)}));
        this.add((Component)new HorizontalLayout(new Component[]{this.newSpan("Property File:"), new Span(info.getPropertyFileName())}));
        this.add((Component)new HorizontalLayout(new Component[]{this.newSpan("Error Message:"), new Span(info.getErrorMessage())}));
        Scroller stackTraceScroller = new Scroller();
        stackTraceScroller.setWidthFull();
        stackTraceScroller.getStyle().set("margin", "16px 0");
        stackTraceScroller.setClassName("thin-border");
        Pre stackTracePre = new Pre();
        if (info.getException() != null) {
            stackTracePre.setText(ExceptionUtils.getStackTrace((Throwable)info.getException()));
        }
        stackTracePre.setHeightFull();
        stackTracePre.getStyle().set("min-width", "max-content");
        stackTracePre.getStyle().set("margin", "0");
        stackTraceScroller.setContent((Component)stackTracePre);
        this.add((Component)stackTraceScroller, 1);
        Button restartButton = new Button("Restart Engine", (ComponentEventListener & Serializable)event -> {
            holder.restart(engineName);
            this.close();
        });
        Button copyButton = new Button("Copy to Clipboard", (ComponentEventListener & Serializable)event -> UI.getCurrent().getPage().executeJs("window.getSelection().selectAllChildren($0);document.execCommand('copy');window.getSelection().removeAllRanges();", new Serializable[]{stackTracePre}));
        this.buildButtonFooter(new Component[]{restartButton, copyButton, this.buildCloseButton()});
    }

    private Span newSpan(String text) {
        Span span = new Span(text);
        span.setClassName("bold");
        span.setWidth("120px");
        span.getStyle().set("min-width", "120px");
        return span;
    }
}

