/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.listbox.ListBox;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class u<T>
extends CustomField<T> {
    private static final long serialVersionUID = 1L;
    ListBox<T> leftBox = this.createListBox();
    ListBox<T> rightBox = this.createListBox();
    List<T> leftItems;
    List<T> rightItems;

    public u() {
        this(null);
    }

    public u(Collection<T> items) {
        if (items != null) {
            this.setItems(items);
        }
        HorizontalLayout layout = new HorizontalLayout(new Component[]{this.leftBox, this.rightBox});
        layout.setSpacing(false);
        this.add(new Component[]{layout});
    }

    private ListBox<T> createListBox() {
        ListBox listBox = new ListBox();
        listBox.setWidth("50%");
        listBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (event.isFromClient()) {
                this.setValue(event.getValue());
            }
        });
        return listBox;
    }

    public void setItems(Collection<T> newItems) {
        this.leftItems = new ArrayList<T>();
        this.rightItems = new ArrayList<T>();
        for (T newItem : newItems) {
            if (this.leftItems.size() == this.rightItems.size()) {
                this.leftItems.add(newItem);
                continue;
            }
            this.rightItems.add(newItem);
        }
        this.leftBox.setItems(this.leftItems);
        this.rightBox.setItems(this.rightItems);
    }

    public T getValue() {
        if (this.leftBox.getValue() != null) {
            return (T)this.leftBox.getValue();
        }
        return (T)this.rightBox.getValue();
    }

    public void setValue(T newValue) {
        if (this.leftItems.contains(newValue)) {
            this.leftBox.setValue(newValue);
            this.rightBox.setValue(null);
        } else if (this.rightItems.contains(newValue)) {
            this.leftBox.setValue(null);
            this.rightBox.setValue(newValue);
        } else {
            this.leftBox.setValue(null);
            this.rightBox.setValue(null);
        }
    }

    public void setRenderer(ComponentRenderer<? extends Component, T> renderer) {
        this.leftBox.setRenderer(renderer);
        this.rightBox.setRenderer(renderer);
    }

    protected T generateModelValue() {
        return this.getValue();
    }

    protected void setPresentationValue(T newPresentationValue) {
        this.setValue(newPresentationValue);
    }
}

