/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.impl.fq;
import com.jumpmind.symmetric.console.model.NodeEngine;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.M;
import com.jumpmind.symmetric.db.elasticsearch.ElasticSearchPlatformFactory;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.server.Command;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.JdbcDatabasePlatformFactory;
import org.jumpmind.db.platform.mssql.MsSql2000DatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.util.BasicDataSourceFactory;
import org.jumpmind.db.util.ResettableBasicDataSource;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ClientSymmetricEngine;
import org.jumpmind.symmetric.util.ModuleManager;
import org.jumpmind.symmetric.util.PropertiesUtil;
import org.jumpmind.symmetric.web.SymmetricEngineHolder;
import org.jumpmind.symmetric.wrapper.JavaAgent;
import org.jumpmind.util.AppUtils;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class s {
    public static final String OPTION_CDC_TRIGGER_BASED = "Trigger-based";
    public static final String OPTION_CDC_LOG_BASED = "Log-based";
    public static final String OPTION_CDC_TIME_BASED = "Time-based (read-only)";
    public static final String OPTION_CDC_NONE = "None (write-only)";
    public static final a ASE = new a("Sybase ASE", false, false, false, true, false);
    public static final a SQLANYWHERE = new a("Sybase SQL Anywhere");
    public static final a INFORMIX = new a("Informix");
    public static final a DB2 = new a("DB2 UDB & z/OS");
    public static final a DB2AS400 = new a("DB2 AS/400", false, false, true, false, false);
    public static final a POSTGRE_SQL = new a("PostgreSQL", false, false, true, true, true);
    public static final a GREENPLUM = new a("Greenplum", true, false, false, false, false, false);
    public static final a INTERBASE = new a("Interbase");
    public static final a FIREBIRD = new a("Firebird");
    public static final a SQL_SERVER = new a("SQL Server", false, false, true, true, false);
    public static final a SQL_SERVER_AZURE = new a("SQL Server Azure", false, false, true, true, false);
    public static final a H2 = new a("H2");
    public static final a HSQLDB = new a("HSQLDB");
    public static final a DERBY = new a("Derby (Apache DB)");
    public static final a ORACLE = new a("Oracle", false, false, true, true, false);
    public static final a MY_SQL = new a("MySQL", false, false, true, true, false);
    public static final a SQLITE = new a("SQLite");
    public static final a MARIADB = new a("MariaDB", false, false, true, true, false);
    public static final a REDSHIFT = new a("Redshift", false, true, false, true, false, false);
    public static final a VOLTDB = new a("VoltDB", true, false, false, false, false, false);
    public static final a NUODB = new a("NuoDB");
    public static final a TIBERO = new a("Tibero");
    public static final a RAIMA = new a("Raima");
    public static final a CASSANDRA = new a("Cassandra", true, false, false, false, false, false);
    public static final a KAFKA = new a("Kafka", true, true, false, false, false, false);
    public static final a RABBITMQ = new a("Rabbit MQ", true, true, false, false, false, false);
    public static final a ELASTICSEARCH = new a("Elasticsearch", true, false, false, true, true, false);
    public static final a OPENSEARCH = new a("Opensearch", true, true, false, true, true, false);
    public static final a SNOWFLAKE = new a("Snowflake", false, true, true, true, false, false);
    public static final a HBASE = new a("HBase", true, false, false, false, false, false);
    public static final a HANA = new a("SAP Hana", false, false, false, false, false);
    public static final a BIGQUERY = new a("Google Big Query", true, true, false, true, true, false);
    public static final a TERADATA = new a("Teradata", true, false, false, false, false, false);
    public static final a IGNITE = new a("Ignite", true, false, false, false, false, false);
    public static final a INGRES = new a("Ingres");
    public static final a MONGO = new a("MongoDB Atlas", false, true, true, true, true, false);
    public static final a COSMOS = new a("Cosmos", false, false, true, false, false, false);
    public static final a S3 = new a("Amazon S3", true, true, false, false, false, false);
    public static final a SINGLESTORE = new a("SingleStore", false, false, true, true, true, false);
    public static final a OPENEDGE = new a("Progress OpenEdge");
    public static final a EXASOL = new a("Exasol", true, false, false, false, false, false);
    public static final a SPARKSQL = new a("SparkSQL", true, false, false, false, false, false);
    public static final a DATABRICKS = new a("Databricks", true, false, false, false, false, false);
    public static final Map<a, String> databaseToDriverMap = new TreeMap<a, String>();
    public static final Map<a, String> databaseModuleIds = new TreeMap<a, String>();
    public static final Map<a, String> databaseToSampleUrlMap = new TreeMap<a, String>();
    public static final Map<a, String> databaseToDefaultPortMap = new TreeMap<a, String>();
    public static final Map<a, String> databaseToValidationQueryMap = new TreeMap<a, String>();
    public static final Map<a, String> databaseConnectionProperties = new TreeMap<a, String>();
    public static final Map<a, String> databaseInitSqlProperties = new TreeMap<a, String>();
    public static final Map<a, String> synchronizedJobsProperties = new TreeMap<a, String>();
    public static final Map<a, String> databaseNameMap = new LinkedHashMap<a, String>();
    public static final String ORACLE_SAMPLE_URL_WITH_SERVICE_NAME = "jdbc:oracle:thin:@//127.0.0.1:1521/databasename";
    static final Logger log;

    public static String testConnection(I controller, a databaseName, TextField databaseUrlField, String userId, String password, Command moduleInstallListener, Consumer<Boolean> shortcutToggler, boolean showSuccessNotification, boolean showFailureNotification, boolean showOtherNotifications, boolean canCallRecursive) {
        String databaseUrl = databaseUrlField.getValue();
        String driverClass = s.getDriverForDatabaseType(databaseName, databaseUrl);
        boolean missingAzurekvModule = false;
        String exceptionMessage = null;
        try {
            if (controller.getLicenseService().i() && !databaseName.equals(POSTGRE_SQL) && !databaseName.equals(SQL_SERVER) && !databaseName.equals(H2)) {
                if (showOtherNotifications) {
                    CommonUiUtils.notify((String)"This feature is not enabled in your license key.  Please contact sales@jumpmind.com for assistance.", shortcutToggler);
                }
                return "This feature is not enabled in your license key.  Please contact sales@jumpmind.com for assistance.";
            }
            if (databaseName.equals(BIGQUERY) || databaseName.equals(CASSANDRA) || databaseName.equals(KAFKA) || databaseName.equals(MONGO) || databaseName.equals(COSMOS) || databaseName.equals(OPENSEARCH) || databaseName.equals(S3)) {
                log.info("Checking driver class {} for database {}", (Object)driverClass, (Object)databaseName);
                Class.forName(driverClass);
            } else if (databaseName.equals(RABBITMQ)) {
                log.info("Checking driver class {} for {}", (Object)driverClass, (Object)databaseName);
                Class.forName(driverClass);
                log.info("Connecting to {} at URL {}", (Object)databaseName, (Object)databaseUrl);
                fq rabbitPlatform = new fq(new SqlTemplateSettings(), databaseUrl, password, userId);
                rabbitPlatform.a();
                if (showSuccessNotification) {
                    CommonUiUtils.notify((String)"Successfully connected to the database", shortcutToggler);
                }
            } else if (databaseName.equals(ELASTICSEARCH)) {
                if (!ModuleManager.getInstance().list().contains("elasticsearch")) {
                    log.info("Module is not installed for {}", (Object)databaseName);
                    throw new RuntimeException("No suitable driver");
                }
                log.info("Connecting to {} database at URL {}", (Object)databaseName, (Object)databaseUrl);
                ElasticSearchPlatformFactory connectionTest = new ElasticSearchPlatformFactory();
                connectionTest.canConnectToElastic(databaseUrl, password, userId);
                if (showSuccessNotification) {
                    CommonUiUtils.notify((String)"Successfully connected to the database", shortcutToggler);
                }
            } else {
                if (!databaseUrl.startsWith("jdbc:")) {
                    log.info("Database {} has invalid JDBC URL: {}", (Object)databaseName, (Object)databaseUrl);
                    if (showOtherNotifications) {
                        CommonUiUtils.notify((String)"A JDBC URL should always start with: jdbc:", shortcutToggler);
                    }
                    return "A JDBC URL should always start with: jdbc:";
                }
                if (StringUtils.isBlank((CharSequence)databaseName.toString())) {
                    if (showOtherNotifications) {
                        CommonUiUtils.notify((String)"Please choose a database", shortcutToggler);
                    }
                    return "Please choose a database";
                }
                log.info("Checking driver class {} for database {}", (Object)driverClass, (Object)databaseName);
                BasicDataSourceFactory.prepareDriver((String)driverClass);
                ResettableBasicDataSource dataSource = new ResettableBasicDataSource();
                dataSource.setInitialSize(1);
                dataSource.setMaxTotal(1);
                dataSource.setDriverClassName(driverClass);
                dataSource.setUrl(databaseUrl);
                dataSource.setUsername(userId);
                dataSource.setPassword(password);
                String valSql = databaseToValidationQueryMap.get(databaseName);
                dataSource.setValidationQuery(valSql);
                log.info("Connecting to {} database at URL {}", (Object)databaseName, (Object)databaseUrl);
                Connection c2 = dataSource.getConnection();
                if (databaseName.equals(SQL_SERVER)) {
                    boolean isMicrosoftDriverSupported;
                    boolean bl2 = isMicrosoftDriverSupported = c2.getMetaData().getDatabaseMajorVersion() >= 10;
                    if (!isMicrosoftDriverSupported && !Strings.CI.startsWith((CharSequence)databaseUrl, (CharSequence)"jdbc:jtds")) {
                        databaseUrlField.setValue("jdbc:jtds:sqlserver://hostname/databasename;sendStringParametersAsUnicode=false;useCursors=true;bufferMaxMemory=10240;lobBuffer=5242880;socketTimeout=360;appName=symds");
                        log.info("This version of SQL Server is not supported by the Microsoft driver. Switching to the jTDS driver instead. Edit the new database URL and try again.");
                        if (showOtherNotifications) {
                            CommonUiUtils.notify((String)"This version of SQL Server is not supported by the Microsoft driver. Switching to the jTDS driver instead. Edit the new database URL and try again.", shortcutToggler);
                        }
                        c2.close();
                        dataSource.close();
                        return "This version of SQL Server is not supported by the Microsoft driver. Switching to the jTDS driver instead. Edit the new database URL and try again.";
                    }
                }
                c2.close();
                if (databaseName.equals(SQL_SERVER_AZURE)) {
                    IDatabasePlatform platform;
                    boolean missingAzureModule = false;
                    if (!ModuleManager.getInstance().list().contains("azure") && (platform = JdbcDatabasePlatformFactory.getInstance().create((DataSource)dataSource, new SqlTemplateSettings(), false, false)) instanceof MsSql2000DatabasePlatform) {
                        missingAzureModule = true;
                    }
                    if (databaseUrl != null && Strings.CI.contains((CharSequence)databaseUrl, (CharSequence)"authentication=ActiveDirectory") && !ModuleManager.getInstance().list().contains("azurekv") && (platform = JdbcDatabasePlatformFactory.getInstance().create((DataSource)dataSource, new SqlTemplateSettings(), false, false)) instanceof MsSql2000DatabasePlatform) {
                        missingAzurekvModule = true;
                    }
                    if (missingAzureModule) {
                        throw new ClassNotFoundException("Azure module is missing");
                    }
                    if (missingAzurekvModule) {
                        throw new ClassNotFoundException("Azure Key Vault module is missing");
                    }
                }
                dataSource.close();
                log.info("Success connecting to database {}", (Object)databaseName);
                if (showSuccessNotification) {
                    CommonUiUtils.notify((String)"Successfully connected to the database", shortcutToggler);
                }
            }
        }
        catch (Exception ex2) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)ex2);
            if (rootCause == null) {
                rootCause = ex2;
            }
            exceptionMessage = ex2.getMessage() == null ? "" : ex2.getMessage();
            log.info("Exception during connection test: {}: {}", (Object)ex2.getClass().getName(), (Object)exceptionMessage);
            if (showFailureNotification) {
                if (System.getProperty("symmetric.standalone.web", "false").equalsIgnoreCase("true") && canCallRecursive && (rootCause.getMessage() != null && rootCause.getMessage().startsWith("No suitable driver") || rootCause instanceof ClassNotFoundException) && !databaseName.equals(OPENEDGE)) {
                    s.installModule(controller, databaseModuleIds.get(databaseName), "Downloading Driver ...", moduleInstallListener, shortcutToggler, showOtherNotifications);
                    if (missingAzurekvModule) {
                        s.installModule(controller, "azurekv", "Downloading Azure Key Vault Module ...", moduleInstallListener, shortcutToggler, showOtherNotifications);
                    }
                    if (databaseName.equals(REDSHIFT)) {
                        showFailureNotification = false;
                    }
                    s.testConnection(controller, databaseName, databaseUrlField, userId, password, moduleInstallListener, shortcutToggler, showSuccessNotification, showFailureNotification, showOtherNotifications, false);
                } else if (databaseName.equals(ELASTICSEARCH)) {
                    if (rootCause.getMessage().contains("reason")) {
                        String[] parsedError = rootCause.getMessage().split(",");
                        Object humanReadableError = "";
                        for (int x2 = 0; x2 < parsedError.length; ++x2) {
                            if (!parsedError[x2].contains("error") && !parsedError[x2].contains("reason")) continue;
                            humanReadableError = (String)humanReadableError + parsedError[x2];
                        }
                        CommonUiUtils.notify((String)"Failed to connect", (String)humanReadableError, shortcutToggler);
                    } else {
                        CommonUiUtils.notify((String)"Failed to connect", (String)rootCause.getMessage(), shortcutToggler);
                    }
                    log.warn("Unsuccessful attempt to connect to a database using url: " + databaseUrl + " with driver: " + s.getDriverForDatabaseType(databaseName, databaseUrl) + " as user: " + userId, rootCause);
                } else {
                    log.warn("Unsuccessful attempt to connect to a database using url: " + databaseUrl + " with driver: " + s.getDriverForDatabaseType(databaseName, databaseUrl) + " as user: " + userId, rootCause);
                    String errorMessageToDisplay = rootCause.getMessage() != null ? rootCause.getMessage() : "Failed to connect to database: " + ex2.getClass().getName() + " " + exceptionMessage;
                    CommonUiUtils.notify((String)"Failed to connect", (String)errorMessageToDisplay, shortcutToggler);
                }
            }
            return exceptionMessage;
        }
        return null;
    }

    protected static String getDriverForDatabaseType(a databaseType, String databaseUrl) {
        if (SQL_SERVER.equals(databaseType)) {
            if (databaseUrl != null && Strings.CI.startsWith((CharSequence)databaseUrl, (CharSequence)"jdbc:jtds")) {
                return "net.sourceforge.jtds.jdbc.Driver";
            }
            return databaseToDriverMap.get(databaseType);
        }
        return databaseToDriverMap.get(databaseType);
    }

    protected static void installModule(I controller, String moduleId, String dialogCaption, Command moduleInstallListener, Consumer<Boolean> shortcutToggler, boolean showNotification) {
        b worker = new b(moduleId, moduleInstallListener, shortcutToggler, showNotification);
        M<Boolean> dialog = new M<Boolean>(dialogCaption, worker, controller.getBackgroundRefresherService());
        if (shortcutToggler != null) {
            dialog.addOpenedChangeListener((ComponentEventListener & Serializable)event -> shortcutToggler.accept(event.isOpened()));
        }
        dialog.show();
        worker.waitForCompletion();
    }

    public static synchronized URL getJarFileUrl(String jarName) throws Exception {
        String jarFullPath = AppUtils.getSymHome() + File.separator + String.valueOf(new File("lib")) + File.separator + jarName;
        return new URL("jar:file:" + jarFullPath + "!/");
    }

    public static void addFileToClasspath(String fileName) throws Exception {
        JavaAgent.addToClassPath((File)new File(AppUtils.getSymHome() + File.separator + String.valueOf(new File("lib")) + File.separator + fileName));
    }

    public static List<String> getValidCaptureTypeList(a type) {
        ArrayList<String> validCaptureTypeList = new ArrayList<String>(Arrays.asList(OPTION_CDC_TRIGGER_BASED, OPTION_CDC_LOG_BASED, OPTION_CDC_TIME_BASED, OPTION_CDC_NONE));
        if (type != null) {
            if (type.isWriteOnly()) {
                return new ArrayList<String>(Arrays.asList(OPTION_CDC_NONE));
            }
            if (!type.isSupportsTriggers()) {
                validCaptureTypeList.remove(OPTION_CDC_TRIGGER_BASED);
            }
            if (!type.hasLogMiner()) {
                validCaptureTypeList.remove(OPTION_CDC_LOG_BASED);
            }
        }
        return validCaptureTypeList;
    }

    public static String getMappedDatabaseType(String type) {
        if (type == null) {
            return "unknown";
        }
        if (type.startsWith("mssql") || type.toLowerCase().startsWith("microsoft sql server")) {
            return "mssql";
        }
        if (type.toLowerCase().startsWith("postgres")) {
            return "postgres";
        }
        if (type.startsWith("oracle")) {
            return "oracle";
        }
        if (type.startsWith("hsqldb")) {
            return "hsqldb";
        }
        if (type.toLowerCase().equals("h2")) {
            return "h2";
        }
        if (type.toLowerCase().contains("db2") && type.toLowerCase().contains("as/400")) {
            return "db2i";
        }
        return type;
    }

    public static boolean isNonJdbcType(a type) {
        String name = type.getName().toLowerCase();
        return name.contains("mongo") || name.contains("cosmos") || name.contains("elasticsearch") || name.contains("opensearch") || name.replaceAll("\\s", "").contains("rabbitmq") || name.contains("S3");
    }

    public static NodeEngine checkForNodeInDatabase(Properties databaseProperties) {
        NodeEngine node = null;
        ClientSymmetricEngine engine = new ClientSymmetricEngine(databaseProperties, false);
        String prefix = engine.getParameterService().getTablePrefix();
        String sql = "select node_id, node_group_id, external_id, sync_url, symmetric_version, created_at_node_id from " + prefix + "_node where node_id in (select node_id from " + prefix + "_node_identity)";
        node = (NodeEngine)((Object)engine.getSqlTemplate().queryForObject(sql, (ISqlRowMapper)new ISqlRowMapper<NodeEngine>(){

            public NodeEngine mapRow(Row rs) {
                NodeEngine node = new NodeEngine();
                node.setNodeId(rs.getString("node_id"));
                node.setNodeGroupId(rs.getString("node_group_id"));
                node.setExternalId(rs.getString("external_id"));
                node.setSyncUrl(rs.getString("sync_url"));
                node.setSymmetricVersion(rs.getString("symmetric_version"));
                node.setCreatedAtNodeId(rs.getString("created_at_node_id"));
                return node;
            }
        }, new Object[0]));
        if (node != null && node.getCreatedAtNodeId() != null) {
            sql = "select sync_url from " + prefix + "_node where node_id = ?";
            node.setRegistrationUrl(engine.getSqlTemplate().queryForString(sql, new Object[]{node.getCreatedAtNodeId()}));
        }
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NodeEngine checkForNodeInEngineFile(SymmetricEngineHolder engineHolder, String url, String userId) {
        NodeEngine node = null;
        if (engineHolder == null || !engineHolder.isMultiServerMode()) return node;
        String enginesDirname = PropertiesUtil.getEnginesDir();
        File enginesDir = new File(enginesDirname);
        File[] files = null;
        if (enginesDir != null) {
            files = enginesDir.listFiles();
        }
        if (files == null && (enginesDir = new File(".")) != null) {
            files = enginesDir.listFiles();
        }
        if (files == null) return node;
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = files[i2];
            if (!file.getName().endsWith(".properties")) continue;
            Properties prop = new Properties();
            try (FileInputStream in = new FileInputStream(file.getAbsolutePath());){
                prop.load(in);
                if (!prop.getProperty("db.url", "").equalsIgnoreCase(url) || !prop.getProperty("db.user", "").equalsIgnoreCase(userId)) continue;
                node = new NodeEngine();
                node.setEngineFileName(file.getName());
                node.setNodeGroupId(prop.getProperty("group.id"));
                node.setExternalId(prop.getProperty("external.id"));
                node.setSyncUrl(prop.getProperty("sync.url"));
                node.setRegistrationUrl(prop.getProperty("registration.url"));
                continue;
            }
            catch (Exception ex2) {
                log.warn("Failed to check engine properties file " + String.valueOf(file), (Throwable)ex2);
            }
        }
        return node;
    }

    public static boolean checkForBcp(Properties properties, boolean isSqlServer) {
        boolean foundBcp;
        boolean bl2 = isSqlServer && new File("tools/mssql/" + (SystemUtils.IS_OS_WINDOWS ? "bcp.exe" : "bin/bcp")).canExecute() ? true : (foundBcp = false);
        if (!foundBcp) {
            ArrayList<String> bcpCmd = new ArrayList<String>();
            String extension = SystemUtils.IS_OS_WINDOWS ? ".exe" : "";
            bcpCmd.add("bcp" + extension);
            bcpCmd.add("-v");
            foundBcp = s.canExecuteBulkLoaderCommand(bcpCmd, isSqlServer);
            if (foundBcp) {
                properties.put(isSqlServer ? "mssql.bulk.load.bcp.cmd" : "ase.bulk.load.bcp.cmd", "bcp" + extension);
            }
        }
        return foundBcp;
    }

    public static boolean canExecuteBulkLoaderCommand(List<String> cmd, boolean isSqlServer) {
        try {
            return s.executeBulkLoaderCommandImpl(cmd, isSqlServer, new MutableBoolean(), new MutableInt());
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static void executeBulkLoaderCommand(List<String> cmd, boolean isSqlServer, MutableBoolean isSybase, MutableInt rc) throws IOException, InterruptedException {
        s.executeBulkLoaderCommandImpl(cmd, isSqlServer, isSybase, rc);
    }

    private static boolean executeBulkLoaderCommandImpl(List<String> cmd, boolean isSqlServer, MutableBoolean isSybase, MutableInt rc) throws IOException, InterruptedException {
        boolean isBcp = cmd.contains("-v");
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (!isBcp || !Strings.CI.contains((CharSequence)line, (CharSequence)"sybase")) continue;
            isSybase.setTrue();
        }
        rc.setValue(process.waitFor());
        return rc.intValue() == 0 && (!isBcp || isSqlServer ^ isSybase.isTrue());
    }

    public static boolean checkIfLocalInfileNeedsSet(TypedProperties databaseProperties, Properties advancedProperties) {
        if (s.isLocalDb(databaseProperties.get("db.url"))) {
            advancedProperties.put("mysql.bulk.load.local", "false");
        } else {
            advancedProperties.remove("mysql.bulk.load.local");
            if (!s.isLocalInfile(databaseProperties)) {
                try (Connection c2 = BasicDataSourceFactory.create((TypedProperties)databaseProperties).getConnection();
                     Statement st = c2.createStatement();){
                    st.executeUpdate("set global local_infile = 'ON'");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return !s.isLocalInfile(databaseProperties);
            }
        }
        return false;
    }

    public static boolean isLocalDb(String databaseUrl) {
        String hostname = AppUtils.getHostName();
        String databaseUrlString = databaseUrl.replaceFirst("jdbc:", "");
        URI dbUri = null;
        try {
            dbUri = new URI(databaseUrlString);
        }
        catch (URISyntaxException e2) {
            log.error("Failed to parse URL: " + databaseUrl, (Throwable)e2);
        }
        if (dbUri != null) {
            String dbHostname = dbUri.getHost();
            return dbHostname != null && (dbHostname.equals(hostname) || dbHostname.equals("localhost") || dbHostname.equals("127.0.0.1"));
        }
        return false;
    }

    public static boolean isLocalInfile(TypedProperties databaseProperties) {
        boolean isLocalInfile = false;
        try (Connection c2 = BasicDataSourceFactory.create((TypedProperties)databaseProperties).getConnection();
             Statement st = c2.createStatement();
             ResultSet rs = st.executeQuery("show variables like 'local_infile'");){
            if (rs.next()) {
                String result = rs.getString(2);
                isLocalInfile = result != null && result.equals("ON");
            }
        }
        catch (Exception e2) {
            log.error("Failed to check local_infile system property", (Throwable)e2);
        }
        return isLocalInfile;
    }

    static {
        databaseToDriverMap.put(MY_SQL, "com.mysql.cj.jdbc.Driver");
        databaseToDriverMap.put(MARIADB, "org.mariadb.jdbc.Driver");
        databaseToDriverMap.put(ORACLE, "oracle.jdbc.driver.OracleDriver");
        databaseToDriverMap.put(DERBY, "org.apache.derby.jdbc.EmbeddedDriver");
        databaseToDriverMap.put(HSQLDB, "org.hsqldb.jdbcDriver");
        databaseToDriverMap.put(H2, "org.h2.Driver");
        databaseToDriverMap.put(SQL_SERVER, "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        databaseToDriverMap.put(SQL_SERVER_AZURE, "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        databaseToDriverMap.put(FIREBIRD, "org.firebirdsql.jdbc.FBDriver");
        databaseToDriverMap.put(INTERBASE, "interbase.interclient.Driver");
        databaseToDriverMap.put(POSTGRE_SQL, "org.postgresql.Driver");
        databaseToDriverMap.put(GREENPLUM, "org.postgresql.Driver");
        databaseToDriverMap.put(DB2, "com.ibm.db2.jcc.DB2Driver");
        databaseToDriverMap.put(DB2AS400, "com.ibm.as400.access.AS400JDBCDriver");
        databaseToDriverMap.put(INFORMIX, "com.informix.jdbc.IfxDriver");
        databaseToDriverMap.put(ASE, "com.sybase.jdbc4.jdbc.SybDriver");
        databaseToDriverMap.put(SQLANYWHERE, "com.sybase.jdbc4.jdbc.SybDriver");
        databaseToDriverMap.put(SQLITE, "org.sqlite.JDBC");
        databaseToDriverMap.put(REDSHIFT, "com.amazon.redshift.jdbc42.Driver");
        databaseToDriverMap.put(VOLTDB, "org.voltdb.jdbc.Driver");
        databaseToDriverMap.put(TIBERO, "com.tmax.tibero.jdbc.TbDriver");
        databaseToDriverMap.put(NUODB, "com.nuodb.jdbc.Driver");
        databaseToDriverMap.put(RAIMA, "com.raima.rdm.jdbc.RDMDriver");
        databaseToDriverMap.put(CASSANDRA, "com.datastax.driver.core.Cluster");
        databaseToDriverMap.put(KAFKA, "org.apache.kafka.clients.producer.KafkaProducer");
        databaseToDriverMap.put(RABBITMQ, "com.rabbitmq.client.ConnectionFactory");
        databaseToDriverMap.put(ELASTICSEARCH, "org.elasticsearch.client.core.MainRequest");
        databaseToDriverMap.put(OPENSEARCH, "org.opensearch.client.RestClientBuilder");
        databaseToDriverMap.put(SNOWFLAKE, "net.snowflake.client.jdbc.SnowflakeDriver");
        databaseToDriverMap.put(HBASE, "org.apache.phoenix.jdbc.PhoenixDriver");
        databaseToDriverMap.put(HANA, "com.sap.db.jdbc.Driver");
        databaseToDriverMap.put(BIGQUERY, "com.google.cloud.bigquery.BigQuery");
        databaseToDriverMap.put(TERADATA, "com.teradata.jdbc.TeraDriver");
        databaseToDriverMap.put(IGNITE, "org.apache.ignite.IgniteJdbcThinDriver");
        databaseToDriverMap.put(INGRES, "com.ingres.jdbc.IngresDriver");
        databaseToDriverMap.put(MONGO, "com.mongodb.client.MongoClient");
        databaseToDriverMap.put(COSMOS, "com.azure.cosmos.models.CosmosBulkOperations");
        databaseToDriverMap.put(S3, "com.amazonaws.services.s3.AmazonS3");
        databaseToDriverMap.put(SINGLESTORE, "com.singlestore.jdbc.Driver");
        databaseToDriverMap.put(OPENEDGE, "com.ddtek.jdbc.openedge.OpenEdgeDriver");
        databaseToDriverMap.put(EXASOL, "com.exasol.jdbc.EXADriver");
        databaseToDriverMap.put(SPARKSQL, "org.apache.hive.jdbc.HiveDriver");
        databaseToDriverMap.put(DATABRICKS, "com.databricks.client.jdbc.Driver");
        databaseModuleIds.put(MY_SQL, "mysql");
        databaseModuleIds.put(MARIADB, "mariadb");
        databaseModuleIds.put(ORACLE, "oracle");
        databaseModuleIds.put(DERBY, "derby");
        databaseModuleIds.put(HSQLDB, "hsqldb");
        databaseModuleIds.put(H2, "h2");
        databaseModuleIds.put(SQL_SERVER, "mssql");
        databaseModuleIds.put(SQL_SERVER_AZURE, "azure");
        databaseModuleIds.put(FIREBIRD, "firebird");
        databaseModuleIds.put(INTERBASE, "interbase");
        databaseModuleIds.put(POSTGRE_SQL, "postgres");
        databaseModuleIds.put(GREENPLUM, "postgres");
        databaseModuleIds.put(DB2, "db2");
        databaseModuleIds.put(DB2AS400, "db2");
        databaseModuleIds.put(INFORMIX, "informix");
        databaseModuleIds.put(IGNITE, "ignite");
        databaseModuleIds.put(ASE, "sybase");
        databaseModuleIds.put(SQLANYWHERE, "sybase");
        databaseModuleIds.put(SQLITE, "sqlite");
        databaseModuleIds.put(REDSHIFT, "redshift");
        databaseModuleIds.put(VOLTDB, "voltdb");
        databaseModuleIds.put(TIBERO, "tibero");
        databaseModuleIds.put(NUODB, "nuodb");
        databaseModuleIds.put(RAIMA, "raima");
        databaseModuleIds.put(CASSANDRA, "cassandra");
        databaseModuleIds.put(KAFKA, "kafka");
        databaseModuleIds.put(RABBITMQ, "rabbitmq");
        databaseModuleIds.put(ELASTICSEARCH, "elasticsearch");
        databaseModuleIds.put(OPENSEARCH, "opensearch");
        databaseModuleIds.put(SNOWFLAKE, "snowflake");
        databaseModuleIds.put(HBASE, "hbase");
        databaseModuleIds.put(HANA, "hana");
        databaseModuleIds.put(BIGQUERY, "bigquery");
        databaseModuleIds.put(TERADATA, "teradata");
        databaseModuleIds.put(INGRES, "ingres");
        databaseModuleIds.put(MONGO, "mongodb");
        databaseModuleIds.put(COSMOS, "cosmos");
        databaseModuleIds.put(S3, "S3");
        databaseModuleIds.put(SINGLESTORE, "singlestore");
        databaseModuleIds.put(OPENEDGE, "openedge");
        databaseModuleIds.put(EXASOL, "exasol");
        databaseModuleIds.put(SPARKSQL, "sparksql");
        databaseModuleIds.put(DATABRICKS, "databricks");
        databaseToSampleUrlMap.put(MY_SQL, "jdbc:mysql://localhost:3306/databasename?tinyInt1isBit=false&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true");
        databaseToSampleUrlMap.put(MARIADB, "jdbc:mariadb://localhost:3306/databasename?tinyInt1isBit=false");
        databaseToSampleUrlMap.put(ORACLE, "jdbc:oracle:thin:@127.0.0.1:1521:databasename");
        databaseToSampleUrlMap.put(DERBY, "jdbc:derby:databasename;create=true");
        databaseToSampleUrlMap.put(HSQLDB, "jdbc:hsqldb:file:databasename;shutdown=true");
        databaseToSampleUrlMap.put(H2, "jdbc:h2:file:./databasename;LOCK_TIMEOUT=60000;WRITE_DELAY=0");
        databaseToSampleUrlMap.put(SQL_SERVER, "jdbc:sqlserver://localhost:1433;databasename=databasename;ApplicationName=SymmetricDS;sendTimeAsDateTime=false;encrypt=false;socketTimeout=3660000");
        databaseToSampleUrlMap.put(SQL_SERVER_AZURE, "jdbc:sqlserver://localhost:1433;databasename=databasename;ApplicationName=SymmetricDS;sendTimeAsDateTime=false;encrypt=false;socketTimeout=3660000");
        databaseToSampleUrlMap.put(FIREBIRD, "jdbc:firebirdsql://localhost:3050/databasename?encoding=none");
        databaseToSampleUrlMap.put(INTERBASE, "jdbc:interbase://localhost:3070//opt/interbase/data/databasename.gdb");
        databaseToSampleUrlMap.put(POSTGRE_SQL, "jdbc:postgresql://localhost:5432/databasename?protocolVersion=3&ApplicationName=SymmetricDS&stringtype=unspecified&socketTimeout=3660&tcpKeepAlive=true");
        databaseToSampleUrlMap.put(GREENPLUM, "jdbc:postgresql://localhost/databasename");
        databaseToSampleUrlMap.put(DB2, "jdbc:db2://localhost:50000/databasename");
        databaseToSampleUrlMap.put(DB2AS400, "jdbc:as400://localhost/databasename;libraries=myschema");
        databaseToSampleUrlMap.put(INFORMIX, "jdbc:informix-sqli://localhost:9088/databasename:INFORMIXSERVER=ol_ids_1150_1");
        databaseToSampleUrlMap.put(ASE, "jdbc:sybase:Tds:localhost:5000/databasename");
        databaseToSampleUrlMap.put(SQLANYWHERE, "jdbc:sybase:Tds:localhost:2638/databasename");
        databaseToSampleUrlMap.put(SQLITE, "jdbc:sqlite:databasename");
        databaseToSampleUrlMap.put(REDSHIFT, "jdbc:redshift://endpoint:5439/databasename");
        databaseToSampleUrlMap.put(VOLTDB, "jdbc:voltdb://localhost:21212");
        databaseToSampleUrlMap.put(TIBERO, "jdbc:tibero:thin:@localhost:8629:servicename");
        databaseToSampleUrlMap.put(NUODB, "jdbc:com.nuodb://localhost/databasename?schema=databasename&clientInfo=symds");
        databaseToSampleUrlMap.put(RAIMA, "jdbc:raima:rdm://localhost/databasename?lock timeout=600");
        databaseToSampleUrlMap.put(CASSANDRA, "cassandra://localhost");
        databaseToSampleUrlMap.put(KAFKA, "localhost:9092");
        databaseToSampleUrlMap.put(RABBITMQ, "amqp://localhost:5672/%2F");
        databaseToSampleUrlMap.put(ELASTICSEARCH, "http://localhost:9200");
        databaseToSampleUrlMap.put(OPENSEARCH, "https://search-domainname.region.es.amazonaws.com");
        databaseToSampleUrlMap.put(SNOWFLAKE, "jdbc:snowflake://<account_name>.snowflakecomputing.com/?db=<database>&warehouse=<warehouse>&JDBC_QUERY_RESULT_FORMAT=JSON");
        databaseToSampleUrlMap.put(HBASE, "jdbc:phoenix:localhost");
        databaseToSampleUrlMap.put(HANA, "jdbc:sap://localhost:39015/");
        databaseToSampleUrlMap.put(BIGQUERY, "bigquery://cloud.google.com");
        databaseToSampleUrlMap.put(TERADATA, "jdbc:teradata://localhost");
        databaseToSampleUrlMap.put(IGNITE, "jdbc:ignite:thin://localhost");
        databaseToSampleUrlMap.put(INGRES, "jdbc:ingres://localhost:II7/databasename");
        databaseToSampleUrlMap.put(MONGO, "mongodb+srv://admin:<password>@<cluster>/<database>?retryWrites=true&w=majority");
        databaseToSampleUrlMap.put(COSMOS, "https://azure-name.documents.azure.com:443/");
        databaseToSampleUrlMap.put(S3, "https://bucket-name.S3.Region.amazonaws.com/key name");
        databaseToSampleUrlMap.put(SINGLESTORE, "jdbc:singlestore://localhost:3306/databasename");
        databaseToSampleUrlMap.put(OPENEDGE, "jdbc:datadirect:openedge://localhost:5678;Database=databasename");
        databaseToSampleUrlMap.put(EXASOL, "jdbc:exa:localhost/nocertcheck:8563;schema=databasename");
        databaseToSampleUrlMap.put(SPARKSQL, "jdbc:hive2://localhost:10000/databasename");
        databaseToSampleUrlMap.put(DATABRICKS, "jdbc:databricks://{instance}.cloud.databricks.com:443/{schema};transportMode=http;ssl=1;httpPath={httpPath}");
        databaseToDefaultPortMap.put(MY_SQL, "3306");
        databaseToDefaultPortMap.put(MARIADB, "3306");
        databaseToDefaultPortMap.put(ORACLE, "1521");
        databaseToDefaultPortMap.put(SQL_SERVER, "1433");
        databaseToDefaultPortMap.put(SQL_SERVER_AZURE, "1433");
        databaseToDefaultPortMap.put(FIREBIRD, "3050");
        databaseToDefaultPortMap.put(INTERBASE, "3070");
        databaseToDefaultPortMap.put(POSTGRE_SQL, "5432");
        databaseToDefaultPortMap.put(DB2, "50000");
        databaseToDefaultPortMap.put(INFORMIX, "9088");
        databaseToDefaultPortMap.put(ASE, "5000");
        databaseToDefaultPortMap.put(SQLANYWHERE, "2638");
        databaseToDefaultPortMap.put(REDSHIFT, "5439");
        databaseToDefaultPortMap.put(INGRES, "II7");
        databaseToDefaultPortMap.put(SINGLESTORE, "3306");
        databaseToDefaultPortMap.put(OPENEDGE, "5678");
        databaseToDefaultPortMap.put(EXASOL, "8563");
        databaseToDefaultPortMap.put(SPARKSQL, "10000");
        databaseToDefaultPortMap.put(DATABRICKS, "443");
        databaseToValidationQueryMap.put(MY_SQL, "select 1");
        databaseToValidationQueryMap.put(MARIADB, "select 1");
        databaseToValidationQueryMap.put(ORACLE, "select 1 from dual");
        databaseToValidationQueryMap.put(DERBY, "values(1)");
        databaseToValidationQueryMap.put(HSQLDB, "SELECT 1 FROM INFORMATION_SCHEMA.SYSTEM_USERS");
        databaseToValidationQueryMap.put(H2, "select 1");
        databaseToValidationQueryMap.put(SQL_SERVER, "select 1");
        databaseToValidationQueryMap.put(SQL_SERVER_AZURE, "select 1");
        databaseToValidationQueryMap.put(FIREBIRD, "select cast(1 AS INTEGER) from rdb$database");
        databaseToValidationQueryMap.put(INTERBASE, "select cast(1 AS INTEGER) from rdb$database");
        databaseToValidationQueryMap.put(POSTGRE_SQL, "select 1");
        databaseToValidationQueryMap.put(GREENPLUM, "select 1");
        databaseToValidationQueryMap.put(DB2, "select CURRENT SCHEMA from sysibm.sysdummy1");
        databaseToValidationQueryMap.put(DB2AS400, "select CURRENT SCHEMA from sysibm.sysdummy1");
        databaseToValidationQueryMap.put(INFORMIX, "select 1");
        databaseToValidationQueryMap.put(ASE, "select 1");
        databaseToValidationQueryMap.put(SQLANYWHERE, "select 1");
        databaseToValidationQueryMap.put(SQLITE, "select 1");
        databaseToValidationQueryMap.put(REDSHIFT, "select 1");
        databaseToValidationQueryMap.put(VOLTDB, "");
        databaseToValidationQueryMap.put(NUODB, "select 1 from dual");
        databaseToValidationQueryMap.put(TIBERO, "select 1 from dual");
        databaseToValidationQueryMap.put(RAIMA, "select 1");
        databaseToValidationQueryMap.put(HANA, "select 1 from dummy");
        databaseToValidationQueryMap.put(TERADATA, "select 1");
        databaseToValidationQueryMap.put(INGRES, "select 1");
        databaseToValidationQueryMap.put(MONGO, "");
        databaseToValidationQueryMap.put(COSMOS, "");
        databaseToValidationQueryMap.put(SNOWFLAKE, "select 1");
        databaseToValidationQueryMap.put(SINGLESTORE, "select 1");
        databaseToValidationQueryMap.put(OPENEDGE, "select 1 from sysprogress.syscalctable");
        databaseToValidationQueryMap.put(SPARKSQL, "select 1");
        databaseToValidationQueryMap.put(DATABRICKS, "select 1");
        databaseConnectionProperties.put(ORACLE, "oracle.net.CONNECT_TIMEOUT=60000;oracle.net.READ_TIMEOUT=3660000;oracle.jdbc.ReadTimeout=3660000;SetBigStringTryClob=true");
        databaseConnectionProperties.put(FIREBIRD, "TRANSACTION_READ_COMMITTED=isc_tpb_read_committed,isc_tpb_rec_version,isc_tpb_write,isc_tpb_wait,isc_tpb_lock_timeout==50");
        databaseConnectionProperties.put(SINGLESTORE, "allowLocalInfile=true");
        databaseConnectionProperties.put(MY_SQL, "allowLoadLocalInfile=true");
        databaseInitSqlProperties.put(ASE, "SET NOCOUNT OFF");
        databaseInitSqlProperties.put(SQL_SERVER, "SET NOCOUNT OFF");
        databaseInitSqlProperties.put(SQL_SERVER_AZURE, "SET NOCOUNT OFF");
        databaseInitSqlProperties.put(INGRES, "set lockmode session where level = row");
        databaseInitSqlProperties.put(H2, "SET MODE LEGACY");
        synchronizedJobsProperties.put(SQLITE, "true");
        databaseNameMap.put(ORACLE, "oracle");
        databaseNameMap.put(MY_SQL, "mysql");
        databaseNameMap.put(SQL_SERVER, "mssql");
        databaseNameMap.put(POSTGRE_SQL, "postgres");
        databaseNameMap.put(BIGQUERY, "bigquery");
        databaseNameMap.put(CASSANDRA, "cassandra");
        databaseNameMap.put(COSMOS, "cosmos");
        databaseNameMap.put(DB2, "db2");
        databaseNameMap.put(DB2AS400, "db2");
        databaseNameMap.put(DERBY, "derby");
        databaseNameMap.put(ELASTICSEARCH, "elasticsearch");
        databaseNameMap.put(FIREBIRD, "firebird");
        databaseNameMap.put(GREENPLUM, "greenplum");
        databaseNameMap.put(H2, "h2");
        databaseNameMap.put(HANA, "hana");
        databaseNameMap.put(HBASE, "hbase");
        databaseNameMap.put(HSQLDB, "hsqldb");
        databaseNameMap.put(IGNITE, "ignite");
        databaseNameMap.put(INFORMIX, "informix");
        databaseNameMap.put(INGRES, "ingres");
        databaseNameMap.put(INTERBASE, "interbase");
        databaseNameMap.put(KAFKA, "kafka");
        databaseNameMap.put(RABBITMQ, "rabbitmq");
        databaseNameMap.put(RAIMA, "raima");
        databaseNameMap.put(MARIADB, "mariadb");
        databaseNameMap.put(MONGO, "mongo");
        databaseNameMap.put(SQL_SERVER_AZURE, "mssql-azure");
        databaseNameMap.put(NUODB, "nuodb");
        databaseNameMap.put(OPENEDGE, "openedge");
        databaseNameMap.put(OPENSEARCH, "opensearch");
        databaseNameMap.put(REDSHIFT, "redshift");
        databaseNameMap.put(SINGLESTORE, "singlestore");
        databaseNameMap.put(SNOWFLAKE, "snowflake");
        databaseNameMap.put(SQLITE, "sqlite");
        databaseNameMap.put(ASE, "sybase");
        databaseNameMap.put(SQLANYWHERE, "sybase-asa");
        databaseNameMap.put(TERADATA, "teradata");
        databaseNameMap.put(TIBERO, "tibero");
        databaseNameMap.put(VOLTDB, "voltdb");
        databaseNameMap.put(S3, "S3");
        databaseNameMap.put(EXASOL, "exasol");
        databaseNameMap.put(SPARKSQL, "sparksql");
        databaseNameMap.put(DATABRICKS, "databricks");
        log = LoggerFactory.getLogger(s.class);
    }

    public static class a
    implements Comparable<a> {
        String name;
        boolean writeOnly;
        boolean advancedOptions;
        boolean hasLogMiner;
        boolean hasBulkLoader;
        boolean hasBuiltInBulkLoader;
        boolean supportsTriggers = true;

        public a(String name) {
            this.name = name;
        }

        public a(String name, boolean writeOnly, boolean advancedOptions, boolean hasLogMiner, boolean hasBulkLoader, boolean hasBuiltInBulkLoader) {
            this.name = name;
            this.writeOnly = writeOnly;
            this.advancedOptions = advancedOptions;
            this.hasLogMiner = hasLogMiner;
            this.hasBulkLoader = hasBulkLoader;
            this.hasBuiltInBulkLoader = hasBuiltInBulkLoader;
        }

        public a(String name, boolean writeOnly, boolean advancedOptions, boolean hasLogMiner, boolean hasBulkLoader, boolean hasBuiltInBulkLoader, boolean supportsTriggers) {
            this(name, writeOnly, advancedOptions, hasLogMiner, hasBulkLoader, hasBuiltInBulkLoader);
            this.supportsTriggers = supportsTriggers;
        }

        public String toString() {
            return this.name;
        }

        public boolean isWriteOnly() {
            return this.writeOnly;
        }

        public void setWriteOnly(boolean writeOnly) {
            this.writeOnly = writeOnly;
        }

        @Override
        public int compareTo(a o2) {
            return this.name.compareTo(o2.name);
        }

        public String getName() {
            return this.name;
        }

        public boolean isAdvancedOptions() {
            return this.advancedOptions;
        }

        public void setAdvancedOptions(boolean advancedOptions) {
            this.advancedOptions = advancedOptions;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean hasLogMiner() {
            return this.hasLogMiner;
        }

        public void setLogMiner(boolean hasLogMiner) {
            this.hasLogMiner = hasLogMiner;
        }

        public boolean hasBulkLoader() {
            return this.hasBulkLoader;
        }

        public void setBulkLoader(boolean hasBulkLoader) {
            this.hasBulkLoader = hasBulkLoader;
        }

        public boolean hasBuiltInBulkLoader() {
            return this.hasBuiltInBulkLoader;
        }

        public void setBuiltInBulkLoader(boolean hasBuiltInBulkLoader) {
            this.hasBuiltInBulkLoader = hasBuiltInBulkLoader;
        }

        public boolean isSupportsTriggers() {
            return this.supportsTriggers;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof a)) {
                return false;
            }
            a other = (a)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    protected static class b
    implements M.a<Boolean> {
        private String moduleId;
        private Command moduleInstallListener;
        private boolean isComplete;
        private Consumer<Boolean> shortcutToggler;
        private boolean showNotification;

        public b(String moduleId, Command moduleInstallListener, Consumer<Boolean> shortcutToggler, boolean showNotification) {
            this.moduleId = moduleId;
            this.moduleInstallListener = moduleInstallListener;
            this.shortcutToggler = shortcutToggler;
            this.showNotification = showNotification;
        }

        @Override
        public Boolean doWork() {
            try {
                ModuleManager.getInstance().install(this.moduleId);
                this.isComplete = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        public void waitForCompletion() {
            try {
                while (!this.isComplete) {
                    Thread.sleep(250L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void doUI(Boolean isSuccess) {
            isSuccess = false;
            try {
                for (String fileName : ModuleManager.getInstance().listFiles(this.moduleId)) {
                    s.addFileToClasspath(fileName);
                    isSuccess = true;
                }
            }
            catch (Exception e2) {
                log.error("", (Throwable)e2);
            }
            if (isSuccess.booleanValue()) {
                if (this.moduleInstallListener != null) {
                    this.moduleInstallListener.execute();
                }
            } else if (this.showNotification) {
                CommonUiUtils.notify((String)"No suitable driver found.  Is the format of the JDBC URL correct?  Is the JDBC driver installed in the lib directory of the SymmetricDS installation?  If not please install it and restart the server.", this.shortcutToggler);
            }
        }
    }
}

