/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.impl.ct;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.ap;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.vaadin.ui.common.ColumnVisibilityToggler;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class j
extends ap {
    private static final long serialVersionUID = 1L;
    private long failedRowNumber = -1L;
    private List<a> filterList;
    Grid<Data> grid;

    public j() {
    }

    public j(I controller, AbstractBatch batch, List<Data> dataIds) {
        super(controller);
        this.setSizeFull();
        boolean isInsertUpdateOrDelete = true;
        if (!dataIds.isEmpty()) {
            DataEventType eventType = dataIds.get(0).getDataEventType();
            boolean bl2 = isInsertUpdateOrDelete = eventType.equals((Object)DataEventType.INSERT) || eventType.equals((Object)DataEventType.UPDATE) || eventType.equals((Object)DataEventType.DELETE);
        }
        if (isInsertUpdateOrDelete) {
            this.generateMissingPkData(dataIds);
        }
        ColumnVisibilityToggler columnVisibilityToggler = new ColumnVisibilityToggler();
        this.add(new Component[]{columnVisibilityToggler});
        this.setHorizontalComponentAlignment(FlexComponent.Alignment.END, new Component[]{columnVisibilityToggler});
        this.grid = new Grid(Data.class);
        this.grid.setWidthFull();
        this.grid.setHeight("110px");
        this.grid.setColumnReorderingAllowed(true);
        this.addAndExpand(new Component[]{this.grid});
        this.grid.removeColumnByKey("dataId");
        this.grid.addColumn((ValueProvider & Serializable)data -> {
            String id = String.valueOf(data.getDataId());
            return id.replace(",", "");
        }).setHeader(controller.getMessage("Data Id", new Object[0])).setKey("dataId").setFrozen(true);
        this.grid.removeColumnByKey("createTime");
        this.grid.addColumn((ValueProvider & Serializable)data -> {
            Date date = data.getCreateTime();
            return as.formatDate(controller, date);
        }).setHeader("Create Time").setKey("createTime");
        this.grid.removeColumnByKey("pkData");
        if (isInsertUpdateOrDelete) {
            this.grid.addColumn((ValueProvider & Serializable)data -> StringUtils.abbreviate((String)data.getPkData(), (int)100)).setHeader("Pk Data").setKey("pkData");
        }
        this.grid.removeColumnByKey("rowData");
        columnVisibilityToggler.addColumn(this.grid.addColumn((ValueProvider & Serializable)data -> StringUtils.abbreviate((String)data.getRowData(), (int)100)).setHeader("Row Data").setKey("rowData"), "Row Data");
        this.grid.removeColumnByKey("oldData");
        columnVisibilityToggler.addColumn(this.grid.addColumn((ValueProvider & Serializable)data -> StringUtils.abbreviate((String)data.getOldData(), (int)100)).setHeader("Old Data").setKey("oldData"), "Old Data");
        this.grid.getColumnByKey("rowData").setVisible(false);
        this.grid.getColumnByKey("oldData").setVisible(false);
        columnVisibilityToggler.addColumn(this.grid.getColumnByKey("sourceNodeId"), "Source Node Id").setVisible(false);
        columnVisibilityToggler.addColumn(this.grid.getColumnByKey("nodeList"), "Node List").setVisible(false);
        columnVisibilityToggler.addColumn(this.grid.getColumnByKey("externalData"), "External Data").setVisible(false);
        columnVisibilityToggler.addColumn(this.grid.getColumnByKey("transactionId"), "Transaction Id").setVisible(false);
        columnVisibilityToggler.addColumn(this.grid.getColumnByKey("preRouted"), "Pre Routed").setVisible(false);
        this.grid.removeColumnByKey("attributes");
        this.grid.removeColumnByKey("channelId");
        this.grid.removeColumnByKey("changedDataIndicators");
        this.grid.removeColumnByKey("noBinaryOldData");
        this.grid.removeColumnByKey("sizeInBytes");
        this.grid.removeColumnByKey("triggerHistory");
        if (batch instanceof IncomingBatch) {
            this.grid.removeColumnByKey("sourceNodeId");
            this.grid.removeColumnByKey("nodeList");
            this.grid.removeColumnByKey("externalData");
            this.grid.removeColumnByKey("transactionId");
            this.grid.removeColumnByKey("preRouted");
            if (isInsertUpdateOrDelete) {
                this.grid.setColumnOrder(new Grid.Column[]{this.grid.getColumnByKey("dataId"), this.grid.getColumnByKey("dataEventType"), this.grid.getColumnByKey("tableName"), this.grid.getColumnByKey("pkData"), this.grid.getColumnByKey("oldData"), this.grid.getColumnByKey("rowData"), this.grid.getColumnByKey("createTime")});
            } else {
                this.grid.setColumnOrder(new Grid.Column[]{this.grid.getColumnByKey("dataId"), this.grid.getColumnByKey("dataEventType"), this.grid.getColumnByKey("tableName"), this.grid.getColumnByKey("oldData"), this.grid.getColumnByKey("rowData"), this.grid.getColumnByKey("createTime")});
            }
        } else if (isInsertUpdateOrDelete) {
            this.grid.setColumnOrder(new Grid.Column[]{this.grid.getColumnByKey("dataId"), this.grid.getColumnByKey("dataEventType"), this.grid.getColumnByKey("tableName"), this.grid.getColumnByKey("pkData"), this.grid.getColumnByKey("externalData"), this.grid.getColumnByKey("nodeList"), this.grid.getColumnByKey("oldData"), this.grid.getColumnByKey("preRouted"), this.grid.getColumnByKey("rowData"), this.grid.getColumnByKey("sourceNodeId"), this.grid.getColumnByKey("transactionId"), this.grid.getColumnByKey("createTime")});
        } else {
            this.grid.setColumnOrder(new Grid.Column[]{this.grid.getColumnByKey("dataId"), this.grid.getColumnByKey("dataEventType"), this.grid.getColumnByKey("tableName"), this.grid.getColumnByKey("externalData"), this.grid.getColumnByKey("nodeList"), this.grid.getColumnByKey("oldData"), this.grid.getColumnByKey("preRouted"), this.grid.getColumnByKey("rowData"), this.grid.getColumnByKey("sourceNodeId"), this.grid.getColumnByKey("transactionId"), this.grid.getColumnByKey("createTime")});
        }
        for (Grid.Column col : this.grid.getColumns()) {
            col.setSortable(false).setResizable(true);
        }
        this.grid.setItems(dataIds);
        if (dataIds.size() > 10) {
            this.filterList = new ArrayList<a>();
            HeaderRow header = this.grid.appendHeaderRow();
            for (Grid.Column col : this.grid.getColumns()) {
                String colKey = col.getKey();
                HeaderRow.HeaderCell cell = (HeaderRow.HeaderCell)header.getCell(this.grid.getColumnByKey(colKey));
                if (colKey.equals("dataEventType")) {
                    ArrayList<String> options = new ArrayList<String>();
                    options.add(controller.getMessage("<Any>", new Object[0]));
                    options.add((String)DataEventType.INSERT);
                    options.add((String)DataEventType.UPDATE);
                    options.add((String)DataEventType.DELETE);
                    options.add((String)DataEventType.CREATE);
                    options.add((String)DataEventType.RELOAD);
                    options.add((String)DataEventType.SQL);
                    options.add((String)DataEventType.BSH);
                    ComboBox select = new ComboBox();
                    select.setItems((ComboBox.ItemFilter & Serializable)(option, filter) -> !CommonUiUtils.isFilteredOut((String)Objects.toString(option, null), (String)filter), options);
                    select.setValue((Object)controller.getMessage("<Any>", new Object[0]));
                    select.setWidthFull();
                    select.getElement().getThemeList().add((Object)"small");
                    cell.setComponent((Component)select);
                    select.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        ListDataProvider dataProvider = (ListDataProvider)this.grid.getDataProvider();
                        dataProvider.clearFilters();
                        ArrayList<a> updatedFilterList = new ArrayList<a>();
                        for (a filter : this.filterList) {
                            if (filter.getField().equals((Object)event.getSource())) continue;
                            dataProvider.addFilter(filter.getGetter(), filter.getPredicate());
                            updatedFilterList.add(filter);
                        }
                        this.filterList = updatedFilterList;
                        if (!event.getValue().equals(controller.getMessage("<Any>", new Object[0]))) {
                            this.filterList.add(new a((ValueProvider<Data, Object>)((ValueProvider & Serializable)CsvData::getDataEventType), (SerializablePredicate<Object>)(SerializablePredicate & Serializable)type -> type.equals(event.getValue()), (HasValue)event.getSource()));
                            dataProvider.addFilter(CsvData::getDataEventType, (SerializablePredicate & Serializable)type -> type.equals(event.getValue()));
                        }
                        this.grid.setItems(dataProvider);
                    });
                    continue;
                }
                TextField filterField = new TextField();
                filterField.setWidth("12em");
                filterField.addThemeName("small");
                filterField.setPlaceholder("Filter");
                filterField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                    ListDataProvider dataProvider = (ListDataProvider)this.grid.getDataProvider();
                    dataProvider.clearFilters();
                    ArrayList<a> updatedFilterList = new ArrayList<a>();
                    for (a filter : this.filterList) {
                        if (filter.getField().equals((Object)event.getSource())) continue;
                        dataProvider.addFilter(filter.getGetter(), filter.getPredicate());
                        updatedFilterList.add(filter);
                    }
                    this.filterList = updatedFilterList;
                    String filterValue = (String)event.getValue();
                    if (!StringUtils.isBlank((CharSequence)filterValue)) {
                        ValueProvider & Serializable getter = null;
                        switch (colKey) {
                            case "dataId": {
                                getter = Data::getDataId;
                                break;
                            }
                            case "tableName": {
                                getter = Data::getTableName;
                                break;
                            }
                            case "pkData": {
                                getter = Data::getPkData;
                                break;
                            }
                            case "rowData": {
                                getter = Data::getRowData;
                                break;
                            }
                            case "oldData": {
                                getter = Data::getOldData;
                                break;
                            }
                            case "sourceNodeId": {
                                getter = Data::getSourceNodeId;
                                break;
                            }
                            case "nodeList": {
                                getter = Data::getNodeList;
                                break;
                            }
                            case "externalData": {
                                getter = Data::getExternalData;
                                break;
                            }
                            case "transactionId": {
                                getter = Data::getTransactionId;
                                break;
                            }
                            case "createTime": {
                                getter = Data::getCreateTime;
                                break;
                            }
                            case "preRouted": {
                                getter = Data::isPreRouted;
                            }
                        }
                        this.filterList.add(new a((ValueProvider<Data, Object>)getter, (SerializablePredicate<Object>)(SerializablePredicate & Serializable)type -> !CommonUiUtils.isFilteredOut((String)type.toString(), (String)filterValue), (HasValue)event.getSource()));
                        dataProvider.addFilter((ValueProvider)getter, (SerializablePredicate & Serializable)type -> !CommonUiUtils.isFilteredOut((String)type.toString(), (String)filterValue));
                    }
                    this.grid.setItems(dataProvider);
                });
                cell.setComponent((Component)filterField);
            }
        }
        if (batch instanceof IncomingBatch && batch.isErrorFlag() && (((IncomingBatch)batch).getFailedLineNumber() > 1L || ((IncomingBatch)batch).getFailedRowNumber() > 1L)) {
            this.failedRowNumber = ((IncomingBatch)batch).getFailedRowNumber();
        }
        this.grid.setPartNameGenerator((SerializableFunction & Serializable)data -> {
            if (data != null && batch instanceof OutgoingBatch && data.getDataId() == batch.getFailedDataId()) {
                return "v-grid-row-marked";
            }
            if (data != null && batch instanceof IncomingBatch && data.getDataId() == this.failedRowNumber) {
                return "v-grid-row-marked";
            }
            return null;
        });
        ct dataLayout = new ct(controller, null);
        this.add(new Component[]{dataLayout});
        this.grid.addItemClickListener((ComponentEventListener & Serializable)event -> dataLayout.a((Data)event.getItem()));
        if (!dataIds.isEmpty()) {
            this.grid.select((Object)dataIds.get(0));
            dataLayout.a(dataIds.get(0));
        }
    }

    protected void generateMissingPkData(List<Data> dataIds) {
        for (int i2 = 0; i2 < dataIds.size(); ++i2) {
            Data data = dataIds.get(i2);
            if (data.getPkData() != null) continue;
            TriggerHistory hist = data.getTriggerHistory();
            String[] oldData = data.getParsedData("oldData");
            if (oldData != null) {
                data.setPkData(this.getColumnString(oldData, hist.getParsedPkColumnNames().length));
                continue;
            }
            String[] rowData = data.getParsedData("rowData");
            data.setPkData(this.getColumnString(rowData, hist.getParsedPkColumnNames().length));
        }
    }

    private String getColumnString(String[] data, int count) {
        StringBuilder sb = new StringBuilder();
        if (data != null) {
            for (int i2 = 0; i2 < count && i2 < data.length; ++i2) {
                sb.append("\"");
                sb.append(data[i2]);
                sb.append("\"");
                if (i2 + 1 >= count) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    class a {
        private ValueProvider<Data, Object> getter;
        private SerializablePredicate<Object> predicate;
        private HasValue<?, ?> field;

        public a(ValueProvider<Data, Object> getter, SerializablePredicate<Object> predicate, HasValue<?, ?> field) {
            this.getter = getter;
            this.predicate = predicate;
            this.field = field;
        }

        public ValueProvider<Data, Object> getGetter() {
            return this.getter;
        }

        public void setGetter(ValueProvider<Data, Object> getter) {
            this.getter = getter;
        }

        public SerializablePredicate<Object> getPredicate() {
            return this.predicate;
        }

        public void setPredicate(SerializablePredicate<Object> predicate) {
            this.predicate = predicate;
        }

        public HasValue<?, ?> getField() {
            return this.field;
        }

        public void setField(HasValue<?, ?> field) {
            this.field = field;
        }
    }
}

