/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.ui.common.D;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.aq;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.c;
import com.jumpmind.symmetric.console.ui.common.z;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jumpmind.symmetric.service.FilterCriterion;
import org.jumpmind.vaadin.ui.common.Label;

public class g
extends aq {
    private static final long serialVersionUID = 1L;
    private D filterSource;
    private FlexLayout filterTags;
    private VerticalLayout filterListLayout;
    private c dynamicFilter;
    private List<FilterCriterion> filterCriteria;
    private Span noFilters;
    private ShortcutRegistration cancelShortcutRegistration;

    public g(I controller, List<c> filters, D filterSource) {
        super(controller, "Advanced Filter", new Object[0]);
        this.filterSource = filterSource;
        this.filterCriteria = new ArrayList<FilterCriterion>();
        this.setCloseOnEsc(true);
        this.setWidth("70%");
        this.setHeight("80%");
        this.setResizable(true);
        VerticalLayout mainLayout = new VerticalLayout();
        mainLayout.setMargin(false);
        mainLayout.setWidthFull();
        Scroller filterPanel = new Scroller();
        VerticalLayout header = new VerticalLayout();
        header.setMargin(false);
        header.getStyle().set("padding", "0 16px");
        HorizontalLayout filterHeader = new HorizontalLayout();
        Button clearButton = as.createLinkButton("Clear");
        clearButton.addClickListener((ComponentEventListener & Serializable)event -> this.clear());
        filterHeader.add(new Component[]{clearButton});
        this.noFilters = new Span("(No Filters)");
        filterHeader.add(new Component[]{this.noFilters});
        this.filterTags = new FlexLayout();
        this.filterTags.setFlexWrap(FlexLayout.FlexWrap.WRAP);
        this.filterTags.getElement().setAttribute("theme", "spacing");
        filterHeader.add(new Component[]{this.filterTags});
        header.add(new Component[]{filterHeader});
        Label divider = new Label("<hr />");
        divider.setWidthFull();
        header.add(new Component[]{divider});
        mainLayout.add(new Component[]{header});
        this.filterListLayout = new VerticalLayout();
        this.filterListLayout.setWidth(null);
        this.filterListLayout.setClassName("filter_list_layout");
        this.filterListLayout.setSpacing(true);
        this.filterListLayout.getStyle().set("margin", "0 16px").set("padding", "0 16px");
        for (c filter : filters) {
            this.filterListLayout.add(new Component[]{filter});
            filter.setFilterWindow(this);
        }
        filterPanel.setContent((Component)this.filterListLayout);
        filterPanel.setHeight("150px");
        filterPanel.setWidthFull();
        filterPanel.getStyle().set("margin", "0");
        mainLayout.add(new Component[]{filterPanel});
        mainLayout.expand(new Component[]{filterPanel});
        Button closeButton = new Button(controller.getMessage("Close", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
        Button okButton = as.createPrimaryButton(controller.getMessage("OK", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
            this.applyFilters();
            this.close();
        });
        this.cancelShortcutRegistration = UI.getCurrent().addShortcutListener((Command & Serializable)() -> this.close(), Key.ESCAPE, new KeyModifier[0]);
        UI.getCurrent().addShortcutListener((Command & Serializable)() -> {
            this.applyFilters();
            this.close();
        }, Key.ENTER, new KeyModifier[0]).bindLifecycleTo((Component)this);
        this.addAndExpand(new Component[]{mainLayout});
        this.getFooter().add(new Component[]{closeButton, okButton});
    }

    protected void applyFilters() {
        this.filterSource.applyFilters(this.filterCriteria);
    }

    public void applyFilter(FilterCriterion filterCriterion) {
        this.noFilters.setVisible(false);
        this.addOrMergeFilter(filterCriterion);
    }

    protected void addFilterTag(FilterCriterion filterCriterion) {
        z tagLayout = new z(this.controller, filterCriterion);
        tagLayout.addButtonClickListerner((ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
            this.filterTags.remove(new Component[]{tagLayout});
            this.filterCriteria.remove(filterCriterion);
            if (this.filterCriteria.isEmpty()) {
                this.noFilters.setVisible(true);
            }
        });
        this.filterTags.add(new Component[]{tagLayout});
    }

    public void createDynamicFilters(List<c> filters) {
        FlexLayout dynamicLayout = new FlexLayout();
        dynamicLayout.getElement().setAttribute("theme", "spacing");
        dynamicLayout.setFlexWrap(FlexLayout.FlexWrap.WRAP);
        Label titleLabel = new Label("<b>Additional</b>");
        titleLabel.setWidthFull();
        dynamicLayout.add(new Component[]{titleLabel});
        ArrayList<String> optionList = new ArrayList<String>();
        for (c filter : filters) {
            optionList.add(filter.getTitle());
            filter.setFilterWindow(this);
        }
        Select options = new Select();
        options.setItems(optionList);
        options.setWidth("200px");
        options.getStyle().set("margin", "0 16px 0 0");
        options.setEmptySelectionAllowed(false);
        options.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (this.dynamicFilter != null) {
                dynamicLayout.remove(new Component[]{this.dynamicFilter});
            }
            for (c filter : filters) {
                if (!filter.getTitle().equals(event.getValue())) continue;
                filter.setTitleVisible(false);
                dynamicLayout.add(new Component[]{filter});
                this.dynamicFilter = filter;
            }
        });
        dynamicLayout.add(new Component[]{options});
        this.filterListLayout.add(new Component[]{dynamicLayout});
    }

    protected void addOrMergeFilter(FilterCriterion newCriterion) {
        List<FilterCriterion> propertyFilters = this.getPropertyFilters(newCriterion.getPropertyId());
        boolean merged = false;
        for (int r2 = 0; r2 < propertyFilters.size(); ++r2) {
            FilterCriterion originalCriterion = propertyFilters.get(r2);
            if (!this.canMergeCriteria(newCriterion, originalCriterion)) continue;
            this.removeFilterTag(originalCriterion);
            this.mergeValues(originalCriterion, newCriterion);
            if (newCriterion.getOption() == FilterCriterion.FilterOption.EQUALS && originalCriterion.getValues().size() > 1) {
                originalCriterion.setOption(FilterCriterion.FilterOption.IN_LIST);
            } else if (newCriterion.getOption() == FilterCriterion.FilterOption.NOT_EQUALS && originalCriterion.getValues().size() > 1) {
                originalCriterion.setOption(FilterCriterion.FilterOption.NOT_IN_LIST);
            }
            this.addFilterTag(originalCriterion);
            merged = true;
        }
        if (!merged) {
            this.filterCriteria.add(newCriterion);
            this.addFilterTag(newCriterion);
        }
    }

    protected void mergeValues(FilterCriterion originalFilter, FilterCriterion filterCriterion) {
        for (Object newValue : filterCriterion.getValues()) {
            boolean contains = false;
            for (int o2 = 0; o2 < originalFilter.getValues().size(); ++o2) {
                Object original = originalFilter.getValues().get(o2);
                if (!newValue.equals(original) && newValue != original) continue;
                contains = true;
            }
            if (contains) continue;
            originalFilter.getValues().add(newValue);
        }
    }

    protected boolean canMergeCriteria(FilterCriterion newCriterion, FilterCriterion originalCriterion) {
        boolean canMerge = false;
        FilterCriterion.FilterOption newOption = newCriterion.getOption();
        FilterCriterion.FilterOption originalOption = originalCriterion.getOption();
        canMerge = newOption == FilterCriterion.FilterOption.EQUALS && (originalOption == FilterCriterion.FilterOption.EQUALS || originalOption == FilterCriterion.FilterOption.IN_LIST) || (newOption == FilterCriterion.FilterOption.IN_LIST || newOption == FilterCriterion.FilterOption.NOT_IN_LIST) && newOption == originalOption || newOption == FilterCriterion.FilterOption.NOT_EQUALS && (originalOption == FilterCriterion.FilterOption.NOT_EQUALS || originalOption == FilterCriterion.FilterOption.NOT_IN_LIST);
        return canMerge;
    }

    protected List<FilterCriterion> getPropertyFilters(String propertyId) {
        ArrayList<FilterCriterion> criteria = new ArrayList<FilterCriterion>();
        for (FilterCriterion filterCriterion : this.filterCriteria) {
            if (!filterCriterion.getPropertyId().equals(propertyId)) continue;
            criteria.add(filterCriterion);
        }
        return criteria;
    }

    protected void removeFilterTag(FilterCriterion filterCriterion) {
        z toRemove = null;
        for (int c2 = 0; c2 < this.filterTags.getComponentCount(); ++c2) {
            z filterTag = (z)this.filterTags.getComponentAt(c2);
            if (!filterTag.getFilterCriterion().equals(filterCriterion)) continue;
            toRemove = filterTag;
            break;
        }
        if (toRemove != null) {
            this.filterTags.remove(new Component[]{toRemove});
        }
    }

    protected void clear() {
        this.filterCriteria.clear();
        this.filterTags.removeAll();
        this.noFilters.setVisible(true);
    }

    public void toggleShortcutListener(boolean opened) {
        if (opened && this.cancelShortcutRegistration != null) {
            this.cancelShortcutRegistration.remove();
            this.cancelShortcutRegistration = null;
        } else if (!opened && this.cancelShortcutRegistration == null) {
            this.cancelShortcutRegistration = UI.getCurrent().addShortcutListener((Command & Serializable)() -> this.close(), Key.ESCAPE, new KeyModifier[0]);
        }
    }
}

