/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import bsh.Parser;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import de.f0rce.ace.AceEditor;
import de.f0rce.ace.enums.AceMarkerColor;
import de.f0rce.ace.enums.AceMode;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.Consumer;
import javax.tools.Diagnostic;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.util.SimpleClassCompilerException;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;

public abstract class f
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String JAVASE_6_DOCS_API = "<a href='http://docs.oracle.com/javase/6/docs/api/";
    private static final String SYMMETRICDS_SF_NET_DOC = "<a href='http://symmetricds.sf.net/doc/";
    private static final String PRE_PRETTYPRINT = "<pre class='prettyprint' style='white-space: pre-wrap;'>";
    private static final String PRE_ENDTAG = "</pre>";
    protected Method method;
    protected a mode = a.JAVA;
    protected AceEditor editor;
    protected Label header;
    protected Class<?>[] interfaceClasses;
    protected StandardReflectionParameterNameDiscoverer discoverer = new StandardReflectionParameterNameDiscoverer();
    protected int cursorPosition = 0;
    protected Consumer<Boolean> shortcutToggler;

    public f() {
        this.setSizeFull();
        this.editor = as.createAceEditor();
        this.editor.setMode(AceMode.java);
        this.editor.addSelectionChangeListener((ComponentEventListener & Serializable)event -> {
            this.cursorPosition = event.getSelection().getStartIndex();
        });
        this.editor.setSizeFull();
        this.header = new Label();
        this.add(new Component[]{this.header});
        this.addAndExpand(new Component[]{this.editor});
    }

    public void focus() {
        this.editor.focus();
    }

    public f(Method method) {
        this();
        this.method = method;
    }

    public void setValue(String text) {
        this.editor.setValue(text);
    }

    public String getValue() {
        return this.editor.getValue();
    }

    public void setInterfaceClasses(Class<?> ... interfaceClazzes) {
        this.interfaceClasses = interfaceClazzes;
    }

    public Class<?>[] getInterfaceClasses() {
        return this.interfaceClasses;
    }

    public void setMethod(Method method) {
        this.method = method;
        if (method == null) {
            this.header.setText("");
            this.header.setVisible(false);
        } else {
            this.header.setText(PRE_PRETTYPRINT + this.getMethodDeclaration() + PRE_ENDTAG);
            this.header.setVisible(true);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMode(a mode) {
        this.mode = mode;
    }

    public a getMode() {
        return this.mode;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public AceEditor getEditor() {
        return this.editor;
    }

    private void appendJavadocLink(Class<?> type, StringBuilder link) {
        if (type.getPackage() == null) {
            link.append(type.getName());
        } else {
            if (type.getPackage().toString().contains("jumpmind")) {
                int[] versionNumbers = Version.parseVersion((String)Version.version());
                String version = versionNumbers[0] + "." + versionNumbers[1];
                link.append(SYMMETRICDS_SF_NET_DOC).append(version).append("/javadoc/");
            } else {
                link.append(JAVASE_6_DOCS_API);
            }
            link.append(type.getName().replaceAll("\\.", "/"));
            link.append(".html' target='_blank'>");
            link.append(type.getSimpleName());
            link.append("</a>");
        }
    }

    private void appendMethodJavadoc(StringBuilder link) {
        int[] versionNumbers = Version.parseVersion((String)Version.version());
        String version = versionNumbers[0] + "." + versionNumbers[1];
        link.append(SYMMETRICDS_SF_NET_DOC).append(version).append("/javadoc/");
        Class<?> type = null;
        if (this.interfaceClasses != null) {
            for (Class<?> interfaceClass : this.interfaceClasses) {
                try {
                    if (interfaceClass.getMethod(this.method.getName(), this.method.getParameterTypes()) == null) continue;
                    type = interfaceClass;
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        if (type == null) {
            type = this.method.getClass();
        }
        link.append(type.getName().replaceAll("\\.", "/").replaceAll("\\$", "."));
        link.append(".html#");
        link.append(this.method.getName()).append("(");
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        int index = 0;
        int count = parameterTypes.length;
        for (Class<?> parameterType : parameterTypes) {
            link.append(parameterType.getName());
            if (++index >= count) continue;
            link.append(",");
        }
        link.append(")' target='_blank'>");
        link.append(this.method.getName());
        link.append("</a>");
    }

    private String getMethodDeclaration() {
        StringBuilder declaration = new StringBuilder();
        if (Modifier.isPublic(this.method.getModifiers())) {
            declaration.append("public ");
        } else if (Modifier.isProtected(this.method.getModifiers())) {
            declaration.append("protected ");
        }
        if (this.method.getReturnType().equals(Void.TYPE)) {
            declaration.append("void ");
        } else if (this.method.getReturnType().isPrimitive()) {
            declaration.append(this.method.getReturnType().toString()).append(" ");
        } else {
            this.appendJavadocLink(this.method.getReturnType(), declaration);
            declaration.append(" ");
        }
        this.appendMethodJavadoc(declaration);
        declaration.append("(");
        String[] paramNames = this.discoverer.getParameterNames(this.method);
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        int index = 0;
        int count = parameterTypes.length;
        for (Class<?> parameterType : parameterTypes) {
            this.appendJavadocLink(parameterType, declaration);
            if (paramNames != null && paramNames.length > index) {
                declaration.append(" ");
                declaration.append(paramNames[index]);
            }
            if (++index >= count) continue;
            declaration.append(", ");
        }
        declaration.append(")");
        return declaration.toString();
    }

    protected abstract void compile() throws Exception;

    protected abstract int countHeaderLines();

    public void validate() {
        block15: {
            this.clearErrors();
            if (StringUtils.isNotBlank((CharSequence)this.editor.getValue())) {
                if (this.mode == a.JAVA) {
                    try {
                        this.compile();
                        CommonUiUtils.notify((String)"", (String)"Valid Java code.", this.shortcutToggler);
                    }
                    catch (SimpleClassCompilerException e2) {
                        this.showErrors(e2);
                    }
                    catch (Exception e3) {
                        String message = e3.getMessage();
                        if (message != null) {
                            CommonUiUtils.notify((String)"", (String)message, this.shortcutToggler);
                            break block15;
                        }
                        CommonUiUtils.notify((String)"", (String)"Invalid Java code.", this.shortcutToggler);
                    }
                } else if (this.mode == a.BSH) {
                    try {
                        Parser parser = new Parser((Reader)new StringReader("test() { " + this.getValue() + "}"));
                        while (!parser.Line()) {
                        }
                        CommonUiUtils.notify((String)"", (String)"Valid Bean Shell script.", this.shortcutToggler);
                    }
                    catch (Exception e4) {
                        CommonUiUtils.notify((String)"", (String)e4.getMessage(), this.shortcutToggler);
                    }
                } else {
                    try {
                        CCJSqlParserUtil.parse((String)this.getValue());
                        CommonUiUtils.notify((String)"", (String)"Valid SQL script.", this.shortcutToggler);
                    }
                    catch (JSQLParserException e5) {
                        String message = e5.getCause().getMessage();
                        if (message != null) {
                            CommonUiUtils.notify((String)"", (String)message, this.shortcutToggler);
                        }
                        CommonUiUtils.notify((String)"", (String)"Invalid SQL script.", this.shortcutToggler);
                    }
                }
            }
        }
    }

    public void clearErrors() {
        this.editor.removeAllMarkers();
    }

    public void showErrors(SimpleClassCompilerException e2) {
        this.editor.removeAllMarkers();
        List errors = e2.getDiagnostics();
        this.editor.setHighlightActiveLine(errors == null);
        if (errors != null) {
            Object errorString = "";
            for (Diagnostic error : errors) {
                if (error.getKind() != Diagnostic.Kind.ERROR) continue;
                int lineNumber = (int)error.getLineNumber() - this.countHeaderLines() - 2;
                if (lineNumber <= 0) {
                    lineNumber = 0;
                }
                String value = this.getValue();
                int columnStart = (int)error.getColumnNumber() - 1;
                int columnEnd = columnStart + ((int)error.getEndPosition() - (int)error.getStartPosition());
                if (value == null) {
                    columnStart = 0;
                } else {
                    String[] lines = value.split("\n");
                    if (lines.length > lineNumber) {
                        if (lines[lineNumber].length() < columnStart) {
                            columnStart = 0;
                        }
                        if (lines[lineNumber].length() < columnEnd || columnStart == columnEnd) {
                            int offset = lines[lineNumber].substring(columnStart).indexOf(" ");
                            columnEnd = offset > 0 ? columnStart + offset : lines[lineNumber].length() - 1;
                        }
                    } else {
                        columnStart = 0;
                        columnEnd = 0;
                    }
                }
                String message = error.getMessage(null);
                String PREFIX = "string:///SimpleClassCompiler";
                if (message != null && message.startsWith("string:///SimpleClassCompiler")) {
                    message = message.substring("string:///SimpleClassCompiler".length());
                    message = message.substring(message.indexOf(":") + 1);
                    message = message.substring(message.indexOf(":") + 1).trim();
                }
                errorString = (String)errorString + "Compile error detected at line " + lineNumber + ", column " + columnStart + ", column end " + columnEnd + ", message: " + message + "\n";
                this.editor.addMarkerAtSelection(lineNumber, columnStart, lineNumber, columnEnd, AceMarkerColor.red);
            }
            CommonUiUtils.notify((String)"", (String)errorString, this.shortcutToggler);
        } else if (e2.getMessage() != null) {
            CommonUiUtils.notify((String)"", (String)e2.getMessage(), this.shortcutToggler);
        }
    }

    public static enum a {
        BSH,
        JAVA,
        SQL;

    }
}

