/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.impl.G;
import com.jumpmind.symmetric.console.impl.ac;
import com.jumpmind.symmetric.console.impl.bk;
import com.jumpmind.symmetric.console.ui.common.B;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.J;
import com.jumpmind.symmetric.console.ui.common.ap;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.util.LinkedCaseInsensitiveMap;
import org.jumpmind.vaadin.ui.common.Label;
import org.springframework.util.CollectionUtils;

public abstract class d
extends HorizontalLayout
implements J,
ComponentEventListener<ClickEvent<Button>> {
    private static final long serialVersionUID = 1L;
    static final int MENU_WIDTH = 200;
    protected I controller;
    protected VerticalLayout menuParent;
    protected VerticalLayout menu;
    protected boolean isFirstItemAddedToMenu = false;
    protected Component currentSelection;
    protected Component firstSelection;
    protected VerticalLayout secondComponent;
    protected Map<String, Component> components = new LinkedCaseInsensitiveMap();
    protected Map<String, Button> buttons = new LinkedCaseInsensitiveMap();
    protected String title;
    protected String docAnchor;

    public d(I controller, String title) {
        this.controller = controller;
        this.title = title;
        this.setSizeFull();
        this.setSpacing(false);
        this.getStyle().set("border-top", "1px solid var(--lumo-contrast-20pct)");
        Scroller menuScroller = new Scroller();
        menuScroller.setWidth("200px");
        menuScroller.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
        menuScroller.getStyle().set("min-width", "200px").set("border-right", "1px solid var(--lumo-contrast-20pct)");
        this.menuParent = new VerticalLayout();
        this.menuParent.setPadding(false);
        this.menuParent.setSpacing(false);
        this.menuParent.setWidth("200px");
        this.menu = new VerticalLayout();
        this.menu.setPadding(false);
        this.menu.setSpacing(false);
        this.menu.setWidth("198px");
        this.menu.setClassName("side-menu");
        this.menuParent.add(new Component[]{this.menu});
        menuScroller.setContent((Component)this.menuParent);
        this.secondComponent = new VerticalLayout();
        this.secondComponent.setSizeFull();
        this.secondComponent.setSpacing(false);
        this.secondComponent.setPadding(false);
        this.add(new Component[]{menuScroller, this.secondComponent});
        this.expand(new Component[]{this.secondComponent});
        this.initMenu();
        UI.getCurrent().addShortcutListener((Command & Serializable)() -> {
            Set<String> names = this.components.keySet();
            boolean selectNext = false;
            for (String name : names) {
                Component c2 = this.components.get(name);
                if (selectNext) {
                    this.onRefresh(name);
                    selectNext = false;
                    break;
                }
                if (!c2.equals(this.currentSelection)) continue;
                selectNext = true;
            }
            if (selectNext && names.size() > 0) {
                this.onRefresh(names.iterator().next());
            }
        }, Key.ARROW_DOWN, new KeyModifier[]{KeyModifier.ALT});
        UI.getCurrent().addShortcutListener((Command & Serializable)() -> {
            ArrayList<String> names = new ArrayList<String>(this.components.keySet());
            Collections.reverse(names);
            boolean selectNext = false;
            for (String name : names) {
                Component c2 = this.components.get(name);
                if (selectNext) {
                    this.onRefresh(name);
                    selectNext = false;
                    break;
                }
                if (!c2.equals(this.currentSelection)) continue;
                selectNext = true;
            }
            if (selectNext && names.size() > 0) {
                this.onRefresh(names.iterator().next());
            }
        }, Key.ARROW_UP, new KeyModifier[]{KeyModifier.ALT});
    }

    @Override
    public void init() {
    }

    protected abstract void initMenu();

    public void onComponentEvent(final ClickEvent<Button> event) {
        boolean okToSwitch = true;
        final Component comp = (Component)ComponentUtil.getData((Component)event.getSource(), (String)"comp");
        Runnable switchClosure = new Runnable(){

            @Override
            public void run() {
                d.this.selectButton((Button)event.getSource());
                d.this.addToView(comp, null);
                d.this.controller.refreshAlerts();
            }
        };
        if (this.currentSelection instanceof J) {
            J view = (J)this.currentSelection;
            okToSwitch = view.onExit(switchClosure);
            if (view instanceof G) {
                this.controller.getBackgroundRefresherService().d((G)((Object)view));
            }
        }
        if (okToSwitch) {
            switchClosure.run();
        }
    }

    public void addToView(Component comp, Object[] params) {
        if (!this.controller.checkLicenseViolations(0, 0, null) && this.controller.checkIfGlassIsStillBroken()) {
            String descriptionKey;
            boolean isCurrentSelection = comp != null && comp.equals(this.currentSelection);
            this.currentSelection = comp;
            this.secondComponent.removeAll();
            Scroller titleWrapperPanel = new Scroller();
            titleWrapperPanel.setWidthFull();
            titleWrapperPanel.setHeight("100px");
            titleWrapperPanel.addClassName("screen-layout");
            VerticalLayout layout = new VerticalLayout();
            layout.setMargin(false);
            layout.setSpacing(false);
            layout.setWidthFull();
            HorizontalLayout hlayout = new HorizontalLayout();
            hlayout.setClassName("screen-description");
            hlayout.setWidthFull();
            if (comp instanceof B && StringUtils.isNotBlank((CharSequence)(descriptionKey = ((B)comp).getDescriptionKey()))) {
                Label helpLabel = new Label(this.controller.getMessage(descriptionKey, new Object[0]));
                helpLabel.setSizeFull();
                helpLabel.getStyle().set("margin", null);
                hlayout.add(new Component[]{helpLabel});
                hlayout.setFlexGrow((double)0.94f, new HasElement[]{helpLabel});
                hlayout.setVerticalComponentAlignment(FlexComponent.Alignment.START, new Component[]{helpLabel});
            }
            this.docAnchor = null;
            if (this.currentSelection instanceof J) {
                this.docAnchor = ((J)this.currentSelection).getDocAnchor();
            } else if (this.currentSelection instanceof ac) {
                this.docAnchor = "/doc/html/user-guide.html#" + ((ac)this.currentSelection).getForm().getHelpSectionName();
            } else if (this.currentSelection instanceof bk) {
                this.docAnchor = "/doc/html/user-guide.html#" + ((bk)this.currentSelection).getHelpSectionName();
            }
            if (this.docAnchor == null) {
                this.docAnchor = "/doc/html/user-guide.html";
            }
            String url = this.controller.getUrlPath();
            String docUrl = url.toString().substring(0, url.toString().indexOf("/app"));
            if (!as.hasHelpHtml()) {
                docUrl = "https://downloads.jumpmind.com/symmetricds/";
                this.docAnchor = this.docAnchor.replace("/doc/", "/doc/" + Version.getMajorVersion() + "." + Version.getMinorVersion() + "/");
            }
            Anchor helpAnchor = new Anchor(docUrl + this.docAnchor, "More Help");
            Icon icon = new Icon(VaadinIcon.QUESTION_CIRCLE);
            icon.setSize("16px");
            icon.getStyle().set("margin-right", "5px");
            helpAnchor.getElement().insertChild(0, new Element[]{icon.getElement()});
            helpAnchor.setTarget("_blank");
            helpAnchor.setSizeFull();
            helpAnchor.setWidth("120px");
            helpAnchor.setHeightFull();
            hlayout.add(new Component[]{helpAnchor});
            hlayout.setFlexGrow((double)0.06f, new HasElement[]{helpAnchor});
            hlayout.setVerticalComponentAlignment(FlexComponent.Alignment.START, new Component[]{helpAnchor});
            layout.add(new Component[]{hlayout});
            layout.addAndExpand(new Component[]{comp});
            layout.setHeight("88%");
            titleWrapperPanel.setContent((Component)layout);
            Div titleRibbon = new Div();
            titleRibbon.setText(this.title + " " + this.getSelectedButtonCaption());
            titleRibbon.addClassName("screen-title");
            this.secondComponent.add(new Component[]{titleRibbon, titleWrapperPanel});
            this.secondComponent.expand(new Component[]{titleWrapperPanel});
            if (comp instanceof J) {
                J view = (J)comp;
                this.controller.initAndRefreshView(view, !isCurrentSelection, params);
            }
        }
    }

    protected void addSectionTitle(String sectionTitleKey) {
        Div sectionTitleContainer = new Div();
        sectionTitleContainer.addClassName("side-menu-header");
        sectionTitleContainer.setText(this.controller.getMessage(sectionTitleKey, new Object[0]));
        this.menu.add(new Component[]{sectionTitleContainer});
    }

    protected void addMenuItem(String labelKey, Component comp) {
        this.addMenuItem(labelKey, null, comp);
    }

    protected void addMenuItem(String labelKey, String title, Component comp) {
        if (comp == null) {
            ap blankLayout = new ap();
            blankLayout.setMargin(true);
            blankLayout.add(new Component[]{new Span("TODO")});
            blankLayout.setSizeFull();
            comp = blankLayout;
        }
        Button b2 = new Button((String)null, (ComponentEventListener)this);
        b2.getElement().setProperty("innerHTML", this.controller.getMessage(labelKey, new Object[0]));
        if (title != null) {
            b2.getElement().setAttribute("title", title);
        }
        b2.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY, ButtonVariant.LUMO_SMALL});
        if (!this.isFirstItemAddedToMenu) {
            b2.addClassName("selected");
            this.isFirstItemAddedToMenu = true;
            this.firstSelection = comp;
        }
        this.components.put(this.controller.getMessage(labelKey, new Object[0]), (Component)comp);
        try {
            this.buttons.put(this.controller.getMessage(labelKey, new Object[0]), b2);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.menu.add(new Component[]{b2});
        ComponentUtil.setData((Component)b2, (String)"comp", (Object)comp);
    }

    public String getTitle() {
        return this.title;
    }

    protected void selectButton(Button button) {
        Collection<Button> all = this.buttons.values();
        for (Button b2 : all) {
            b2.removeClassName("selected");
        }
        button.addClassName("selected");
    }

    protected String getSelectedButtonCaption() {
        Collection<Button> all = this.buttons.values();
        for (Button b2 : all) {
            if (!"selected".equals(b2.getClassName())) continue;
            if (b2.getElement().hasAttribute("title")) {
                return b2.getElement().getAttribute("title");
            }
            return b2.getElement().getProperty("innerHTML");
        }
        return "";
    }

    @Override
    public void onRefresh(Object ... params) {
        if (params != null && params.length > 0) {
            String viewName;
            Component c2;
            if (params[0] instanceof String && (c2 = this.components.get(viewName = (String)params[0])) != null) {
                ArrayList list = new ArrayList();
                CollectionUtils.mergeArrayIntoCollection((Object)params, list);
                list.remove(0);
                params = list.toArray();
                this.selectButton(this.buttons.get(viewName));
                this.addToView(c2, params);
            }
        } else if (this.currentSelection instanceof J) {
            J view = (J)this.currentSelection;
            this.controller.initAndRefreshView(view, true, params);
        }
        if (this.currentSelection == null) {
            this.addToView(this.firstSelection, params);
        }
    }

    @Override
    public boolean onExit(Runnable exitClosure) {
        if (this.currentSelection instanceof J) {
            J view = (J)this.currentSelection;
            boolean exit = view.onExit(exitClosure);
            if (exit && view instanceof G) {
                this.controller.getBackgroundRefresherService().d((G)((Object)view));
            }
            return exit;
        }
        return true;
    }

    @Override
    public void applicationClosing() {
    }
}

