/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.ac;
import com.jumpmind.symmetric.console.impl.bD;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.ui.common.B;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.J;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.ItemClickEvent;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.vaadin.ui.common.ColumnVisibilityToggler;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.CustomSplitLayout;
import org.jumpmind.vaadin.ui.common.Label;
import org.jumpmind.vaadin.ui.common.TabSheet;
import org.jumpmind.vaadin.ui.common.TabbedApplicationPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class b<T extends IModelObject>
extends TabbedApplicationPanel
implements B,
J {
    private static final long serialVersionUID = 1L;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Grid<T> grid;
    protected List<T> itemList;
    protected Set<T> selectedItemSet;
    protected TextField searchField;
    protected ColumnVisibilityToggler columnVisibilityToggler;
    protected FlexLayout buttonLayout;
    protected Button newButton;
    protected Button editButton;
    protected Button deleteButton;
    protected Button selectAllLink;
    protected Span displaySpan;
    protected String descriptionKey;
    protected I controller;
    protected ComponentEventListener<ItemClickEvent<T>> defaultItemClickListener;
    protected Registration itemClickListenerRegistration;
    protected Registration itemMultiSelectListenerRegistration;
    protected Registration itemShortcutListenerRegistration;
    protected ShortcutRegistration defaultEnterRegistration;

    public b(I controller) {
        this(null, controller);
    }

    public abstract String getNewTitle();

    public abstract String getEditTitle();

    public abstract String getTitleKey();

    public b(String descriptionKey, I controller) {
        this.descriptionKey = descriptionKey;
        this.controller = controller;
    }

    @Override
    public void init() {
        if (this.grid == null) {
            this.buttonLayout = new FlexLayout();
            this.buttonLayout.setFlexWrap(FlexLayout.FlexWrap.WRAP);
            this.buttonLayout.getElement().setAttribute("theme", "spacing");
            this.buttonLayout.setWidthFull();
            this.searchField = as.createSearchField();
            this.searchField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.search(this.searchField.getValue()));
            this.newButton = new Button(this.controller.getMessage("New", new Object[0]));
            this.newButton.getStyle().set("margin", "4px");
            this.newButton.addClickListener((ComponentEventListener & Serializable)event -> {
                if (!this.checkViolations()) {
                    a formLayout = new a(this.getNewTitle(), true, true, true);
                    this.addCloseableTab(this.getNewTitle(), new Icon(VaadinIcon.EDIT), (Component)formLayout);
                }
            });
            this.editButton = new Button(this.controller.getMessage("Edit", new Object[0]));
            this.editButton.getStyle().set("margin", "4px");
            this.editButton.addClickListener((ComponentEventListener & Serializable)event -> this.showEditTab());
            this.deleteButton = new Button(this.controller.getMessage("Delete", new Object[0]));
            this.deleteButton.getStyle().set("margin", "4px");
            this.deleteButton.setEnabled(false);
            this.deleteButton.addClickListener((ComponentEventListener & Serializable)event -> {
                String message = "";
                message = this.grid.getSelectedItems().size() > 1 ? this.controller.getMessage("About to delete these rows.\n Are you sure?", new Object[0]) : this.controller.getMessage("About to delete this row.\n Are you sure?", new Object[0]);
                new ConfirmDialog(this.controller.getMessage("Confirm", new Object[0]), message, this.controller.getMessage("Ok", new Object[0]), (ComponentEventListener & Serializable)e2 -> this.deleteSelectedItems(), this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)e2 -> {}).open();
            });
            this.displaySpan = new Span();
            this.displaySpan.setSizeUndefined();
            this.columnVisibilityToggler = new ColumnVisibilityToggler();
            this.columnVisibilityToggler.getStyle().set("margin-left", "8px");
            this.initGrid();
            this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
            this.grid.setColumnReorderingAllowed(true);
            this.configureGridColumns();
            if (this.grid.getColumnByKey(this.getKeyColumn()) != null) {
                GridSortOrder order = new GridSortOrder(this.grid.getColumnByKey(this.getKeyColumn()), SortDirection.ASCENDING);
                ArrayList<GridSortOrder> orderList = new ArrayList<GridSortOrder>();
                orderList.add(order);
                this.grid.sort(orderList);
            }
            this.selectedItemSet = new HashSet<T>();
            this.itemMultiSelectListenerRegistration = ((GridMultiSelectionModel)this.grid.getSelectionModel()).addMultiSelectionListener((MultiSelectionListener & Serializable)event -> {
                this.resetButtonLayout();
                if (event.isFromClient()) {
                    this.selectedItemSet.addAll(event.getAddedSelection());
                    this.selectedItemSet.removeAll(event.getRemovedSelection());
                }
                if (!this.grid.getSelectedItems().isEmpty()) {
                    this.itemSelected();
                } else {
                    this.noItemsSelected();
                }
            });
            this.defaultEnterRegistration = Shortcuts.addShortcutListener((Component)this, (Command & Serializable)() -> {
                if (this.gridCanBeModified()) {
                    this.editButton.click();
                }
            }, (Key)Key.ENTER, (KeyModifier[])new KeyModifier[0]).listenOn(new Component[]{this.grid});
            this.defaultItemClickListener = (ComponentEventListener & Serializable)event -> {
                if (event.getColumn() != null && this.grid.getSelectionModel() instanceof GridMultiSelectionModel) {
                    this.selectedItemSet.removeAll(this.grid.getSelectedItems());
                    this.grid.deselectAll();
                    this.grid.select((Object)((IModelObject)event.getItem()));
                    this.selectedItemSet.add((IModelObject)event.getItem());
                }
                StringBuilder tooltipTest = new StringBuilder();
                if (this.gridCanBeModified() && this.isEditEnabled(tooltipTest) && event.getClickCount() == 2 && event.getItem() != null) {
                    this.showEditTab();
                }
            };
            this.itemClickListenerRegistration = this.grid.addItemClickListener(this.defaultItemClickListener);
            this.grid.setSizeFull();
            this.setMainTab(this.message(this.getTitleKey()), new Icon(VaadinIcon.TABLE), this.buildMainTab());
        }
    }

    protected void deleteSelectedItems() {
        R<T> form = this.createForm(false, true);
        form.setFormListener(new ac(){
            private static final long serialVersionUID = 1L;

            @Override
            public void formSaved() {
            }

            @Override
            public void formDeleted() {
                b.this.onRefresh(new Object[0]);
                b.this.updateDisplaySpan();
            }

            @Override
            public R<?> getForm() {
                return null;
            }

            @Override
            public a getFormLayout() {
                return null;
            }

            @Override
            public void closeForm(boolean force) {
            }
        });
        form.delete();
    }

    protected Component buildMainTab() {
        VerticalLayout layout = new VerticalLayout();
        layout.setClassName("tab-layout");
        layout.setMargin(false);
        layout.setSpacing(true);
        layout.getThemeList().remove((Object)"padding");
        layout.setSizeFull();
        layout.add(new Component[]{this.buttonLayout});
        layout.addAndExpand(new Component[]{this.grid});
        HorizontalLayout hlayout = new HorizontalLayout();
        layout.add(new Component[]{hlayout});
        this.selectAllLink = as.createLinkButton(this.controller.getMessage("Select All", new Object[0]));
        hlayout.add(new Component[]{this.selectAllLink});
        this.selectAllLink.addClickListener((ComponentEventListener & Serializable)event -> {
            for (IModelObject item : this.grid.getDataProvider().fetch(new Query()).collect(Collectors.toList())) {
                this.grid.select((Object)item);
                this.selectedItemSet.add(item);
            }
        });
        Button selectNoneLink = as.createLinkButton(this.controller.getMessage("Select None", new Object[0]));
        hlayout.add(new Component[]{selectNoneLink});
        selectNoneLink.addClickListener((ComponentEventListener & Serializable)event -> {
            this.grid.deselectAll();
            this.selectedItemSet.clear();
        });
        hlayout.addAndExpand(new Component[]{new Span()});
        hlayout.setWidth("99%");
        hlayout.add(new Component[]{this.displaySpan});
        return layout;
    }

    protected void search(String searchText) {
        this.fillGrid(this.grid);
        this.updateDisplaySpan();
        this.searchField.focus();
    }

    protected void updateDisplaySpan() {
        this.displaySpan.setText(this.controller.getMessage("Rows Returned", new Object[0]) + ": " + this.grid.getDataProvider().fetch(new Query()).count());
    }

    protected void itemSelected() {
    }

    protected void noItemsSelected() {
    }

    public void deselectAll() {
        this.grid.deselectAll();
        this.selectedItemSet.clear();
    }

    protected void updateItems(Collection<T> items) {
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.grid.getDataProvider().refreshAll();
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.grid.setItems(items);
        for (IModelObject item : this.selectedItemSet) {
            if (!items.contains(item)) continue;
            this.grid.select((Object)item);
        }
    }

    protected void showEditTab() {
        if (!this.grid.getSelectedItems().isEmpty()) {
            String caption = null;
            caption = this.grid.getSelectedItems().size() > 1 ? "Bulk Edit" : this.controller.getMessage(this.getEditTitle(), this.getId((IModelObject)this.grid.getSelectedItems().iterator().next()));
            a formLayout = new a(caption, true, true, false);
            this.addCloseableTab(caption, new Icon(VaadinIcon.EDIT), (Component)formLayout);
        }
    }

    protected String getId(T item) {
        return "";
    }

    @Override
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    protected void resetButtonLayout() {
        this.buttonLayout.removeAll();
        boolean canModify = this.gridCanBeModified();
        if (canModify) {
            this.buttonLayout.add(new Component[]{this.newButton});
            this.addButtonsLeft(this.buttonLayout);
            this.buttonLayout.add(new Component[]{this.buildSeperater()});
        }
        if (canModify) {
            this.buttonLayout.add(new Component[]{this.editButton});
            StringBuilder tooltipDelete = new StringBuilder();
            StringBuilder tooltipNew = new StringBuilder();
            StringBuilder tooltipEdit = new StringBuilder();
            if (this.isEditEnabled(tooltipEdit)) {
                this.editButton.setEnabled(!this.grid.getSelectedItems().isEmpty());
            } else {
                this.editButton.setEnabled(false);
                this.editButton.getElement().setAttribute("title", tooltipEdit.toString());
            }
            this.deleteButton.setEnabled(this.isDeleteEnabled(tooltipDelete));
            this.deleteButton.getElement().setAttribute("title", tooltipDelete.toString());
            this.newButton.setEnabled(this.isNewEnabled(tooltipNew));
            this.newButton.getElement().setAttribute("title", tooltipNew.toString());
            this.buttonLayout.add(new Component[]{this.deleteButton});
            this.addButtonsMiddle(this.buttonLayout);
        }
        Span spacer = new Span();
        this.buttonLayout.add(new Component[]{spacer});
        this.buttonLayout.expand(new Component[]{spacer});
        this.addButtonsRight(this.buttonLayout);
        this.buttonLayout.add(new Component[]{this.searchField});
        this.buttonLayout.add(new Component[]{this.columnVisibilityToggler});
    }

    protected boolean gridCanBeModified() {
        return false;
    }

    protected abstract boolean isDeleteEnabled(StringBuilder var1);

    protected abstract boolean isNewEnabled(StringBuilder var1);

    protected abstract boolean isEditEnabled(StringBuilder var1);

    protected void addButtonsLeft(FlexLayout buttonLayout) {
    }

    protected void addButtonsMiddle(FlexLayout buttonLayout) {
    }

    protected void addButtonsRight(FlexLayout buttonLayout) {
    }

    protected abstract R<T> createForm(boolean var1, boolean var2);

    protected abstract void initGrid();

    protected abstract void fillGrid(Grid<T> var1);

    protected abstract Map<String, String> getVisibleGridColumns();

    protected abstract String getKeyColumn();

    protected abstract String[] getFilterColumns();

    protected abstract void hideColumns();

    protected void configureGridColumns() {
        Map<String, String> visibleColumns = this.getVisibleGridColumns();
        visibleColumns.put("lastUpdateTime", this.controller.getMessage("Last Updated", new Object[0]));
        visibleColumns.put("lastUpdateBy", this.controller.getMessage("Last Updated By", new Object[0]));
        visibleColumns.put("createTime", this.controller.getMessage("Created", new Object[0]));
        Set<String> colKeys = visibleColumns.keySet();
        this.grid.setColumns(colKeys.toArray(new String[colKeys.size()]));
        this.grid.removeColumnByKey("lastUpdateTime");
        this.grid.addColumn((ValueProvider & Serializable)item -> as.formatDate(this.controller, item.getLastUpdateTime())).setComparator((ValueProvider & Serializable)item -> item.getLastUpdateTime()).setKey("lastUpdateTime").setHeader(this.controller.getMessage("Last Updated", new Object[0]));
        this.grid.removeColumnByKey("createTime");
        this.grid.addColumn((ValueProvider & Serializable)item -> as.formatDate(this.controller, item.getCreateTime())).setComparator((ValueProvider & Serializable)item -> item.getCreateTime()).setKey("createTime").setHeader(this.controller.getMessage("Created", new Object[0]));
        List cols = colKeys.stream().map(key -> this.grid.getColumnByKey(key)).collect(Collectors.toList());
        this.grid.setColumnOrder(cols);
        for (String key2 : colKeys) {
            this.grid.getColumnByKey(key2).setHeader(visibleColumns.get(key2)).setResizable(true);
            this.columnVisibilityToggler.addColumn(this.grid.getColumnByKey(key2), visibleColumns.get(key2));
        }
        this.hideColumns();
    }

    @Override
    public void onRefresh(Object ... params) {
        this.refreshUI();
    }

    protected void refreshUI() {
        try {
            this.search(this.searchField.getValue());
            this.updateDisplaySpan();
            if (this.grid.getSelectedItems().isEmpty()) {
                this.noItemsSelected();
            } else {
                this.itemSelected();
            }
            this.resetButtonLayout();
        }
        catch (Exception ex2) {
            this.log.error(ex2.getMessage(), (Throwable)ex2);
            CommonUiUtils.notifyError();
        }
    }

    public void remove(TabSheet.EnhancedTab tab) {
        Component component = tab.getComponent();
        if (component instanceof a) {
            ((a)component).closeForm(false);
        } else if (component instanceof bD.c) {
            ((bD.c)component).c();
        } else {
            this.forceRemove(tab);
        }
    }

    protected void forceRemove(TabSheet.EnhancedTab tab) {
        int tabCount = this.tabList.size();
        if (tab.isSelected() && tabCount > 1) {
            int index = this.tabList.indexOf(tab);
            if (index < tabCount - 1) {
                this.tabs.setSelectedIndex(index + 1);
            } else {
                this.tabs.setSelectedIndex(index - 1);
            }
        }
        this.tabs.remove(new Tab[]{tab});
        this.tabList.remove(tab);
        this.onRefresh(new Object[0]);
    }

    @Override
    public boolean onExit(Runnable exitClosure) {
        return true;
    }

    protected String message(String messageKey) {
        return this.controller.getMessage(messageKey, new Object[0]);
    }

    protected void addEvent(String eventCode, Set<String> values) {
        Object finalValue = "";
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            finalValue = (String)finalValue + iterator.next();
            if (!iterator.hasNext()) continue;
            finalValue = (String)finalValue + ", ";
        }
        this.addEvent(eventCode, (String)finalValue);
    }

    protected void addEvent(String eventCode, String value) {
        String nodeId = this.controller.getSymmetricEngine().getNodeId();
        this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), eventCode, nodeId, nodeId, null, value));
    }

    @Override
    public void applicationClosing() {
    }

    protected boolean canSaveAsCopy() {
        return false;
    }

    protected Span buildSeperater() {
        Span separator = new Span(" ");
        separator.addClassName("vrule");
        separator.setHeight("100%");
        separator.setWidth(null);
        this.buttonLayout.add(new Component[]{separator});
        return separator;
    }

    protected boolean checkViolations() {
        return false;
    }

    public class a
    extends VerticalLayout
    implements ac {
        private static final long serialVersionUID = 1L;
        R<?> form;
        String caption;
        Button helpButton;
        Button advancedOptionsButton;
        boolean showAdvancedChanged;
        Button saveButton;
        Button cancelButton;
        ShortcutRegistration cancelRegistration;
        CustomSplitLayout hsplit;
        double lastSplitPosition;
        Label helpTextLabel;

        public a(String caption, boolean save, boolean cancel, boolean newItemFlag) {
            this.form = b.this.createForm(newItemFlag, false);
            this.form.setFormListener(this);
            this.caption = caption;
            if (as.hasHelpHtml()) {
                this.helpButton = as.createLinkButton("Hide Help", (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
                    if (this.helpButton.getText().equals("Hide Help")) {
                        this.hideHelp();
                    } else {
                        this.showHelp();
                    }
                });
            }
            this.advancedOptionsButton = as.createLinkButton("Show Advanced Options", (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
                this.showAdvancedChanged = true;
                if (this.advancedOptionsButton.getText().equals("Show Advanced Options")) {
                    this.form.setAdvancedOptionsVisible(true);
                    this.advancedOptionsButton.setText(b.this.controller.getMessage("Hide Advanced Options", new Object[0]));
                } else {
                    this.form.setAdvancedOptionsVisible(false);
                    this.advancedOptionsButton.setText("Show Advanced Options");
                }
                this.updateHelpTextSpan();
            });
            this.saveButton = new Button(b.this.controller.getMessage("Save", new Object[0]));
            this.saveButton.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.form.save(false)) {
                    this.closeForm(true);
                }
            });
            Button saveAsCopyButton = new Button(b.this.controller.getMessage("Save as Copy", new Object[0]));
            saveAsCopyButton.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.form.save(true)) {
                    this.closeForm(true);
                }
            });
            this.cancelButton = new Button(b.this.controller.getMessage("Cancel", new Object[0]));
            this.enableCancelShortcut(true);
            this.cancelButton.addClickListener((ComponentEventListener & Serializable)event -> this.closeForm(false));
            HorizontalLayout toolbarLayout = new HorizontalLayout();
            toolbarLayout.setSpacing(true);
            this.add(new Component[]{toolbarLayout});
            if (b.this.gridCanBeModified() && save) {
                toolbarLayout.add(new Component[]{this.saveButton});
                if (b.this.canSaveAsCopy() && !newItemFlag && b.this.grid.getSelectedItems().size() == 1) {
                    toolbarLayout.add(new Component[]{saveAsCopyButton});
                }
            }
            if (cancel) {
                toolbarLayout.add(new Component[]{this.cancelButton});
            }
            toolbarLayout.addAndExpand(new Component[]{new Span()});
            if (this.form.hasAdvancedOptions() && !this.form.isBulkForm()) {
                toolbarLayout.add(new Component[]{this.advancedOptionsButton});
            }
            if (this.helpButton != null) {
                toolbarLayout.add(new Component[]{this.helpButton});
            }
            this.hsplit = new CustomSplitLayout();
            this.hsplit.setWidthFull();
            Scroller leftPanel = new Scroller();
            leftPanel.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
            leftPanel.setClassName("form");
            leftPanel.setHeight("93%");
            VerticalLayout leftVert = new VerticalLayout();
            leftVert.setWidth("98%");
            leftVert.setPadding(false);
            leftVert.setSpacing(false);
            leftVert.setMargin(false);
            leftVert.add(new Component[]{new H3(caption), this.form});
            leftPanel.setContent((Component)leftVert);
            this.hsplit.addToPrimary(new Component[]{leftPanel});
            Scroller rightPanel = new Scroller();
            rightPanel.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
            rightPanel.setHeight("93%");
            rightPanel.setClassName("help");
            VerticalLayout rightVert = new VerticalLayout();
            rightVert.setWidth("97%");
            rightVert.setPadding(false);
            rightVert.setSpacing(false);
            rightVert.setMargin(false);
            this.helpTextLabel = new Label();
            this.helpTextLabel.setWidth(rightVert.getWidth());
            this.updateHelpTextSpan();
            if (!as.hasHelpHtml() || !b.this.controller.getSymmetricEngine().getParameterService().is("console.help.show")) {
                this.hideHelp();
            }
            rightVert.add(new Component[]{new H3("Help"), this.helpTextLabel});
            rightPanel.setContent((Component)rightVert);
            this.hsplit.addToSecondary(new Component[]{rightPanel});
            this.addAndExpand(new Component[]{this.hsplit});
            this.hsplit.setSplitterPosition(50.0);
            this.lastSplitPosition = this.hsplit.getSplitterPosition();
            this.setSpacing(true);
            this.setMargin(false);
            this.setSizeFull();
            if (b.this.controller.isShowAdvanced()) {
                this.form.setAdvancedOptionsVisible(true);
                this.advancedOptionsButton.setText(b.this.controller.getMessage("Hide Advanced Options", new Object[0]));
                this.updateHelpTextSpan();
            }
        }

        @Override
        public void formSaved() {
            b.this.onRefresh(new Object[0]);
            b.this.updateDisplaySpan();
        }

        @Override
        public void formDeleted() {
            b.this.onRefresh(new Object[0]);
            b.this.updateDisplaySpan();
        }

        protected void hideHelp() {
            this.lastSplitPosition = this.hsplit.getSplitterPosition();
            this.hsplit.setSplitterPosition(100.0);
            this.hsplit.setPrimaryStyle("min-width", "100%");
            if (this.helpButton != null) {
                this.helpButton.setText("Show Help");
            }
        }

        protected void showHelp() {
            this.hsplit.setSplitterPosition(this.lastSplitPosition);
            this.hsplit.setPrimaryStyle("min-width", "0%");
            if (this.helpButton != null) {
                this.helpButton.setText("Hide Help");
            }
        }

        protected void updateHelpTextSpan() {
            if (as.hasHelpHtml()) {
                String html = as.getHelpHtml(this.form.getHelpSectionName(), this.advancedOptionsButton.getText().equals("Hide Advanced Options") || this.form.isBulkForm());
                if (!StringUtils.isBlank((CharSequence)html)) {
                    this.helpTextLabel.setText(html);
                } else {
                    this.hideHelp();
                    this.helpButton.setVisible(false);
                }
            }
        }

        public void enableCancelShortcut(boolean enable) {
            if (enable && this.cancelRegistration == null) {
                this.cancelRegistration = Shortcuts.addShortcutListener((Component)this, (Command & Serializable)() -> this.cancelButton.clickInClient(), (Key)Key.ESCAPE, (KeyModifier[])new KeyModifier[0]);
            } else if (!enable && this.cancelRegistration != null) {
                this.cancelRegistration.remove();
                this.cancelRegistration = null;
            }
        }

        @Override
        public R<?> getForm() {
            return this.form;
        }

        @Override
        public a getFormLayout() {
            return this;
        }

        @Override
        public void closeForm(boolean force) {
            if (this.showAdvancedChanged) {
                b.this.controller.setShowAdvanced(!this.advancedOptionsButton.getText().equals("Show Advanced Options"));
            }
            if (!force && this.form.getBinder() != null && this.form.getBinder().hasChanges()) {
                this.enableCancelShortcut(false);
                new ConfirmDialog(b.this.controller.getMessage("Cancel Editing?", new Object[0]), b.this.controller.getMessage("Changes will be lost.  Are you sure you want to leave edit mode?", new Object[0]), b.this.controller.getMessage("Yes", new Object[0]), (ComponentEventListener & Serializable)e2 -> b.this.forceRemove(b.this.getTab(this.caption)), b.this.controller.getMessage("No", new Object[0]), (ComponentEventListener & Serializable)e2 -> this.enableCancelShortcut(true)).open();
            } else {
                TabSheet.EnhancedTab tab = b.this.getTab(this.caption);
                if (tab != null) {
                    b.this.forceRemove(tab);
                }
            }
        }
    }
}

