/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasEndpoint;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.o;
import com.jumpmind.symmetric.console.ui.common.s;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.SvgIcon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.BindingValidationStatusHandler;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.Command;
import de.f0rce.ace.AceEditor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.Lock;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class as {
    static final Logger log = LoggerFactory.getLogger(as.class);
    static final FastDateFormat DATETIMEFORMAT = FastDateFormat.getDateTimeInstance((int)3, (int)3);
    static final FastDateFormat TIMEFORMAT = FastDateFormat.getTimeInstance((int)2);
    static final String NULL_TEXT = "<null>";
    static Map<String, String> userGuideBySection;
    static long total;

    private as() {
    }

    public static Button createIconButton(VaadinIcon icon) {
        Button button = new Button();
        button.setIcon((Component)new Icon(icon));
        return button;
    }

    public static Button createIconButton(String contextPath, String iconText) {
        Button button = new Button();
        button.setIcon((Component)as.createImage(contextPath, iconText));
        return button;
    }

    public static Button createLinkButton(String name) {
        return as.createLinkButton(name, null, null);
    }

    public static Button createLinkButton(String name, ComponentEventListener<ClickEvent<Button>> listener) {
        return as.createLinkButton(name, null, listener);
    }

    public static Button createLinkButton(String name, VaadinIcon icon) {
        return as.createLinkButton(name, icon, null);
    }

    public static Button createLinkButton(String name, VaadinIcon icon, ComponentEventListener<ClickEvent<Button>> listener) {
        Button button = new Button(name);
        button.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_TERTIARY_INLINE});
        button.addClickListener((ComponentEventListener & Serializable)event -> {
            Component parent = button.getParent().orElse(null);
            while (parent != null) {
                if (parent instanceof Focusable) {
                    ((Focusable)parent).focus();
                    break;
                }
                parent = parent.getParent().orElse(null);
            }
        });
        if (listener != null) {
            button.addClickListener(listener);
        }
        if (icon != null) {
            button.setIcon((Component)new Icon(icon));
        }
        return button;
    }

    public static Button createPrimaryButton(String name) {
        return as.createPrimaryButton(name, null, true);
    }

    public static Button createPrimaryButton(String name, boolean addEnterShortcut) {
        return as.createPrimaryButton(name, null, addEnterShortcut);
    }

    public static Button createPrimaryButton(String name, ComponentEventListener<ClickEvent<Button>> listener) {
        return as.createPrimaryButton(name, listener, true);
    }

    public static Button createPrimaryButton(String name, ComponentEventListener<ClickEvent<Button>> listener, boolean addEnterShortcut) {
        Button button = new Button(name);
        if (listener != null) {
            button.addClickListener(listener);
        }
        button.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        if (addEnterShortcut) {
            button.addClickShortcut(Key.ENTER, new KeyModifier[0]);
        }
        return button;
    }

    public static TextField createSearchField() {
        TextField searchField = new TextField();
        searchField.setPlaceholder("Filter");
        searchField.setPrefixComponent((Component)new Icon(VaadinIcon.SEARCH));
        searchField.setValueChangeMode(ValueChangeMode.LAZY);
        searchField.setValueChangeTimeout(200);
        return searchField;
    }

    private static Span createSpanWithStyle(String value, String ... classNames) {
        Span label = new Span(value);
        label.addClassNames(classNames);
        return label;
    }

    public static Span createHeader1WithMessage(String message) {
        return as.createSpanWithStyle(message, "h1");
    }

    public static Span createHeader1(I controller, String key) {
        return as.createSpanWithStyle(controller.getMessage(key, new Object[0]), "h1");
    }

    public static Span createSubHeader(I controller, String key) {
        return as.createSpanWithStyle(StringUtils.isBlank((CharSequence)key) ? "" : controller.getMessage(key, new Object[0]), "h3", "focus-color");
    }

    public static Span createSubHeader(I controller, String key, Object ... values) {
        return as.createSpanWithStyle(StringUtils.isBlank((CharSequence)key) ? "" : controller.getMessage(key, values), "h3", "focus-color");
    }

    public static Image createImage(String contextPath, String url) {
        return new Image(contextPath + url, "");
    }

    public static SvgIcon createSvgIcon(String contextPath, String url) {
        return new SvgIcon(contextPath + url);
    }

    public static FlexLayout createItemLayout(I controller, List<String> itemList, String theme, int maxLength) {
        FlexLayout itemLayout = new FlexLayout();
        itemLayout.setFlexWrap(FlexLayout.FlexWrap.WRAP);
        itemList.sort(String.CASE_INSENSITIVE_ORDER);
        int size = 0;
        for (String item : itemList) {
            Span badge = new Span(item);
            badge.getElement().getThemeList().add((Object)("badge small" + (String)(theme != null ? " " + theme : "")));
            badge.getStyle().set("margin", "4px 0px 4px 8px");
            itemLayout.add(new Component[]{badge});
            if (maxLength <= 0 || (size += item.length() + 4) <= maxLength) continue;
            Span moreSpan = new Span(controller.getMessage("+ %d more", (long)itemList.size() - itemLayout.getChildren().count()));
            moreSpan.getStyle().set("margin-left", "8px");
            itemLayout.add(new Component[]{moreSpan});
            break;
        }
        return itemLayout;
    }

    public static String formatDate(I controller, Date date) {
        return as.formatDate(controller, date, false);
    }

    public static String formatDate(I controller, Date date, boolean shortenToTimeOnly) {
        if (date == null) {
            return "";
        }
        ConsoleUser user = controller.getConsoleUser();
        Object dateString = "yyyy-MM-dd hh:mm:ss aaa";
        String timeString = "hh:mm:ss aaa";
        String timeZone = "auto";
        int offset = 0;
        if (user != null) {
            TypedProperties settings = controller.getProConsoleService().getSettings(user.getUserId());
            dateString = settings.get("display.date.format", "yyyy-MM-dd") + " " + settings.get("display.time.format", "hh:mm:ss aaa");
            timeString = settings.get("display.time.format", "hh:mm:ss aaa");
            timeZone = settings.get("display.time.zone", "auto");
        }
        if (timeZone.equals("browser")) {
            timeZone = "GMT+00:00";
            offset = controller.getTimezoneOffset();
        }
        if (shortenToTimeOnly) {
            Calendar cal = Calendar.getInstance();
            Calendar ref = Calendar.getInstance();
            ref.setTime(date);
            if (ref.get(6) == cal.get(6) && ref.get(1) == cal.get(1)) {
                if (!timeZone.equals("auto")) {
                    return as.formatDateInTimeZone(date, timeString, timeZone, offset);
                }
                return new SimpleDateFormat(timeString).format(date);
            }
        }
        if (!timeZone.equals("auto")) {
            return as.formatDateInTimeZone(date, (String)dateString, timeZone, offset);
        }
        return new SimpleDateFormat((String)dateString).format(date);
    }

    public static String formatDateWithPattern(I controller, Date date, String pattern) {
        if (date == null) {
            return "";
        }
        ConsoleUser user = controller.getConsoleUser();
        String timeZone = "auto";
        if (user != null && controller.getSymmetricEngine() != null) {
            TypedProperties settings = controller.getProConsoleService().getSettings(user.getUserId());
            timeZone = settings.get("display.time.zone", "auto");
        }
        if (!timeZone.equals("auto")) {
            int offset = 0;
            if (timeZone.equals("browser")) {
                timeZone = "GMT+00:00";
                offset = controller.getTimezoneOffset();
            }
            return as.formatDateInTimeZone(date, pattern, timeZone, offset);
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String formatDateInTimeZone(Date date, String pattern, String timeZone, int offset) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(TimeZone.getTimeZone(timeZone));
        if (offset != 0) {
            date = DateUtils.addMilliseconds((Date)date, (int)offset);
        }
        return format.format(date);
    }

    public static Date convertInputDateToUTC(I controller, LocalDateTime localDateTime) {
        String timeZoneString;
        Date date = new Date(localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        ConsoleUser user = controller.getConsoleUser();
        if (user != null && !(timeZoneString = controller.getProConsoleService().getSettings(user.getUserId()).get("display.time.zone", "auto")).equals("auto")) {
            date = new Date(localDateTime.atZone(ZoneId.of(timeZoneString)).toInstant().toEpochMilli());
        }
        return date;
    }

    public static String formatDateTime(Date dateTime) {
        if (dateTime != null) {
            Calendar cal = Calendar.getInstance();
            Calendar ref = Calendar.getInstance();
            ref.setTime(dateTime);
            if (ref.get(6) == cal.get(6) && ref.get(1) == cal.get(1)) {
                return TIMEFORMAT.format(dateTime);
            }
            return DATETIMEFORMAT.format(dateTime);
        }
        return null;
    }

    public static String formatDateAgo(Date date) {
        long msAgo = new Date().getTime() - date.getTime();
        if (msAgo < 60000L) {
            long secondsAgo = msAgo / 1000L;
            if (secondsAgo > 1L) {
                return secondsAgo + " seconds ago";
            }
            return "1 second ago";
        }
        if (msAgo < 3600000L) {
            long minutesAgo = msAgo / 60000L;
            if (minutesAgo > 1L) {
                return minutesAgo + " minutes ago";
            }
            return "1 minute ago";
        }
        if (msAgo < 86400000L) {
            long hoursAgo = msAgo / 3600000L;
            if (hoursAgo > 1L) {
                return hoursAgo + " hours ago";
            }
            return "1 hour ago";
        }
        long daysAgo = msAgo / 86400000L;
        if (daysAgo > 1L) {
            return daysAgo + " days ago";
        }
        return "Yesterday";
    }

    public static String getUriFragmentName(Object comp) {
        if (comp != null) {
            Class<?> clazz = null;
            clazz = comp instanceof Class ? (Class<?>)comp : comp.getClass();
            return clazz.getSimpleName().toLowerCase();
        }
        return "";
    }

    public static int getIntegerValueFromTextField(TextField field) {
        String value = field.getValue();
        if (value instanceof Integer) {
            return (Integer)((Object)value);
        }
        if (value instanceof String) {
            return Integer.parseInt(value);
        }
        throw new NumberFormatException("Could not parse " + String.valueOf(value) + " into an integer");
    }

    public static List<String> getConsoleDisplayChannelIds(ISymmetricEngine engine, a type) {
        List<String> channels;
        if (engine.getParameterService().is("console.web.hide.system.info")) {
            HashSet<String> channelList = new HashSet<String>();
            if (engine.getParameterService().is("file.sync.enable")) {
                for (FileTriggerRouter ftr : engine.getFileSyncService().getFileTriggerRoutersForCurrentNode(false)) {
                    String reloadChannel;
                    String channel = ftr.getFileTrigger() != null ? ftr.getFileTrigger().getChannelId() : "";
                    String string = reloadChannel = ftr.getFileTrigger() != null ? ftr.getFileTrigger().getReloadChannelId() : "";
                    if (channel.length() > 0 && !as.isHidableChannel(channel, engine)) {
                        channelList.add(channel);
                    }
                    if (reloadChannel.length() <= 0 || as.isHidableChannel(reloadChannel, engine)) continue;
                    channelList.add(reloadChannel);
                }
            }
            for (TriggerRouter tr : engine.getTriggerRouterService().getTriggerRouters(false)) {
                String curReloadChannel;
                String trSourceGroup = tr.getRouter().getNodeGroupLink().getSourceNodeGroupId();
                String trTargetGroup = tr.getRouter().getNodeGroupLink().getTargetNodeGroupId();
                String nodeGroup = engine.getParameterService().getNodeGroupId();
                Trigger t2 = engine.getTriggerRouterService().getTriggerById(tr.getTriggerId(), false);
                String curChannel = t2 != null ? t2.getChannelId() : "";
                String string = curReloadChannel = t2 != null ? t2.getReloadChannelId() : "";
                if (a.OUTGOING.equals((Object)type) && nodeGroup.equals(trSourceGroup)) {
                    if (curChannel.length() > 0 && !as.isHidableChannel(curChannel, engine)) {
                        channelList.add(curChannel);
                    }
                    if (curReloadChannel.length() <= 0 || as.isHidableChannel(curReloadChannel, engine)) continue;
                    channelList.add(curReloadChannel);
                    continue;
                }
                if (a.INCOMING.equals((Object)type) && nodeGroup.equals(trTargetGroup)) {
                    if (curChannel.length() > 0 && !as.isHidableChannel(curChannel, engine)) {
                        channelList.add(curChannel);
                    }
                    if (curReloadChannel.length() <= 0 || as.isHidableChannel(curReloadChannel, engine)) continue;
                    channelList.add(curReloadChannel);
                    continue;
                }
                if (!a.BOTH.equals((Object)type)) continue;
                if (curChannel.length() > 0 && !as.isHidableChannel(curChannel, engine)) {
                    channelList.add(curChannel);
                }
                if (curReloadChannel.length() <= 0 || as.isHidableChannel(curReloadChannel, engine)) continue;
                channelList.add(curReloadChannel);
            }
            channelList.add("config");
            channels = new ArrayList<String>(channelList);
        } else {
            channels = as.toChannelIdList(engine.getConfigurationService().getNodeChannels(false));
        }
        Collections.sort(channels);
        return channels;
    }

    public static boolean isHidableChannel(String channelId, ISymmetricEngine engine) {
        return engine.getParameterService().is("console.web.hide.system.info") && (channelId == null || channelId.equals("heartbeat") || channelId.equals("dynamic") || channelId.equals("0"));
    }

    public static List<String> toChannelIdList(List<NodeChannel> channels) {
        ArrayList<String> channelIds = new ArrayList<String>(channels.size());
        for (NodeChannel nodeChannel : channels) {
            channelIds.add(nodeChannel.getChannelId());
        }
        return channelIds;
    }

    public static String formatDuration(long timeInMs) {
        long days = timeInMs / 86400000L;
        long hours = (timeInMs %= 86400000L) / 3600000L;
        long minutes = (timeInMs %= 3600000L) / 60000L;
        long seconds = (timeInMs %= 60000L) / 1000L;
        if (days > 0L) {
            return days + " d " + hours + " h " + minutes + " m";
        }
        if (hours > 0L) {
            return hours + " h " + minutes + " m";
        }
        if (minutes > 0L) {
            return minutes + " m " + seconds + " s";
        }
        if (seconds > 0L) {
            return seconds + " s";
        }
        return timeInMs + " ms";
    }

    public static String formatDurationLargestUnitOnly(long timeInMs) {
        long days = timeInMs / 86400000L;
        long hours = (timeInMs %= 86400000L) / 3600000L;
        long minutes = (timeInMs %= 3600000L) / 60000L;
        long seconds = (timeInMs %= 60000L) / 1000L;
        if (days > 0L) {
            if (days == 1L) {
                return "1 day";
            }
            return days + " days";
        }
        if (hours > 0L) {
            if (hours == 1L) {
                return "1 hour";
            }
            return hours + " hours";
        }
        if (minutes > 0L) {
            if (minutes == 1L) {
                return "1 minute";
            }
            return minutes + " minutes";
        }
        if (seconds > 0L) {
            if (seconds == 1L) {
                return "1 second";
            }
            return seconds + " seconds";
        }
        if (timeInMs == 1L) {
            return "1 millisecond";
        }
        return timeInMs + " milliseconds";
    }

    public static String formatDurationLargestUnitOnlyShort(long timeInMs) {
        long days = timeInMs / 86400000L;
        long hours = (timeInMs %= 86400000L) / 3600000L;
        long minutes = (timeInMs %= 3600000L) / 60000L;
        long seconds = (timeInMs %= 60000L) / 1000L;
        if (days > 0L) {
            return days + " d";
        }
        if (hours > 0L) {
            return hours + " h";
        }
        if (minutes > 0L) {
            return minutes + " m";
        }
        if (seconds > 0L) {
            return seconds + " s";
        }
        return timeInMs + " ms";
    }

    public static String formatNumericLargestUnitOnly(long value) {
        if (value > 999999L) {
            return String.format("%.2fM", (double)value / 1000000.0);
        }
        if (value > 999L) {
            return String.format("%.2fK", (double)value / 1000.0);
        }
        return String.valueOf(value);
    }

    public static String formatDurationFull(long timeInMs) {
        long days = timeInMs / 86400000L;
        long hours = (timeInMs %= 86400000L) / 3600000L;
        long minutes = (timeInMs %= 3600000L) / 60000L;
        long seconds = (timeInMs %= 60000L) / 1000L;
        String duration = "";
        duration = as.formatDurationFullAppend(duration, days, "day");
        duration = as.formatDurationFullAppend(duration, hours, "hour");
        duration = as.formatDurationFullAppend(duration, minutes, "minute");
        if (days == 0L && hours == 0L) {
            duration = as.formatDurationFullAppend(duration, seconds, "second");
        }
        return duration;
    }

    private static String formatDurationFullAppend(String str, long amount, String name) {
        if (amount > 0L) {
            if (!((String)str).equals("")) {
                str = (String)str + ", ";
            }
            str = (String)str + amount + " " + name;
            if (amount > 1L) {
                str = (String)str + "s";
            }
        }
        return str;
    }

    public static String formatFileSize(long sizeInBytes) {
        if (sizeInBytes >= 0x100000L) {
            return (sizeInBytes + 1048575L) / 0x100000L + " MB";
        }
        if (sizeInBytes >= 1024L) {
            return (sizeInBytes + 1023L) / 1024L + " KB";
        }
        return sizeInBytes + " bytes";
    }

    public static String formatMonitorType(String type) {
        switch (type) {
            case "dataUnrouted": {
                return "Unrouted Data";
            }
            case "disk": {
                return "Disk Usage";
            }
            case "memory": {
                return "Memory Usage";
            }
            case "batchUnsent": {
                return "Unsent Batches (Online Nodes)";
            }
            case "batchUnsentOffline": {
                return "Unsent Batches (Offline Nodes)";
            }
            case "log": {
                return "Log Entries";
            }
            case "offlineNodes": {
                return "Offline Nodes";
            }
            case "batchError": {
                return "Batches in Error";
            }
            case "cpu": {
                return "CPU Usage";
            }
            case "dataGap": {
                return "Data Gaps";
            }
            case "block": {
                return "Blocked Transactions";
            }
            case "licenseExpire": {
                return "License Expiration";
            }
            case "certExpire": {
                return "Certificate Expiration";
            }
            case "incompatibleDatetime": {
                return "Incompatible datetime";
            }
            case "licenseRows": {
                return "License Rows";
            }
            case "loadAverage": {
                return "Load Average";
            }
            case "fileHandles": {
                return "Open File Handles";
            }
            case "jobError": {
                return "Jobs in Error";
            }
            case "jobTrending": {
                return "Job Trending";
            }
            case "jvm64Bit": {
                return "64-bit JVM";
            }
            case "jvmCrash": {
                return "JVM Crash";
            }
            case "jvmOutOfMemory": {
                return "JVM Out of Memory";
            }
            case "jvmThreads": {
                return "JVM Threads";
            }
            case "mySqlMode": {
                return "MySQL Mode";
            }
            case "nextDataInGap": {
                return "Next Data in Gap";
            }
            case "channelsDisabled": {
                return "Disabled Channels";
            }
            case "maxBatchSize": {
                return "Max Batch Size";
            }
            case "maxDataToRoute": {
                return "Max Data to Route";
            }
            case "maxBatchToSend": {
                return "Max Batch to Send";
            }
            case "maxChannels": {
                return "Max Channels";
            }
            case "channelSuspend": {
                return "Suspended or Ignored Channels";
            }
            case "missingPrimaryKey": {
                return "Tables Missing a Primary Key";
            }
            case "channelsForeignKey": {
                return "Foreign Keys Across Channels";
            }
            case "connectionPool": {
                return "Connection Pool";
            }
            case "connectionReset": {
                return "Connection Reset";
            }
            case "lob": {
                return "Large Object";
            }
            case "strandedOrExpiredData": {
                return "Stranded or Expired Data";
            }
            case "unknownCa": {
                return "Unknown Certificate Authority";
            }
            case "formKeys": {
                return "Too Many Form Keys";
            }
            case "postgresWal": {
                return "Postgres WAL Backlog";
            }
            case "jvmOutOfMemoryMonitor": {
                return "JVM Out of Memory Monitor";
            }
        }
        return type;
    }

    public static Gson getMonitorEventGson() {
        return new GsonBuilder().setDateFormat("MMM dd, yyyy, HH:mm:ss").create();
    }

    public static AceEditor createAceEditor() {
        return CommonUiUtils.createAceEditor();
    }

    public static boolean hasHelpHtml() {
        return as.getUserGuideBySection().size() > 0;
    }

    public static String getHelpHtml(String section, boolean showAdvancedOptions) {
        String text = "";
        Map<String, String> bySection = as.getUserGuideBySection();
        if (bySection != null && section != null) {
            text = bySection.get(section);
        }
        if (text != null && !showAdvancedOptions) {
            text = as.removeAdvancedOptions(text);
        }
        return text;
    }

    public static void passHelpHtmlToConsumer(String section, Consumer<String> consumer, boolean showAdvancedOptions) {
        String text = "";
        if (section != null) {
            text = as.getUserGuideBySection().get(section);
        }
        if (text != null && !showAdvancedOptions) {
            text = as.removeAdvancedOptions(text);
        }
        consumer.accept(text);
    }

    private static String removeAdvancedOptions(String text) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new StringReader(text));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(" class=\"title\">Advanced Options") != -1) {
                    sb.append("</div>");
                    break;
                }
                sb.append(line).append("\n");
            }
        }
        catch (Exception e2) {
            log.error("Exception while getting removed advanced options", (Throwable)e2);
        }
        return sb.toString();
    }

    private static Map<String, String> getUserGuideBySection() {
        if (userGuideBySection == null) {
            as.loadHelpHtmlSections(null, null, false);
        }
        return userGuideBySection;
    }

    private static synchronized void loadHelpHtmlSections(String section, Consumer<String> consumer, boolean showAdvancedOptions) {
        userGuideBySection = new HashMap<String, String>();
        UI.getCurrent().getPage().fetchCurrentURL((SerializableConsumer & Serializable)url -> {
            String urlString;
            String userGuidePath = "/doc/html/user-guide.html";
            String userGuideUrlString = urlString = url.toString().replace("/app" + (url.toString().endsWith("/") ? "/" : ""), "/doc/html/user-guide.html");
            if ("true".equals(System.getProperty("symmetric.standalone.web"))) {
                File file = new File("web/doc/html/user-guide.html");
                if (!file.canRead()) {
                    file = new File("target/web/doc/html/user-guide.html");
                }
                if (file.canRead()) {
                    userGuideUrlString = file.toURI().toString();
                }
            }
            URL userGuideUrl = null;
            try {
                userGuideUrl = new URL(userGuideUrlString);
            }
            catch (MalformedURLException e2) {
                log.warn("Unable to form URL for user guide at {} because {}", (Object)urlString, (Object)e2.getMessage());
                return;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(userGuideUrl.openStream()));){
                String line = null;
                String id = null;
                boolean inSection = false;
                boolean inFields = false;
                boolean inTable = false;
                int countDivs = 0;
                StringBuilder sb = new StringBuilder();
                String regex = ".*(h[234]) id=\"(.*)\".*";
                String helpRegex = ".*class=\".*help\".*";
                Pattern pattern = Pattern.compile(regex, 2);
                Pattern helpPattern = Pattern.compile(helpRegex, 2);
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = pattern.matcher(line);
                    Matcher helpMatcher = helpPattern.matcher(line);
                    if (matcher.matches()) {
                        if (inSection) {
                            if (id != null && sb.length() > 0) {
                                userGuideBySection.put(id, sb.toString());
                            }
                            id = matcher.group(2);
                            sb = new StringBuilder();
                        }
                        if (matcher.group(1).equalsIgnoreCase("h2")) {
                            inSection = matcher.group(2).equalsIgnoreCase("_configuration") || matcher.group(2).equalsIgnoreCase("_manage");
                        }
                    } else if (inFields && line.indexOf("<div ") != -1) {
                        ++countDivs;
                    } else if (inSection && (line.indexOf(" class=\"dlist\"") != -1 || helpMatcher.matches())) {
                        inFields = true;
                        ++countDivs;
                    } else if (inSection && line.indexOf("<table") != -1) {
                        inTable = true;
                    }
                    if (inFields || inTable && line.indexOf("<caption") == -1) {
                        line = line.replaceAll("href=\"#", "target='_blank' href=\"" + urlString + "#");
                        sb.append(line).append("\n");
                    }
                    if (inFields && line.indexOf("</div>") != -1) {
                        if (countDivs != 1) {
                            --countDivs;
                        } else {
                            inFields = false;
                            countDivs = 0;
                        }
                    }
                    if (!inTable || line.indexOf("</table>") == -1) continue;
                    inTable = false;
                }
                if (consumer != null) {
                    String text = "";
                    if (section != null) {
                        text = userGuideBySection.get(section);
                    }
                    if (text != null && !showAdvancedOptions) {
                        text = as.removeAdvancedOptions(text);
                    }
                    consumer.accept(text);
                }
            }
            catch (FileNotFoundException e3) {
                log.info("User guide was not found at {}", (Object)userGuideUrl);
            }
            catch (Exception e4) {
                log.warn("Unable to access user guide at {} because {}", (Object)userGuideUrl, (Object)(e4.getClass().getName() + ": " + e4.getMessage()));
            }
        });
    }

    public static BindingValidationStatusHandler getValidationHandler(Component field, Span label) {
        return (BindingValidationStatusHandler & Serializable)event -> {
            label.setText(event.getMessage().orElse(""));
            if (field != null) {
                field.getElement().setAttribute("invalid", event.isError());
            }
        };
    }

    public static Span getErrorSpan() {
        Span label = new Span();
        label.addClassName("v-label-marked");
        return label;
    }

    public static Icon getDropdownIcon() {
        Icon icon = new Icon(VaadinIcon.CHEVRON_DOWN_SMALL);
        icon.getStyle().set("padding", "4px 0 4px 8px");
        return icon;
    }

    public static Div getSpinnerIcon(String size, String color) {
        Div spin = new Div();
        spin.setHeight(size);
        spin.getStyle().set("max-height", size);
        spin.setWidth(size);
        spin.getStyle().set("max-width", size);
        spin.getStyle().set("color", color);
        spin.addClassName("spinner-border");
        return spin;
    }

    public static void securelyAccessUI(UI ui, Command command) {
        if (ui != null && !ui.isClosing() && ui.getSession() != null) {
            if (ui.getSession().hasLock()) {
                command.execute();
            } else {
                ui.access(command);
            }
        }
    }

    public static void notifySyncTriggersLockNotAcquired(Lock lock) {
        if (lock != null) {
            String lockTime = null;
            if (lock.getLockTime() != null) {
                lockTime = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss aaa").format(lock.getLockTime());
            }
            CommonUiUtils.notify((String)String.format("Sync triggers was locked by the cluster service. The locking server id was: %s. The lock time was: %s", lock.getLockingServerId(), lockTime));
        } else {
            CommonUiUtils.notify((String)"Sync triggers was locked by the cluster service but lock details were not found. Perhaps the lock was released in the meantime.");
        }
    }

    public static void restartSymmetric(I controller, String source) {
        as.restartSymmetric(controller.getSymmetricEngine(), controller.getConsoleUser().getUserId(), source);
    }

    public static void restartSymmetric(ISymmetricEngine engine, String userId, String source) {
        IConsoleEventService consoleEventService = (IConsoleEventService)engine.getExtensionService().getExtensionPoint(IConsoleEventService.class);
        String nodeId = engine.getNodeId();
        consoleEventService.addEvent(new ConsoleEvent(userId, "Restart SymmetricDS", nodeId, nodeId, null, source));
        System.exit(0);
    }

    public static HtmlContainer getEndpointIcon(String contextPath, s.a type) {
        if (type != null) {
            Image image = UI.getCurrent().getElement().getThemeList().contains((Object)"dark") ? as.createImage(contextPath, "/icons/databases/" + s.databaseNameMap.get(type) + "-48x48-dark.png") : as.createImage(contextPath, "/icons/databases/" + s.databaseNameMap.get(type) + "-48x48.png");
            image.setWidth("24px");
            image.setHeight("24px");
            image.addClassName("circle");
            image.getStyle().set("filter", "var(--disabled-filter)");
            return image;
        }
        return new o(contextPath, "/icons/database_o.svg");
    }

    public static HorizontalLayout getEndpointLayout(I controller, ConfigCanvasEndpoint endpoint, boolean isHeader) {
        HtmlContainer icon = as.getEndpointIcon(controller.getContextPath(), endpoint != null ? endpoint.getType() : null);
        HorizontalLayout endpointLayout = new HorizontalLayout(new Component[]{icon});
        endpointLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
        Object endpointId = controller.getMessage("Endpoint", new Object[0]);
        if (endpoint != null) {
            endpointId = endpoint.getId();
            if (endpoint.isRemote()) {
                endpointId = (String)endpointId + controller.getMessage(" (remote)", new Object[0]);
            }
        }
        if (isHeader) {
            H5 header = new H5((String)endpointId);
            header.addClassName("less-contrast");
            header.getStyle().set("margin", "0").set("font-weight", "700");
            endpointLayout.add(new Component[]{header});
        } else {
            endpointLayout.add(new Component[]{new Span((String)endpointId)});
        }
        return endpointLayout;
    }

    public static HorizontalLayout createCountLayout(I controller, String messageKey, int totalCount) {
        return as.createCountLayout(controller, messageKey, totalCount, 0, 0);
    }

    public static HorizontalLayout createCountLayout(I controller, String messageKey, int totalCount, int addedCount, int removedCount) {
        Label countLabel = new Label(String.format(messageKey, totalCount) + (totalCount != 1 ? "s" : ""));
        countLabel.getStyle().set("font-size", "var(--lumo-font-size-l)");
        HorizontalLayout countLayout = new HorizontalLayout(new Component[]{countLabel});
        countLayout.setSpacing(false);
        if (addedCount > 0) {
            Span addedBadge = new Span("+" + addedCount);
            addedBadge.getElement().getThemeList().add((Object)"badge success pill");
            addedBadge.getStyle().set("margin-left", "8px");
            countLayout.add(new Component[]{addedBadge});
        }
        if (removedCount > 0) {
            Span removedBadge = new Span("-" + removedCount);
            removedBadge.getElement().getThemeList().add((Object)"badge error pill");
            removedBadge.getStyle().set("margin-left", "8px");
            countLayout.add(new Component[]{removedBadge});
        }
        return countLayout;
    }

    public static VerticalLayout createLinkLayout(I controller, ConfigCanvasEndpoint sourceEndpoint, ConfigCanvasEndpoint targetEndpoint, Component contents) {
        HorizontalLayout linkHeader = new HorizontalLayout(new Component[]{as.getEndpointLayout(controller, sourceEndpoint, true), new Icon(VaadinIcon.ARROW_RIGHT), as.getEndpointLayout(controller, targetEndpoint, true)});
        linkHeader.setWidthFull();
        linkHeader.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
        linkHeader.getStyle().setPadding("16px").set("border-bottom", "1px solid var(--lumo-contrast-20pct)");
        VerticalLayout linkLayout = new VerticalLayout(new Component[]{linkHeader, contents});
        linkLayout.setWidthFull();
        linkLayout.setSpacing(false);
        linkLayout.addClassName("subtle-border");
        linkLayout.getStyle().setPadding("0").setMargin("0");
        return linkLayout;
    }

    public static enum a {
        OUTGOING,
        INCOMING,
        BOTH;

    }
}

