/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.service.impl.ConsoleUserServiceHelper;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.progressbar.ProgressBar;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.vaadin.ui.common.Label;

public class ac
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    public static final String HEALTHY = "healthy";
    public static final String UNHEALTHY = "unhealthy";
    IParameterService parameterService;
    boolean needSymbol;
    boolean needNumber;
    boolean needMixedCase;
    boolean needCommonWord;
    int passwordLength;
    private float complexity;
    private Label containsSymbol;
    private Label containsNumber;
    private Label containsMixedCase;
    private Label containsCommonWord;
    private Label passwordLengthRequirement;
    private ProgressBar progressBar;
    private NativeLabel progressBarLabel;
    private boolean firstLoad;
    VerticalLayout passwordLayout;

    public ac(I controller, boolean loadType) {
        this.firstLoad = loadType;
        if (!this.firstLoad) {
            this.parameterService = controller.getSymmetricEngine().getParameterService();
            this.needSymbol = this.parameterService.is("console.password.require.symbol");
            this.needNumber = this.parameterService.is("console.password.require.alphanum");
            this.needMixedCase = this.parameterService.is("console.password.require.mixed.case");
            this.needCommonWord = this.parameterService.is("console.password.prohibit.common.words");
            this.passwordLength = this.parameterService.getInt("console.password.min.length");
        } else if (this.firstLoad && controller.getSymmetricEngine() != null) {
            this.parameterService = controller.getSymmetricEngine().getParameterService();
            this.needSymbol = this.parameterService.is("console.password.require.symbol");
            this.needNumber = this.parameterService.is("console.password.require.alphanum");
            this.needMixedCase = this.parameterService.is("console.password.require.mixed.case");
            this.needCommonWord = this.parameterService.is("console.password.prohibit.common.words");
            this.passwordLength = this.parameterService.getInt("console.password.min.length");
        } else {
            this.needSymbol = true;
            this.needNumber = true;
            this.needMixedCase = true;
            this.needCommonWord = true;
            this.passwordLength = 15;
        }
        this.progressBar = new ProgressBar();
        this.progressBar.setId("progressBar");
        this.progressBar.setWidthFull();
        this.progressBarLabel = new NativeLabel("Password Strength: Poor");
        this.progressBarLabel.setFor((Component)this.progressBar);
    }

    public VerticalLayout getProgressBar() {
        VerticalLayout progressBarLayout = new VerticalLayout(new Component[]{this.progressBarLabel, this.progressBar});
        progressBarLayout.getStyle().set("margin-top", "15px");
        progressBarLayout.getElement().setAttribute("theme", "");
        return progressBarLayout;
    }

    public void setPasswordRequirements(boolean reqSymbol, boolean reqNumber, boolean reqMixedCase, boolean reqCommonWord, int reqLength) {
        this.needSymbol = reqSymbol;
        this.needNumber = reqNumber;
        this.needMixedCase = reqMixedCase;
        this.needCommonWord = reqCommonWord;
        this.passwordLength = reqLength;
    }

    public VerticalLayout getPasswordRequirementLabels() {
        this.passwordLayout = new VerticalLayout();
        this.passwordLayout.getStyle().set("padding", "0 16px");
        if (this.needSymbol) {
            this.containsSymbol = this.createLabel("Contains a Symbol");
            this.passwordLayout.add(new Component[]{this.containsSymbol});
        }
        if (this.needNumber) {
            this.containsNumber = this.createLabel("Contains a Number");
            this.passwordLayout.add(new Component[]{this.containsNumber});
        }
        if (this.needMixedCase) {
            this.containsMixedCase = this.createLabel("Contains Mixed Case");
            this.passwordLayout.add(new Component[]{this.containsMixedCase});
        }
        if (this.needCommonWord) {
            this.containsCommonWord = this.createLabel("Does Not Contain Common Words");
            this.passwordLayout.add(new Component[]{this.containsCommonWord});
        }
        this.passwordLengthRequirement = this.createLabel(String.format("Minimum Password Length: %s", this.passwordLength));
        this.passwordLengthRequirement.addClassName(UNHEALTHY);
        this.passwordLayout.add(new Component[]{this.passwordLengthRequirement});
        return this.passwordLayout;
    }

    public void updateProgress(String password) {
        StringBuilder builder = new StringBuilder();
        String symbolPattern = ".*[^\\w].*";
        String upperPattern = ".*[A-Z].*";
        String lowerPattern = ".*[a-z].*";
        String numberPattern = ".*[0-9].*";
        boolean hasSymbol = false;
        boolean hasMixedCase = false;
        boolean hasNumber = false;
        boolean hasLength = false;
        boolean hasCommonWord = false;
        ConsoleUserServiceHelper commonWordCheck = new ConsoleUserServiceHelper();
        hasCommonWord = commonWordCheck.containsCommonWords(password);
        this.complexity = 0.0f;
        if (password.matches(symbolPattern)) {
            this.complexity += 0.0625f;
            hasSymbol = true;
        }
        if (password.matches(upperPattern) && password.matches(lowerPattern)) {
            hasMixedCase = true;
            this.complexity += 0.075f;
        }
        if (password.matches(numberPattern)) {
            hasNumber = true;
            this.complexity += 0.05f;
        }
        if (!hasCommonWord && password.length() >= 1) {
            this.complexity += 0.0625f;
        }
        if (password.length() >= 15) {
            this.complexity += 0.75f;
        } else if (password.length() < 15 && password.length() >= 12) {
            this.complexity += 0.5f;
        } else if (password.length() < 12 && password.length() >= 8) {
            this.complexity += 0.25f;
        }
        if (password.length() >= this.passwordLength) {
            hasLength = true;
        }
        this.setHealthy(this.passwordLengthRequirement, hasLength);
        this.passwordLengthRequirement.setText(String.format("Minimum Password Length: %s", this.passwordLength));
        if (this.needSymbol) {
            this.setHealthy(this.containsSymbol, hasSymbol);
            this.containsSymbol.setText("Contains a Symbol");
        }
        if (this.needMixedCase) {
            this.setHealthy(this.containsMixedCase, hasMixedCase);
            this.containsMixedCase.setText("Contains Mixed Case");
        }
        if (this.needNumber) {
            this.setHealthy(this.containsNumber, hasNumber);
            this.containsNumber.setText("Contains a Number");
        }
        if (this.needCommonWord) {
            this.setHealthy(this.containsCommonWord, !hasCommonWord && password.length() >= 1);
            this.containsCommonWord.setText("Does Not Contain Common Words");
        }
        this.progressBar.setValue((double)this.complexity);
        if (this.complexity >= 0.0f && (double)this.complexity <= 0.35) {
            builder.append("Password Strength: Poor");
        } else if ((double)this.complexity > 0.35 && (double)this.complexity <= 0.5) {
            builder.append("Password Strength: Fair");
        } else if ((double)this.complexity > 0.5 && (double)this.complexity <= 0.8) {
            builder.append("Password Strength: Good");
        } else if ((double)this.complexity > 0.8 && this.complexity <= 1.0f) {
            builder.append("Password Strength: Excellent");
        }
        this.progressBarLabel.setText(builder.toString());
    }

    private Label createLabel(String text) {
        Label label = new Label(this.failIcon(), text);
        label.getStyle().set("line-height", "initial");
        label.addClassName(UNHEALTHY);
        return label;
    }

    protected Icon failIcon() {
        Icon icon = new Icon(VaadinIcon.WARNING);
        icon.setColor("red");
        return icon;
    }

    protected Icon passIcon() {
        Icon icon = new Icon(VaadinIcon.CHECK);
        icon.setColor("green");
        return icon;
    }

    private void setHealthy(Label label, boolean healthy) {
        if (healthy) {
            label.addClassName(HEALTHY);
            label.removeClassName(UNHEALTHY);
            label.setLeftIcon((Component)this.passIcon());
        } else {
            label.addClassName(UNHEALTHY);
            label.removeClassName(HEALTHY);
            label.setLeftIcon((Component)this.failIcon());
        }
    }
}

