/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.grid.AbstractGridMultiSelectionModel;
import com.vaadin.flow.component.grid.AbstractRow;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.value.ValueChangeMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.FilterCriterion;
import org.jumpmind.symmetric.service.INodeService;

public class Y
extends Grid<Node> {
    private static final long serialVersionUID = 1L;
    private I controller;
    private Set<Node> selectedNodes = new HashSet<Node>();
    private HeaderRow.HeaderCell titleCell;
    private Node currentNode;
    private String selectedGroup = "";
    private Select<String> nodeGroupIdFilterField;

    public Y(I controller, List<Node> preselectedNodeIds, String title, boolean limitToOneGroup) {
        super(Node.class);
        String[] displayColumns;
        this.controller = controller;
        this.currentNode = controller.getSymmetricEngine().getNodeService().findIdentity();
        INodeService nodeService = controller.getSymmetricEngine().getNodeService();
        CallbackDataProvider callbackDataProvider = DataProvider.fromFilteringCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> this.findFilteredNodesWithLimit(query.getOffset(), query.getLimit(), query.getFilter().orElse(null), query.getSortOrders()).stream(), (CallbackDataProvider.CountCallback & Serializable)query -> nodeService.countFilteredNodes((List)query.getFilter().orElse(null)));
        ConfigurableFilterDataProvider dataProvider = callbackDataProvider.withConfigurableFilter();
        ArrayList<FilterCriterion> filterList = new ArrayList<FilterCriterion>();
        filterList.add(new FilterCriterion("nodeId", (Object)this.currentNode.getNodeId(), FilterCriterion.FilterOption.NOT_EQUALS));
        dataProvider.setFilter(filterList);
        this.setItems((DataProvider)dataProvider);
        this.removeAllColumns();
        this.setSelectionMode(Grid.SelectionMode.MULTI);
        this.setSizeFull();
        this.addItemClickListener((ComponentEventListener & Serializable)event -> {
            if (event.getColumn() != null) {
                this.deselectAll();
                this.select((Node)event.getItem());
                this.selectedNodes = this.getSelectedItems();
            }
        });
        for (String pid : displayColumns = new String[]{"nodeId", "nodeGroupId", "databaseType", "symmetricVersion"}) {
            this.addColumn(pid).setResizable(true);
        }
        List nodes = controller.getSymmetricEngine().getNodeService().findAllNodes();
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return o1.getNodeId().compareTo(o2.getNodeId());
            }
        });
        ArrayList<Object> otherNodes = new ArrayList<Object>();
        for (Object n2 : nodes) {
            if (n2.getNodeId().equals(this.currentNode.getNodeId())) continue;
            otherNodes.add(n2);
        }
        HashSet<String> nodeGroups = new HashSet<String>();
        for (Object node : nodes) {
            nodeGroups.add(node.getNodeGroupId());
        }
        if (nodeGroups.size() > 0) {
            nodeGroups.add("");
        }
        AbstractGridMultiSelectionModel selection = (AbstractGridMultiSelectionModel)this.getSelectionModel();
        selection.setSelectAllCheckboxVisibility(GridMultiSelectionModel.SelectAllCheckboxVisibility.VISIBLE);
        for (Node n3 : preselectedNodeIds) {
            if (limitToOneGroup && nodeGroups.size() > 1 && this.selectedGroup == "") {
                this.selectedGroup = n3.getNodeGroupId();
            }
            if (this.selectedGroup != "" && !n3.getNodeGroupId().equals(this.selectedGroup)) continue;
            selection.select((Object)n3);
        }
        HeaderRow groupingHeader = this.prependHeaderRow();
        this.titleCell = (HeaderRow.HeaderCell)groupingHeader.join((AbstractRow.AbstractCell[])new HeaderRow.HeaderCell[]{(HeaderRow.HeaderCell)groupingHeader.getCell(this.getColumnByKey("nodeId")), (HeaderRow.HeaderCell)groupingHeader.getCell(this.getColumnByKey("nodeGroupId")), (HeaderRow.HeaderCell)groupingHeader.getCell(this.getColumnByKey("databaseType")), (HeaderRow.HeaderCell)groupingHeader.getCell(this.getColumnByKey("symmetricVersion"))});
        Span titleCellSpan = new Span(title);
        titleCellSpan.setClassName("grid-title");
        this.titleCell.setComponent((Component)titleCellSpan);
        HeaderRow filterRow = this.appendHeaderRow();
        for (Grid.Column column : this.getColumns()) {
            HeaderRow.HeaderCell cell = (HeaderRow.HeaderCell)filterRow.getCell(column);
            if (column.getKey().equals("nodeGroupId")) {
                Select selectField = new Select();
                selectField.setItems(nodeGroups);
                selectField.setWidthFull();
                selectField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                    String nodeGroupIdValue = (String)event.getValue();
                    for (FilterCriterion criterion : new ArrayList(filterList)) {
                        if (!criterion.getPropertyId().equals(column.getKey()) || !criterion.getOption().equals((Object)FilterCriterion.FilterOption.CONTAINS)) continue;
                        filterList.remove(criterion);
                        break;
                    }
                    filterList.add(new FilterCriterion(column.getKey(), event.getValue(), FilterCriterion.FilterOption.CONTAINS));
                    ConfigurableFilterDataProvider gridDataProvider = (ConfigurableFilterDataProvider)this.getDataProvider();
                    gridDataProvider.setFilter((Object)filterList);
                    Set currentlySelectedNodes = this.getSelectedItems();
                    this.setItems((DataProvider)gridDataProvider);
                    for (Node node : currentlySelectedNodes) {
                        if (limitToOneGroup) {
                            if (nodeGroupIdValue.equals(node.getNodeGroupId())) {
                                this.select(node);
                                continue;
                            }
                            this.deselect(node);
                            continue;
                        }
                        this.select(node);
                    }
                    this.selectedNodes = currentlySelectedNodes = this.getSelectedItems();
                });
                this.nodeGroupIdFilterField = selectField;
                cell.setComponent((Component)selectField);
                continue;
            }
            TextField filterField = new TextField();
            filterField.setWidthFull();
            filterField.addThemeVariants((ThemeVariant[])new TextFieldVariant[]{TextFieldVariant.LUMO_SMALL});
            filterField.setValueChangeMode(ValueChangeMode.LAZY);
            filterField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                for (FilterCriterion criterion : new ArrayList(filterList)) {
                    FilterCriterion.FilterOption option = criterion.getOption();
                    if (!criterion.getPropertyId().equals(column.getKey()) || !option.equals((Object)FilterCriterion.FilterOption.CONTAINS) && !option.equals((Object)FilterCriterion.FilterOption.STARTS_WITH)) continue;
                    filterList.remove(criterion);
                    break;
                }
                String filterValue = (String)event.getValue();
                filterList.add(new FilterCriterion(column.getKey(), (Object)filterValue, filterValue.length() > 2 ? FilterCriterion.FilterOption.CONTAINS : FilterCriterion.FilterOption.STARTS_WITH));
                ConfigurableFilterDataProvider gridDataProvider = (ConfigurableFilterDataProvider)this.getDataProvider();
                gridDataProvider.setFilter((Object)filterList);
                Set currentlySelectedNodes = this.getSelectedItems();
                this.setItems((DataProvider)gridDataProvider);
                for (Node node : currentlySelectedNodes) {
                    this.select(node);
                }
                this.selectedNodes = currentlySelectedNodes;
            });
            cell.setComponent((Component)filterField);
        }
        if (limitToOneGroup && nodeGroups.size() > 1) {
            this.nodeGroupIdFilterField.setValue((Object)this.selectedGroup);
            this.addSelectionListener((SelectionListener)new SelectionListener<Grid<Node>, Node>(){
                private static final long serialVersionUID = 1L;

                public void selectionChange(SelectionEvent<Grid<Node>, Node> event) {
                    if (event.isFromClient()) {
                        Set currentlySelectedNodes = event.getAllSelectedItems();
                        if (currentlySelectedNodes.size() > 0) {
                            if (currentlySelectedNodes.size() > Y.this.selectedNodes.size()) {
                                HashSet currentSelectedNodesCopy = new HashSet(currentlySelectedNodes);
                                currentSelectedNodesCopy.removeAll(Y.this.selectedNodes);
                                Node newlySelectedNode = (Node)currentSelectedNodesCopy.iterator().next();
                                if (!StringUtils.isEmpty((CharSequence)Y.this.selectedGroup) && !newlySelectedNode.getNodeGroupId().equals(Y.this.selectedGroup)) {
                                    Y.this.selectedGroup = newlySelectedNode.getNodeGroupId();
                                    Y.this.deselectAll();
                                    Y.this.select(newlySelectedNode);
                                } else {
                                    Y.this.selectedGroup = newlySelectedNode.getNodeGroupId();
                                }
                            }
                        } else {
                            Y.this.selectedGroup = "";
                        }
                        Y.this.selectedNodes = currentlySelectedNodes;
                        Y.this.nodeGroupIdFilterField.setValue((Object)Y.this.selectedGroup);
                    }
                }
            });
        }
        this.getColumnByKey("nodeId").setHeader("Node");
        this.getColumnByKey("nodeGroupId").setHeader("Group");
        this.getColumnByKey("databaseType").setHeader("Database");
        this.getColumnByKey("symmetricVersion").setHeader("SymmetricDS Version");
    }

    private List<Node> findFilteredNodesWithLimit(int offset, int limit, List<FilterCriterion> filter, List<QuerySortOrder> sortOrders) {
        INodeService nodeService = this.controller.getSymmetricEngine().getNodeService();
        if (!sortOrders.isEmpty()) {
            QuerySortOrder sortOrder = sortOrders.get(0);
            return nodeService.findFilteredNodesWithLimit(offset, limit, filter, (String)sortOrder.getSorted(), sortOrder.getDirection().toString());
        }
        return nodeService.findFilteredNodesWithLimit(offset, limit, filter, null, null);
    }

    public HeaderRow.HeaderCell getTitleCell() {
        return this.titleCell;
    }
}

