/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.ui.common.aj;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.dom.Style;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class V
extends CustomField<Set<String>>
implements HasStyle {
    private static final long serialVersionUID = 1L;
    private Div outerDiv;
    private FlexLayout stringLayout;
    private Set<String> stringSet;
    private TextField field;
    private Validator<String> addToListValidator;
    private Validator<Set<String>> finishListValidator;
    private Binder<?> binder;

    public V() {
        HorizontalLayout fieldLayout = new HorizontalLayout();
        this.field = new TextField();
        fieldLayout.addAndExpand(new Component[]{this.field});
        fieldLayout.setWidth(null);
        Button addButton = new Button("Add");
        addButton.setIcon((Component)new Icon(VaadinIcon.PLUS));
        addButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SUCCESS, ButtonVariant.LUMO_PRIMARY});
        addButton.addClickListener((ComponentEventListener & Serializable)event -> this.addString(this.field.getValue()));
        fieldLayout.add(new Component[]{addButton});
        this.stringLayout = new FlexLayout();
        this.stringLayout.setFlexWrap(FlexLayout.FlexWrap.WRAP);
        this.outerDiv = new Div(new Component[]{fieldLayout, this.stringLayout});
        this.add(new Component[]{this.outerDiv});
        this.stringSet = new HashSet<String>();
        this.setValue(this.stringSet);
    }

    public V(Validator<String> addToListValidator, Validator<Set<String>> finishListValidator, Binder<?> binder) {
        this();
        this.addToListValidator = addToListValidator;
        this.finishListValidator = finishListValidator;
        this.binder = binder;
    }

    public void addString(String string) {
        ValidationResult finishListResult;
        ValidationResult addToListResult = null;
        if (this.addToListValidator != null) {
            addToListResult = this.addToListValidator.apply((Object)string, new ValueContext(this.binder, (Component)this.field));
        }
        if (addToListResult != null && addToListResult.isError()) {
            this.field.setErrorMessage(addToListResult.getErrorMessage());
            this.field.setInvalid(true);
        } else {
            this.field.setValue("");
            if (this.stringSet.add(string)) {
                aj tag = new aj(string);
                tag.addButtonClickListener((ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)tagEvent -> {
                    this.stringLayout.remove(new Component[]{tag});
                    this.stringSet.remove(tag.getValue());
                });
                this.stringLayout.add(new Component[]{tag});
                this.setValue(this.stringSet);
            }
        }
        if (this.finishListValidator != null && !(finishListResult = this.finishListValidator.apply((Object)((Set)this.getValue()), new ValueContext(this.binder, (Component)this))).isError()) {
            this.setInvalid(false);
        }
    }

    public Style getStyle() {
        return this.outerDiv.getStyle();
    }

    public void setWidth(String width) {
        this.outerDiv.setWidth(width);
    }

    protected Set<String> generateModelValue() {
        return this.stringSet;
    }

    protected void setPresentationValue(Set<String> newPresentationValue) {
        this.stringSet = newPresentationValue;
    }

    public TextField getField() {
        return this.field;
    }
}

