/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvas;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasEndpoint;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasLink;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasTable;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class S
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    protected I controller;
    protected ConfigCanvas canvas;
    protected Collection<ConfigCanvasEndpoint> endpoints;
    protected Map<String, Set<ConfigCanvasTable>> missingTableMap;
    protected RadioButtonGroup<String> optionGroup;

    public S(I controller, ConfigCanvas canvas, Collection<ConfigCanvasEndpoint> endpoints, Map<String, Set<ConfigCanvasTable>> missingTableMap) {
        this(controller, canvas, endpoints, missingTableMap, null);
    }

    public S(I controller, ConfigCanvas canvas, Collection<ConfigCanvasEndpoint> endpoints, Map<String, Set<ConfigCanvasTable>> missingTableMap, String description) {
        this.controller = controller;
        this.canvas = canvas;
        this.endpoints = endpoints;
        this.missingTableMap = missingTableMap;
        if (description != null) {
            this.add(new Component[]{new Span(description)});
        }
        this.optionGroup = new RadioButtonGroup(null, (Object[])new String[]{controller.getMessage("Keep table configuration", new Object[0]), controller.getMessage("Remove table configuration", new Object[0])});
        this.optionGroup.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
        this.optionGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.optionSelected(((String)event.getValue()).equals(controller.getMessage("Remove table configuration", new Object[0]))));
        this.optionGroup.setValue((Object)controller.getMessage("Keep table configuration", new Object[0]));
        this.add(new Component[]{this.optionGroup});
        for (ConfigCanvasEndpoint endpoint : endpoints) {
            for (ConfigCanvasLink link : endpoint.getLinkList()) {
                VerticalLayout missingTableLayout = new VerticalLayout();
                String targetEndpointGuid = link.getTargetEndpointGuid();
                String key = endpoint.getGuid() + targetEndpointGuid;
                Set<ConfigCanvasTable> missingTableSet = missingTableMap.get(key);
                if (missingTableSet == null) continue;
                missingTableLayout.add(new Component[]{as.createCountLayout(controller, "<b>%d</b> missing source table", missingTableSet.size()), as.createItemLayout(controller, missingTableSet.stream().map(t2 -> t2.getName()).collect(Collectors.toList()), null, 1000)});
                this.add(new Component[]{as.createLinkLayout(controller, endpoint, canvas.getContext().getEndpointByGuid(targetEndpointGuid), (Component)missingTableLayout)});
            }
        }
    }

    public boolean removeTablesIfNecessary() {
        boolean removedTables = false;
        if (((String)this.optionGroup.getValue()).equals(this.controller.getMessage("Remove table configuration", new Object[0]))) {
            for (ConfigCanvasEndpoint endpoint : this.endpoints) {
                for (ConfigCanvasLink link : endpoint.getLinkList()) {
                    String targetEndpointGuid;
                    String sourceEndpointGuid = endpoint.getGuid();
                    Set<ConfigCanvasTable> missingTableSet = this.missingTableMap.get(sourceEndpointGuid + (targetEndpointGuid = link.getTargetEndpointGuid()));
                    if (missingTableSet.isEmpty()) continue;
                    link.removeTables(missingTableSet);
                    for (ConfigCanvasEndpoint otherEndpoint : this.endpoints) {
                        if (!otherEndpoint.getGuid().equals(targetEndpointGuid)) continue;
                        otherEndpoint.setIncomingTableCountForLink(sourceEndpointGuid, endpoint.getTableCount(targetEndpointGuid));
                        break;
                    }
                    removedTables = true;
                }
            }
        } else {
            this.canvas.forceRefreshJsonFile();
        }
        return removedTables;
    }

    protected void optionSelected(boolean removeTables) {
    }
}

