/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.jumpmind.symmetric.console.impl.bC;
import com.jumpmind.symmetric.console.ui.canvas.AbstractSidebarScreen;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvas;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasEndpoint;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasSourceToTargetLayout;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasTable;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasTransformTable;
import com.jumpmind.symmetric.console.ui.canvas.ISidebarScreen;
import com.jumpmind.symmetric.console.ui.canvas.TransformColumnsDiagram;
import com.jumpmind.symmetric.console.ui.canvas.TransformColumnsDiagramDetail;
import com.jumpmind.symmetric.console.ui.canvas.TransformDiagram;
import com.jumpmind.symmetric.console.ui.canvas.TransformDiagramDetail;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.X;
import com.jumpmind.symmetric.console.ui.common.ad;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.o;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.io.data.transform.ColumnPolicy;
import org.jumpmind.symmetric.io.data.transform.TargetDmlAction;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformDataScreen
extends AbstractSidebarScreen {
    private static final long serialVersionUID = 1L;
    private TransformDialog transformDialog;
    private TransformColumnsDialog transformColumnsDialog;

    public TransformDataScreen(I controller, ConfigCanvas canvas) {
        super(controller, canvas, controller.getMessage("Transform Data", new Object[0]), controller.getMessage("Optionally transform data as it gets extracted from the source or loaded into the target.", new Object[0]));
        ConfigCanvasEndpoint firstEndpoint = canvas.getFirstEndpoint();
        ConfigCanvasEndpoint secondEndpoint = canvas.getSecondEndpoint();
        if (firstEndpoint.getTableCount(secondEndpoint.getGuid()) > 0) {
            this.add(new Component[]{new TransformLayout(firstEndpoint, secondEndpoint)});
        }
        if (secondEndpoint.getTableCount(firstEndpoint.getGuid()) > 0 && !firstEndpoint.getGuid().equals(secondEndpoint.getGuid())) {
            this.add(new Component[]{new TransformLayout(secondEndpoint, firstEndpoint)});
        }
    }

    public void updateDivPosition(int windowHeight, int windowWidth) {
        if (this.transformDialog != null && this.transformDialog.isOpened()) {
            this.transformDialog.updateDivPosition(windowHeight, windowWidth);
        }
        if (this.transformColumnsDialog != null && this.transformColumnsDialog.isOpened()) {
            this.transformColumnsDialog.updateDivPosition(windowHeight, windowWidth);
        }
    }

    private Button createButton(String text, VaadinIcon vaadinIcon, ComponentEventListener<ClickEvent<Button>> listener) {
        Icon icon = new Icon(vaadinIcon);
        icon.setSize("16px");
        icon.addClassName("contrast");
        icon.getStyle().set("min-width", "16px").set("min-height", "16px").set("padding", "0").set("margin-bottom", "3px");
        Button button = new Button(text, (Component)icon, listener);
        button.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE, ButtonVariant.LUMO_SMALL});
        button.addClassName("contrast");
        button.setEnabled(false);
        return button;
    }

    private ad createLegend(String headerMessageKey, String dashedMessageKey, String solidMessageKey) {
        H5 legendHeader = new H5(this.controller.getMessage(headerMessageKey, new Object[0]));
        legendHeader.addClassName("less-contrast");
        legendHeader.getStyle().set("font-weight", "700");
        Span dashedSpan = new Span(this.controller.getMessage(dashedMessageKey, new Object[0]));
        dashedSpan.addClassName("less-contrast");
        Span solidSpan = new Span(this.controller.getMessage(solidMessageKey, new Object[0]));
        solidSpan.addClassName("less-contrast");
        VerticalLayout legendLabelLayout = new VerticalLayout(new Component[]{dashedSpan, solidSpan});
        legendLabelLayout.setMargin(false);
        legendLabelLayout.setPadding(false);
        legendLabelLayout.setSpacing(false);
        Image legendImage = as.createImage(this.controller.getContextPath(), UI.getCurrent().getElement().getThemeList().contains((Object)"dark") ? "/icons/dashed_vs_solid_dark.png" : "/icons/dashed_vs_solid.png");
        legendImage.setHeight("50px");
        legendImage.setWidth("122px");
        legendImage.getStyle().set("margin-top", "1px");
        VerticalLayout legendLayout = new VerticalLayout(new Component[]{legendHeader, new HorizontalLayout(new Component[]{legendLabelLayout, legendImage})});
        legendLayout.getStyle().set("margin", "0").set("padding", "8px").set("gap", "0");
        ad legendDiv = new ad();
        legendDiv.setHeight("100px");
        legendDiv.setWidth("260px");
        legendDiv.setLeft(this.canvas.getWindowWidth() - 330 + "px");
        legendDiv.getStyle().set("z-index", "300");
        legendDiv.add(new Component[]{legendLayout});
        return legendDiv;
    }

    @Override
    public int getProgressStepperIndex() {
        return 4;
    }

    @Override
    public boolean isNextEnabled() {
        return true;
    }

    @Override
    public boolean isPreviousEnabled() {
        return true;
    }

    @Override
    public boolean isFinishVisible() {
        return true;
    }

    @Override
    public ISidebarScreen next() {
        this.canvas.closeSidebarAndClearSelection(false, true);
        return null;
    }

    @Override
    public boolean last() {
        this.canvas.getProgressStepper().setStepComplete(this.getProgressStepperIndex());
        return true;
    }

    @Override
    public String getNextButtonTooltip() {
        return this.controller.getMessage("Close the sidebar", new Object[0]);
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_transform_configuration";
    }

    class TransformLayout
    extends Scroller {
        private static final long serialVersionUID = 1L;
        private ConfigCanvasEndpoint sourceEndpoint;
        private ConfigCanvasEndpoint targetEndpoint;
        private Component sourceEndpointIcon;
        private Span sourceEndpointIdSpan;
        private Icon arrowIcon;
        private Component targetEndpointIcon;
        private Span targetEndpointIdSpan;
        private VerticalLayout transformLayout;

        public TransformLayout(ConfigCanvasEndpoint sourceEndpoint, ConfigCanvasEndpoint targetEndpoint) {
            this.sourceEndpoint = sourceEndpoint;
            this.targetEndpoint = targetEndpoint;
            this.sourceEndpointIcon = as.getEndpointIcon(TransformDataScreen.this.controller.getContextPath(), sourceEndpoint.getType());
            this.targetEndpointIcon = as.getEndpointIcon(TransformDataScreen.this.controller.getContextPath(), targetEndpoint.getType());
            this.sourceEndpointIdSpan = new Span(sourceEndpoint.getId());
            this.sourceEndpointIdSpan.addClassName("less-contrast");
            this.arrowIcon = new Icon(VaadinIcon.ARROW_RIGHT);
            this.arrowIcon.addClassName("less-contrast");
            this.targetEndpointIdSpan = new Span(targetEndpoint.getId());
            this.targetEndpointIdSpan.addClassName("less-contrast");
            HorizontalLayout linkLayout = new HorizontalLayout(new Component[]{this.sourceEndpointIcon, this.sourceEndpointIdSpan, this.arrowIcon, this.targetEndpointIcon, this.targetEndpointIdSpan});
            linkLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
            this.transformLayout = new VerticalLayout();
            this.transformLayout.setPadding(false);
            this.transformLayout.setMargin(false);
            MenuBar addTransformBar = new MenuBar();
            addTransformBar.addThemeVariants((ThemeVariant[])new MenuBarVariant[]{MenuBarVariant.LUMO_TERTIARY_INLINE, MenuBarVariant.LUMO_ICON});
            ComponentEventListener & Serializable extractTransformClickListener = (ComponentEventListener & Serializable)event -> {
                TransformDataScreen.this.transformDialog = new TransformDialog(this, sourceEndpoint, targetEndpoint, TransformPoint.EXTRACT);
                TransformDataScreen.this.transformDialog.open();
            };
            MenuItem addTransformMenuItem = addTransformBar.addItem(TransformDataScreen.this.controller.getMessage("Add transform", new Object[0]), (ComponentEventListener)extractTransformClickListener);
            addTransformMenuItem.getStyle().set("cursor", "pointer");
            addTransformBar.setTooltipText(addTransformMenuItem, TransformDataScreen.this.controller.getMessage("Open the Define Table Extract Transform dialog", new Object[0]));
            MenuItem addTransformDropdown = addTransformBar.addItem((Component)as.getDropdownIcon());
            addTransformDropdown.getStyle().set("cursor", "pointer");
            ((SubMenu)addTransformDropdown.getSubMenu()).addItem(TransformDataScreen.this.controller.getMessage("Add extract transform", new Object[0]), (ComponentEventListener)extractTransformClickListener);
            ((SubMenu)addTransformDropdown.getSubMenu()).addItem(TransformDataScreen.this.controller.getMessage("Add load transform", new Object[0]), (ComponentEventListener & Serializable)event -> {
                TransformDataScreen.this.transformDialog = new TransformDialog(this, sourceEndpoint, targetEndpoint, TransformPoint.LOAD);
                TransformDataScreen.this.transformDialog.open();
            });
            VerticalLayout leftLayout = new VerticalLayout(new Component[]{linkLayout, this.transformLayout});
            leftLayout.getStyle().set("max-width", "80%");
            HorizontalLayout mainLayout = new HorizontalLayout(new Component[]{leftLayout});
            mainLayout.addAndExpand(new Component[]{new Span()});
            if (!TransformDataScreen.this.readOnly && !TransformDataScreen.this.errorMessageVisible) {
                mainLayout.add(new Component[]{addTransformBar});
                mainLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{addTransformBar});
            } else {
                addTransformBar.setEnabled(false);
                Div addTransformDiv = new Div(new Component[]{addTransformBar});
                Tooltip.forComponent((Component)addTransformDiv).setText(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "Requires write permission" : "Requires valid connection details", new Object[0]));
                mainLayout.add(new Component[]{addTransformDiv});
                mainLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{addTransformDiv});
            }
            this.setContent((Component)mainLayout);
            this.setWidthFull();
            this.setMaxHeight("42%");
            this.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
            this.addClassName("subtle-border-disabled");
            this.getStyle().set("padding", "0 8px 0 0").set("margin-left", "0");
            this.refresh(false, false);
        }

        public void refresh(boolean refreshCanvas, boolean forceRedraw) {
            this.transformLayout.removeAll();
            List<Set<ConfigCanvasTransformTable>> transformList = this.sourceEndpoint.getTransformList(this.targetEndpoint.getGuid());
            int transformCount = transformList.size();
            if (transformCount > 0) {
                this.sourceEndpointIcon.getStyle().remove("filter");
                this.sourceEndpointIdSpan.removeClassName("less-contrast");
                this.arrowIcon.removeClassName("less-contrast");
                this.targetEndpointIcon.getStyle().remove("filter");
                this.targetEndpointIdSpan.removeClassName("less-contrast");
                for (int i2 = 0; i2 < transformCount; ++i2) {
                    this.addLayoutForTransformSet(transformList.get(i2), i2);
                }
                this.removeClassName("subtle-border-disabled");
                this.addClassName("subtle-border");
            } else {
                this.sourceEndpointIcon.getStyle().set("filter", "grayscale(1)");
                this.sourceEndpointIdSpan.addClassName("less-contrast");
                this.arrowIcon.addClassName("less-contrast");
                this.targetEndpointIcon.getStyle().set("filter", "grayscale(1)");
                this.targetEndpointIdSpan.addClassName("less-contrast");
                this.addLayoutForTransformSet(null, 0);
                this.removeClassName("subtle-border");
                this.addClassName("subtle-border-disabled");
            }
            if (refreshCanvas) {
                if (forceRedraw) {
                    TransformDataScreen.this.canvas.refreshEndpoints();
                    TransformDataScreen.this.canvas.redrawDiagram();
                } else {
                    TransformDataScreen.this.canvas.redrawDiagramIfStateChanged(this.sourceEndpoint);
                }
            }
        }

        private void addLayoutForTransformSet(Set<ConfigCanvasTransformTable> transformSet, int index) {
            Label label = new Label();
            label.addClassName("less-contrast");
            if (transformSet != null) {
                String sourceSchema;
                HashSet<String> sourceTableNameSet = new HashSet<String>();
                for (ConfigCanvasTransformTable transform : transformSet) {
                    sourceTableNameSet.add(transform.getFullyQualifiedSourceTableName());
                }
                int sourceTableCount = sourceTableNameSet.size();
                Object labelText = TransformDataScreen.this.controller.getMessage("Transforming <b>%d</b> table", sourceTableCount);
                if (sourceTableCount > 1) {
                    labelText = (String)labelText + "s";
                }
                ConfigCanvasTransformTable transform = transformSet.iterator().next();
                String transformPoint = StringUtils.capitalize((String)transform.getTransformPoint().toString().toLowerCase());
                labelText = (String)labelText + " (<b>" + transformPoint + "</b>, ";
                String sourceCatalog = (String)StringUtils.defaultIfBlank((CharSequence)transform.getOriginalSourceCatalogName(), (CharSequence)this.sourceEndpoint.getDefaultCatalog());
                if (StringUtils.isNotBlank((CharSequence)sourceCatalog)) {
                    labelText = (String)labelText + TransformDataScreen.this.controller.getMessage("Source Catalog", new Object[0]) + ": <b>" + sourceCatalog + "</b>, ";
                }
                if (StringUtils.isNotBlank((CharSequence)(sourceSchema = (String)StringUtils.defaultIfBlank((CharSequence)transform.getOriginalSourceSchemaName(), (CharSequence)this.sourceEndpoint.getDefaultSchema())))) {
                    labelText = (String)labelText + TransformDataScreen.this.controller.getMessage("Source Schema", new Object[0]) + ": <b>" + sourceSchema + "</b>, ";
                }
                labelText = ((String)labelText).substring(0, ((String)labelText).length() - 2) + ")";
                label.setText((String)labelText);
                HorizontalLayout transformMapLayout = new HorizontalLayout(new Component[]{label});
                if (!TransformDataScreen.this.errorMessageVisible) {
                    Icon editIcon = new Icon(VaadinIcon.EDIT);
                    editIcon.setSize("20px");
                    editIcon.setColor("var(--lumo-primary-text-color)");
                    editIcon.getStyle().set("min-height", "20px").set("min-width", "20px").set("margin", "4px 0 0 8px").set("cursor", "pointer");
                    editIcon.addClickListener((ComponentEventListener & Serializable)event -> {
                        TransformDataScreen.this.transformDialog = new TransformDialog(this, this.sourceEndpoint, this.targetEndpoint, transform.getTransformPoint(), index);
                        TransformDataScreen.this.transformDialog.open();
                    });
                    editIcon.setTooltipText(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "View transform(s)" : "Edit transform(s)", new Object[0]));
                    transformMapLayout.add(new Component[]{editIcon});
                }
                if (!TransformDataScreen.this.readOnly) {
                    label.getStyle().set("padding-left", "8px");
                    o deleteIcon = new o(TransformDataScreen.this.controller.getContextPath(), VaadinIcon.CLOSE_SMALL);
                    deleteIcon.addClickListener(() -> {
                        this.sourceEndpoint.removeTransforms(this.targetEndpoint.getGuid(), index);
                        boolean removedAllTransforms = false;
                        if (this.sourceEndpoint.getTransformList(this.targetEndpoint.getGuid()).isEmpty()) {
                            this.targetEndpoint.setIncomingTransformedForLink(this.sourceEndpoint.getGuid(), false);
                            removedAllTransforms = true;
                        }
                        this.refresh(true, removedAllTransforms);
                    });
                    Tooltip.forComponent((Component)deleteIcon).setText(TransformDataScreen.this.controller.getMessage("Remove transform(s)", new Object[0]));
                    transformMapLayout.addComponentAsFirst((Component)deleteIcon);
                }
                transformMapLayout.setPadding(false);
                transformMapLayout.setMargin(false);
                transformMapLayout.setSpacing(false);
                this.transformLayout.add(new Component[]{transformMapLayout});
            } else {
                label.setText(TransformDataScreen.this.controller.getMessage("No transforms configured", new Object[0]));
                this.transformLayout.add(new Component[]{label});
            }
        }
    }

    class TransformDialog
    extends X {
        private static final long serialVersionUID = 1L;
        private final Logger log;
        private final String TRANSFORMED_SUFFIX = " <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>";
        private List<ConfigCanvasTable> sourceTableList;
        private List<ConfigCanvasTable> transformedTableList;
        private List<ConfigCanvasTable> targetTableList;
        private Set<String> viewableSourceTableNameSet;
        private Set<String> viewableTargetTableNameSet;
        private Set<ConfigCanvasTransformTable> transformSet;
        private List<ConfigCanvasTransformTable> allExtractTransformList;
        private List<ConfigCanvasTable> allSourceTableList;
        private ConfigCanvasEndpoint sourceEndpoint;
        private ConfigCanvasEndpoint targetEndpoint;
        private TransformPoint transformPoint;
        private String tablePrefix;
        private ConfigCanvasSourceToTargetLayout sourceToTargetLayout;
        private boolean preventDiagramRefresh;
        private Scroller diagramScroller;
        private TransformDiagram diagram;
        private RadioButtonGroup<String> tableVisibilityGroup;
        private ad tableVisibilityDiv;
        private Button editButton;
        private Div editDiv;
        private Tooltip editTooltip;
        private Button mapColumnsButton;
        private Div mapColumnsDiv;
        private Tooltip mapColumnsTooltip;
        private Button deleteButton;
        private Div deleteDiv;
        private Tooltip deleteTooltip;
        private ad diagramActionDiv;
        private ad legendDiv;
        private ConfigCanvasTable selectedSourceTable;
        private ConfigCanvasTable selectedTargetTable;

        public TransformDialog(TransformLayout transformLayout, ConfigCanvasEndpoint sourceEndpoint, ConfigCanvasEndpoint targetEndpoint, TransformPoint transformPoint) {
            this(transformLayout, sourceEndpoint, targetEndpoint, transformPoint, -1);
        }

        public TransformDialog(TransformLayout transformLayout, final ConfigCanvasEndpoint sourceEndpoint, final ConfigCanvasEndpoint targetEndpoint, TransformPoint transformPoint, int transformSetIndex) {
            super(TransformDataScreen.this.controller.getMessage(TransformPoint.LOAD.equals((Object)transformPoint) ? (TransformDataScreen.this.readOnly ? "View Table Load Transform" : "Define Table Load Transform") : (TransformDataScreen.this.readOnly ? "View Table Extract Transform" : "Define Table Extract Transform"), new Object[0]), TransformDataScreen.this.controller.getContextPath(), VaadinIcon.TABLE, TransformDataScreen.this.readOnly ? null : TransformDataScreen.this.controller.getMessage("Close the dialog without saving any transforms", new Object[0]));
            this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            this.TRANSFORMED_SUFFIX = " <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>";
            this.sourceTableList = new ArrayList<ConfigCanvasTable>();
            this.transformedTableList = new ArrayList<ConfigCanvasTable>();
            this.targetTableList = new ArrayList<ConfigCanvasTable>();
            this.viewableSourceTableNameSet = new TreeSet<String>((t0, t1) -> t0.toLowerCase().compareTo(t1.toLowerCase()));
            this.viewableTargetTableNameSet = new TreeSet<String>((t0, t1) -> t0.toLowerCase().compareTo(t1.toLowerCase()));
            this.transformSet = new HashSet<ConfigCanvasTransformTable>();
            this.allExtractTransformList = new ArrayList<ConfigCanvasTransformTable>();
            this.allSourceTableList = new ArrayList<ConfigCanvasTable>();
            this.sourceEndpoint = sourceEndpoint;
            this.targetEndpoint = targetEndpoint;
            this.transformPoint = transformPoint;
            if (TransformPoint.LOAD.equals((Object)transformPoint)) {
                for (Set set : sourceEndpoint.getTransformList(targetEndpoint.getGuid())) {
                    if (!TransformPoint.EXTRACT.equals((Object)((ConfigCanvasTransformTable)set.iterator().next()).getTransformPoint())) continue;
                    this.allExtractTransformList.addAll(set);
                }
            }
            for (ConfigCanvasTable configCanvasTable : sourceEndpoint.getAllTables(targetEndpoint.getGuid())) {
                if (TransformPoint.LOAD.equals((Object)transformPoint) && this.hasTableBeenTransformed(configCanvasTable)) continue;
                this.allSourceTableList.add(configCanvasTable);
            }
            if (transformSetIndex >= 0) {
                Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).create();
                this.transformSet = (Set)gson.fromJson(gson.toJson(sourceEndpoint.getTransformList(targetEndpoint.getGuid()).get(transformSetIndex)), (TypeToken)new TypeToken<Set<ConfigCanvasTransformTable>>(){});
                for (ConfigCanvasTransformTable transform : this.transformSet) {
                    if (!transform.getSourceColumnNames().isEmpty() || !transform.getTargetColumnNames().isEmpty()) continue;
                    this.populateColumnNames(transform);
                    for (ConfigCanvasTransformTable.ConfigCanvasTransformColumn transformColumn : transform.getTransformColumns()) {
                        String targetColumnName = transformColumn.getTargetColumnName();
                        if ("remove".equals(transformColumn.getTransformType()) || !transform.getTargetColumnNames().stream().noneMatch(c2 -> Strings.CI.equals(c2, targetColumnName))) continue;
                        transform.getTargetColumnNames().add(targetColumnName);
                        transform.getAddedColumnNames().add(targetColumnName);
                    }
                }
            }
            this.tablePrefix = TransformDataScreen.this.controller.getSymmetricEngine() != null ? TransformDataScreen.this.controller.getSymmetricEngine().getTablePrefix() : "sym_";
            this.setSizeFull();
            this.setCloseOnOutsideClick(false);
            this.addClassName("base-color-footer");
            final List<String> targetCatalogList = this.getCatalogs(false);
            Collections.sort(targetCatalogList, String.CASE_INSENSITIVE_ORDER);
            this.sourceToTargetLayout = new ConfigCanvasSourceToTargetLayout(TransformDataScreen.this.controller, sourceEndpoint, targetEndpoint, null, null, true, true, false){
                private static final long serialVersionUID = 1L;

                @Override
                protected void initCatalogSchemaFields(boolean source, Select<String> catalogSelect, Select<String> schemaSelect) {
                    String schema;
                    if (source) {
                        TransformDialog.this.refreshSourceCatalogs();
                        TransformDialog.this.refreshSchemas(true);
                    } else if (targetCatalogList != null && !targetCatalogList.isEmpty() && targetCatalogList.get(0) != null) {
                        catalogSelect.setItems((Collection)targetCatalogList);
                    } else {
                        catalogSelect.setVisible(false);
                    }
                    if (catalogSelect.isVisible()) {
                        catalogSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                            if (event.isFromClient()) {
                                if (source) {
                                    TransformDialog.this.transformSet.clear();
                                }
                                TransformDialog.this.preventDiagramRefresh = true;
                                TransformDialog.this.refreshSchemas(source);
                                TransformDialog.this.preventDiagramRefresh = false;
                                TransformDialog.this.refreshDiagram(source, !source);
                            }
                        });
                        if (!source) {
                            String catalog;
                            String string = catalog = !TransformDialog.this.transformSet.isEmpty() ? (String)StringUtils.defaultIfBlank((CharSequence)TransformDialog.this.transformSet.iterator().next().getTargetCatalogName(), (CharSequence)targetEndpoint.getDefaultCatalog()) : targetEndpoint.getDefaultCatalog();
                            if (catalog == null && catalogSelect.getListDataView().getItemCount() > 0) {
                                catalog = (String)catalogSelect.getListDataView().getItem(0);
                            }
                            catalogSelect.setValue((Object)catalog);
                        }
                    }
                    if (source) {
                        schema = !TransformDialog.this.transformSet.isEmpty() ? (String)StringUtils.defaultIfBlank((CharSequence)TransformDialog.this.transformSet.iterator().next().getOriginalSourceSchemaName(), (CharSequence)sourceEndpoint.getDefaultSchema()) : sourceEndpoint.getDefaultSchema();
                    } else {
                        String string = schema = !TransformDialog.this.transformSet.isEmpty() ? (String)StringUtils.defaultIfBlank((CharSequence)TransformDialog.this.transformSet.iterator().next().getTargetSchemaName(), (CharSequence)targetEndpoint.getDefaultSchema()) : targetEndpoint.getDefaultSchema();
                    }
                    if (schema == null && schemaSelect.getListDataView().getItemCount() > 0) {
                        schema = (String)schemaSelect.getListDataView().getItem(0);
                    }
                    if (!source) {
                        TransformDialog.this.refreshSchemas(false);
                    }
                    schemaSelect.setValue((Object)schema);
                    schemaSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        if (source) {
                            TransformDialog.this.transformSet.clear();
                        }
                        if (!TransformDialog.this.preventDiagramRefresh) {
                            TransformDialog.this.refreshDiagram(source, !source);
                        }
                    });
                }

                @Override
                protected void initFilterField(boolean source, TextField filterField, HorizontalLayout filterLayout) {
                    filterField.setValueChangeTimeout(500);
                    filterField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> TransformDialog.this.refreshDiagram(false, false));
                }
            };
            this.sourceToTargetLayout.init();
            Div div = new Div();
            div.setHeight("8000px");
            div.setWidthFull();
            this.diagramScroller = new Scroller((Component)div);
            this.diagramScroller.setSizeFull();
            this.diagramScroller.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
            this.tableVisibilityGroup = new RadioButtonGroup();
            this.tableVisibilityGroup.setItems((Object[])new String[]{TransformDataScreen.this.controller.getMessage("Show all", new Object[0]), TransformDataScreen.this.controller.getMessage("Show mapped only", new Object[0]), TransformDataScreen.this.controller.getMessage("Show unmapped only", new Object[0])});
            this.tableVisibilityGroup.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
            this.tableVisibilityGroup.setValue((Object)TransformDataScreen.this.controller.getMessage("Show all", new Object[0]));
            this.tableVisibilityGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.refreshDiagram(false, false));
            this.tableVisibilityDiv = new ad();
            this.tableVisibilityDiv.setHeight("98px");
            this.tableVisibilityDiv.setWidth("200px");
            this.tableVisibilityDiv.setLeft(TransformDataScreen.this.canvas.getWindowWidth() - 270 + "px");
            this.tableVisibilityDiv.getStyle().set("z-index", "300");
            this.tableVisibilityDiv.add(new Component[]{this.tableVisibilityGroup});
            this.editButton = TransformDataScreen.this.createButton(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "View Details" : "Edit", new Object[0]), VaadinIcon.EDIT, (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> this.editSelection());
            this.editDiv = new Div(new Component[]{this.editButton});
            this.editDiv.getStyle().set("margin", "4px 0 0 12px");
            this.editTooltip = Tooltip.forComponent((Component)this.editDiv).withPosition(Tooltip.TooltipPosition.START).withText(TransformDataScreen.this.controller.getMessage("Select exactly 1 transform first", new Object[0]));
            this.mapColumnsButton = TransformDataScreen.this.createButton(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "View Columns" : "Map Columns", new Object[0]), VaadinIcon.SITEMAP, (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> this.mapColumnsForSelection());
            this.mapColumnsDiv = new Div(new Component[]{this.mapColumnsButton});
            this.mapColumnsDiv.getStyle().set("margin", "4px 0 0 12px");
            this.mapColumnsTooltip = Tooltip.forComponent((Component)this.mapColumnsDiv).withPosition(Tooltip.TooltipPosition.START).withText(TransformDataScreen.this.controller.getMessage("Select exactly 1 transform first", new Object[0]));
            this.deleteButton = TransformDataScreen.this.createButton(TransformDataScreen.this.controller.getMessage("Delete", new Object[0]), VaadinIcon.TRASH, (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> this.deleteSelection());
            this.deleteDiv = new Div(new Component[]{this.deleteButton});
            this.deleteDiv.getStyle().set("margin", "4px 0 0 12px");
            this.deleteTooltip = Tooltip.forComponent((Component)this.deleteDiv).withPosition(Tooltip.TooltipPosition.START).withText(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "Requires write permission" : "Select 1 or more transforms first", new Object[0]));
            VerticalLayout diagramActionLayout = new VerticalLayout(new Component[]{this.editDiv, this.mapColumnsDiv, this.deleteDiv});
            diagramActionLayout.setMargin(false);
            diagramActionLayout.setPadding(false);
            diagramActionLayout.setSpacing(false);
            this.diagramActionDiv = new ad();
            this.diagramActionDiv.setHeight("94px");
            this.diagramActionDiv.setWidth("140px");
            if (this.sourceToTargetLayout.areSourceCatalogSchemaFieldsVisible()) {
                this.tableVisibilityDiv.setTop("336px");
                this.diagramActionDiv.setTop("446px");
            } else {
                this.tableVisibilityDiv.setTop("243px");
                this.diagramActionDiv.setTop("353px");
            }
            this.diagramActionDiv.setLeft(TransformDataScreen.this.canvas.getWindowWidth() - 210 + "px");
            this.diagramActionDiv.getStyle().set("z-index", "300");
            this.diagramActionDiv.add(new Component[]{diagramActionLayout});
            this.legendDiv = TransformDataScreen.this.createLegend("Table Mapping", "Auto Mapped", "User Mapped");
            this.legendDiv.setTop(TransformDataScreen.this.canvas.getWindowHeight() - 214 + "px");
            Div diagramPaddingDiv = new Div(new Component[]{this.diagramScroller, this.tableVisibilityDiv, this.diagramActionDiv, this.legendDiv});
            diagramPaddingDiv.setHeight("0");
            diagramPaddingDiv.setWidthFull();
            diagramPaddingDiv.getStyle().set("padding", "0 8px 8px 8px");
            this.mainLayout.add(new Component[]{this.sourceToTargetLayout, diagramPaddingDiv});
            this.mainLayout.setPadding(false);
            this.mainLayout.setSpacing(false);
            this.mainLayout.expand(new Component[]{diagramPaddingDiv});
            Anchor helpAnchor = TransformDataScreen.this.canvas.createHelpAnchor(TransformDataScreen.this.getDocAnchor());
            helpAnchor.getStyle().set("margin-right", "auto");
            if (TransformDataScreen.this.readOnly) {
                this.getFooter().add(new Component[]{helpAnchor, new Button(TransformDataScreen.this.controller.getMessage("Close", new Object[0]), (ComponentEventListener & Serializable)event -> this.close())});
            } else {
                Button cancelButton = new Button(TransformDataScreen.this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
                cancelButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
                cancelButton.getStyle().set("margin-right", "10px");
                cancelButton.setTooltipText(TransformDataScreen.this.controller.getMessage("Close the dialog without saving any transforms", new Object[0]));
                Button saveButton = as.createPrimaryButton(TransformDataScreen.this.controller.getMessage("Save", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
                    if (transformSetIndex >= 0 || !this.transformSet.isEmpty()) {
                        String targetEndpointGuid = targetEndpoint.getGuid();
                        List<Set<ConfigCanvasTransformTable>> transformList = sourceEndpoint.getTransformList(targetEndpointGuid);
                        boolean addedFirstTransform = transformList.isEmpty();
                        if (transformSetIndex >= 0) {
                            sourceEndpoint.removeTransforms(targetEndpointGuid, transformSetIndex);
                        }
                        Set<String> transformIdSet = TransformDataScreen.this.canvas.getContext().getAllTransformIds();
                        for (ConfigCanvasTransformTable transform : this.transformSet) {
                            String newId = transform.getId();
                            int i2 = 2;
                            while (transformIdSet.contains(newId)) {
                                newId = transform.generateDefaultId(i2++);
                            }
                            transform.setId(newId);
                            transformIdSet.add(newId);
                        }
                        sourceEndpoint.addTransforms(targetEndpointGuid, this.transformSet, transformSetIndex);
                        boolean removedAllTransforms = !addedFirstTransform && transformList.isEmpty();
                        targetEndpoint.setIncomingTransformedForLink(sourceEndpoint.getGuid(), !removedAllTransforms);
                        transformLayout.refresh(true, addedFirstTransform || removedAllTransforms);
                    }
                    this.close();
                });
                saveButton.setTooltipText(TransformDataScreen.this.controller.getMessage("Save the transform(s) and close the dialog", new Object[0]));
                this.getFooter().add(new Component[]{helpAnchor, cancelButton, saveButton});
            }
            this.refreshDiagram(true, true);
            this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> TransformDataScreen.this.canvas.toggleDeleteShortcut(!event.isOpened()));
        }

        public void updateDivPosition(int windowHeight, int windowWidth) {
            this.tableVisibilityDiv.setLeft(windowWidth - 270 + "px");
            this.diagramActionDiv.setLeft(windowWidth - 210 + "px");
            this.legendDiv.setTop(windowHeight - 214 + "px");
            this.legendDiv.setLeft(windowWidth - 330 + "px");
            this.refreshDiagram(false, false);
        }

        public void populateColumnNames(ConfigCanvasTransformTable transform) {
            String sourceCatalog = transform.getSourceCatalogName();
            String sourceSchema = transform.getSourceSchemaName();
            String sourceTableName = transform.getSourceTableName();
            for (ConfigCanvasTable sourceTable : this.allSourceTableList) {
                if (!Strings.CS.equals(sourceTable.getTargetCatalog(), sourceCatalog) || !Strings.CS.equals(sourceTable.getTargetSchema(), sourceSchema) || !sourceTable.getName().equals(sourceTableName)) continue;
                if (sourceTable.getColumnCount() == 0) {
                    Table dbTable = this.sourceEndpoint.getDatabasePlatform().getDdlReader().readTable(sourceTable.getCatalog(), sourceTable.getSchema(), sourceTable.getName());
                    sourceTable.addColumns(dbTable.getColumnsAsList());
                }
                transform.getSourceColumnNames().addAll(sourceTable.getColumnNames());
                transform.getSourcePrimaryKeyColumnNames().addAll(sourceTable.getPrimaryKeyColumnNames());
            }
            for (ConfigCanvasTransformTable otherTransform : this.allExtractTransformList) {
                String columnName;
                if (!Strings.CS.equals(otherTransform.getTargetCatalogName(), sourceCatalog) || !Strings.CS.equals(otherTransform.getTargetSchemaName(), sourceSchema) || !otherTransform.getTargetTableName().equals(sourceTableName)) continue;
                for (ConfigCanvasTransformTable.ConfigCanvasTransformColumn column : otherTransform.getTransformColumns()) {
                    if ("remove".equals(column.getTransformType())) continue;
                    columnName = column.getTargetColumnName();
                    transform.getSourceColumnNames().add(columnName);
                    if (!column.isPrimaryKey()) continue;
                    transform.getSourcePrimaryKeyColumnNames().add(columnName);
                }
                for (Column impliedColumn : otherTransform.getImpliedColumnSet()) {
                    columnName = impliedColumn.getName();
                    transform.getSourceColumnNames().add(columnName);
                    if (!impliedColumn.isPrimaryKey()) continue;
                    transform.getSourcePrimaryKeyColumnNames().add(columnName);
                }
            }
            Table targetTable = this.targetEndpoint.getDatabasePlatform().getDdlReader().readTable(transform.getTargetCatalogName(), transform.getTargetSchemaName(), transform.getTargetTableName());
            if (targetTable != null) {
                transform.getTargetColumnNames().addAll(Arrays.asList(targetTable.getColumnNames()));
                transform.getTargetPrimaryKeyColumnNames().addAll(Arrays.asList(targetTable.getPrimaryKeyColumnNames()));
            } else {
                for (ConfigCanvasTransformTable.ConfigCanvasTransformColumn transformColumn : transform.getTransformColumns()) {
                    if ("remove".equals(transformColumn.getTransformType())) continue;
                    transform.getTargetColumnNames().add(transformColumn.getTargetColumnName());
                }
            }
        }

        private void refreshDiagram(boolean refreshSourceTables, boolean refreshTargetTables) {
            String targetSchema;
            String targetCatalog;
            Object columnName;
            String selectedSourceCatalog = this.sourceToTargetLayout.getSelectedCatalog(true);
            String selectedSourceSchema = this.sourceToTargetLayout.getSelectedSchema(true);
            if (refreshSourceTables) {
                this.transformedTableList.clear();
                for (ConfigCanvasTransformTable transform : this.allExtractTransformList) {
                    String originalSourceCatalog = (String)StringUtils.defaultIfBlank((CharSequence)transform.getOriginalSourceCatalogName(), (CharSequence)this.sourceEndpoint.getDefaultCatalog());
                    String originalSourceSchema = (String)StringUtils.defaultIfBlank((CharSequence)transform.getOriginalSourceSchemaName(), (CharSequence)this.sourceEndpoint.getDefaultSchema());
                    if (!Strings.CS.equals(selectedSourceCatalog, originalSourceCatalog) || !Strings.CS.equals(selectedSourceSchema, originalSourceSchema)) continue;
                    String tableName = transform.getTargetTableName() + " <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>";
                    Object transformedTable = null;
                    for (ConfigCanvasTable table : this.transformedTableList) {
                        if (!Strings.CS.equals(transform.getOriginalSourceCatalogName(), table.getCatalog()) || !Strings.CS.equals(transform.getOriginalSourceSchemaName(), table.getSchema()) || !tableName.equals(table.getName())) continue;
                        transformedTable = table;
                        break;
                    }
                    if (transformedTable == null) {
                        transformedTable = new ConfigCanvasTable(transform.getOriginalSourceCatalogName(), transform.getOriginalSourceSchemaName(), tableName, transform.getTargetCatalogName(), transform.getTargetSchemaName());
                        ((ConfigCanvasTable)transformedTable).setSourceTableExists(true);
                        this.transformedTableList.add((ConfigCanvasTable)transformedTable);
                    }
                    for (ConfigCanvasTransformTable.ConfigCanvasTransformColumn column : transform.getTransformColumns()) {
                        if ("remove".equals(column.getTransformType()) || !((ConfigCanvasTable)transformedTable).hasColumnWithName((String)(columnName = column.getTargetColumnName()))) continue;
                        ((ConfigCanvasTable)transformedTable).addColumn((String)columnName, column.isPrimaryKey());
                    }
                    for (Column impliedColumn : transform.getImpliedColumnSet()) {
                        if (!((ConfigCanvasTable)transformedTable).hasColumnWithName(impliedColumn.getName())) continue;
                        ((ConfigCanvasTable)transformedTable).addColumn(impliedColumn.getName(), impliedColumn.isPrimaryKey());
                    }
                }
                this.sourceTableList.clear();
                for (ConfigCanvasTable table : this.sourceEndpoint.getAllTables(this.targetEndpoint.getGuid())) {
                    String catalog = (String)StringUtils.defaultIfBlank((CharSequence)table.getCatalog(), (CharSequence)this.sourceEndpoint.getDefaultCatalog());
                    String schema = (String)StringUtils.defaultIfBlank((CharSequence)table.getSchema(), (CharSequence)this.sourceEndpoint.getDefaultSchema());
                    if (!Strings.CS.equals(selectedSourceCatalog, catalog) || !Strings.CS.equals(selectedSourceSchema, schema)) continue;
                    boolean extractTransformExists = false;
                    for (ConfigCanvasTransformTable configCanvasTransformTable : this.allExtractTransformList) {
                        if (!Strings.CS.equals(table.getTargetCatalog(), configCanvasTransformTable.getTargetCatalogName()) || !Strings.CS.equals(table.getTargetSchema(), configCanvasTransformTable.getTargetSchemaName()) || !table.getName().equals(configCanvasTransformTable.getTargetTableName())) continue;
                        extractTransformExists = true;
                        break;
                    }
                    if (extractTransformExists) continue;
                    this.sourceTableList.add(table);
                }
            }
            String selectedTargetCatalog = this.sourceToTargetLayout.getSelectedCatalog(false);
            String selectedTargetSchema = this.sourceToTargetLayout.getSelectedSchema(false);
            String defaultTargetCatalog = this.targetEndpoint.getDefaultCatalog();
            String defaultTargetSchema = this.targetEndpoint.getDefaultSchema();
            if (refreshTargetTables) {
                this.targetTableList.clear();
                List<ConfigCanvasTable> cachedTables = this.targetEndpoint.getTablesFromCache(selectedTargetCatalog, selectedTargetSchema);
                if (cachedTables != null) {
                    this.targetTableList.addAll(cachedTables);
                } else {
                    List tableNames = this.targetEndpoint.getDatabasePlatform().getDdlReader().getTableNames(selectedTargetCatalog, selectedTargetSchema, new String[]{"TABLE"});
                    Collections.sort(tableNames, String.CASE_INSENSITIVE_ORDER);
                    String string = Strings.CS.equals(selectedTargetCatalog, this.targetEndpoint.getDefaultCatalog()) ? null : selectedTargetCatalog;
                    String schema = Strings.CS.equals(selectedTargetSchema, this.targetEndpoint.getDefaultSchema()) ? null : selectedTargetSchema;
                    columnName = tableNames.iterator();
                    while (columnName.hasNext()) {
                        String tableName = (String)columnName.next();
                        ConfigCanvasTable table = new ConfigCanvasTable(string, schema, tableName);
                        table.setSourceTableExists(true);
                        this.targetTableList.add(table);
                    }
                    this.targetEndpoint.cacheTables(selectedTargetCatalog, selectedTargetSchema, this.targetTableList);
                }
                for (ConfigCanvasTransformTable configCanvasTransformTable : this.transformSet) {
                    String transformTargetCatalog = (String)StringUtils.defaultIfBlank((CharSequence)configCanvasTransformTable.getTargetCatalogName(), (CharSequence)defaultTargetCatalog);
                    String transformTargetSchema = (String)StringUtils.defaultIfBlank((CharSequence)configCanvasTransformTable.getTargetSchemaName(), (CharSequence)defaultTargetSchema);
                    String transformTargetTableName = configCanvasTransformTable.getTargetTableName();
                    boolean foundTargetTable = false;
                    for (ConfigCanvasTable targetTable : this.targetTableList) {
                        String targetCatalog2 = (String)StringUtils.defaultIfBlank((CharSequence)targetTable.getTargetCatalog(), (CharSequence)defaultTargetCatalog);
                        String targetSchema2 = (String)StringUtils.defaultIfBlank((CharSequence)targetTable.getTargetSchema(), (CharSequence)defaultTargetSchema);
                        if (!Strings.CS.equals(transformTargetCatalog, targetCatalog2) || !Strings.CS.equals(transformTargetSchema, targetSchema2) || !targetTable.getName().equals(transformTargetTableName)) continue;
                        foundTargetTable = true;
                    }
                    if (foundTargetTable) continue;
                    ConfigCanvasTable targetTableFromTransform = new ConfigCanvasTable(configCanvasTransformTable.getTargetCatalogName(), configCanvasTransformTable.getTargetSchemaName(), transformTargetTableName);
                    targetTableFromTransform.setSourceTableExists(false);
                    this.targetTableList.add(targetTableFromTransform);
                }
            }
            this.diagram = new TransformDiagram(this, this.diagram != null ? this.diagram.getDetail() : null);
            this.viewableSourceTableNameSet.clear();
            this.viewableTargetTableNameSet.clear();
            this.filterTables(true);
            this.filterTables(false);
            TransformDiagramDetail diagramDetail = this.diagram.getDetail();
            Set<TransformDiagramDetail.TransformDiagramTable> diagramSourceTableSet = diagramDetail.getSourceTableSet();
            diagramSourceTableSet.clear();
            for (Object sourceTable : ListUtils.union(this.transformedTableList, this.sourceTableList)) {
                String sourceTableName = ((ConfigCanvasTable)sourceTable).getName();
                if (!this.viewableSourceTableNameSet.contains(sourceTableName)) continue;
                TransformDiagramDetail transformDiagramDetail = diagramDetail;
                Objects.requireNonNull(transformDiagramDetail);
                diagramSourceTableSet.add(transformDiagramDetail.new TransformDiagramDetail.TransformDiagramTable(sourceTableName, ((ConfigCanvasTable)sourceTable).getSourceTableExists()));
            }
            Set<TransformDiagramDetail.TransformDiagramTable> set = diagramDetail.getTargetTableSet();
            set.clear();
            for (ConfigCanvasTable targetTable : this.targetTableList) {
                String targetTableName = targetTable.getName();
                if (!this.viewableTargetTableNameSet.contains(targetTableName)) continue;
                HashSet<String> mappedColumnSet = new HashSet<String>();
                for (ConfigCanvasTransformTable transform : this.transformSet) {
                    String transformTargetCatalog = (String)StringUtils.defaultIfBlank((CharSequence)transform.getTargetCatalogName(), (CharSequence)defaultTargetCatalog);
                    String transformTargetSchema = (String)StringUtils.defaultIfBlank((CharSequence)transform.getTargetSchemaName(), (CharSequence)defaultTargetSchema);
                    if (!Strings.CS.equals(transformTargetCatalog, selectedTargetCatalog) || !Strings.CS.equals(transformTargetSchema, selectedTargetSchema) || !transform.getTargetTableName().equals(targetTable.getName())) continue;
                    mappedColumnSet.addAll(transform.getMappedColumnSet());
                }
                TransformDiagramDetail transformDiagramDetail = diagramDetail;
                Objects.requireNonNull(transformDiagramDetail);
                set.add(transformDiagramDetail.new TransformDiagramDetail.TransformDiagramTable(targetTableName, targetTable.getSourceTableExists(), mappedColumnSet.size()));
            }
            boolean deselectSourceTable = true;
            if (this.selectedSourceTable != null && this.viewableSourceTableNameSet.contains(this.selectedSourceTable.getName())) {
                String selectedSourceTableCatalog = (String)StringUtils.defaultIfBlank((CharSequence)this.selectedSourceTable.getCatalog(), (CharSequence)this.sourceEndpoint.getDefaultCatalog());
                String selectedSourceTableSchema = (String)StringUtils.defaultIfBlank((CharSequence)this.selectedSourceTable.getSchema(), (CharSequence)this.sourceEndpoint.getDefaultSchema());
                if (Strings.CS.equals(selectedSourceTableCatalog, selectedSourceCatalog) && Strings.CS.equals(selectedSourceTableSchema, selectedSourceSchema)) {
                    diagramDetail.setSelectedSourceTableName(this.selectedSourceTable.getName());
                    deselectSourceTable = false;
                }
            }
            if (deselectSourceTable) {
                this.selectedSourceTable = null;
                diagramDetail.setSelectedSourceTableName(null);
            }
            boolean deselectTargetTable = true;
            if (this.selectedTargetTable != null && this.viewableTargetTableNameSet.contains(this.selectedTargetTable.getName())) {
                String selectedTargetTableCatalog = (String)StringUtils.defaultIfBlank((CharSequence)this.selectedTargetTable.getCatalog(), (CharSequence)this.targetEndpoint.getDefaultCatalog());
                String selectedTargetTableSchema = (String)StringUtils.defaultIfBlank((CharSequence)this.selectedTargetTable.getSchema(), (CharSequence)this.targetEndpoint.getDefaultSchema());
                if (Strings.CS.equals(selectedTargetTableCatalog, selectedTargetCatalog) && Strings.CS.equals(selectedTargetTableSchema, selectedTargetSchema)) {
                    diagramDetail.setSelectedTargetTableName(this.selectedTargetTable.getName());
                    deselectTargetTable = false;
                }
            }
            if (deselectTargetTable) {
                this.selectedTargetTable = null;
                diagramDetail.setSelectedTargetTableName(null);
            }
            Map<String, Set<String>> linkMap = diagramDetail.getLinkMap();
            linkMap.clear();
            diagramDetail.setReadOnly(TransformDataScreen.this.readOnly);
            for (ConfigCanvasTransformTable transform : this.transformSet) {
                String sourceCatalog = (String)StringUtils.defaultIfBlank((CharSequence)transform.getOriginalSourceCatalogName(), (CharSequence)this.sourceEndpoint.getDefaultCatalog());
                String sourceSchema = (String)StringUtils.defaultIfBlank((CharSequence)transform.getOriginalSourceSchemaName(), (CharSequence)this.sourceEndpoint.getDefaultSchema());
                String sourceTableName = transform.getSourceTableName();
                targetCatalog = (String)StringUtils.defaultIfBlank((CharSequence)transform.getTargetCatalogName(), (CharSequence)this.targetEndpoint.getDefaultCatalog());
                targetSchema = (String)StringUtils.defaultIfBlank((CharSequence)transform.getTargetSchemaName(), (CharSequence)this.targetEndpoint.getDefaultSchema());
                String targetTableName = transform.getTargetTableName();
                if (!Strings.CS.equals(sourceCatalog, selectedSourceCatalog) || !Strings.CS.equals(sourceSchema, selectedSourceSchema) || !Strings.CS.equals(targetCatalog, selectedTargetCatalog) || !Strings.CS.equals(targetSchema, selectedTargetSchema) || !this.viewableTargetTableNameSet.contains(targetTableName)) continue;
                if (this.viewableSourceTableNameSet.contains(sourceTableName)) {
                    diagramDetail.addLink(sourceTableName, targetTableName);
                    continue;
                }
                if (!TransformPoint.LOAD.equals((Object)this.transformPoint) || !this.viewableSourceTableNameSet.contains(sourceTableName + " <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>")) continue;
                diagramDetail.addLink(sourceTableName + " <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>", targetTableName);
            }
            Map<String, String> autoLinkMap = diagramDetail.getAutoLinkMap();
            autoLinkMap.clear();
            for (ConfigCanvasTable table : ListUtils.union(this.transformedTableList, this.sourceTableList)) {
                String sourceTableName = table.getName();
                String targetTableName = Strings.CS.removeEnd(sourceTableName, (CharSequence)" <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>");
                targetCatalog = (String)StringUtils.defaultIfBlank((CharSequence)table.getTargetCatalog(), (CharSequence)defaultTargetCatalog);
                targetSchema = (String)StringUtils.defaultIfBlank((CharSequence)table.getTargetSchema(), (CharSequence)defaultTargetSchema);
                if (!this.viewableSourceTableNameSet.contains(sourceTableName) || !this.viewableTargetTableNameSet.contains(targetTableName) || !Strings.CS.equals(targetCatalog, selectedTargetCatalog) || !Strings.CS.equals(targetSchema, selectedTargetSchema) || linkMap.containsKey(sourceTableName)) continue;
                autoLinkMap.put(sourceTableName, targetTableName);
            }
            this.updateButtonsEnabled();
            this.diagramScroller.setContent((Component)this.diagram);
        }

        private void filterTables(boolean source) {
            List tableList = source ? ListUtils.union(this.transformedTableList, this.sourceTableList) : this.targetTableList;
            Set<String> filteredTableNameSet = source ? this.viewableSourceTableNameSet : this.viewableTargetTableNameSet;
            String visibility = (String)this.tableVisibilityGroup.getValue();
            boolean showAll = visibility.equals(TransformDataScreen.this.controller.getMessage("Show all", new Object[0]));
            boolean showMappedOnly = visibility.equals(TransformDataScreen.this.controller.getMessage("Show mapped only", new Object[0]));
            for (ConfigCanvasTable table : tableList) {
                String tableName = table.getName();
                if (Strings.CI.startsWith((CharSequence)tableName, (CharSequence)this.tablePrefix) || this.isFilteredOut(tableName, source) || source && TransformPoint.LOAD.equals((Object)this.transformPoint) && this.hasTableBeenTransformed(table) || !showAll && !(showMappedOnly ? this.countTransforms(table, source) > 0 : this.countTransforms(table, source) == 0)) continue;
                filteredTableNameSet.add(tableName);
            }
        }

        private boolean isFilteredOut(String tableName, boolean source) {
            String filter = this.sourceToTargetLayout.getFilter(source);
            String tableNameToFilter = tableName;
            if (TransformPoint.LOAD.equals((Object)this.transformPoint) && tableName.endsWith(" <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>")) {
                tableNameToFilter = tableName.substring(0, tableName.length() - " <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>".length());
            }
            return CommonUiUtils.isFilteredOut((String)tableNameToFilter, (String)filter);
        }

        private boolean hasTableBeenTransformed(ConfigCanvasTable table) {
            return this.allExtractTransformList.stream().anyMatch(t2 -> Strings.CS.equals(t2.getSourceCatalogName(), table.getTargetCatalog()) && Strings.CS.equals(t2.getSourceSchemaName(), table.getTargetSchema()) && t2.getSourceTableName().equals(table.getName()));
        }

        private int countTransforms(ConfigCanvasTable table, boolean source) {
            int transformCount = 0;
            if (this.isAutoMapped(table, source, true)) {
                if (source) {
                    return 1;
                }
                ++transformCount;
            }
            return transformCount += this.getTransformsForTable(table, source).size();
        }

        private boolean isAutoMapped(ConfigCanvasTable table, boolean source, boolean checkFilter) {
            String tableName = table.getName();
            if (!checkFilter) {
                Map<String, String> autoLinkMap = this.diagram.getDetail().getAutoLinkMap();
                return source ? autoLinkMap.containsKey(tableName) : autoLinkMap.containsValue(tableName);
            }
            String tableNameWithoutSuffix = Strings.CS.removeEnd(tableName, (CharSequence)" <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>");
            if (this.transformSet.stream().anyMatch(t2 -> tableNameWithoutSuffix.equals(t2.getSourceTableName()))) {
                return false;
            }
            String selectedTargetCatalog = this.sourceToTargetLayout.getSelectedCatalog(false);
            String selectedTargetSchema = this.sourceToTargetLayout.getSelectedSchema(false);
            String defaultTargetCatalog = this.targetEndpoint.getDefaultCatalog();
            String defaultTargetSchema = this.targetEndpoint.getDefaultSchema();
            if (source) {
                String targetCatalog = (String)StringUtils.defaultIfBlank((CharSequence)table.getTargetCatalog(), (CharSequence)defaultTargetCatalog);
                String targetSchema = (String)StringUtils.defaultIfBlank((CharSequence)table.getTargetSchema(), (CharSequence)defaultTargetSchema);
                if (!Strings.CS.equals(targetCatalog, selectedTargetCatalog) || !Strings.CS.equals(targetSchema, selectedTargetSchema) || this.targetTableList.stream().noneMatch(t2 -> tableNameWithoutSuffix.equals(t2.getName()))) {
                    return false;
                }
            } else {
                boolean foundSourceTable = false;
                for (ConfigCanvasTable sourceTable : ListUtils.union(this.transformedTableList, this.sourceTableList)) {
                    String sourceTableTargetCatalog = (String)StringUtils.defaultIfBlank((CharSequence)sourceTable.getTargetCatalog(), (CharSequence)defaultTargetCatalog);
                    String sourceTableTargetSchema = (String)StringUtils.defaultIfBlank((CharSequence)sourceTable.getTargetSchema(), (CharSequence)defaultTargetSchema);
                    String sourceTableName = sourceTable.getName();
                    if (!Strings.CS.equals(sourceTableTargetCatalog, selectedTargetCatalog) || !Strings.CS.equals(sourceTableTargetSchema, selectedTargetSchema) || !sourceTableName.equals(tableName) && !sourceTableName.equals(tableName + " <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>")) continue;
                    foundSourceTable = true;
                    break;
                }
                if (!foundSourceTable) {
                    return false;
                }
            }
            return !this.isFilteredOut(tableName, true) && !this.isFilteredOut(tableName, false);
        }

        private Set<ConfigCanvasTransformTable> getTransformsForTable(ConfigCanvasTable table, boolean source) {
            String tableSchema;
            String tableCatalog;
            if (source) {
                tableCatalog = Strings.CS.equals(table.getTargetCatalog(), this.targetEndpoint.getDefaultCatalog()) ? null : table.getTargetCatalog();
                tableSchema = Strings.CS.equals(table.getTargetSchema(), this.targetEndpoint.getDefaultSchema()) ? null : table.getTargetSchema();
            } else {
                tableCatalog = Strings.CS.equals(table.getCatalog(), this.targetEndpoint.getDefaultCatalog()) ? null : table.getCatalog();
                tableSchema = Strings.CS.equals(table.getSchema(), this.targetEndpoint.getDefaultSchema()) ? null : table.getSchema();
            }
            String tableName = table.getName();
            if (TransformPoint.LOAD.equals((Object)this.transformPoint) && tableName.contains(" <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>")) {
                tableName = tableName.replace(" <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>", "");
            }
            HashSet<ConfigCanvasTransformTable> transformsForTable = new HashSet<ConfigCanvasTransformTable>();
            for (ConfigCanvasTransformTable transform : this.transformSet) {
                String transformTableName;
                String transformSchema;
                String transformCatalog;
                if (source) {
                    transformCatalog = Strings.CS.equals(transform.getSourceCatalogName(), this.targetEndpoint.getDefaultCatalog()) ? null : transform.getSourceCatalogName();
                    transformSchema = Strings.CS.equals(transform.getSourceSchemaName(), this.targetEndpoint.getDefaultSchema()) ? null : transform.getSourceSchemaName();
                    transformTableName = transform.getSourceTableName();
                } else {
                    transformCatalog = Strings.CS.equals(transform.getTargetCatalogName(), this.targetEndpoint.getDefaultCatalog()) ? null : transform.getTargetCatalogName();
                    transformSchema = Strings.CS.equals(transform.getTargetSchemaName(), this.targetEndpoint.getDefaultSchema()) ? null : transform.getTargetSchemaName();
                    transformTableName = transform.getTargetTableName();
                }
                if (!Strings.CS.equals(tableCatalog, transformCatalog) || !Strings.CS.equals(tableSchema, transformSchema) || !tableName.equals(transformTableName) || this.isFilteredOut(source ? transform.getTargetTableName() : transform.getSourceTableName(), !source)) continue;
                transformsForTable.add(transform);
            }
            return transformsForTable;
        }

        private void updateButtonsEnabled() {
            if (this.selectedSourceTable != null && this.selectedTargetTable != null) {
                this.editButton.setEnabled(true);
                this.deleteButton.setEnabled(!TransformDataScreen.this.readOnly & !this.isAutoMapped(this.selectedSourceTable, true, false));
                this.mapColumnsButton.setEnabled(this.selectedSourceTable.getSourceTableExists() != false && this.selectedTargetTable.getSourceTableExists() != false);
            } else if (this.selectedSourceTable != null || this.selectedTargetTable != null) {
                boolean source = this.selectedSourceTable != null;
                ConfigCanvasTable selectedTable = source ? this.selectedSourceTable : this.selectedTargetTable;
                Set<ConfigCanvasTransformTable> transformsForTable = this.getTransformsForTable(selectedTable, source);
                int transformCount = transformsForTable.size();
                this.deleteButton.setEnabled(!TransformDataScreen.this.readOnly && transformCount > 0);
                boolean autoMapped = this.isAutoMapped(selectedTable, source, false);
                this.editButton.setEnabled((transformCount += autoMapped ? 1 : 0) == 1);
                if (transformCount == 1 && selectedTable.getSourceTableExists().booleanValue()) {
                    boolean otherTableExists = false;
                    ConfigCanvasTransformTable transform = transformsForTable.iterator().next();
                    String otherTableName = source ^ autoMapped ? transform.getTargetTableName() : transform.getSourceTableName();
                    for (TransformDiagramDetail.TransformDiagramTable table : source ? this.diagram.getDetail().getTargetTableSet() : this.diagram.getDetail().getSourceTableSet()) {
                        if (!table.getName().equals(otherTableName)) continue;
                        otherTableExists = table.isExists();
                        break;
                    }
                    this.mapColumnsButton.setEnabled(otherTableExists);
                } else {
                    this.mapColumnsButton.setEnabled(false);
                }
            } else {
                this.editButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
                this.mapColumnsButton.setEnabled(false);
            }
            if (this.editButton.isEnabled()) {
                this.editTooltip.setText(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "View the selected transform's details" : "Edit the selected transform's details", new Object[0]));
                if (this.mapColumnsButton.isEnabled()) {
                    this.mapColumnsTooltip.setText(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "View the selected transform's columns" : "Map the selected transform's columns", new Object[0]));
                } else {
                    this.mapColumnsTooltip.setText(TransformDataScreen.this.controller.getMessage("The source or target table is missing from the database", new Object[0]));
                }
            } else {
                this.editTooltip.setText(TransformDataScreen.this.controller.getMessage("Select exactly 1 transform first", new Object[0]));
                this.mapColumnsTooltip.setText(TransformDataScreen.this.controller.getMessage("Select exactly 1 transform first", new Object[0]));
            }
            if (this.deleteButton.isEnabled()) {
                this.deleteTooltip.setText(TransformDataScreen.this.controller.getMessage("Delete the selected transform(s) (excluding auto mappings)", new Object[0]));
            } else {
                this.deleteTooltip.setText(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "Requires write permission" : "Select 1 or more transforms first", new Object[0]));
            }
        }

        private void refreshSchemas(boolean source) {
            Select<String> schemaSelect = this.sourceToTargetLayout.getSchemaSelect(source);
            String oldValue = (String)schemaSelect.getValue();
            List<String> schemaList = this.getSchemas(source);
            Collections.sort(schemaList, String.CASE_INSENSITIVE_ORDER);
            schemaSelect.setItems(schemaList);
            if (schemaList.size() == 0) {
                schemaSelect.setVisible(false);
            } else {
                schemaSelect.setVisible(true);
                schemaSelect.setValue((Object)(schemaList.contains(oldValue) ? oldValue : (source ? schemaList.get(0) : null)));
            }
        }

        private List<String> getSchemas(boolean source) {
            String selectedCatalog = this.sourceToTargetLayout.getSelectedCatalog(source);
            List<String> schemas = null;
            if (source) {
                schemas = new ArrayList();
                for (ConfigCanvasTable table : this.sourceEndpoint.getAllTables(this.targetEndpoint.getGuid())) {
                    String catalog = (String)StringUtils.defaultIfBlank((CharSequence)table.getCatalog(), (CharSequence)this.sourceEndpoint.getDefaultCatalog());
                    String schema = (String)StringUtils.defaultIfBlank((CharSequence)table.getSchema(), (CharSequence)this.sourceEndpoint.getDefaultSchema());
                    if (schemas.contains(schema) || !Strings.CS.equals(selectedCatalog, catalog)) continue;
                    schemas.add(schema);
                }
            } else {
                try {
                    schemas = this.targetEndpoint.getDatabasePlatform().getDdlReader().getSchemaNames(selectedCatalog);
                }
                catch (Exception e2) {
                    this.log.debug("Unable to get schemas for catalog " + selectedCatalog, (Throwable)e2);
                }
                if (schemas == null) {
                    schemas = new ArrayList();
                }
            }
            schemas.removeIf(Objects::isNull);
            return schemas;
        }

        private void refreshSourceCatalogs() {
            List<String> catalogList = this.getCatalogs(true);
            Collections.sort(catalogList, String.CASE_INSENSITIVE_ORDER);
            Select<String> sourceCatalogSelect = this.sourceToTargetLayout.getCatalogSelect(true);
            sourceCatalogSelect.setItems(catalogList);
            if (catalogList.size() == 0) {
                sourceCatalogSelect.setVisible(false);
            } else {
                sourceCatalogSelect.setVisible(true);
                String catalog = null;
                if (!this.transformSet.isEmpty()) {
                    catalog = this.transformSet.iterator().next().getOriginalSourceCatalogName();
                }
                sourceCatalogSelect.setValue(catalog != null ? catalog : catalogList.get(0));
            }
        }

        private List<String> getCatalogs(boolean source) {
            List<String> catalogs = new ArrayList();
            if (source) {
                for (ConfigCanvasTable table : this.sourceEndpoint.getAllTables(this.targetEndpoint.getGuid())) {
                    String catalog = (String)StringUtils.defaultIfBlank((CharSequence)table.getCatalog(), (CharSequence)this.sourceEndpoint.getDefaultCatalog());
                    if (catalogs.contains(catalog)) continue;
                    catalogs.add(catalog);
                }
                catalogs.removeIf(Objects::isNull);
            } else {
                catalogs = (source ? this.sourceEndpoint : this.targetEndpoint).getDatabasePlatform().getDdlReader().getCatalogNames();
                if (catalogs != null) {
                    catalogs.removeIf(Objects::isNull);
                } else {
                    catalogs = new ArrayList();
                }
            }
            return catalogs;
        }

        private Set<ConfigCanvasTransformTable> getSelectedTransforms() {
            String fullyQualifiedSourceTableName = null;
            if (this.selectedSourceTable != null) {
                fullyQualifiedSourceTableName = this.selectedSourceTable.getFullyQualifiedTargetTableName();
                if (TransformPoint.LOAD.equals((Object)this.transformPoint) && fullyQualifiedSourceTableName.contains(" <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>")) {
                    fullyQualifiedSourceTableName = fullyQualifiedSourceTableName.replace(" <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>", "");
                }
            }
            String fullyQualifiedTargetTableName = null;
            if (this.selectedTargetTable != null) {
                fullyQualifiedTargetTableName = Table.getFullyQualifiedTableName((String)this.sourceToTargetLayout.getSelectedCatalog(false), (String)this.sourceToTargetLayout.getSelectedSchema(false), (String)this.selectedTargetTable.getName());
            }
            HashSet<ConfigCanvasTransformTable> selectedTransformSet = new HashSet<ConfigCanvasTransformTable>();
            for (ConfigCanvasTransformTable transform : this.transformSet) {
                String sourceTableName = transform.getSourceTableName();
                String transformTargetCatalog = (String)StringUtils.defaultIfBlank((CharSequence)transform.getTargetCatalogName(), (CharSequence)this.targetEndpoint.getDefaultCatalog());
                String transformTargetSchema = (String)StringUtils.defaultIfBlank((CharSequence)transform.getTargetSchemaName(), (CharSequence)this.targetEndpoint.getDefaultSchema());
                String transformFullyQualifiedTargetTableName = Table.getFullyQualifiedTableName((String)transformTargetCatalog, (String)transformTargetSchema, (String)transform.getTargetTableName());
                if (this.selectedSourceTable != null && this.selectedTargetTable != null) {
                    if (!fullyQualifiedSourceTableName.equals(transform.getFullyQualifiedSourceTableName()) || !fullyQualifiedTargetTableName.equals(transformFullyQualifiedTargetTableName)) continue;
                    selectedTransformSet.add(transform);
                    continue;
                }
                if (this.selectedSourceTable != null) {
                    if (!fullyQualifiedSourceTableName.equals(transform.getFullyQualifiedSourceTableName()) || !this.viewableTargetTableNameSet.contains(transform.getTargetTableName())) continue;
                    selectedTransformSet.add(transform);
                    continue;
                }
                if (!fullyQualifiedTargetTableName.equals(transformFullyQualifiedTargetTableName) || !this.viewableSourceTableNameSet.contains(sourceTableName) && (!TransformPoint.LOAD.equals((Object)this.transformPoint) || !this.viewableSourceTableNameSet.contains(sourceTableName + " <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>"))) continue;
                selectedTransformSet.add(transform);
            }
            return selectedTransformSet;
        }

        private void editSelection() {
            Set<ConfigCanvasTransformTable> selectedTransformSet = this.getSelectedTransforms();
            new TransformDetailsDialog(selectedTransformSet.isEmpty() ? this.createSelectedAutoMappedTransform() : selectedTransformSet.iterator().next()).open();
        }

        private void mapColumnsForSelection() {
            ConfigCanvasTransformTable transform;
            Set<ConfigCanvasTransformTable> selectedTransformSet = this.getSelectedTransforms();
            if (selectedTransformSet.isEmpty()) {
                transform = this.createSelectedAutoMappedTransform();
                this.populateColumnNames(transform);
            } else {
                transform = selectedTransformSet.iterator().next();
            }
            TransformDataScreen.this.transformColumnsDialog = new TransformColumnsDialog(transform, this.sourceEndpoint, this.targetEndpoint);
            TransformDataScreen.this.transformColumnsDialog.open();
        }

        private void deleteSelection() {
            this.transformSet.removeAll(this.getSelectedTransforms());
            this.selectionEvent(null, null);
            this.refreshDiagram(false, false);
        }

        public void selectionEvent(String sourceTableName, String targetTableName) {
            if (sourceTableName != null) {
                boolean isSourceTableTransformed = TransformPoint.LOAD.equals((Object)this.transformPoint) && sourceTableName.endsWith(" <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>");
                String sourceCatalog = this.sourceToTargetLayout.getSelectedCatalog(true);
                String sourceSchema = this.sourceToTargetLayout.getSelectedSchema(true);
                for (ConfigCanvasTable sourceTable : isSourceTableTransformed ? this.transformedTableList : this.sourceTableList) {
                    String catalog = (String)StringUtils.defaultIfBlank((CharSequence)sourceTable.getCatalog(), (CharSequence)this.sourceEndpoint.getDefaultCatalog());
                    String schema = (String)StringUtils.defaultIfBlank((CharSequence)sourceTable.getSchema(), (CharSequence)this.sourceEndpoint.getDefaultSchema());
                    if (!Strings.CS.equals(catalog, sourceCatalog) || !Strings.CS.equals(schema, sourceSchema) || !sourceTable.getName().equals(sourceTableName)) continue;
                    this.selectedSourceTable = sourceTable;
                    break;
                }
            } else {
                this.selectedSourceTable = null;
            }
            if (targetTableName != null) {
                String targetCatalog = this.sourceToTargetLayout.getSelectedCatalog(false);
                String targetSchema = this.sourceToTargetLayout.getSelectedSchema(false);
                for (ConfigCanvasTable targetTable : this.targetTableList) {
                    String catalog = (String)StringUtils.defaultIfBlank((CharSequence)targetTable.getCatalog(), (CharSequence)this.targetEndpoint.getDefaultCatalog());
                    String schema = (String)StringUtils.defaultIfBlank((CharSequence)targetTable.getSchema(), (CharSequence)this.targetEndpoint.getDefaultSchema());
                    if (!Strings.CS.equals(catalog, targetCatalog) || !Strings.CS.equals(schema, targetSchema) || !targetTable.getName().equals(targetTableName)) continue;
                    this.selectedTargetTable = targetTable;
                    break;
                }
            } else {
                this.selectedTargetTable = null;
            }
            this.updateButtonsEnabled();
        }

        public void linkCreatedEvent(String sourceTableName, String targetTableName) {
            ConfigCanvasTransformTable transform = this.createTransform(sourceTableName, targetTableName);
            this.populateColumnNames(transform);
            this.transformSet.add(transform);
            this.selectionEvent(null, null);
            this.refreshDiagram(false, false);
        }

        private ConfigCanvasTransformTable createSelectedAutoMappedTransform() {
            String targetTableName;
            String sourceTableName;
            if (this.selectedSourceTable != null) {
                sourceTableName = this.selectedSourceTable.getName();
                targetTableName = Strings.CS.removeEnd(sourceTableName, (CharSequence)" <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>");
            } else {
                targetTableName = sourceTableName = this.selectedTargetTable.getName();
                for (Map.Entry<String, String> autoLinkEntry : this.diagram.getDetail().getAutoLinkMap().entrySet()) {
                    if (!targetTableName.equals(autoLinkEntry.getValue())) continue;
                    sourceTableName = autoLinkEntry.getKey();
                    break;
                }
            }
            return this.createTransform(sourceTableName, targetTableName);
        }

        private ConfigCanvasTransformTable createTransform(String sourceTableName, String targetTableName) {
            boolean isSourceTableTransformed = false;
            ConfigCanvasTransformTable transform = new ConfigCanvasTransformTable(sourceTableName, targetTableName, this.transformPoint);
            if (TransformPoint.LOAD.equals((Object)this.transformPoint) && sourceTableName.endsWith(" <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>")) {
                isSourceTableTransformed = true;
                transform.setSourceTableName(sourceTableName.substring(0, sourceTableName.length() - " <span style=\"color: var(--lumo-primary-color-50pct);\">(transformed)</span>".length()));
            }
            String sourceCatalog = Strings.CS.equals(this.sourceToTargetLayout.getSelectedCatalog(true), this.sourceEndpoint.getDefaultCatalog()) ? null : this.sourceToTargetLayout.getSelectedCatalog(true);
            String sourceSchema = Strings.CS.equals(this.sourceToTargetLayout.getSelectedSchema(true), this.sourceEndpoint.getDefaultSchema()) ? null : this.sourceToTargetLayout.getSelectedSchema(true);
            String targetCatalog = Strings.CS.equals(this.sourceToTargetLayout.getSelectedCatalog(false), this.targetEndpoint.getDefaultCatalog()) ? null : this.sourceToTargetLayout.getSelectedCatalog(false);
            String targetSchema = Strings.CS.equals(this.sourceToTargetLayout.getSelectedSchema(false), this.targetEndpoint.getDefaultSchema()) ? null : this.sourceToTargetLayout.getSelectedSchema(false);
            transform.setOriginalSourceCatalogName(sourceCatalog);
            transform.setOriginalSourceSchemaName(sourceSchema);
            transform.setTargetCatalogName(targetCatalog);
            transform.setTargetSchemaName(targetSchema);
            for (ConfigCanvasTable sourceTable : isSourceTableTransformed ? this.transformedTableList : this.sourceTableList) {
                String schema;
                String catalog = Strings.CS.equals(sourceTable.getCatalog(), this.sourceEndpoint.getDefaultCatalog()) ? null : sourceTable.getCatalog();
                String string = schema = Strings.CS.equals(sourceTable.getSchema(), this.sourceEndpoint.getDefaultSchema()) ? null : sourceTable.getSchema();
                if (!Strings.CS.equals(catalog, sourceCatalog) || !Strings.CS.equals(schema, sourceSchema) || !sourceTable.getName().equals(sourceTableName)) continue;
                sourceCatalog = sourceTable.getTargetCatalog();
                sourceSchema = sourceTable.getTargetSchema();
                if (!isSourceTableTransformed && sourceTable.getColumnCount() == 0) {
                    Table dbTable = this.sourceEndpoint.getDatabasePlatform().getDdlReader().readTable(sourceTable.getCatalog(), sourceTable.getSchema(), sourceTable.getName());
                    sourceTable.addColumns(dbTable.getColumnsAsList());
                }
                transform.getSourceColumnNames().addAll(sourceTable.getColumnNames());
                transform.getSourcePrimaryKeyColumnNames().addAll(sourceTable.getPrimaryKeyColumnNames());
                break;
            }
            transform.setSourceCatalogName(sourceCatalog);
            transform.setSourceSchemaName(sourceSchema);
            transform.setId(transform.generateDefaultId());
            return transform;
        }

        public void editEvent(String sourceTable, String targetTable) {
            this.selectionEvent(sourceTable, targetTable);
            this.editSelection();
            this.refreshDiagram(false, false);
        }

        public void mapColumnsEvent(String sourceTable, String targetTable) {
            this.selectionEvent(sourceTable, targetTable);
            this.mapColumnsForSelection();
            this.refreshDiagram(false, false);
        }

        public void deleteEvent(String sourceTable, String targetTable) {
            this.selectionEvent(sourceTable, targetTable);
            this.deleteSelection();
        }

        public Set<ConfigCanvasTransformTable> getTransformSet() {
            return this.transformSet;
        }
    }

    public class TransformColumnsDialog
    extends X {
        private static final long serialVersionUID = 1L;
        private final String EMPTY = "diagram | empty";
        private final String REMOVE = "diagram | remove";
        private final String REMOVE_SUFFIX = " remove";
        private Set<String> targetColumnSet;
        private Set<String> addedColumnSet;
        private Set<String> viewableSourceColumnSet;
        private Set<String> viewableTargetColumnSet;
        private Set<String> missingSourceColumnSet;
        private Set<ConfigCanvasTransformTable.ConfigCanvasTransformColumn> transformColumnSet;
        private ConfigCanvasTransformTable transform;
        private ConfigCanvasSourceToTargetLayout sourceToTargetLayout;
        private Scroller diagramScroller;
        private TransformColumnsDiagram diagram;
        private RadioButtonGroup<String> columnVisibilityGroup;
        private ad columnVisibilityDiv;
        private Button editButton;
        private Div editDiv;
        private Tooltip editTooltip;
        private Button deleteButton;
        private Div deleteDiv;
        private Tooltip deleteTooltip;
        private Button addButton;
        private ad diagramActionDiv;
        private ad legendDiv;
        private String selectedSourceColumn;
        private String selectedTargetColumn;
        private ColumnPolicy columnPolicy;
        private Tooltip switchTooltip;

        public TransformColumnsDialog(ConfigCanvasTransformTable transform, ConfigCanvasEndpoint sourceEndpoint, ConfigCanvasEndpoint targetDatabase) {
            super(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "View Columns for '%s to %s' Transform" : "Edit Columns for '%s to %s' Transform", transform.getSourceTableName(), transform.getTargetTableName()), TransformDataScreen.this.controller.getContextPath(), VaadinIcon.CHART_3D, TransformDataScreen.this.readOnly ? null : TransformDataScreen.this.controller.getMessage("Close the dialog without saving any transforms", new Object[0]));
            this.EMPTY = "diagram | empty";
            this.REMOVE = "diagram | remove";
            this.REMOVE_SUFFIX = " remove";
            this.targetColumnSet = new TreeSet<String>((c0, c1) -> Strings.CI.compare(c0, c1));
            this.addedColumnSet = new HashSet<String>();
            this.viewableSourceColumnSet = new TreeSet<String>((c0, c1) -> Strings.CI.compare(c0, c1));
            this.viewableTargetColumnSet = new TreeSet<String>((c0, c1) -> Strings.CI.compare(c0, c1));
            this.missingSourceColumnSet = new HashSet<String>();
            this.transformColumnSet = new HashSet<ConfigCanvasTransformTable.ConfigCanvasTransformColumn>();
            this.transform = transform;
            this.addedColumnSet.addAll(transform.getAddedColumnNames());
            this.transformColumnSet.addAll(transform.getTransformColumns());
            for (ConfigCanvasTransformTable.ConfigCanvasTransformColumn transformColumn : transform.getTransformColumns()) {
                String sourceColumnName = transformColumn.getSourceColumnName();
                if (transform.getSourceColumnNames().contains(sourceColumnName)) continue;
                this.missingSourceColumnSet.add(sourceColumnName);
            }
            this.setSizeFull();
            this.setCloseOnOutsideClick(false);
            this.addClassNames(new String[]{"second-layer", "base-color-footer"});
            this.sourceToTargetLayout = new ConfigCanvasSourceToTargetLayout(TransformDataScreen.this.controller, sourceEndpoint, targetDatabase, transform.getSourceTableName(), transform.getTargetTableName(), false, false, false){
                private static final long serialVersionUID = 1L;

                @Override
                protected void initFilterField(boolean source, TextField filterField, HorizontalLayout filterLayout) {
                    filterField.setPlaceholder(this.controller.getMessage("Filter Columns", new Object[0]));
                    filterField.setValueChangeTimeout(500);
                    filterField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> TransformColumnsDialog.this.refreshDiagram());
                }
            };
            this.sourceToTargetLayout.init();
            Div sizingDiv = new Div();
            sizingDiv.setHeight("8000px");
            sizingDiv.setWidthFull();
            this.diagramScroller = new Scroller((Component)sizingDiv);
            this.diagramScroller.setSizeFull();
            this.diagramScroller.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
            this.columnVisibilityGroup = new RadioButtonGroup();
            this.columnVisibilityGroup.setItems((Object[])new String[]{TransformDataScreen.this.controller.getMessage("Show all", new Object[0]), TransformDataScreen.this.controller.getMessage("Show mapped only", new Object[0]), TransformDataScreen.this.controller.getMessage("Show unmapped only", new Object[0])});
            this.columnVisibilityGroup.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
            this.columnVisibilityGroup.setValue((Object)TransformDataScreen.this.controller.getMessage("Show all", new Object[0]));
            this.columnVisibilityGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.refreshDiagram());
            this.columnVisibilityDiv = new ad();
            this.columnVisibilityDiv.setHeight("98px");
            this.columnVisibilityDiv.setWidth("200px");
            this.columnVisibilityDiv.setTop("243px");
            this.columnVisibilityDiv.setLeft(TransformDataScreen.this.canvas.getWindowWidth() - 270 + "px");
            this.columnVisibilityDiv.getStyle().set("z-index", "300");
            this.columnVisibilityDiv.add(new Component[]{this.columnVisibilityGroup});
            this.editButton = TransformDataScreen.this.createButton(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "View Details" : "Edit", new Object[0]), VaadinIcon.EDIT, (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> this.editSelection());
            this.editDiv = new Div(new Component[]{this.editButton});
            this.editDiv.getStyle().set("margin", "4px 0 0 12px");
            this.editTooltip = Tooltip.forComponent((Component)this.editDiv).withPosition(Tooltip.TooltipPosition.START).withText(TransformDataScreen.this.controller.getMessage("Select exactly 1 transform first (excluding remove transforms)", new Object[0]));
            this.deleteButton = TransformDataScreen.this.createButton(TransformDataScreen.this.controller.getMessage("Delete", new Object[0]), VaadinIcon.TRASH, (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> this.deleteSelection());
            this.deleteDiv = new Div(new Component[]{this.deleteButton});
            this.deleteDiv.getStyle().set("margin", "4px 0 0 12px");
            this.deleteTooltip = Tooltip.forComponent((Component)this.deleteDiv).withPosition(Tooltip.TooltipPosition.START).withText(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "Requires write permission" : "Select 1 or more transforms or an added column first", new Object[0]));
            this.addButton = TransformDataScreen.this.createButton(TransformDataScreen.this.controller.getMessage("Add Target Column", new Object[0]), VaadinIcon.PLUS, (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> this.addTargetColumnEvent());
            this.addButton.getStyle().set("margin", "4px 0 0 12px");
            this.addButton.setEnabled(!TransformDataScreen.this.readOnly);
            this.columnPolicy = transform.getColumnPolicy();
            Button switchButton = TransformDataScreen.this.createButton(TransformDataScreen.this.controller.getMessage(ColumnPolicy.IMPLIED.equals((Object)this.columnPolicy) ? "Switch to Specified" : "Switch to Implied", new Object[0]), VaadinIcon.RANDOM, (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
                if (ColumnPolicy.IMPLIED.equals((Object)this.columnPolicy)) {
                    ((Button)event.getSource()).setText(TransformDataScreen.this.controller.getMessage("Switch to Implied", new Object[0]));
                    this.switchTooltip.setText(TransformDataScreen.this.controller.getMessage("Automatically map columns with matching names", new Object[0]));
                    this.columnPolicy = ColumnPolicy.SPECIFIED;
                } else {
                    ((Button)event.getSource()).setText(TransformDataScreen.this.controller.getMessage("Switch to Specified", new Object[0]));
                    this.switchTooltip.setText(TransformDataScreen.this.controller.getMessage("Remove the automatic column mappings", new Object[0]));
                    this.columnPolicy = ColumnPolicy.IMPLIED;
                }
                this.refreshDiagram();
            });
            switchButton.getStyle().set("margin", "4px 0 0 12px");
            switchButton.setEnabled(!TransformDataScreen.this.readOnly);
            this.switchTooltip = Tooltip.forComponent((Component)switchButton).withPosition(Tooltip.TooltipPosition.START).withText(TransformDataScreen.this.controller.getMessage(ColumnPolicy.IMPLIED.equals((Object)this.columnPolicy) ? "Remove the automatic column mappings" : "Automatically map columns with matching names", new Object[0]));
            VerticalLayout diagramActionLayout = new VerticalLayout(new Component[]{this.editDiv, this.deleteDiv, this.addButton, switchButton});
            diagramActionLayout.setMargin(false);
            diagramActionLayout.setPadding(false);
            diagramActionLayout.setSpacing(false);
            this.diagramActionDiv = new ad();
            this.diagramActionDiv.setHeight("124px");
            this.diagramActionDiv.setWidth("186px");
            this.diagramActionDiv.setTop("353px");
            this.diagramActionDiv.setLeft(TransformDataScreen.this.canvas.getWindowWidth() - 256 + "px");
            this.diagramActionDiv.getStyle().set("z-index", "300");
            this.diagramActionDiv.add(new Component[]{diagramActionLayout});
            this.legendDiv = TransformDataScreen.this.createLegend("Transform Column Policy", "Implied", "Specified");
            this.legendDiv.setTop(TransformDataScreen.this.canvas.getWindowHeight() - 269 + "px");
            Div diagramPaddingDiv = new Div(new Component[]{this.diagramScroller, this.columnVisibilityDiv, this.diagramActionDiv, this.legendDiv});
            diagramPaddingDiv.setHeight("0");
            diagramPaddingDiv.setWidthFull();
            diagramPaddingDiv.getStyle().set("padding", "0 8px 8px 8px");
            this.mainLayout.add(new Component[]{this.sourceToTargetLayout, diagramPaddingDiv});
            this.mainLayout.setPadding(false);
            this.mainLayout.setSpacing(false);
            this.mainLayout.expand(new Component[]{diagramPaddingDiv});
            Anchor helpAnchor = TransformDataScreen.this.canvas.createHelpAnchor(TransformDataScreen.this.getDocAnchor());
            helpAnchor.getStyle().set("margin-right", "auto");
            if (TransformDataScreen.this.readOnly) {
                this.getFooter().add(new Component[]{helpAnchor, new Button(TransformDataScreen.this.controller.getMessage("Close", new Object[0]), (ComponentEventListener & Serializable)event -> this.close())});
            } else {
                Button cancelButton = new Button(TransformDataScreen.this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
                cancelButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
                cancelButton.getStyle().set("margin-right", "10px");
                cancelButton.setTooltipText(TransformDataScreen.this.controller.getMessage("Close the dialog without saving any transforms", new Object[0]));
                Button saveButton = as.createPrimaryButton(TransformDataScreen.this.controller.getMessage("Save", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
                    transform.setTransformColumns(new ArrayList<ConfigCanvasTransformTable.ConfigCanvasTransformColumn>(this.transformColumnSet));
                    transform.getTargetColumnNames().clear();
                    transform.getTargetColumnNames().addAll(this.targetColumnSet);
                    transform.getAddedColumnNames().clear();
                    transform.getAddedColumnNames().addAll(this.addedColumnSet);
                    transform.setColumnPolicy(this.columnPolicy);
                    TransformDataScreen.this.transformDialog.getTransformSet().add(transform);
                    TransformDataScreen.this.transformDialog.refreshDiagram(false, false);
                    this.close();
                });
                saveButton.setTooltipText(TransformDataScreen.this.controller.getMessage("Save the transform(s) and close the dialog", new Object[0]));
                this.getFooter().add(new Component[]{helpAnchor, cancelButton, saveButton});
            }
            this.targetColumnSet.addAll(transform.getTargetColumnNames());
            for (ConfigCanvasTransformTable.ConfigCanvasTransformColumn transformColumn : this.transformColumnSet) {
                String targetColumn = transformColumn.getTargetColumnName();
                if (this.targetColumnSet.contains(targetColumn) || targetColumn.endsWith(" remove")) continue;
                this.targetColumnSet.add(targetColumn);
            }
            this.refreshDiagram();
        }

        public void updateDivPosition(int windowHeight, int windowWidth) {
            this.columnVisibilityDiv.setLeft(windowWidth - 270 + "px");
            this.diagramActionDiv.setLeft(windowWidth - 256 + "px");
            this.legendDiv.setTop(windowHeight - 269 + "px");
            this.legendDiv.setLeft(windowWidth - 330 + "px");
            this.refreshDiagram();
        }

        public void refreshDiagram() {
            this.diagram = new TransformColumnsDiagram(this, this.diagram != null ? this.diagram.getDetail() : null);
            this.viewableSourceColumnSet.clear();
            this.viewableTargetColumnSet.clear();
            this.filterColumns(true);
            this.filterColumns(false);
            TransformColumnsDiagramDetail diagramDetail = this.diagram.getDetail();
            diagramDetail.setSourceColumnSet(this.viewableSourceColumnSet);
            diagramDetail.setTargetColumnSet(this.viewableTargetColumnSet);
            if (this.selectedSourceColumn != null && this.viewableSourceColumnSet.contains(this.selectedSourceColumn)) {
                diagramDetail.setSelectedSourceColumn(this.selectedSourceColumn);
            } else {
                this.selectedSourceColumn = null;
                diagramDetail.setSelectedSourceColumn(null);
            }
            if (this.selectedTargetColumn != null && this.viewableTargetColumnSet.contains(this.selectedTargetColumn)) {
                diagramDetail.setSelectedTargetColumn(this.selectedTargetColumn);
            } else {
                this.selectedTargetColumn = null;
                diagramDetail.setSelectedTargetColumn(null);
            }
            this.updateButtonsEnabled();
            diagramDetail.getTransformColumnSet().clear();
            for (ConfigCanvasTransformTable.ConfigCanvasTransformColumn transformColumn : this.transformColumnSet) {
                String sourceColumn = transformColumn.getSourceColumnName();
                String targetColumn = transformColumn.getTargetColumnName();
                if (sourceColumn != null && !this.viewableSourceColumnSet.contains(sourceColumn) && !this.missingSourceColumnSet.contains(sourceColumn)) continue;
                if (sourceColumn != null && this.missingSourceColumnSet.contains(sourceColumn)) {
                    sourceColumn = null;
                }
                if (this.viewableTargetColumnSet.contains(targetColumn)) {
                    diagramDetail.addTransformColumn(sourceColumn, targetColumn, transformColumn.getTransformType(), transformColumn.isPrimaryKey(), transformColumn.getIncludeOn());
                    continue;
                }
                if (!"remove".equals(transformColumn.getTransformType()) || !targetColumn.endsWith(" remove") || !this.viewableTargetColumnSet.contains(targetColumn = targetColumn.substring(0, targetColumn.length() - " remove".length()))) continue;
                diagramDetail.addTransformColumn(sourceColumn, targetColumn, "remove", transformColumn.isPrimaryKey(), transformColumn.getIncludeOn());
            }
            diagramDetail.setSourcePkSet(this.transform.getSourcePrimaryKeyColumnNames());
            diagramDetail.setTargetPkSet(this.transform.getTargetPrimaryKeyColumnNames());
            diagramDetail.setAutoMap(ColumnPolicy.IMPLIED.equals((Object)this.columnPolicy));
            diagramDetail.setReadOnly(TransformDataScreen.this.readOnly);
            this.diagramScroller.setContent((Component)this.diagram);
        }

        private void filterColumns(boolean source) {
            Set<String> columnSet = source ? this.transform.getSourceColumnNames() : this.targetColumnSet;
            Set<String> filteredColumnSet = source ? this.viewableSourceColumnSet : this.viewableTargetColumnSet;
            String visibility = (String)this.columnVisibilityGroup.getValue();
            boolean showAll = visibility.equals(TransformDataScreen.this.controller.getMessage("Show all", new Object[0]));
            boolean showMappedOnly = visibility.equals(TransformDataScreen.this.controller.getMessage("Show mapped only", new Object[0]));
            for (String column : columnSet) {
                if (this.isFilteredOut(column, source) || !showAll && !(showMappedOnly ? this.countConnections(column, source, true, false) > 0 : this.countConnections(column, source, true, false) == 0)) continue;
                filteredColumnSet.add(column);
            }
        }

        private boolean isFilteredOut(String column, boolean source) {
            if ("diagram | empty".equals(column) || "diagram | remove".equals(column)) {
                return false;
            }
            return CommonUiUtils.isFilteredOut((String)column, (String)this.sourceToTargetLayout.getFilter(source));
        }

        private int countConnections(String column, boolean source, boolean checkFilter, boolean includeRemove) {
            if (this.isAutoMapped(column, checkFilter)) {
                return 1;
            }
            HashSet<CallSite> connectionSet = new HashSet<CallSite>();
            for (ConfigCanvasTransformTable.ConfigCanvasTransformColumn transformColumn : this.transformColumnSet) {
                String sourceColumn = transformColumn.getSourceColumnName() != null ? transformColumn.getSourceColumnName() : "diagram | empty";
                String targetColumn = transformColumn.getTargetColumnName();
                if (!(column.equals("diagram | remove") ? Strings.CS.equals(sourceColumn + " remove", targetColumn) && !this.isFilteredOut(sourceColumn, source) : (includeRemove || !"remove".equals(transformColumn.getTransformType())) && Strings.CS.equals(source ? sourceColumn : targetColumn, column) && !this.isFilteredOut(source ? targetColumn : sourceColumn, !source))) continue;
                connectionSet.add((CallSite)((Object)(sourceColumn + " -> " + targetColumn)));
            }
            return connectionSet.size();
        }

        private boolean isAutoMapped(String column, boolean checkFilter) {
            return ColumnPolicy.IMPLIED.equals((Object)this.columnPolicy) && column != null && (checkFilter ? this.transform.getSourceColumnNames().contains(column) && this.targetColumnSet.contains(column) && !this.isFilteredOut(column, true) && !this.isFilteredOut(column, true) : this.viewableSourceColumnSet.contains(column) && this.viewableTargetColumnSet.contains(column)) && this.transformColumnSet.stream().noneMatch(tc -> column.equals(tc.getSourceColumnName()) || column.equals(tc.getTargetColumnName()));
        }

        private void updateButtonsEnabled() {
            if (this.selectedSourceColumn != null && this.selectedTargetColumn != null) {
                this.editButton.setEnabled(!this.selectedSourceColumn.equals("diagram | remove") && !this.selectedTargetColumn.equals("diagram | remove"));
                this.deleteButton.setEnabled(!TransformDataScreen.this.readOnly);
            } else if (this.selectedSourceColumn != null || this.selectedTargetColumn != null) {
                boolean source = this.selectedSourceColumn != null;
                String selectedColumn = source ? this.selectedSourceColumn : this.selectedTargetColumn;
                int transformCount = this.countConnections(selectedColumn, source, false, true);
                this.editButton.setEnabled(transformCount == 1 && !this.isRemoved(selectedColumn, source));
                this.deleteButton.setEnabled(!TransformDataScreen.this.readOnly && (transformCount > 0 || !source && this.addedColumnSet.contains(selectedColumn)));
            } else {
                this.editButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
            }
            if (this.editButton.isEnabled()) {
                this.editTooltip.setText(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "View the selected transform's details" : "Edit the selected transform's details", new Object[0]));
            } else {
                this.editTooltip.setText(TransformDataScreen.this.controller.getMessage("Select exactly 1 transform first (excluding remove transforms)", new Object[0]));
            }
            if (this.deleteButton.isEnabled()) {
                this.deleteTooltip.setText(TransformDataScreen.this.controller.getMessage("Delete the selected transform(s) or added column", new Object[0]));
            } else {
                this.deleteTooltip.setText(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "Requires write permission" : "Select 1 or more transforms or an added column first", new Object[0]));
            }
        }

        private boolean isRemoved(String column, boolean source) {
            if (source) {
                for (ConfigCanvasTransformTable.ConfigCanvasTransformColumn transformColumn : this.transformColumnSet) {
                    if (!"remove".equals(transformColumn.getTransformType()) || !Strings.CS.equals(transformColumn.getSourceColumnName(), column) || !Strings.CS.equals(transformColumn.getTargetColumnName() + " remove", column)) continue;
                    return true;
                }
                return false;
            }
            return "diagram | remove".equals(column);
        }

        private Set<ConfigCanvasTransformTable.ConfigCanvasTransformColumn> getSelectedTransformColumns() {
            HashSet<ConfigCanvasTransformTable.ConfigCanvasTransformColumn> selectedTransformColumnSet = new HashSet<ConfigCanvasTransformTable.ConfigCanvasTransformColumn>();
            if (this.selectedSourceColumn == null && this.selectedTargetColumn == null) {
                return selectedTransformColumnSet;
            }
            for (ConfigCanvasTransformTable.ConfigCanvasTransformColumn transformColumn : this.transformColumnSet) {
                String targetColumn;
                String sourceColumn = transformColumn.getSourceColumnName() != null ? transformColumn.getSourceColumnName() : "diagram | empty";
                String string = targetColumn = "remove".equals(transformColumn.getTransformType()) ? "diagram | remove" : transformColumn.getTargetColumnName();
                if (this.selectedSourceColumn != null && this.selectedTargetColumn != null) {
                    if (!this.selectedSourceColumn.equals(sourceColumn) || !this.selectedTargetColumn.equals(targetColumn)) continue;
                    selectedTransformColumnSet.add(transformColumn);
                    continue;
                }
                if (!(this.selectedSourceColumn != null ? this.selectedSourceColumn.equals(sourceColumn) && (this.viewableTargetColumnSet.contains(targetColumn) || "diagram | remove".equals(targetColumn)) : targetColumn.equals(this.selectedTargetColumn) && (this.viewableSourceColumnSet.contains(sourceColumn) || "diagram | empty".equals(sourceColumn)))) continue;
                selectedTransformColumnSet.add(transformColumn);
            }
            return selectedTransformColumnSet;
        }

        private void editSelection() {
            bC dialog;
            Set<ConfigCanvasTransformTable.ConfigCanvasTransformColumn> selectedTransformColumnSet = this.getSelectedTransformColumns();
            if (!selectedTransformColumnSet.isEmpty()) {
                dialog = new bC(TransformDataScreen.this.controller, TransformDataScreen.this.canvas, this, this.transform, selectedTransformColumnSet, false, TransformDataScreen.this.readOnly);
            } else {
                String selectedColumn = this.selectedSourceColumn != null ? this.selectedSourceColumn : this.selectedTargetColumn;
                HashSet<ConfigCanvasTransformTable.ConfigCanvasTransformColumn> newTransformColumnSet = new HashSet<ConfigCanvasTransformTable.ConfigCanvasTransformColumn>();
                ConfigCanvasTransformTable configCanvasTransformTable = this.transform;
                Objects.requireNonNull(configCanvasTransformTable);
                newTransformColumnSet.add(configCanvasTransformTable.new ConfigCanvasTransformTable.ConfigCanvasTransformColumn(selectedColumn, selectedColumn, this.transform.getSourcePrimaryKeyColumnNames().contains(selectedColumn)));
                dialog = new bC(TransformDataScreen.this.controller, TransformDataScreen.this.canvas, this, this.transform, newTransformColumnSet, true, TransformDataScreen.this.readOnly);
            }
            dialog.open();
            dialog.a();
        }

        private void deleteSelection() {
            if (this.selectedSourceColumn == null && this.selectedTargetColumn != null && this.addedColumnSet.contains(this.selectedTargetColumn)) {
                this.targetColumnSet.remove(this.selectedTargetColumn);
                this.addedColumnSet.remove(this.selectedTargetColumn);
            }
            this.deleteSelectedTransforms();
        }

        public void deleteSelectedTransforms() {
            String matchingColumn = null;
            if (this.selectedSourceColumn != null && (this.selectedTargetColumn == null || this.selectedSourceColumn.equals(this.selectedTargetColumn)) && this.isAutoMapped(this.selectedSourceColumn, false)) {
                matchingColumn = this.selectedSourceColumn;
            } else if (this.selectedSourceColumn == null && this.selectedTargetColumn != null && this.isAutoMapped(this.selectedTargetColumn, false)) {
                matchingColumn = this.selectedTargetColumn;
            }
            this.transformColumnSet.removeAll(this.getSelectedTransformColumns());
            if (matchingColumn != null) {
                ConfigCanvasTransformTable configCanvasTransformTable = this.transform;
                Objects.requireNonNull(configCanvasTransformTable);
                ConfigCanvasTransformTable.ConfigCanvasTransformColumn removeTransformColumn = configCanvasTransformTable.new ConfigCanvasTransformTable.ConfigCanvasTransformColumn(matchingColumn, matchingColumn + " remove", this.transform.getSourcePrimaryKeyColumnNames().contains(matchingColumn));
                removeTransformColumn.setTransformType("remove");
                this.transformColumnSet.add(removeTransformColumn);
            }
            this.selectionEvent(null, null);
            this.refreshDiagram();
        }

        public Set<ConfigCanvasTransformTable.ConfigCanvasTransformColumn> getTransformColumnSet() {
            return this.transformColumnSet;
        }

        public void selectionEvent(String sourceColumn, String targetColumn) {
            this.selectedSourceColumn = sourceColumn;
            this.selectedTargetColumn = targetColumn;
            this.updateButtonsEnabled();
        }

        public void linkCreatedEvent(String sourceColumn, String targetColumn) {
            boolean noSourceColumn = sourceColumn.equals("diagram | empty");
            boolean remove = targetColumn.equals("diagram | remove");
            boolean pk = this.transform.getSourcePrimaryKeyColumnNames().contains(sourceColumn);
            ConfigCanvasTransformTable configCanvasTransformTable = this.transform;
            Objects.requireNonNull(configCanvasTransformTable);
            ConfigCanvasTransformTable.ConfigCanvasTransformColumn transformColumn = configCanvasTransformTable.new ConfigCanvasTransformTable.ConfigCanvasTransformColumn(noSourceColumn ? null : sourceColumn, (String)(remove ? sourceColumn + " remove" : targetColumn), pk);
            if (noSourceColumn) {
                transformColumn.setTransformType("const");
            } else if (remove) {
                transformColumn.setTransformType("remove");
            }
            this.transformColumnSet.add(transformColumn);
            this.refreshDiagram();
        }

        public void editEvent(String sourceColumn, String targetColumn) {
            this.selectionEvent(sourceColumn, targetColumn);
            this.editSelection();
            this.refreshDiagram();
        }

        public void deleteEvent(String sourceColumn, String targetColumn) {
            this.selectedSourceColumn = sourceColumn;
            this.selectedTargetColumn = targetColumn;
            this.deleteSelectedTransforms();
        }

        public void addTargetColumnEvent() {
            new AddTargetColumnDialog(this).open();
        }
    }

    class AddTargetColumnDialog
    extends Dialog {
        private static final long serialVersionUID = 1L;
        private Button saveButton;
        private Tooltip saveTooltip;

        public AddTargetColumnDialog(TransformColumnsDialog dialog) {
            this.setWidth("350px");
            this.setCloseOnOutsideClick(false);
            Icon headerIcon = new Icon(VaadinIcon.CHART_3D);
            H2 header = new H2(TransformDataScreen.this.controller.getMessage("Add Target Column", new Object[0]));
            header.getStyle().set("font-size", "22px").set("font-weight", "600");
            HorizontalLayout headerLayout = new HorizontalLayout(new Component[]{headerIcon, header});
            headerLayout.addAndExpand(new Component[]{new Span()});
            o closeIcon = new o(TransformDataScreen.this.controller.getContextPath(), VaadinIcon.CLOSE_SMALL);
            closeIcon.addClickListener(() -> this.close());
            Tooltip.forComponent((Component)closeIcon).setText(TransformDataScreen.this.controller.getMessage("Close the dialog without adding the new target column", new Object[0]));
            headerLayout.add(new Component[]{closeIcon});
            this.getHeader().add(new Component[]{headerLayout});
            TextField columnName = new TextField(TransformDataScreen.this.controller.getMessage("Column name", new Object[0]));
            columnName.setWidthFull();
            columnName.getStyle().set("padding", "0").set("margin-bottom", "16px");
            columnName.setManualValidation(true);
            columnName.setValueChangeMode(ValueChangeMode.EAGER);
            columnName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                boolean invalid;
                boolean blank = StringUtils.isBlank((CharSequence)((CharSequence)event.getValue()));
                boolean bl2 = invalid = blank || dialog.targetColumnSet.contains(event.getValue());
                if (invalid) {
                    if (blank) {
                        columnName.setErrorMessage(TransformDataScreen.this.controller.getMessage("%s is required.", "Column name"));
                    } else {
                        columnName.setErrorMessage(TransformDataScreen.this.controller.getMessage("Column name already exists", new Object[0]));
                    }
                }
                columnName.setInvalid(invalid);
                this.saveButton.setEnabled(!invalid);
                this.saveTooltip.setText(TransformDataScreen.this.controller.getMessage(invalid ? "Column name is invalid" : "Save the new target column and close the dialog", new Object[0]));
            });
            Checkbox mapToNoSourceColumn = new Checkbox(TransformDataScreen.this.controller.getMessage("Map this to \"(no source column)\"", new Object[0]));
            mapToNoSourceColumn.setValue((Object)true);
            this.add(new Component[]{columnName, mapToNoSourceColumn});
            Button cancelButton = new Button(TransformDataScreen.this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
            cancelButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
            cancelButton.getStyle().set("margin-right", "10px");
            cancelButton.setTooltipText(TransformDataScreen.this.controller.getMessage("Close the dialog without adding the new target column", new Object[0]));
            this.saveButton = as.createPrimaryButton(TransformDataScreen.this.controller.getMessage("Save", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
                String newColumnName = columnName.getValue();
                dialog.targetColumnSet.add(newColumnName);
                dialog.addedColumnSet.add(newColumnName);
                if (((Boolean)mapToNoSourceColumn.getValue()).booleanValue()) {
                    ConfigCanvasTransformTable configCanvasTransformTable = dialog.transform;
                    Objects.requireNonNull(configCanvasTransformTable);
                    ConfigCanvasTransformTable.ConfigCanvasTransformColumn newTransform = configCanvasTransformTable.new ConfigCanvasTransformTable.ConfigCanvasTransformColumn(null, newColumnName, false);
                    newTransform.setTransformType("const");
                    dialog.transformColumnSet.add(newTransform);
                } else if (((String)dialog.columnVisibilityGroup.getValue()).equals(TransformDataScreen.this.controller.getMessage("Show mapped only", new Object[0]))) {
                    dialog.columnVisibilityGroup.setValue((Object)TransformDataScreen.this.controller.getMessage("Show all", new Object[0]));
                }
                dialog.refreshDiagram();
                this.close();
            });
            this.saveButton.setEnabled(false);
            Div saveDiv = new Div(new Component[]{this.saveButton});
            this.saveTooltip = Tooltip.forComponent((Component)saveDiv).withText(TransformDataScreen.this.controller.getMessage("Column name is invalid", new Object[0]));
            this.getFooter().add(new Component[]{cancelButton, saveDiv});
        }
    }

    class TransformDetailsDialog
    extends X {
        private static final long serialVersionUID = 1L;
        private Button saveButton;
        private Tooltip saveTooltip;

        public TransformDetailsDialog(ConfigCanvasTransformTable transform) {
            super(TransformDataScreen.this.controller.getMessage(TransformDataScreen.this.readOnly ? "View Details of '%s to %s' Transform" : "Edit Details of '%s to %s' Transform", transform.getSourceTableName(), transform.getTargetTableName()), TransformDataScreen.this.controller.getContextPath(), VaadinIcon.TABLE, TransformDataScreen.this.readOnly ? null : TransformDataScreen.this.controller.getMessage("Close the dialog without saving the transform's details", new Object[0]));
            this.setHeight("420px");
            this.setWidth("600px");
            this.setCloseOnOutsideClick(false);
            Binder binder = new Binder(ConfigCanvasTransformTable.class);
            Select columnPolicy = new Select();
            columnPolicy.setLabel(TransformDataScreen.this.controller.getMessage("Column Policy", new Object[0]));
            columnPolicy.setItems((Object[])ColumnPolicy.values());
            binder.forField((HasValue)columnPolicy).bind("columnPolicy");
            Checkbox updateFirst = new Checkbox(TransformDataScreen.this.controller.getMessage("Update First", new Object[0]));
            binder.forField((HasValue)updateFirst).bind("updateFirst");
            Select updateAction = new Select();
            updateAction.setLabel(TransformDataScreen.this.controller.getMessage("Update Action", new Object[0]));
            ArrayList<String> updateActionList = new ArrayList<String>();
            updateActionList.add(TargetDmlAction.UPD_ROW.name());
            updateActionList.add(TargetDmlAction.INS_ROW.name());
            updateActionList.add(TargetDmlAction.DEL_ROW.name());
            updateActionList.add(TargetDmlAction.NONE.name());
            updateAction.setItems(updateActionList);
            binder.forField((HasValue)updateAction).bind("updateAction");
            Select deleteAction = new Select();
            deleteAction.setLabel(TransformDataScreen.this.controller.getMessage("Delete Action", new Object[0]));
            ArrayList<TargetDmlAction> deleteActionList = new ArrayList<TargetDmlAction>();
            deleteActionList.add(TargetDmlAction.NONE);
            deleteActionList.add(TargetDmlAction.DEL_ROW);
            deleteActionList.add(TargetDmlAction.UPDATE_COL);
            deleteAction.setItems(deleteActionList);
            binder.forField((HasValue)deleteAction).bind("deleteAction");
            TextField transformOrder = new TextField(TransformDataScreen.this.controller.getMessage("Transform Order", new Object[0]));
            transformOrder.setAllowedCharPattern("[0-9]");
            transformOrder.setValueChangeMode(ValueChangeMode.EAGER);
            transformOrder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (this.saveButton != null) {
                    boolean enabled = binder.validate().isOk();
                    this.saveButton.setEnabled(enabled);
                    this.saveTooltip.setText(TransformDataScreen.this.controller.getMessage(enabled ? "Save the transform's details and close the dialog" : "Transform Order is invalid", new Object[0]));
                }
            });
            binder.forField((HasValue)transformOrder).withConverter((Converter)new StringToIntegerConverter(TransformDataScreen.this.controller.getMessage("Transform Order must be an integer.", new Object[0]))).withValidator((SerializablePredicate & Serializable)value -> value != null, TransformDataScreen.this.controller.getMessage("%s is required.", "Transform Order")).bind("transformOrder");
            FormLayout fieldLayout = new FormLayout(new Component[]{columnPolicy, updateFirst, updateAction, deleteAction, transformOrder});
            fieldLayout.setSizeFull();
            fieldLayout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 2, FormLayout.ResponsiveStep.LabelsPosition.TOP)});
            this.mainLayout.add(new Component[]{fieldLayout});
            this.mainLayout.setSizeUndefined();
            Anchor helpAnchor = TransformDataScreen.this.canvas.createHelpAnchor(TransformDataScreen.this.getDocAnchor());
            helpAnchor.getStyle().set("margin-right", "auto");
            if (TransformDataScreen.this.readOnly) {
                columnPolicy.setReadOnly(true);
                columnPolicy.setReadOnly(true);
                updateFirst.setReadOnly(true);
                updateAction.setReadOnly(true);
                deleteAction.setReadOnly(true);
                transformOrder.setReadOnly(true);
                this.getFooter().add(new Component[]{helpAnchor, new Button(TransformDataScreen.this.controller.getMessage("Close", new Object[0]), (ComponentEventListener & Serializable)event -> this.close())});
            } else {
                Button cancelButton = new Button(TransformDataScreen.this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
                cancelButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
                cancelButton.getStyle().set("margin-right", "10px");
                cancelButton.setTooltipText(TransformDataScreen.this.controller.getMessage("Close the dialog without saving the transform's details", new Object[0]));
                this.saveButton = as.createPrimaryButton(TransformDataScreen.this.controller.getMessage("Save", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
                    try {
                        binder.writeBean((Object)transform);
                        transform.setId(transform.generateDefaultId());
                        if (!TransformDataScreen.this.transformDialog.getTransformSet().contains(transform)) {
                            TransformDataScreen.this.transformDialog.populateColumnNames(transform);
                            TransformDataScreen.this.transformDialog.getTransformSet().add(transform);
                        }
                        TransformDataScreen.this.transformDialog.refreshDiagram(false, false);
                        this.close();
                    }
                    catch (ValidationException validationException) {
                        // empty catch block
                    }
                });
                Div saveDiv = new Div(new Component[]{this.saveButton});
                this.saveTooltip = Tooltip.forComponent((Component)saveDiv).withText(TransformDataScreen.this.controller.getMessage("Save the transform's details and close the dialog", new Object[0]));
                this.getFooter().add(new Component[]{helpAnchor, cancelButton, saveDiv});
            }
            binder.readBean((Object)transform);
        }
    }
}

