/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.jumpmind.symmetric.console.ui.canvas.TransformColumnsDiagramDetail;
import com.jumpmind.symmetric.console.ui.canvas.TransformDataScreen;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.internal.AllowInert;
import com.vaadin.flow.component.page.Page;
import elemental.json.JsonObject;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CssImport(value="./transform-diagram.css")
@JsModule.Container(value={@JsModule(value="./jsplumb.min.js"), @JsModule(value="./transform-columns-diagram.js")})
@JavaScript(value="./transform-columns-diagram.js")
public class TransformColumnsDiagram
extends Div {
    private static final Logger log = LoggerFactory.getLogger(TransformColumnsDiagram.class);
    private static final long serialVersionUID = 1L;
    private TransformColumnsDiagramDetail detail;
    private TransformDataScreen.TransformColumnsDialog dialog;

    public TransformColumnsDiagram(TransformDataScreen.TransformColumnsDialog dialog, TransformColumnsDiagramDetail detail) {
        this.dialog = dialog;
        this.detail = detail != null ? detail : new TransformColumnsDiagramDetail();
        this.setId("transform-columns-diagram");
        this.addClassName("transform-diagram");
    }

    protected void onAttach(AttachEvent attachEvent) {
        Page page = UI.getCurrent().getPage();
        page.executeJs("window.com_jumpmind_symmetric_console_ui_screen_configure_TransformColumnsDiagram($0)", new Serializable[]{this.getElement()});
    }

    @ClientCallable
    private void onSelection(JsonObject json) {
        String sourceColumnName = null;
        String targetColumnName = null;
        if (json.hasKey("source")) {
            sourceColumnName = this.parseColumnName(json.getString("source"), true);
        }
        if (json.hasKey("target")) {
            targetColumnName = this.parseColumnName(json.getString("target"), false);
        }
        this.dialog.selectionEvent(sourceColumnName, targetColumnName);
    }

    @ClientCallable
    private void onConnection(JsonObject json) {
        this.dialog.linkCreatedEvent(this.parseColumnName(json.getString("source"), true), this.parseColumnName(json.getString("target"), false));
    }

    @ClientCallable
    private void onEditOverlayClick(JsonObject json) {
        this.dialog.editEvent(this.parseColumnName(json.getString("source"), true), this.parseColumnName(json.getString("target"), false));
    }

    @ClientCallable
    private void onDeleteOverlayClick(JsonObject json) {
        this.dialog.deleteEvent(this.parseColumnName(json.getString("source"), true), this.parseColumnName(json.getString("target"), false));
    }

    @ClientCallable
    private void onAddTargetColumnButtonClick() {
        this.dialog.addTargetColumnEvent();
    }

    private String parseColumnName(String columnName, boolean source) {
        if (columnName.startsWith(source ? "source-col:" : "target-col:")) {
            return columnName.substring(11);
        }
        return "diagram | " + columnName;
    }

    @AllowInert
    @ClientCallable
    public String getCurState() {
        ObjectMapper om = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).build();
        try {
            return om.writeValueAsString((Object)this.detail);
        }
        catch (JsonProcessingException e2) {
            log.warn("Failed to convert transform columns diagram state to JSON", (Throwable)e2);
            return null;
        }
    }

    public TransformColumnsDiagramDetail getDetail() {
        return this.detail;
    }
}

