/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.jumpmind.symmetric.console.ui.canvas.AbstractSidebarScreen;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvas;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasEndpoint;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasLink;
import com.jumpmind.symmetric.console.ui.canvas.ISidebarScreen;
import com.jumpmind.symmetric.console.ui.canvas.SelectTablesScreen;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.M;
import com.jumpmind.symmetric.console.ui.common.X;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.s;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.component.tabs.TabSheet;
import com.vaadin.flow.component.tabs.TabSheetVariant;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldBase;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class DefineEndpointScreen
extends AbstractSidebarScreen {
    private static final long serialVersionUID = 1L;
    private final String NEW_ENDPOINT;
    private boolean isFirst;
    private boolean redrawDiagram;
    private boolean updatingEndpointList;
    private ConfigCanvasEndpoint endpoint;
    private ComboBox<String> endpointComboBox;
    private ComboBox<s.a> endpointType;
    private TextField displayName;
    private Span connectionFailedSpan;
    private HorizontalLayout connectionFailedLayout;
    private TextField host;
    private TextField port;
    private TextField databaseName;
    private RadioButtonGroup<String> databaseNameOptions;
    private Select<String> basicAuthentication;
    private TextField basicUserId;
    private PasswordField basicPassword;
    private FormLayout basicForm;
    private TextField url;
    private Select<String> customAuthentication;
    private TextField bigQueryLocation;
    private TextField bigQueryProjectId;
    private TextField bigQuerySecurityPath;
    private TextField customUserId;
    private PasswordField customPassword;
    private TabSheet detailsTabSheet;
    private VerticalLayout detailsLayout;
    private Button testConnectionButton;
    private Tooltip testConnectionTooltip;
    private String newEndpointGuid;
    private s.a originalEndpointType;
    private String originalDisplayName;
    private IDatabasePlatform originalPlatform;
    private boolean originalConnectionSuccessful;
    private boolean previousConnectionSuccessful;
    private String originalExceptionMessage;
    private boolean originalEndpointDetailsChanged;
    private String originalHost;
    private String originalPort;
    private String originalDatabaseName;
    private Boolean originalUseOracleServiceName;
    private String originalUserId;
    private String originalPassword;
    private String originalUrl;
    private String originalBigQueryLocation;
    private String originalBigQueryProjectId;
    private String originalBigQuerySecurityPath;
    private boolean endpointDetailsChanged;
    private boolean notifyAboutExistingInstallation;
    private boolean hasNextButtonBeenClicked;
    private DefineEndpointScreen secondDefineEndpointScreen;

    public DefineEndpointScreen(I controller, ConfigCanvas canvas, boolean isFirst) {
        super(controller, canvas, controller.getMessage(canvas.isInitialSetup() || canvas.isAddingNewReplication() ? (isFirst ? "Define First Endpoint" : "Define Second Endpoint") : "Define Endpoint", new Object[0]), controller.getMessage(isFirst && canvas.getFirstEndpoint() != null && canvas.getFirstEndpoint().isDeployed() ? "SymmetricDS uses metadata from this endpoint to define tables for replication. The connection information for a deployed node can be edited via the Manage Startup Parameters screen." : "Enter the user and connection information for this endpoint. SymmetricDS uses metadata from this endpoint to define tables for replication.", new Object[0]));
        this.NEW_ENDPOINT = this.controller.getMessage("<New Endpoint>", new Object[0]);
        this.notifyAboutExistingInstallation = true;
        this.isFirst = isFirst;
        ConfigCanvasEndpoint configCanvasEndpoint = this.endpoint = isFirst ? canvas.getFirstEndpoint() : canvas.getSecondEndpoint();
        if (canvas.isAddingNewReplication() || !isFirst) {
            if (this.endpoint != null) {
                this.newEndpointGuid = this.endpoint.getGuid();
            }
            this.endpointComboBox = new ComboBox(controller.getMessage("Select New or Existing Endpoint", new Object[0]));
            this.endpointComboBox.setPlaceholder(controller.getMessage("Choose a new or existing endpoint (start typing to filter)", new Object[0]));
            this.endpointComboBox.setWidthFull();
            this.endpointComboBox.setRenderer((Renderer)new ComponentRenderer((SerializableFunction & Serializable)endpointId -> {
                if (this.NEW_ENDPOINT.equals(endpointId)) {
                    return new Span(this.NEW_ENDPOINT);
                }
                return as.getEndpointLayout(controller, canvas.getContext().getEndpointById((String)endpointId), false);
            }));
            this.updateEndpointList(canvas.isInitialSetup() ? this.NEW_ENDPOINT : null);
            this.endpointComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (this.updatingEndpointList) {
                    return;
                }
                this.hasNextButtonBeenClicked = false;
                String previousEndpointId = (String)event.getOldValue();
                if (previousEndpointId != null) {
                    if (this.endpoint != null && !this.endpoint.isDeployed() && !this.endpoint.isRemote()) {
                        this.discardChanges(false, false, false);
                    }
                    this.deleteEndpointOrLink(previousEndpointId);
                }
                this.newEndpointGuid = null;
                String endpointId = (String)event.getValue();
                if (endpointId != null) {
                    this.endpointType.setVisible(true);
                    if (this.NEW_ENDPOINT.equals(endpointId)) {
                        this.endpoint = canvas.addEndpoint();
                        this.newEndpointGuid = this.endpoint.getGuid();
                    } else {
                        this.endpoint = canvas.getContext().getEndpointById(endpointId);
                    }
                    if (!isFirst) {
                        canvas.getFirstEndpoint().addLink(this.endpoint.getGuid(), this.endpoint.getId());
                    } else if (this.secondDefineEndpointScreen != null && canvas.getSecondEndpoint() != null) {
                        ConfigCanvasEndpoint secondEndpoint = canvas.getSecondEndpoint();
                        this.endpoint.addLink(secondEndpoint.getGuid(), secondEndpoint.getId());
                    }
                } else {
                    this.endpointType.setVisible(false);
                    this.detailsLayout.setVisible(false);
                    this.endpoint = null;
                }
                this.descriptionSpan.setText(controller.getMessage(this.endpoint != null && this.endpoint.isDeployed() ? "SymmetricDS uses metadata from this endpoint to define tables for replication. The connection information for a deployed node can be edited via the Manage Startup Parameters screen." : "Enter the user and connection information for this endpoint. SymmetricDS uses metadata from this endpoint to define tables for replication.", new Object[0]));
                if (isFirst) {
                    canvas.setFirstEndpoint(this.endpoint);
                } else {
                    canvas.setSecondEndpoint(this.endpoint);
                }
                if (this.endpoint != null) {
                    canvas.getProgressStepper().setStepName(isFirst ? 0 : 1, this.endpoint.getId());
                    this.refreshDetailsLayout();
                }
                canvas.setSelectedEndpoint(this.endpoint, false);
                canvas.refresh();
            });
            canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.endpointComboBox);
            this.add(new Component[]{this.endpointComboBox});
        }
        this.endpointType = new ComboBox(controller.getMessage("Endpoint Type", new Object[0]));
        this.endpointType.setPlaceholder(controller.getMessage("Enter a source type (start typing to filter)", new Object[0]));
        this.endpointType.setWidthFull();
        this.endpointType.setRenderer((Renderer)new ComponentRenderer((SerializableFunction & Serializable)type -> {
            HorizontalLayout typeLayout = new HorizontalLayout(new Component[]{as.getEndpointIcon(controller.getContextPath(), type), new Span(type.getName())});
            typeLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
            return typeLayout;
        }));
        this.endpointType.setVisible(this.endpointComboBox == null || !this.endpointComboBox.isEmpty());
        this.endpointType.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            boolean fromClient = event.isFromClient();
            s.a type = (s.a)event.getValue();
            if (type != null) {
                this.detailsLayout.setVisible(true);
                if (fromClient) {
                    this.url.setValue(s.databaseToSampleUrlMap.get(type));
                    if (!this.endpoint.isUsingCustomUrl()) {
                        this.checkCompletion();
                    }
                    this.host.setValue("");
                    String defaultPort = s.databaseToDefaultPortMap.get(type);
                    if (defaultPort != null) {
                        this.port.setValue(defaultPort);
                    } else {
                        this.port.clear();
                    }
                    this.databaseName.clear();
                    this.databaseNameOptions.setValue((Object)controller.getMessage("System ID (SID)", new Object[0]));
                    this.endpoint.setUseOracleServiceName(null);
                    this.basicUserId.clear();
                    this.basicPassword.clear();
                    this.customUserId.clear();
                    this.customPassword.clear();
                    this.updateBasicTabEnabled(type);
                }
                if (this.basicAuthentication != null) {
                    if (type.equals(s.ORACLE)) {
                        this.databaseName.setLabel(controller.getMessage("System ID (SID)", new Object[0]));
                        this.basicForm.setColspan((Component)this.databaseName, 1);
                        this.databaseNameOptions.setVisible(true);
                    } else {
                        this.databaseName.setLabel(controller.getMessage("Database Name", new Object[0]));
                        this.databaseNameOptions.setVisible(false);
                        this.basicForm.setColspan((Component)this.databaseName, 2);
                    }
                    if (type.equals(s.SQL_SERVER) || type.equals(s.SQL_SERVER_AZURE)) {
                        this.basicAuthentication.setVisible(true);
                        this.customAuthentication.setVisible(true);
                    } else {
                        this.basicAuthentication.setVisible(false);
                        this.basicAuthentication.setValue((Object)controller.getMessage("Database Native", new Object[0]));
                        this.customAuthentication.setVisible(false);
                        this.customAuthentication.setValue((Object)controller.getMessage("Database Native", new Object[0]));
                        this.toggleWindowsAuthentication(false, false);
                    }
                    boolean isBigQuery = type.equals(s.BIGQUERY);
                    this.bigQueryLocation.setVisible(isBigQuery);
                    this.bigQueryProjectId.setVisible(isBigQuery);
                    this.bigQuerySecurityPath.setVisible(isBigQuery);
                }
            } else {
                this.detailsLayout.setVisible(false);
            }
            if (fromClient || type != null) {
                this.endpoint.setType(type);
                if (fromClient) {
                    canvas.refresh();
                    if (this.detailsTabSheet != null && this.detailsTabSheet.isVisible() && this.endpoint.isUsingCustomUrl()) {
                        this.highlightUrl();
                    }
                }
            }
        });
        canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.endpointType);
        this.updateEndpointTypes(!isFirst && canvas.getFirstEndpoint().getType().isWriteOnly());
        this.displayName = new TextField(controller.getMessage("Display Name/Group", new Object[0]));
        this.displayName.setWidthFull();
        this.displayName.setAllowedCharPattern("[^<>\\[\\]{}|^%\\\\/~`#&\\s]");
        this.displayName.setValueChangeMode(ValueChangeMode.LAZY);
        this.displayName.setValueChangeTimeout(500);
        this.displayName.setManualValidation(true);
        this.displayName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            String endpointId = (String)event.getValue();
            boolean invalid = true;
            if (StringUtils.isEmpty((CharSequence)endpointId)) {
                this.displayName.setErrorMessage(controller.getMessage("The display name can't be blank", new Object[0]));
            } else if (endpointId.length() > 50) {
                this.displayName.setErrorMessage(controller.getMessage("The display name is too long", new Object[0]));
            } else if (canvas.doesEndpointIdExist(endpointId, isFirst)) {
                this.displayName.setErrorMessage(controller.getMessage("An endpoint with this display name already exists", new Object[0]));
            } else {
                invalid = false;
                this.endpoint.setId(endpointId);
                canvas.endpointIdUpdated(this.endpoint.getGuid(), endpointId, event.isFromClient());
                canvas.getProgressStepper().setStepName(isFirst ? 0 : 1, endpointId);
                this.updateEndpointList(endpointId);
                if (this.secondDefineEndpointScreen != null) {
                    if (this.endpoint.equals(canvas.getSecondEndpoint())) {
                        canvas.getProgressStepper().setStepName(1, endpointId);
                        this.secondDefineEndpointScreen.updateEndpointList(endpointId);
                    } else {
                        this.secondDefineEndpointScreen.updateEndpointList(null);
                    }
                }
            }
            this.displayName.setInvalid(invalid);
            this.checkCompletion();
        });
        canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.displayName);
        this.detailsLayout = new VerticalLayout();
        this.detailsLayout.setPadding(false);
        if (this.endpoint != null) {
            this.refreshDetailsLayout();
        } else {
            this.openComboBox();
        }
        this.add(new Component[]{this.endpointType, this.detailsLayout});
    }

    public void updateEndpointList(String endpointIdToSelect) {
        if (this.endpointComboBox != null) {
            this.updatingEndpointList = true;
            ConfigCanvasEndpoint otherEndpoint = this.isFirst ? this.canvas.getSecondEndpoint() : this.canvas.getFirstEndpoint();
            String originalSelectedEndpointId = (String)this.endpointComboBox.getValue();
            ComboBox.ItemFilter & Serializable endpointFilter = (ComboBox.ItemFilter & Serializable)(endpoint, filter) -> !CommonUiUtils.isFilteredOut((String)endpoint, (String)filter);
            ArrayList<String> endpointIdList = new ArrayList<String>();
            endpointIdList.add(this.NEW_ENDPOINT);
            endpointIdList.addAll(this.canvas.getEndpointList().stream().filter(e2 -> {
                if (!(!this.canvas.isAddingNewReplication() || e2.equals(this.endpoint) || otherEndpoint == null || this.isFirst && e2.equals(otherEndpoint) || e2.getLink(otherEndpoint.getGuid()) == null && otherEndpoint.getLink(e2.getGuid()) == null)) {
                    return false;
                }
                return !e2.getGuid().equals(this.newEndpointGuid) && (this.secondDefineEndpointScreen == null || !e2.getGuid().equals(this.secondDefineEndpointScreen.newEndpointGuid));
            }).map(e2 -> e2.getId()).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList()));
            this.endpointComboBox.setItems((ComboBox.ItemFilter)endpointFilter, endpointIdList);
            if (endpointIdToSelect != null && endpointIdList.contains(endpointIdToSelect)) {
                this.endpointComboBox.setValue((Object)endpointIdToSelect);
            } else if (endpointIdList.size() == 1) {
                this.endpointComboBox.setValue((Object)this.NEW_ENDPOINT);
            } else if (originalSelectedEndpointId != null) {
                this.endpointComboBox.setValue((Object)originalSelectedEndpointId);
            }
            this.updatingEndpointList = false;
        }
    }

    private void deleteEndpointOrLink(String endpointId) {
        if (this.controller.getMessage("<New Endpoint>", new Object[0]).equals(endpointId)) {
            this.canvas.deleteEndpoint(this.newEndpointGuid);
        } else if (this.endpoint != null) {
            if (!this.isFirst) {
                this.canvas.getFirstEndpoint().removeLink(this.endpoint.getGuid());
            } else if (this.canvas.getSecondEndpoint() != null) {
                this.endpoint.removeLink(this.canvas.getSecondEndpoint().getGuid());
            }
        }
        if (this.isFirst) {
            this.canvas.setFirstEndpoint(null);
        } else {
            this.canvas.setSecondEndpoint(null);
        }
    }

    private void updateBasicTabEnabled(s.a type) {
        if (this.detailsTabSheet != null) {
            String defaultPort = s.databaseToDefaultPortMap.get(type);
            if (defaultPort != null) {
                this.detailsTabSheet.getTabAt(0).setEnabled(true);
                this.detailsTabSheet.setSelectedIndex(0);
            } else {
                this.detailsTabSheet.getTabAt(0).setEnabled(false);
                this.detailsTabSheet.setSelectedIndex(1);
            }
        }
    }

    private void highlightUrl() {
        String urlValue = this.url.getValue();
        if (urlValue != null) {
            String DATABASENAME = "databasename";
            String HOSTNAME = "localhost";
            int index = urlValue.lastIndexOf("databasename");
            String js = "$0.querySelector('[slot=\"input\"]').focus();$0.querySelector('[slot=\"input\"]').setSelectionRange($1, $2);$0.querySelector('[slot=\"input\"]').scrollLeft = 0;";
            if (index > 0 && !s.SQL_SERVER.equals(this.endpointType.getValue()) && !s.SQL_SERVER_AZURE.equals(this.endpointType.getValue()) || StringUtils.countMatches((CharSequence)urlValue, (CharSequence)"databasename") > 1) {
                UI.getCurrent().getPage().executeJs(js, new Serializable[]{this.url.getElement(), Integer.valueOf(index), Integer.valueOf(index + "databasename".length())});
            } else {
                index = urlValue.lastIndexOf("localhost");
                if (index > 0) {
                    UI.getCurrent().getPage().executeJs(js, new Serializable[]{this.url.getElement(), Integer.valueOf(index), Integer.valueOf(index + "localhost".length())});
                }
            }
        }
    }

    private void refreshDetailsLayout() {
        this.detailsLayout.removeAll();
        if (this.endpoint.isRemote() && this.endpoint.isDeployed() && this.endpoint.getUrl() == null) {
            this.endpointType.setVisible(true);
            this.endpointType.setEnabled(false);
            this.displayName.setEnabled(false);
            this.detailsLayout.add(new Component[]{this.displayName, ConfigCanvas.createInfoLayout(this.controller.getMessage("This endpoint is remote and its connection information is unavailable.", new Object[0]))});
            if (this.endpoint.getType() != null) {
                this.endpointType.setValue((Object)this.endpoint.getType());
            }
            this.detailsLayout.setVisible(this.endpointType.getValue() != null);
            if (this.endpoint.getId() != null) {
                this.displayName.setValue(this.endpoint.getId());
            }
        } else {
            if (!this.endpointType.isEmpty()) {
                this.endpointType.clear();
            }
            this.endpointType.setEnabled(true);
            this.displayName.setEnabled(this.endpoint.isRenamable());
            Icon errorIcon = new Icon(VaadinIcon.EXCLAMATION_CIRCLE);
            errorIcon.getStyle().set("min-height", "24px").set("min-width", "24px");
            this.connectionFailedSpan = new Span();
            this.connectionFailedLayout = new HorizontalLayout(new Component[]{errorIcon, this.connectionFailedSpan});
            this.connectionFailedLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
            this.connectionFailedLayout.getStyle().set("color", "var(--lumo-error-color)").set("font-weight", "600");
            this.host = new TextField(this.controller.getMessage("Hostname or IP Address", new Object[0]));
            this.host.getStyle().set("padding-top", "4px");
            this.host.setValueChangeMode(ValueChangeMode.EAGER);
            this.host.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.endpoint.setHost((String)event.getValue()));
            this.host.addBlurListener((ComponentEventListener & Serializable)event -> this.updateUrl());
            this.canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.host);
            this.port = new TextField(this.controller.getMessage("Port", new Object[0]));
            this.port.getStyle().set("padding-top", "4px");
            this.port.setAllowedCharPattern("[0-9]");
            this.port.setValueChangeMode(ValueChangeMode.EAGER);
            this.port.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.endpoint.setPort((String)event.getValue()));
            this.port.addBlurListener((ComponentEventListener & Serializable)event -> this.updateUrl());
            this.canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.port);
            this.databaseName = new TextField(this.controller.getMessage("Database Name", new Object[0]));
            this.databaseName.setValueChangeMode(ValueChangeMode.EAGER);
            this.databaseName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.endpoint.setDatabaseName((String)event.getValue()));
            this.databaseName.addBlurListener((ComponentEventListener & Serializable)event -> this.updateUrl());
            this.canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.databaseName);
            this.databaseNameOptions = new RadioButtonGroup(null, (HasValue.ValueChangeListener & Serializable)event -> {
                this.endpoint.setUseOracleServiceName("Service Name".equals(event.getValue()));
                this.databaseName.setLabel((String)event.getValue());
                this.updateUrl();
            }, (Object[])new String[]{this.controller.getMessage("System ID (SID)", new Object[0]), this.controller.getMessage("Service Name", new Object[0])});
            this.basicAuthentication = new Select();
            this.basicAuthentication.setLabel(this.controller.getMessage("Authentication", new Object[0]));
            this.basicAuthentication.setVisible(false);
            ArrayList<String> authenticationList = new ArrayList<String>();
            authenticationList.add(this.controller.getMessage("Database Native", new Object[0]));
            authenticationList.add(this.controller.getMessage("Windows", new Object[0]));
            this.basicAuthentication.setItems(authenticationList);
            this.basicAuthentication.setValue((Object)this.controller.getMessage("Database Native", new Object[0]));
            this.basicAuthentication.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (event.isFromClient()) {
                    this.customAuthentication.setValue((Object)((String)event.getValue()));
                    this.toggleWindowsAuthentication(((String)event.getValue()).equals(this.controller.getMessage("Windows", new Object[0])), true);
                    this.endpoint.setEndpointDetailsChanged(true);
                }
            });
            this.basicUserId = new TextField(this.controller.getMessage("User ID", new Object[0]), (HasValue.ValueChangeListener & Serializable)event -> {
                this.endpoint.setUserId((String)event.getValue());
                if (event.isFromClient()) {
                    this.customUserId.setValue((String)event.getValue());
                }
            });
            this.basicUserId.setValueChangeMode(ValueChangeMode.EAGER);
            this.basicUserId.addBlurListener((ComponentEventListener & Serializable)event -> {
                if (this.endpoint.getType() != null && this.endpoint.getType().equals(s.RABBITMQ)) {
                    this.updateUrl();
                }
            });
            this.canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.basicUserId);
            this.disableAutofill((TextFieldBase<?, ?>)this.basicUserId);
            this.basicPassword = new PasswordField(this.controller.getMessage("Password", new Object[0]), (HasValue.ValueChangeListener & Serializable)event -> {
                this.endpoint.setPassword((String)event.getValue());
                if (event.isFromClient()) {
                    this.customPassword.setValue((String)event.getValue());
                }
            });
            this.basicPassword.setValueChangeMode(ValueChangeMode.EAGER);
            this.basicPassword.addBlurListener((ComponentEventListener & Serializable)event -> {
                if (this.endpoint.getType() != null && this.endpoint.getType().equals(s.RABBITMQ)) {
                    this.updateUrl();
                }
            });
            this.canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.basicPassword);
            this.disableAutofill((TextFieldBase<?, ?>)this.basicPassword);
            this.basicForm = new FormLayout(new Component[]{this.host, this.port, this.databaseName, this.databaseNameOptions, this.basicAuthentication, this.basicUserId, this.basicPassword});
            this.basicForm.setSizeFull();
            this.basicForm.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 2)});
            this.basicForm.setColspan((Component)this.databaseName, 2);
            this.basicForm.setColspan(this.basicAuthentication, 2);
            this.url = new TextField(this.controller.getMessage("URL", new Object[0]), (HasValue.ValueChangeListener & Serializable)event -> {
                this.endpoint.setUrl((String)event.getValue());
                if (this.endpoint.isUsingCustomUrl()) {
                    this.checkCompletion();
                }
            });
            this.url.getStyle().set("padding-top", "4px");
            this.url.setValueChangeMode(ValueChangeMode.EAGER);
            this.canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.url);
            this.customAuthentication = new Select();
            this.customAuthentication.setLabel(this.controller.getMessage("Authentication", new Object[0]));
            this.customAuthentication.setVisible(false);
            this.customAuthentication.setItems(authenticationList);
            this.customAuthentication.setValue((Object)this.controller.getMessage("Database Native", new Object[0]));
            this.customAuthentication.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (event.isFromClient()) {
                    this.basicAuthentication.setValue((Object)((String)event.getValue()));
                    this.toggleWindowsAuthentication(((String)event.getValue()).equals(this.controller.getMessage("Windows", new Object[0])), true);
                    this.endpoint.setEndpointDetailsChanged(true);
                }
            });
            this.bigQueryLocation = new TextField(this.controller.getMessage("DataSet Data Location", new Object[0]));
            this.bigQueryLocation.setVisible(false);
            this.bigQueryLocation.setValueChangeMode(ValueChangeMode.EAGER);
            this.bigQueryLocation.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.endpoint.setAdvancedProperty("google.bigquery.location", (String)event.getValue()));
            this.canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.bigQueryLocation);
            this.bigQueryProjectId = new TextField(this.controller.getMessage("Project ID", new Object[0]));
            this.bigQueryProjectId.setVisible(false);
            this.bigQueryProjectId.setValueChangeMode(ValueChangeMode.EAGER);
            this.bigQueryProjectId.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.endpoint.setAdvancedProperty("google.bigquery.project.id", (String)event.getValue()));
            this.canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.bigQueryProjectId);
            this.bigQuerySecurityPath = new TextField(this.controller.getMessage("JSON Local Security File Path", new Object[0]));
            this.bigQuerySecurityPath.setVisible(false);
            this.bigQuerySecurityPath.setValueChangeMode(ValueChangeMode.EAGER);
            this.bigQuerySecurityPath.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.endpoint.setAdvancedProperty("google.bigquery.security.credentials.path", (String)event.getValue()));
            this.canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.bigQuerySecurityPath);
            this.customUserId = new TextField(this.controller.getMessage("User ID", new Object[0]), (HasValue.ValueChangeListener & Serializable)event -> {
                this.endpoint.setUserId((String)event.getValue());
                if (event.isFromClient()) {
                    this.basicUserId.setValue((String)event.getValue());
                }
            });
            this.customUserId.setValueChangeMode(ValueChangeMode.EAGER);
            this.canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.customUserId);
            this.disableAutofill((TextFieldBase<?, ?>)this.customUserId);
            this.customPassword = new PasswordField(this.controller.getMessage("Password", new Object[0]), (HasValue.ValueChangeListener & Serializable)event -> {
                this.endpoint.setPassword((String)event.getValue());
                if (event.isFromClient()) {
                    this.basicPassword.setValue((String)event.getValue());
                }
            });
            this.customPassword.setValueChangeMode(ValueChangeMode.EAGER);
            this.canvas.addListenersToToggleDeleteShortcut((Focusable<?>)this.customPassword);
            this.disableAutofill((TextFieldBase<?, ?>)this.customPassword);
            FormLayout customForm = new FormLayout(new Component[]{this.url, this.customAuthentication, this.bigQueryLocation, this.bigQueryProjectId, this.bigQuerySecurityPath, this.customUserId, this.customPassword});
            customForm.setSizeFull();
            customForm.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 2)});
            customForm.setColspan((Component)this.url, 2);
            customForm.setColspan(this.customAuthentication, 2);
            customForm.setColspan((Component)this.bigQuerySecurityPath, 2);
            this.detailsTabSheet = new TabSheet();
            this.detailsTabSheet.add(this.controller.getMessage("Basic", new Object[0]), (Component)this.basicForm);
            this.detailsTabSheet.add(this.controller.getMessage("Custom", new Object[0]), (Component)customForm);
            this.detailsTabSheet.setWidthFull();
            this.detailsTabSheet.addThemeVariants((ThemeVariant[])new TabSheetVariant[]{TabSheetVariant.LUMO_BORDERED, TabSheetVariant.LUMO_TABS_EQUAL_WIDTH_TABS});
            this.detailsTabSheet.addClassName("bordered-tabsheet");
            this.detailsTabSheet.addSelectedChangeListener((ComponentEventListener & Serializable)event -> {
                boolean isCustom = event.getSelectedTab().getLabel().equals(this.controller.getMessage("Custom", new Object[0]));
                this.endpoint.setUsingCustomUrl(isCustom);
                this.checkCompletion();
                if (event.isFromClient()) {
                    this.updateUrl();
                    if (isCustom) {
                        this.highlightUrl();
                    }
                }
            });
            if (!this.isFirst && this.endpoint.equals(this.canvas.getFirstEndpoint())) {
                this.endpointType.setVisible(false);
                HorizontalLayout multiPrimaryInfoLayout = ConfigCanvas.createInfoLayout(this.controller.getMessage("This is multi-primary replication where all '%s' endpoints have matching tables and data.", this.endpoint.getId()));
                multiPrimaryInfoLayout.getStyle().set("margin-top", "16px");
                this.detailsLayout.add(new Component[]{multiPrimaryInfoLayout});
                this.detailsLayout.setVisible(true);
            } else {
                this.endpointType.setVisible(true);
                this.detailsLayout.add(new Component[]{this.displayName, this.connectionFailedLayout, this.detailsTabSheet});
                this.detailsLayout.setVisible(this.endpointType.getValue() != null);
            }
            this.updateOriginalDetails();
            if (this.originalEndpointType != null) {
                this.endpointType.setValue((Object)this.originalEndpointType);
                this.updateBasicTabEnabled(this.originalEndpointType);
            }
            if (this.originalDisplayName != null) {
                this.displayName.setValue(this.originalDisplayName);
            }
            this.updateConnectionFailedLayout(!this.originalConnectionSuccessful && this.originalEndpointType != null, this.originalExceptionMessage);
            if (this.originalHost != null) {
                this.host.setValue(this.originalHost);
            }
            if (this.originalPort != null) {
                this.port.setValue(this.originalPort);
            }
            if (this.originalDatabaseName != null) {
                this.databaseName.setValue(this.originalDatabaseName);
            }
            if (this.originalEndpointType != null && this.originalEndpointType.equals(s.ORACLE)) {
                this.databaseNameOptions.setValue((Object)this.controller.getMessage(Boolean.TRUE.equals(this.originalUseOracleServiceName) ? "Service Name" : "System ID (SID)", new Object[0]));
            }
            if (this.endpoint.isUsingCustomUrl()) {
                this.detailsTabSheet.setSelectedIndex(1);
                if (this.originalUrl != null) {
                    this.url.setValue(this.originalUrl);
                }
            }
            if (this.originalUserId != null) {
                this.basicUserId.setValue(this.originalUserId);
                this.customUserId.setValue(this.originalUserId);
            }
            if (this.originalPassword != null) {
                this.basicPassword.setValue(this.originalPassword);
                this.customPassword.setValue(this.originalPassword);
            }
            if (this.originalEndpointType != null && (this.originalEndpointType.equals(s.SQL_SERVER) || this.originalEndpointType.equals(s.SQL_SERVER_AZURE)) && this.originalUrl != null && this.originalUrl.contains(";integratedSecurity=true") && StringUtils.isBlank((CharSequence)this.originalUserId) && StringUtils.isBlank((CharSequence)this.originalPassword)) {
                this.basicAuthentication.setValue((Object)this.controller.getMessage("Windows", new Object[0]));
                this.customAuthentication.setValue((Object)this.controller.getMessage("Windows", new Object[0]));
                this.toggleWindowsAuthentication(true, false);
            }
            if (this.originalEndpointType != null && this.originalEndpointType.equals(s.BIGQUERY)) {
                this.bigQueryLocation.setValue(this.endpoint.getAdvancedProperty("google.bigquery.location", ""));
                this.bigQueryProjectId.setValue(this.endpoint.getAdvancedProperty("google.bigquery.project.id", ""));
                this.bigQuerySecurityPath.setValue(this.endpoint.getAdvancedProperty("google.bigquery.security.credentials.path", ""));
            }
            this.checkCompletion();
            if (this.endpoint.isDeployed() || this.endpoint.isRemote() || this.readOnly) {
                this.endpointType.setEnabled(false);
                this.displayName.setEnabled(false);
                this.host.setEnabled(false);
                this.port.setEnabled(false);
                this.databaseName.setEnabled(false);
                this.databaseNameOptions.setEnabled(false);
                this.basicAuthentication.setEnabled(false);
                this.basicUserId.setEnabled(false);
                this.basicPassword.setEnabled(false);
                this.url.setEnabled(false);
                this.customAuthentication.setEnabled(false);
                this.bigQueryLocation.setEnabled(false);
                this.bigQueryProjectId.setEnabled(false);
                this.bigQuerySecurityPath.setEnabled(false);
                this.customUserId.setEnabled(false);
                this.customPassword.setEnabled(false);
                this.detailsTabSheet.getTabAt(0).setEnabled(false);
                this.detailsTabSheet.getTabAt(1).setEnabled(false);
            } else if (this.originalEndpointType == null) {
                this.openComboBox();
            }
        }
    }

    private void disableAutofill(TextFieldBase<?, ?> field) {
        field.addAttachListener((ComponentEventListener & Serializable)event -> UI.getCurrent().getPage().executeJs("$0.setAttribute('autocomplete', 'one-time-code')", new Serializable[]{field.getElement()}));
    }

    private void updateOriginalDetails() {
        this.originalEndpointType = this.endpoint.getType();
        this.originalDisplayName = this.endpoint.getId();
        this.originalPlatform = this.endpoint.getDatabasePlatform(false);
        this.previousConnectionSuccessful = this.originalConnectionSuccessful = this.endpoint.isConnectionSuccessful();
        this.originalExceptionMessage = this.endpoint.getExceptionMessage();
        this.originalEndpointDetailsChanged = this.endpoint.endpointDetailsChanged();
        this.originalHost = this.endpoint.getHost();
        this.originalPort = this.endpoint.getPort();
        this.originalDatabaseName = this.endpoint.getDatabaseName();
        this.originalUseOracleServiceName = this.endpoint.isUseOracleServiceName();
        this.originalUrl = this.endpoint.getUrl();
        this.originalUserId = this.endpoint.getUserId();
        this.originalPassword = this.endpoint.getPassword();
        if (this.originalEndpointType != null && this.originalEndpointType.equals(s.BIGQUERY)) {
            this.originalBigQueryLocation = this.endpoint.getAdvancedProperty("google.bigquery.location");
            this.originalBigQueryProjectId = this.endpoint.getAdvancedProperty("google.bigquery.project.id");
            this.originalBigQuerySecurityPath = this.endpoint.getAdvancedProperty("google.bigquery.security.credentials.path");
        }
    }

    private void updateEndpointTypes(boolean hideWriteOnly) {
        ComboBox.ItemFilter & Serializable typeFilter = (ComboBox.ItemFilter & Serializable)(type, filter) -> !CommonUiUtils.isFilteredOut((String)type.toString(), (String)filter);
        s.a selectedType = (s.a)this.endpointType.getValue();
        ArrayList<s.a> typeList = new ArrayList<s.a>();
        if (hideWriteOnly) {
            for (s.a type2 : s.databaseModuleIds.keySet()) {
                if (type2.isWriteOnly()) continue;
                typeList.add(type2);
            }
        } else {
            typeList.addAll(s.databaseModuleIds.keySet());
        }
        typeList.sort((i0, i1) -> i0.getName().toLowerCase().compareTo(i1.getName().toLowerCase()));
        this.endpointType.setItems((ComboBox.ItemFilter)typeFilter, typeList);
        this.endpointType.setValue((Object)selectedType);
    }

    private void updateConnectionFailedLayout(boolean visible, String exceptionMessage) {
        if (StringUtils.isNotBlank((CharSequence)exceptionMessage)) {
            this.connectionFailedSpan.setText(this.controller.getMessage("Endpoint connection failed: %s", this.originalExceptionMessage));
        } else {
            this.connectionFailedSpan.setText(this.controller.getMessage("Endpoint connection failed", new Object[0]));
        }
        this.connectionFailedLayout.setVisible(visible);
    }

    private void checkCompletion() {
        boolean complete = this.isComplete();
        this.canvas.getNextButton().setEnabled(complete);
        this.canvas.setNextButtonTooltip(this.controller.getMessage(complete ? "Save any changes and proceed to the next screen" : "This endpoint's details are incomplete", new Object[0]));
        if (this.testConnectionButton != null) {
            this.testConnectionButton.setEnabled(complete);
            this.testConnectionTooltip.setText(complete ? "Test this endpoint's connection without saving any changes" : "This endpoint's details are incomplete");
        }
    }

    private boolean isComplete() {
        boolean complete;
        boolean bl2 = complete = this.endpoint != null && this.endpointType.getValue() != null && StringUtils.isNotBlank((CharSequence)this.displayName.getValue()) && !this.displayName.isInvalid();
        if (this.endpoint != null && this.endpoint.isUsingCustomUrl()) {
            complete &= this.url != null && StringUtils.isNotBlank((CharSequence)this.url.getValue());
        }
        return complete;
    }

    private void toggleWindowsAuthentication(boolean enabled, boolean updateUrl) {
        this.basicUserId.setVisible(!enabled);
        this.basicPassword.setVisible(!enabled);
        this.customUserId.setVisible(!enabled);
        this.customPassword.setVisible(!enabled);
        if (enabled) {
            if (updateUrl) {
                this.url.setValue(this.url.getValue() + ";integratedSecurity=true");
            }
            this.basicUserId.clear();
            this.basicPassword.clear();
            this.customUserId.clear();
            this.customPassword.clear();
        } else if (updateUrl) {
            this.url.setValue(this.url.getValue().replaceAll(";integratedSecurity=true", ""));
        }
    }

    private void updateUrl() {
        s.a type = this.endpoint.getType();
        if (type != null) {
            String databaseName;
            String host;
            Object sampleUrl = type.equals(s.ORACLE) && Boolean.TRUE.equals(this.endpoint.isUseOracleServiceName()) ? "jdbc:oracle:thin:@//127.0.0.1:1521/databasename" : s.databaseToSampleUrlMap.get(type);
            String portString = this.endpoint.getPort();
            if (StringUtils.isNotBlank((CharSequence)portString)) {
                if (((String)sampleUrl).contains("localhost") && !((String)sampleUrl).contains("localhost:")) {
                    sampleUrl = ((String)sampleUrl).replaceFirst("localhost", "localhost:" + portString);
                } else {
                    String defaultPort = s.databaseToDefaultPortMap.get(type);
                    sampleUrl = ((String)sampleUrl).replaceFirst(":" + defaultPort, ":" + portString);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(host = this.endpoint.getHost()))) {
                sampleUrl = ((String)sampleUrl).replaceFirst("localhost", host);
                sampleUrl = ((String)sampleUrl).replaceFirst("127.0.0.1", host);
                sampleUrl = ((String)sampleUrl).replaceFirst("endpoint", host);
            }
            if (StringUtils.isNotBlank((CharSequence)(databaseName = this.endpoint.getDatabaseName()))) {
                sampleUrl = ((String)sampleUrl).contains("databasename=databasename") ? ((String)sampleUrl).replace("databasename=databasename", "databasename=" + databaseName) : ((String)sampleUrl).replace("databasename", databaseName);
            }
            if (type.equals(s.SQL_SERVER) || type.equals(s.SQL_SERVER_AZURE)) {
                if (((String)this.basicAuthentication.getValue()).equals(this.controller.getMessage("Windows", new Object[0]))) {
                    sampleUrl = (String)sampleUrl + ";integratedSecurity=true";
                }
            } else if (type.equals(s.RABBITMQ)) {
                String password;
                String userId = this.endpoint.getUserId();
                if (StringUtils.isNotBlank((CharSequence)userId)) {
                    sampleUrl = ((String)sampleUrl).replaceFirst("guest", userId);
                }
                if (StringUtils.isNotBlank((CharSequence)(password = this.endpoint.getPassword()))) {
                    sampleUrl = ((String)sampleUrl).replaceFirst(":guest", password);
                }
            }
            this.url.setValue((String)sampleUrl);
        }
    }

    @Override
    public void addComponentsToFooter(HorizontalLayout footer) {
        if (!(this.canvas.isInitialSetup() || this.canvas.isAddingNewReplication() || this.endpoint.isDeployed() || this.endpoint.isRemote() && this.endpoint.getUrl() == null)) {
            this.testConnectionButton = new Button(this.controller.getMessage("Test Connection", new Object[0]), (ComponentEventListener & Serializable)event -> new M<Object>(this.controller.getMessage("Testing connection...", new Object[0]), new M.a<Object>(){

                @Override
                public Object doWork() {
                    return null;
                }

                @Override
                public void doUI(Object data) {
                    DefineEndpointScreen.this.endpointDetailsChanged |= DefineEndpointScreen.this.endpoint.endpointDetailsChanged();
                    DefineEndpointScreen.this.testConnection(true, true, false);
                    DefineEndpointScreen.this.redrawDiagramIfNecessary();
                    DefineEndpointScreen.this.updateConnectionFailedLayout(!DefineEndpointScreen.this.endpoint.isConnectionSuccessful(), DefineEndpointScreen.this.endpoint.getExceptionMessage());
                }
            }, this.controller.getBackgroundRefresherService(), null, false, false).show());
            Div testConnectionDiv = new Div(new Component[]{this.testConnectionButton});
            testConnectionDiv.getStyle().set("margin-right", "16px");
            this.testConnectionTooltip = Tooltip.forComponent((Component)testConnectionDiv);
            Button cancelButton = new Button(this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.onCloseIconClick());
            cancelButton.getStyle().set("margin-right", "16px");
            cancelButton.setTooltipText(this.controller.getMessage("Discard any unsaved changes and close the sidebar", new Object[0]));
            footer.add(new Component[]{testConnectionDiv, cancelButton});
            if (!this.endpoint.isRemote()) {
                Button okButton = new Button(this.controller.getMessage("OK", new Object[0]), (ComponentEventListener & Serializable)event -> {
                    this.endpoint.setVisitedDefineEndpointScreen(true);
                    this.canvas.closeSidebarAndClearSelection(false, false);
                    if (this.endpointDetailsChanged || this.endpoint.endpointDetailsChanged()) {
                        this.removeTablesIfNecessary(null);
                        this.resetTables();
                    } else {
                        this.canvas.redrawDiagram();
                    }
                });
                okButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
                okButton.setTooltipText(this.controller.getMessage("Save any changes and close the sidebar", new Object[0]));
                footer.add(new Component[]{okButton});
            }
            boolean complete = this.isComplete();
            this.testConnectionButton.setEnabled(complete);
            this.testConnectionTooltip.setText(complete ? "Test this endpoint's connection without saving any changes" : "This endpoint's details are incomplete");
        }
    }

    private boolean testConnection(boolean force, boolean notify, boolean callNext) {
        this.notifyAboutExistingInstallation |= !this.endpoint.isConnectionSuccessful();
        if (this.endpoint.endpointDetailsChanged()) {
            this.endpoint.setConnectionSuccessful(false);
            this.endpoint.setDatabasePlatform(null);
            this.endpoint.setExceptionMessage(null);
        }
        if (!this.endpoint.isConnectionSuccessful() || force) {
            if (this.url.isEmpty() && this.detailsTabSheet.getTabAt(0).isSelected()) {
                this.updateUrl();
            }
            boolean notifyOnSuccess = force && notify;
            String exceptionMessage = s.testConnection(this.controller, (s.a)this.endpointType.getValue(), this.url, this.endpoint.getUserId(), this.endpoint.getPassword(), callNext ? (Command & Serializable)() -> this.next() : null, null, false, notify, notify, true);
            this.endpoint.setExceptionMessage(exceptionMessage);
            if (exceptionMessage == null) {
                this.endpoint.setConnectionSuccessful(true);
                if (notifyOnSuccess) {
                    if (this.notifyAboutExistingInstallation && this.endpointType.isEnabled() && this.endpoint.getDatabasePlatform().getTableFromCache("sym_node", false) != null) {
                        String description = this.controller.getMessage("Successfully connected to the database", new Object[0]) + ". " + this.controller.getMessage("SymmetricDS is already installed on the '%s' endpoint. During deployment, if you choose this as the runtime database, any existing configuration will be overwritten.", this.endpoint.getId());
                        new SymmetricDetectedDialog(description).open();
                        this.notifyAboutExistingInstallation = false;
                    } else {
                        CommonUiUtils.notify((String)this.controller.getMessage("Successfully connected to the database", new Object[0]));
                    }
                }
            } else {
                this.endpoint.setConnectionSuccessful(false);
            }
            if (this.previousConnectionSuccessful != this.endpoint.isConnectionSuccessful()) {
                this.redrawDiagram = true;
            }
            this.previousConnectionSuccessful = this.endpoint.isConnectionSuccessful();
            return this.endpoint.isConnectionSuccessful();
        }
        return true;
    }

    private void redrawDiagramIfNecessary() {
        if (this.redrawDiagram) {
            this.canvas.refreshEndpoints();
            this.canvas.redrawDiagram();
            this.redrawDiagram = false;
        }
    }

    @Override
    public void onAttach(AttachEvent event) {
        super.onAttach(event);
        this.canvas.setSelectedEndpoint(this.endpoint, true);
        if (!event.isInitialAttach()) {
            if (this.isFirst && this.canvas.getSecondEndpoint() != null) {
                this.updateEndpointList(null);
                s.a secondType = this.canvas.getSecondEndpoint().getType();
                this.updateEndpointTypes(secondType != null ? secondType.isWriteOnly() : false);
            }
            this.canvas.updateSidebarHeader();
        }
    }

    private void openComboBox() {
        if (this.endpointType != null && this.endpointType.isVisible() && this.endpointType.isEmpty()) {
            this.endpointType.getElement().executeJs("setTimeout(() => this.opened = true, 0);", new Serializable[0]);
        } else if (this.endpointComboBox != null && this.endpointComboBox.isEmpty()) {
            this.endpointComboBox.getElement().executeJs("setTimeout(() => this.opened = true, 0);", new Serializable[0]);
        }
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public boolean hasNextButtonBeenClicked() {
        return this.hasNextButtonBeenClicked;
    }

    @Override
    public int getProgressStepperIndex() {
        return this.isFirst ? 0 : 1;
    }

    @Override
    public boolean isNextEnabled() {
        return this.isComplete();
    }

    @Override
    public boolean isPreviousEnabled() {
        return !this.isFirst;
    }

    @Override
    public boolean isPreviousVisible() {
        return !this.isFirst;
    }

    @Override
    public ISidebarScreen next() {
        this.endpoint.setVisitedDefineEndpointScreen(true);
        if (this.endpointType.isEnabled() && (this.isFirst || !this.endpoint.equals(this.canvas.getFirstEndpoint()))) {
            new M<Object>(this.getVerificationMessage(), new M.a<Object>(){

                @Override
                public Object doWork() {
                    DefineEndpointScreen.this.endpointDetailsChanged |= DefineEndpointScreen.this.endpoint.endpointDetailsChanged();
                    if (DefineEndpointScreen.this.endpointDetailsChanged) {
                        DefineEndpointScreen.this.resetTables();
                    }
                    return null;
                }

                @Override
                public void doUI(Object data) {
                    boolean connectionSuccessful = DefineEndpointScreen.this.testConnection(false, true, true);
                    DefineEndpointScreen.this.redrawDiagramIfNecessary();
                    if (connectionSuccessful) {
                        DefineEndpointScreen.this.endpoint.setEndpointDetailsChanged(false);
                        DefineEndpointScreen.this.canvas.getProgressStepper().setStepComplete(DefineEndpointScreen.this.getProgressStepperIndex());
                        if (DefineEndpointScreen.this.notifyAboutExistingInstallation && DefineEndpointScreen.this.endpoint.getDatabasePlatform().getTableFromCache("sym_node", false) != null) {
                            new SymmetricDetectedDialog(DefineEndpointScreen.this.controller.getMessage("SymmetricDS is already installed on the '%s' endpoint. During deployment, if you choose this as the runtime database, any existing configuration will be overwritten.", DefineEndpointScreen.this.endpoint.getId())).open();
                            DefineEndpointScreen.this.notifyAboutExistingInstallation = false;
                        }
                        if (DefineEndpointScreen.this.isFirst) {
                            if (DefineEndpointScreen.this.secondDefineEndpointScreen == null) {
                                DefineEndpointScreen.this.secondDefineEndpointScreen = new DefineEndpointScreen(DefineEndpointScreen.this.controller, DefineEndpointScreen.this.canvas, false);
                            }
                            DefineEndpointScreen.this.canvas.nextScreen(DefineEndpointScreen.this.secondDefineEndpointScreen);
                        } else {
                            DefineEndpointScreen.this.canvas.nextScreen(new SelectTablesScreen(DefineEndpointScreen.this.controller, DefineEndpointScreen.this.canvas));
                        }
                        DefineEndpointScreen.this.updateOriginalDetails();
                        DefineEndpointScreen.this.hasNextButtonBeenClicked = true;
                    }
                }
            }, this.controller.getBackgroundRefresherService(), null, false, false).show();
        } else {
            this.redrawDiagramIfNecessary();
            this.canvas.getProgressStepper().setStepComplete(this.getProgressStepperIndex());
            if (this.isFirst) {
                if (this.secondDefineEndpointScreen == null) {
                    this.secondDefineEndpointScreen = new DefineEndpointScreen(this.controller, this.canvas, false);
                }
                this.canvas.nextScreen(this.secondDefineEndpointScreen);
            } else {
                this.canvas.nextScreen(new SelectTablesScreen(this.controller, this.canvas));
            }
            this.hasNextButtonBeenClicked = true;
        }
        return null;
    }

    private String getVerificationMessage() {
        return this.controller.getMessage(this.endpoint.areAnyTablesConfigured() ? "Verifying configuration..." : "Testing connection...", new Object[0]);
    }

    private void resetTables() {
        this.endpoint.clearTableCache();
        this.endpoint.setSourceTablesExist(null);
    }

    @Override
    public boolean last() {
        this.canvas.getProgressStepper().setStepComplete(this.getProgressStepperIndex());
        this.canvas.redrawDiagram();
        return true;
    }

    @Override
    public void onCloseIconClick() {
        if (this.endpoint != null) {
            this.endpoint.setVisitedDefineEndpointScreen(true);
        }
        if (this.secondDefineEndpointScreen != null) {
            this.secondDefineEndpointScreen.discardChanges(false, true, false);
            if (this.secondDefineEndpointScreen.endpoint != null) {
                this.secondDefineEndpointScreen.endpoint.setVisitedDefineEndpointScreen(true);
            }
        }
        this.discardChanges(true, true, true);
    }

    private void discardChanges(boolean closeSidebarAndClearSelection, boolean deleteIfNecessary, boolean refreshCanvas) {
        if (this.endpoint != null && this.displayName.isEnabled() && !Strings.CS.equals(this.endpoint.getId(), this.originalDisplayName)) {
            this.endpoint.setId(this.originalDisplayName);
            for (ConfigCanvasEndpoint otherEndpoint : this.canvas.getEndpointList()) {
                ConfigCanvasLink link = otherEndpoint.getLink(this.endpoint.getGuid());
                if (link == null) continue;
                link.setTargetEndpointId(this.originalDisplayName);
            }
            this.canvas.getProgressStepper().setStepName(this.isFirst ? 0 : 1, this.originalDisplayName);
        }
        if (closeSidebarAndClearSelection) {
            this.canvas.closeSidebarAndClearSelection(false, false);
        }
        if (this.endpoint != null && this.endpointType.isEnabled()) {
            this.endpoint.setType(this.originalEndpointType);
            this.endpoint.setHost(this.originalHost);
            this.endpoint.setPort(this.originalPort);
            this.endpoint.setDatabaseName(this.originalDatabaseName);
            this.endpoint.setUseOracleServiceName(this.originalUseOracleServiceName);
            this.endpoint.setUserId(this.originalUserId);
            this.endpoint.setPassword(this.originalPassword);
            this.endpoint.setUrl(this.originalUrl);
            if (this.originalEndpointType != null && this.originalEndpointType.equals(s.BIGQUERY)) {
                this.endpoint.setAdvancedProperty("google.bigquery.location", this.originalBigQueryLocation);
                this.endpoint.setAdvancedProperty("google.bigquery.project.id", this.originalBigQueryProjectId);
                this.endpoint.setAdvancedProperty("google.bigquery.security.credentials.path", this.originalBigQuerySecurityPath);
            }
            this.endpoint.setDatabasePlatform(this.originalPlatform);
            this.endpoint.setDefaultCatalog(null);
            this.endpoint.setDefaultSchema(null);
            this.endpoint.setConnectionSuccessful(this.originalConnectionSuccessful);
            this.endpoint.setExceptionMessage(this.originalExceptionMessage);
            this.endpoint.setEndpointDetailsChanged(this.originalEndpointDetailsChanged);
        }
        if (deleteIfNecessary && !this.hasNextButtonBeenClicked && this.endpointComboBox != null && this.canvas.getEndpointList().size() > 2) {
            this.deleteEndpointOrLink((String)this.endpointComboBox.getValue());
        }
        if (refreshCanvas) {
            this.canvas.refreshEndpoints();
            this.canvas.redrawDiagram();
        }
    }

    @Override
    public void onClose(boolean endpointDeleted, Command callback) {
        boolean displayNameChanged;
        if (this.endpoint != null) {
            this.endpoint.setVisitedDefineEndpointScreen(true);
        }
        boolean bl2 = displayNameChanged = this.endpoint != null && this.endpoint.isRenamable() && !this.endpoint.getId().equals(this.originalDisplayName);
        if (!(this.endpoint == null || this.endpoint.isDeployed() || this.endpoint.isRemote() && !displayNameChanged)) {
            this.endpointDetailsChanged |= this.endpoint.endpointDetailsChanged();
            if (endpointDeleted || !this.endpointDetailsChanged && !displayNameChanged || !this.endpointType.isEnabled()) {
                super.onClose(endpointDeleted, callback);
            } else {
                ConfirmDialog confirmSaveDialog = new ConfirmDialog(this.controller.getMessage("Unsaved Changes", new Object[0]), this.controller.getMessage("The Define Endpoint sidebar has unsaved changes. Would you like to save these changes or discard them?", new Object[0]), this.controller.getMessage("Save", new Object[0]), (ComponentEventListener & Serializable)event -> {
                    if (this.endpointDetailsChanged) {
                        this.removeTablesIfNecessary(callback);
                        this.resetTables();
                    } else {
                        if (callback != null) {
                            callback.execute();
                        }
                        this.canvas.redrawDiagram();
                    }
                });
                Button discardButton = new Button(this.controller.getMessage("Discard", new Object[0]));
                discardButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
                discardButton.getStyle().set("margin-right", "16px");
                confirmSaveDialog.setRejectable(true);
                confirmSaveDialog.setRejectButton((Component)discardButton);
                confirmSaveDialog.addRejectListener((ComponentEventListener & Serializable)event -> {
                    this.discardChanges(false, true, true);
                    if (callback != null) {
                        callback.execute();
                    }
                });
                confirmSaveDialog.open();
            }
        } else if (callback != null) {
            callback.execute();
        }
    }

    private void removeTablesIfNecessary(final Command callback) {
        if (this.endpoint != null && this.endpointType.isEnabled() && (this.endpointDetailsChanged || this.endpoint.endpointDetailsChanged())) {
            new M<Boolean>(this.getVerificationMessage(), new M.a<Boolean>(){

                @Override
                public Boolean doWork() {
                    String endpointGuid = DefineEndpointScreen.this.endpoint.getGuid();
                    if (DefineEndpointScreen.this.endpointType.getValue() != null && DefineEndpointScreen.this.testConnection(false, false, false)) {
                        DefineEndpointScreen.this.endpoint.setEndpointDetailsChanged(false);
                        if (DefineEndpointScreen.this.endpoint.isWriteOnly()) {
                            Set writeOnlyEndpointSet = DefineEndpointScreen.this.canvas.getEndpointList().stream().filter(endpoint -> endpoint.isWriteOnly()).collect(Collectors.toSet());
                            for (ConfigCanvasEndpoint writeOnlyEndpoint : writeOnlyEndpointSet) {
                                DefineEndpointScreen.this.endpoint.removeLink(writeOnlyEndpoint.getGuid());
                                writeOnlyEndpoint.removeLink(endpointGuid);
                            }
                        }
                        return true;
                    }
                    return false;
                }

                @Override
                public void doUI(Boolean connectionSuccessful) {
                    Command & Serializable callbackWrapper = (Command & Serializable)() -> {
                        if (callback != null) {
                            callback.execute();
                        }
                        DefineEndpointScreen.this.canvas.refreshEndpoints();
                        DefineEndpointScreen.this.canvas.redrawDiagram();
                        DefineEndpointScreen.this.redrawDiagram = false;
                    };
                    if (!connectionSuccessful.booleanValue()) {
                        if (DefineEndpointScreen.this.canvas.isInitialSetup() || DefineEndpointScreen.this.canvas.isAddingNewReplication()) {
                            DefineEndpointScreen.this.canvas.getProgressStepper().setStepInactive(2);
                            DefineEndpointScreen.this.canvas.getProgressStepper().setStepInactive(3);
                            DefineEndpointScreen.this.canvas.getProgressStepper().setStepInactive(4);
                        }
                        callbackWrapper.execute();
                    } else if (DefineEndpointScreen.this.notifyAboutExistingInstallation && DefineEndpointScreen.this.endpointType.isEnabled() && DefineEndpointScreen.this.endpoint.getDatabasePlatform() != null && DefineEndpointScreen.this.endpoint.getDatabasePlatform().getTableFromCache("sym_node", false) != null) {
                        new SymmetricDetectedDialog(DefineEndpointScreen.this.controller.getMessage("SymmetricDS is already installed on the '%s' endpoint. During deployment, if you choose this as the runtime database, any existing configuration will be overwritten.", DefineEndpointScreen.this.endpoint.getId()), callbackWrapper, true).open();
                        DefineEndpointScreen.this.notifyAboutExistingInstallation = false;
                    } else {
                        callbackWrapper.execute();
                    }
                }
            }, this.controller.getBackgroundRefresherService()).show();
        } else {
            if (callback != null) {
                callback.execute();
            }
            this.redrawDiagram = false;
        }
    }

    @Override
    public String getNextButtonTooltip() {
        return this.controller.getMessage(this.isNextEnabled() ? "Save any changes and proceed to the next screen" : "This endpoint's details are incomplete", new Object[0]);
    }

    @Override
    public String getPreviousButtonTooltip() {
        return this.controller.getMessage("Save any changes and go back to the previous screen", new Object[0]);
    }

    @Override
    public String getCloseIconTooltip() {
        return this.controller.getMessage("Discard any unsaved changes and close the sidebar", new Object[0]);
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_connect_to_the_first_endpoint";
    }

    class SymmetricDetectedDialog
    extends X {
        private static final long serialVersionUID = 1L;

        public SymmetricDetectedDialog(String description) {
            this(description, null, true);
        }

        public SymmetricDetectedDialog(String description, Command callback, boolean openComboBoxIfNecessary) {
            super(DefineEndpointScreen.this.controller.getMessage("Found Existing Installation", new Object[0]), DefineEndpointScreen.this.controller.getContextPath());
            this.setWidth("500px");
            this.setModal(false);
            this.setCloseOnEsc(false);
            this.setCloseOnOutsideClick(false);
            this.addClassNames(new String[]{"show-backdrop", "show-in-foreground"});
            this.mainLayout.add(new Component[]{new Span(description)});
            this.getFooter().add(new Component[]{as.createPrimaryButton(DefineEndpointScreen.this.controller.getMessage("OK", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
                this.close();
                if (callback != null) {
                    callback.execute();
                }
                if (openComboBoxIfNecessary && DefineEndpointScreen.this.secondDefineEndpointScreen != null) {
                    DefineEndpointScreen.this.secondDefineEndpointScreen.openComboBox();
                }
            }, false)});
        }
    }
}

