/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;

public class ConfigCanvasTable {
    private String triggerId;
    private String catalog;
    private String schema;
    private String name;
    private String targetCatalog;
    private String targetSchema;
    private transient ArrayList<ConfigCanvasColumn> columns = new ArrayList();
    private transient ArrayList<ConfigCanvasForeignKey> foreignKeys = new ArrayList();
    private boolean skippedForeignKeyCheck;
    private Boolean sourceTableExists;
    private transient boolean removed;

    public ConfigCanvasTable() {
    }

    public ConfigCanvasTable(String catalog, String schema, String name) {
        this(catalog, schema, name, null, null);
    }

    public ConfigCanvasTable(String catalog, String schema, String name, String targetCatalog, String targetSchema) {
        this.catalog = catalog;
        this.schema = schema;
        this.name = name;
        this.targetCatalog = targetCatalog;
        this.targetSchema = targetSchema;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public String getFullyQualifiedSourceTableName() {
        return Table.getFullyQualifiedTableName((String)this.catalog, (String)this.schema, (String)this.name);
    }

    public String getFullyQualifiedTargetTableName() {
        return Table.getFullyQualifiedTableName((String)this.targetCatalog, (String)this.targetSchema, (String)this.name);
    }

    public String getTargetCatalog() {
        return this.targetCatalog;
    }

    public void setTargetCatalog(String targetCatalog) {
        this.targetCatalog = targetCatalog;
    }

    public String getTargetSchema() {
        return this.targetSchema;
    }

    public void setTargetSchema(String targetSchema) {
        this.targetSchema = targetSchema;
    }

    public List<String> getColumnNames() {
        return this.columns.stream().map(c2 -> c2.getName()).collect(Collectors.toList());
    }

    public List<String> getPrimaryKeyColumnNames() {
        return this.columns.stream().filter(c2 -> c2.isPrimaryKey()).map(c2 -> c2.getName()).collect(Collectors.toList());
    }

    public boolean hasColumnWithName(String name) {
        return this.columns.stream().anyMatch(c2 -> c2.getName().equals(name));
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public void addColumn(String name, boolean pk) {
        this.columns.add(new ConfigCanvasColumn(name, pk));
    }

    public void addColumns(Collection<Column> columns) {
        for (Column column : columns) {
            this.columns.add(new ConfigCanvasColumn(column.getName(), column.isPrimaryKey()));
        }
    }

    public void removeAllColumns() {
        this.columns.clear();
    }

    public List<ConfigCanvasForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public void addForeignKeys(ForeignKey[] foreignKeys) {
        for (ForeignKey foreignKey : foreignKeys) {
            this.foreignKeys.add(new ConfigCanvasForeignKey(foreignKey));
        }
    }

    public void removeAllForeignKeys() {
        this.foreignKeys.clear();
    }

    public boolean isSkippedForeignKeyCheck() {
        return this.skippedForeignKeyCheck;
    }

    public void setSkippedForeignKeyCheck(boolean skippedForeignKeyCheck) {
        this.skippedForeignKeyCheck = skippedForeignKeyCheck;
    }

    public Boolean getSourceTableExists() {
        return this.sourceTableExists;
    }

    public void setSourceTableExists(Boolean sourceTableExists) {
        this.sourceTableExists = sourceTableExists;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConfigCanvasTable) {
            ConfigCanvasTable other = (ConfigCanvasTable)obj;
            return new EqualsBuilder().append((Object)this.catalog, (Object)other.catalog).append((Object)this.schema, (Object)other.schema).append((Object)this.name, (Object)other.name).append(this.columns, other.columns).append(new HashSet<ConfigCanvasForeignKey>(this.foreignKeys), new HashSet<ConfigCanvasForeignKey>(other.foreignKeys)).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.catalog).append((Object)this.schema).append(this.columns).append(new HashSet<ConfigCanvasForeignKey>(this.foreignKeys)).toHashCode();
    }

    public class ConfigCanvasColumn {
        private String name;
        private boolean primaryKey;

        public ConfigCanvasColumn(String name, boolean primaryKey) {
            this.name = name;
            this.primaryKey = primaryKey;
        }

        public String getName() {
            return this.name;
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }
    }

    public class ConfigCanvasForeignKey {
        private String foreignTableCatalog;
        private String foreignTableSchema;
        private String foreignTableName;
        private List<ConfigCanvasReference> references = new ArrayList<ConfigCanvasReference>();

        public ConfigCanvasForeignKey(ForeignKey foreignKey) {
            this.foreignTableCatalog = foreignKey.getForeignTableCatalog();
            this.foreignTableSchema = foreignKey.getForeignTableSchema();
            this.foreignTableName = foreignKey.getForeignTableName();
            for (Reference reference : foreignKey.getReferences()) {
                this.references.add(new ConfigCanvasReference(reference.getLocalColumnName(), reference.getForeignColumnName()));
            }
        }

        public String getForeignTableCatalog() {
            return this.foreignTableCatalog;
        }

        public String getForeignTableSchema() {
            return this.foreignTableSchema;
        }

        public String getForeignTableName() {
            return this.foreignTableName;
        }

        public List<ConfigCanvasReference> getReferences() {
            return this.references;
        }

        public class ConfigCanvasReference {
            private String localColumnName;
            private String foreignColumnName;

            public ConfigCanvasReference(String localColumnName, String foreignColumnName) {
                this.localColumnName = localColumnName;
                this.foreignColumnName = foreignColumnName;
            }

            public String getLocalColumnName() {
                return this.localColumnName;
            }

            public String getForeignColumnName() {
                return this.foreignColumnName;
            }
        }
    }
}

