/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasEndpoint;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class ConfigCanvasSourceToTargetLayout
extends HorizontalLayout {
    private static final long serialVersionUID = 1L;
    protected I controller;
    protected Icon arrowIcon;
    protected Select<String> sourceCatalogSelect;
    protected Select<String> sourceSchemaSelect;
    protected FormLayout sourceCatalogSchemaLayout;
    protected Select<String> targetCatalogSelect;
    protected Select<String> targetSchemaSelect;
    protected FormLayout targetCatalogSchemaLayout;
    protected Checkbox matchSource;
    protected TextField sourceFilterField = new TextField();
    protected HorizontalLayout sourceFilterLayout = new HorizontalLayout();
    protected TextField targetFilterField = new TextField();
    protected HorizontalLayout targetFilterLayout = new HorizontalLayout();

    public ConfigCanvasSourceToTargetLayout(I controller, ConfigCanvasEndpoint sourceEndpoint, ConfigCanvasEndpoint targetEndpoint, String sourceHeader, String targetHeader, boolean showSourceCatalogSchema, boolean showTargetCatalogSchema, boolean showMatchCatalogSchemaCheckbox) {
        this.controller = controller;
        this.setWidthFull();
        this.setMargin(false);
        VerticalLayout sourceLayout = this.createLayout(true, sourceEndpoint, sourceHeader, showSourceCatalogSchema, false);
        VerticalLayout targetLayout = this.createLayout(false, targetEndpoint, targetHeader, showTargetCatalogSchema, showMatchCatalogSchemaCheckbox);
        if (sourceEndpoint != null && targetEndpoint != null) {
            this.arrowIcon = new Icon(VaadinIcon.ARROW_RIGHT);
            this.arrowIcon.setSize("40px");
            this.arrowIcon.addClassName("less-contrast");
            this.arrowIcon.getStyle().set("margin-top", this.areSourceCatalogSchemaFieldsVisible() ? "125px" : "70px");
            this.add(new Component[]{sourceLayout, this.arrowIcon, targetLayout});
        } else {
            Span spacer = new Span();
            spacer.setWidth("90px");
            spacer.getStyle().set("min-width", "90px");
            this.add(new Component[]{sourceLayout, spacer, targetLayout});
        }
        this.expand(new Component[]{sourceLayout, targetLayout});
    }

    private VerticalLayout createLayout(boolean source, ConfigCanvasEndpoint endpoint, String header, boolean showCatalogSchema, boolean showMatchCatalogSchemaCheckbox) {
        VerticalLayout layout = new VerticalLayout();
        H4 headerLayout = null;
        if (endpoint != null) {
            HtmlContainer endpointIcon = as.getEndpointIcon(this.controller.getContextPath(), endpoint.getType());
            endpointIcon.getStyle().set("height", "48px").set("width", "48px");
            Span topSpan = new Span(header != null ? header : endpoint.getId());
            Span bottomSpan = new Span(header != null ? endpoint.getId() : this.controller.getMessage(source ? "Source" : "Target", new Object[0]));
            bottomSpan.addClassName("less-contrast");
            VerticalLayout endpointIdLayout = new VerticalLayout(new Component[]{topSpan, bottomSpan});
            endpointIdLayout.setPadding(false);
            endpointIdLayout.setSpacing(false);
            endpointIdLayout.setWidth(null);
            HorizontalLayout horizontalHeaderLayout = new HorizontalLayout(new Component[]{endpointIcon, endpointIdLayout});
            if (showMatchCatalogSchemaCheckbox) {
                horizontalHeaderLayout.addAndExpand(new Component[]{new Span()});
                this.matchSource = new Checkbox(this.controller.getMessage("Match Source Catalog/Schema", new Object[0]), (HasValue.ValueChangeListener & Serializable)event -> {
                    if (((Boolean)event.getValue()).booleanValue()) {
                        if (this.targetCatalogSelect.isVisible()) {
                            this.targetCatalogSelect.setValue((Object)"");
                            this.targetCatalogSelect.setEnabled(false);
                        }
                        this.targetSchemaSelect.setValue((Object)"");
                        this.targetSchemaSelect.setEnabled(false);
                    } else {
                        if (this.targetCatalogSelect.isVisible()) {
                            this.targetCatalogSelect.setEnabled(true);
                        }
                        this.targetSchemaSelect.setEnabled(true);
                    }
                });
                this.matchSource.getStyle().set("padding-top", "16px");
                horizontalHeaderLayout.add(new Component[]{this.matchSource});
                horizontalHeaderLayout.setWidthFull();
            }
            headerLayout = horizontalHeaderLayout;
        } else if (header != null) {
            headerLayout = new H4(header);
            headerLayout.addClassName("less-contrast");
            layout.setSpacing(false);
        }
        if (headerLayout != null) {
            layout.add(new Component[]{headerLayout});
        }
        if (showCatalogSchema) {
            if (source) {
                this.sourceCatalogSelect = new Select();
                this.sourceCatalogSelect.setLabel(this.controller.getMessage("Source Catalog", new Object[0]));
                this.sourceSchemaSelect = new Select();
                this.sourceSchemaSelect.setLabel(this.controller.getMessage("Source Schema", new Object[0]));
                this.sourceCatalogSchemaLayout = new FormLayout(new Component[]{this.sourceCatalogSelect, this.sourceSchemaSelect});
            } else {
                this.targetCatalogSelect = new Select();
                this.targetCatalogSelect.setLabel(this.controller.getMessage("Target Catalog", new Object[0]));
                this.targetSchemaSelect = new Select();
                this.targetSchemaSelect.setLabel(this.controller.getMessage("Target Schema", new Object[0]));
                this.targetCatalogSchemaLayout = new FormLayout(new Component[]{this.targetCatalogSelect, this.targetSchemaSelect});
            }
            FormLayout catalogSchemaLayout = source ? this.sourceCatalogSchemaLayout : this.targetCatalogSchemaLayout;
            catalogSchemaLayout.setWidthFull();
            catalogSchemaLayout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 2)});
            layout.add(new Component[]{catalogSchemaLayout});
        } else {
            layout.expand(new Component[]{headerLayout});
        }
        TextField filterField = source ? this.sourceFilterField : this.targetFilterField;
        filterField.setPrefixComponent((Component)new Icon(VaadinIcon.SEARCH));
        filterField.setPlaceholder(this.controller.getMessage("Filter Tables", new Object[0]));
        filterField.setValueChangeMode(ValueChangeMode.LAZY);
        HorizontalLayout filterLayout = source ? this.sourceFilterLayout : this.targetFilterLayout;
        filterLayout.addAndExpand(new Component[]{filterField});
        filterLayout.getStyle().set("padding-top", "16px").set("border-top", "1px solid var(--lumo-contrast-20pct)");
        layout.add(new Component[]{filterLayout});
        layout.addClassName("subtle-border");
        return layout;
    }

    public void init() {
        if (this.sourceCatalogSelect != null) {
            this.initCatalogSchemaFields(true, this.sourceCatalogSelect, this.sourceSchemaSelect);
        }
        if (this.targetCatalogSelect != null) {
            this.initCatalogSchemaFields(false, this.targetCatalogSelect, this.targetSchemaSelect);
        }
        this.initFilterField(true, this.sourceFilterField, this.sourceFilterLayout);
        this.initFilterField(false, this.targetFilterField, this.targetFilterLayout);
    }

    protected void initCatalogSchemaFields(boolean source, Select<String> catalogSelect, Select<String> schemaSelect) {
    }

    protected void initFilterField(boolean source, TextField filterField, HorizontalLayout filterLayout) {
        filterField.setValueChangeTimeout(200);
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public Select<String> getCatalogSelect(boolean source) {
        return source ? this.sourceCatalogSelect : this.targetCatalogSelect;
    }

    public String getSelectedCatalog(boolean source) {
        Select<String> catalogSelect = this.getCatalogSelect(source);
        return catalogSelect == null || !catalogSelect.isVisible() ? null : (String)StringUtils.defaultIfBlank((CharSequence)((String)catalogSelect.getValue()), null);
    }

    public Select<String> getSchemaSelect(boolean source) {
        return source ? this.sourceSchemaSelect : this.targetSchemaSelect;
    }

    public String getSelectedSchema(boolean source) {
        Select<String> schemaSelect = this.getSchemaSelect(source);
        return schemaSelect == null || !schemaSelect.isVisible() ? null : (String)StringUtils.defaultIfBlank((CharSequence)((String)schemaSelect.getValue()), null);
    }

    public FormLayout getCatalogSchemaLayout(boolean source) {
        return source ? this.sourceCatalogSchemaLayout : this.targetCatalogSchemaLayout;
    }

    public boolean areSourceCatalogSchemaFieldsVisible() {
        return this.sourceCatalogSelect != null && this.sourceCatalogSelect.isVisible() || this.sourceSchemaSelect != null && this.sourceSchemaSelect.isVisible() || this.targetCatalogSelect != null && this.targetCatalogSelect.isVisible() || this.targetSchemaSelect != null && this.targetSchemaSelect.isVisible();
    }

    public boolean isMatchSourceCatalogSchema() {
        return this.matchSource != null && (Boolean)this.matchSource.getValue() != false;
    }

    public String getFilter(boolean source) {
        return (source ? this.sourceFilterField : this.targetFilterField).getValue();
    }
}

