/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasEndpoint;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Strings;
import org.jumpmind.symmetric.Version;

public class ConfigCanvasPosition {
    private List<ConfigCanvasCoordinates> coordinatesList = new ArrayList<ConfigCanvasCoordinates>();
    private transient boolean changed;
    private String documentVersion = Version.version();
    private Date created = new Date();
    private Date modified = new Date();

    public void setGuidForId(String id, String guid) {
        for (ConfigCanvasCoordinates coords : this.coordinatesList) {
            if (!id.equals(coords.getId())) continue;
            if (!Strings.CS.equals(coords.getGuid(), guid)) {
                coords.setGuid(guid);
                this.changed = true;
            }
            return;
        }
    }

    public void setIdForGuid(String guid, String id) {
        for (ConfigCanvasCoordinates coords : this.coordinatesList) {
            if (!guid.equals(coords.getGuid())) continue;
            if (!Strings.CS.equals(coords.getId(), id)) {
                coords.setId(id);
                this.changed = true;
            }
            return;
        }
    }

    public void replaceGuidWithId(String guid, String id) {
        for (ConfigCanvasCoordinates coords : this.coordinatesList) {
            if (!guid.equals(coords.getGuid())) continue;
            coords.setId(id);
            coords.setGuid(null);
            this.changed = true;
            return;
        }
    }

    public void updateEndpointCoordinates(ConfigCanvasEndpoint endpoint) {
        String guid = endpoint.getGuid();
        String id = endpoint.getId();
        int x2 = endpoint.getX();
        int y2 = endpoint.getY();
        for (ConfigCanvasCoordinates coords : this.coordinatesList) {
            if (guid.equals(coords.getGuid())) {
                if (x2 != coords.getX() || y2 != coords.getY()) {
                    coords.setX(x2);
                    coords.setY(y2);
                    this.changed = true;
                }
                return;
            }
            if (id == null || !id.equals(coords.getId())) continue;
            if (x2 != coords.getX() || y2 != coords.getY()) {
                coords.setX(x2);
                coords.setY(y2);
                coords.setGuid(guid);
                this.changed = true;
            }
            return;
        }
        this.coordinatesList.add(new ConfigCanvasCoordinates(guid, id, endpoint.getX(), endpoint.getY()));
        this.changed = true;
    }

    public void removeEndpointCoordinates(String guid) {
        this.changed |= this.coordinatesList.removeIf(c2 -> guid.equals(c2.getGuid()));
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public List<ConfigCanvasCoordinates> getCoordinatesList() {
        return this.coordinatesList;
    }

    public class ConfigCanvasCoordinates {
        private String guid;
        private String id;
        private int x;
        private int y;

        public ConfigCanvasCoordinates(String guid, String id, int x2, int y2) {
            this.guid = guid;
            this.id = id;
            this.x = x2;
            this.y = y2;
        }

        public String getGuid() {
            return this.guid;
        }

        public void setGuid(String guid) {
            this.guid = guid;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x2) {
            this.x = x2;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y2) {
            this.y = y2;
        }
    }
}

