/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jumpmind.symmetric.console.model.AbstractSubsetRule;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasLink;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasTable;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasTransformTable;
import com.jumpmind.symmetric.console.ui.common.s;
import com.jumpmind.symmetric.db.ProDatabasePlatformFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.util.BasicDataSourceFactory;
import org.jumpmind.db.util.ResettableBasicDataSource;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IParameterService;

public class ConfigCanvasEndpoint {
    public static transient String ENDPOINT_TYPE = "endpoint.type";
    private String guid = UUID.randomUUID().toString();
    private String id = "New_Endpoint";
    private transient ISymmetricEngine engine;
    private transient IDatabasePlatform databasePlatform;
    private transient boolean endpointDetailsChanged;
    private boolean connectionSuccessful;
    private transient String exceptionMessage;
    private boolean visitedDefineEndpointScreen;
    @JsonIgnore
    private s.a type;
    @JsonIgnore
    private boolean usingCustomUrl;
    @JsonIgnore
    private String host = "localhost";
    @JsonIgnore
    private String port;
    @JsonIgnore
    private String databaseName;
    @JsonIgnore
    private Boolean useOracleServiceName;
    @JsonIgnore
    private String url;
    @JsonIgnore
    private String userId;
    @JsonIgnore
    private String password;
    @JsonIgnore
    private TypedProperties advancedProperties = new TypedProperties();
    private transient String defaultCatalog;
    private transient String defaultSchema;
    private boolean remote;
    @JsonIgnore
    private String captureType;
    @JsonIgnore
    private boolean registrationServer;
    @JsonIgnore
    private String registrationServerExternalId;
    @JsonIgnore
    private String registersWithGroupId;
    @JsonIgnore
    private String syncUrl;
    private transient Map<String, List<ConfigCanvasTable>> tableCache = new HashMap<String, List<ConfigCanvasTable>>();
    @JsonIgnore
    private boolean renamable;
    private boolean deployed;
    private transient boolean isNew;
    private transient boolean modified;
    private transient boolean removed;
    private List<ConfigCanvasLink> linkList = new ArrayList<ConfigCanvasLink>();
    private int x;
    private int y;
    private String html;
    private String stateIconSrc;

    public ConfigCanvasEndpoint() {
    }

    public ConfigCanvasEndpoint(int x2, int y2) {
        this.x = x2;
        this.y = y2;
    }

    public ConfigCanvasEndpoint(String guid, String id, List<ConfigCanvasLink> linkList) {
        this.guid = guid;
        this.id = id;
        this.linkList.addAll(linkList);
    }

    public void load(ISymmetricEngine engine) {
        this.engine = engine;
        IParameterService parameterService = engine.getParameterService();
        this.id = parameterService.getNodeGroupId();
        this.usingCustomUrl = true;
        this.url = parameterService.getString("db.url");
        this.type = this.getEndpointType(engine.getTargetDialect().getName());
        this.userId = parameterService.getString("db.user");
        this.password = parameterService.getString("db.password");
        if (this.password != null && this.password.startsWith("enc:")) {
            this.password = engine.getSecurityService().decrypt(this.password.substring("enc:".length()));
        }
        if (s.BIGQUERY.equals(this.type)) {
            this.setAdvancedProperty("google.bigquery.location", parameterService.getString("google.bigquery.location"));
            this.setAdvancedProperty("google.bigquery.project.id", parameterService.getString("google.bigquery.project.id"));
            this.setAdvancedProperty("google.bigquery.security.credentials.path", parameterService.getString("google.bigquery.security.credentials.path"));
        }
        if (parameterService.is("time.based.capture")) {
            this.captureType = "Time-based (read-only)";
        }
        this.updateRegistrationServerStatus();
        this.deployed = true;
    }

    public void updateRegistrationServerStatus() {
        if (this.engine != null) {
            IParameterService parameterService = this.engine.getParameterService();
            this.registrationServer = parameterService.isRegistrationServer();
            if (this.registrationServer) {
                this.registrationServerExternalId = parameterService.getExternalId();
            } else {
                for (Node node : this.engine.getNodeService().findAllNodes()) {
                    if (!parameterService.isRemoteNodeRegistrationServer(node)) continue;
                    this.registersWithGroupId = node.getNodeGroupId();
                    break;
                }
            }
        }
    }

    public void load(TypedProperties properties) {
        this.id = properties.getProperty("group.id");
        String typeName = properties.getProperty(ENDPOINT_TYPE);
        for (s.a endpointType : s.databaseToDriverMap.keySet()) {
            if (!endpointType.getName().equals(typeName)) continue;
            this.type = endpointType;
            break;
        }
        this.usingCustomUrl = true;
        this.url = properties.getProperty("db.url");
        this.userId = properties.getProperty("db.user");
        this.password = properties.getProperty("db.password");
        if (this.password != null && this.password.startsWith("enc:")) {
            ISecurityService securityService = SecurityServiceFactory.create((SecurityServiceFactory.SecurityServiceType)SecurityServiceFactory.SecurityServiceType.CLIENT, (TypedProperties)properties);
            this.password = securityService.decrypt(this.password.substring("enc:".length()));
        }
        if (s.BIGQUERY.equals(this.type)) {
            if (properties.containsKey((Object)"google.bigquery.location")) {
                this.setAdvancedProperty("google.bigquery.location", properties.get("google.bigquery.location"));
            }
            if (properties.containsKey((Object)"google.bigquery.project.id")) {
                this.setAdvancedProperty("google.bigquery.project.id", properties.get("google.bigquery.project.id"));
            }
            if (properties.containsKey((Object)"google.bigquery.security.credentials.path")) {
                this.setAdvancedProperty("google.bigquery.security.credentials.path", properties.get("google.bigquery.security.credentials.path"));
            }
        }
        this.remote = true;
    }

    public void load(Node node) {
        this.id = node.getNodeGroupId();
        s.a newType = this.getDatabaseType(node);
        if (!(this.type == null || newType != null && this.type.getName().equals(newType.getName()))) {
            this.usingCustomUrl = false;
            this.host = null;
            this.port = null;
            this.databaseName = null;
            this.useOracleServiceName = null;
            this.url = null;
            this.userId = null;
            this.password = null;
            this.advancedProperties.clear();
            this.defaultCatalog = null;
            this.defaultSchema = null;
        }
        this.type = newType;
        if ("time-based".equals(node.getDeploymentSubType())) {
            this.captureType = "Time-based (read-only)";
        }
        this.remote = true;
        this.deployed = true;
        this.syncUrl = node.getSyncUrl();
    }

    private s.a getDatabaseType(Node node) {
        return this.getEndpointType(node.getDeploymentSubType() != null ? node.getDatabaseType() : node.getDatabaseName());
    }

    private s.a getEndpointType(String databaseName) {
        String typeName = s.getMappedDatabaseType(databaseName);
        if ("db2".equals(typeName)) {
            if (Strings.CI.startsWith((CharSequence)this.url, (CharSequence)"jdbc:as400")) {
                return s.DB2AS400;
            }
            return s.DB2;
        }
        for (Map.Entry<s.a, String> typeEntry : s.databaseNameMap.entrySet()) {
            if (!typeEntry.getValue().equalsIgnoreCase(typeName)) continue;
            return typeEntry.getKey();
        }
        return null;
    }

    public IDatabasePlatform getDatabasePlatform() {
        return this.getDatabasePlatform(true);
    }

    public IDatabasePlatform getDatabasePlatform(boolean createPlatformIfNecessary) {
        if (this.engine != null) {
            this.databasePlatform = this.engine.getSymmetricDialect().getTargetPlatform();
            return this.databasePlatform;
        }
        if (createPlatformIfNecessary && (this.endpointDetailsChanged || this.databasePlatform == null && this.exceptionMessage == null) && this.type != null && StringUtils.isNotBlank((CharSequence)this.url)) {
            TypedProperties dbProperties = new TypedProperties();
            dbProperties.setProperty("db.driver", s.databaseToDriverMap.get(this.type));
            dbProperties.setProperty("db.url", this.url);
            dbProperties.setProperty("db.user", this.userId);
            dbProperties.setProperty("db.password", this.password);
            dbProperties.setProperty("db.validation.query", s.databaseToValidationQueryMap.get(this.type));
            dbProperties.putAll((Properties)this.advancedProperties);
            ResettableBasicDataSource ds2 = null;
            try {
                if (ProDatabasePlatformFactory.isJdbcUrl((String)this.url)) {
                    ds2 = BasicDataSourceFactory.create((TypedProperties)dbProperties);
                }
                SqlTemplateSettings settings = new SqlTemplateSettings();
                settings.setProperties(dbProperties);
                this.databasePlatform = ProDatabasePlatformFactory.getInstance().create((DataSource)ds2, settings, true, false, this.type.isWriteOnly(), "Log-based".equals(this.captureType));
                this.exceptionMessage = null;
            }
            catch (Exception e2) {
                this.exceptionMessage = StringUtils.defaultString((String)e2.getMessage());
            }
            this.endpointDetailsChanged = false;
        }
        return this.databasePlatform;
    }

    public void setDatabasePlatform(IDatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    public void cacheTables(String catalog, String schema, List<ConfigCanvasTable> tableList) {
        catalog = (String)StringUtils.defaultIfBlank((CharSequence)catalog, (CharSequence)this.getDefaultCatalog());
        schema = (String)StringUtils.defaultIfBlank((CharSequence)schema, (CharSequence)this.getDefaultSchema());
        this.tableCache.put(Table.getFullyQualifiedTablePrefix((String)catalog, (String)schema), new ArrayList<ConfigCanvasTable>(tableList));
    }

    public List<ConfigCanvasTable> getTablesFromCache(String catalog, String schema) {
        catalog = (String)StringUtils.defaultIfBlank((CharSequence)catalog, (CharSequence)this.getDefaultCatalog());
        schema = (String)StringUtils.defaultIfBlank((CharSequence)schema, (CharSequence)this.getDefaultSchema());
        return this.tableCache.get(Table.getFullyQualifiedTablePrefix((String)catalog, (String)schema));
    }

    public void clearTableCache() {
        this.tableCache.clear();
        if (this.databasePlatform != null) {
            this.databasePlatform.resetCachedTableModel();
        }
    }

    public ConfigCanvasLink addLink(String targetEndpointGuid, String targetEndpointId) {
        return this.addLink(targetEndpointGuid, targetEndpointId, null, null);
    }

    public ConfigCanvasLink addLink(String targetEndpointGuid, String targetEndpointId, String sourceDiagramEndpointUuid, String targetDiagramEndpointUuid) {
        ConfigCanvasLink link = new ConfigCanvasLink(targetEndpointGuid, targetEndpointId, sourceDiagramEndpointUuid, targetDiagramEndpointUuid);
        this.linkList.add(link);
        return link;
    }

    public void removeLink(String targetEndpointGuid) {
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link != null) {
            this.linkList.remove(link);
        }
    }

    public ConfigCanvasLink getLink(String targetEndpointGuid) {
        for (ConfigCanvasLink link : this.linkList) {
            if (!link.getTargetEndpointGuid().equals(targetEndpointGuid)) continue;
            return link;
        }
        return null;
    }

    public void addTables(ConfigCanvasEndpoint targetEndpoint, Set<ConfigCanvasTable> tableSet, String channelId, String triggerIdPrefix, String targetCatalog, String targetSchema, boolean useSourceCatalogSchema) {
        String targetEndpointGuid = targetEndpoint.getGuid();
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link == null) {
            link = new ConfigCanvasLink(targetEndpointGuid, targetEndpoint.getId(), 0, targetEndpoint.getTableCount(this.guid));
            this.linkList.add(link);
        }
        link.addTables(tableSet, channelId, triggerIdPrefix, targetCatalog, targetSchema, useSourceCatalogSchema, targetEndpoint.getDefaultCatalog(), targetEndpoint.getDefaultSchema());
    }

    public void removeTables(String targetEndpointGuid, int index) {
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link != null) {
            link.removeTables(index);
        }
    }

    public Set<ConfigCanvasTable> getMissingSourceTableSet(String targetEndpointGuid, boolean setSourceTableExists) {
        ConfigCanvasLink link;
        HashSet<ConfigCanvasTable> missingSourceTableSet = new HashSet<ConfigCanvasTable>();
        IDatabasePlatform platform = this.getDatabasePlatform();
        if (platform != null && this.isConnectionSuccessful() && this.exceptionMessage == null && (!this.remote || this.url != null) && (link = this.getLink(targetEndpointGuid)) != null) {
            for (ConfigCanvasTable configuredTable : link.getAllTables()) {
                String schema;
                if (configuredTable.getSourceTableExists() != null) continue;
                String catalog = configuredTable.getCatalog();
                List<ConfigCanvasTable> tableList = this.getTablesFromCache(catalog, schema = configuredTable.getSchema());
                if (tableList == null) {
                    tableList = new ArrayList<ConfigCanvasTable>();
                    String targetCatalog = configuredTable.getTargetCatalog();
                    String targetSchema = configuredTable.getTargetSchema();
                    List tableNameList = platform.getDdlReader().getTableNames(Objects.toString(catalog, this.getDefaultCatalog()), Objects.toString(schema, this.getDefaultSchema()), new String[]{"TABLE"});
                    Collections.sort(tableNameList, String.CASE_INSENSITIVE_ORDER);
                    for (String tableName : tableNameList) {
                        ConfigCanvasTable table = new ConfigCanvasTable(catalog, schema, tableName, targetCatalog, targetSchema);
                        table.setSourceTableExists(true);
                        tableList.add(table);
                    }
                    this.cacheTables(catalog, schema, tableList);
                }
                boolean configuredTableExists = false;
                for (ConfigCanvasTable table : tableList) {
                    if (!table.getName().equals(configuredTable.getName())) continue;
                    configuredTableExists = true;
                    break;
                }
                if (!configuredTableExists) {
                    missingSourceTableSet.add(configuredTable);
                }
                if (!setSourceTableExists) continue;
                configuredTable.setSourceTableExists(configuredTableExists);
            }
        }
        return missingSourceTableSet;
    }

    public void setSourceTablesExist(Boolean sourceTablesExist) {
        for (ConfigCanvasLink configCanvasLink : this.linkList) {
            for (ConfigCanvasTable table : configCanvasLink.getAllTables()) {
                if (sourceTablesExist != null && table.getSourceTableExists() == null) continue;
                table.setSourceTableExists(sourceTablesExist);
            }
        }
        for (List list : this.tableCache.values()) {
            for (ConfigCanvasTable table : list) {
                if (sourceTablesExist != null && table.getSourceTableExists() == null) continue;
                table.setSourceTableExists(sourceTablesExist);
            }
        }
    }

    public boolean hasTableBeenAdded(String targetEndpointGuid, ConfigCanvasTable table) {
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link != null) {
            return link.hasTableBeenAdded(table, this.getDefaultCatalog(), this.getDefaultSchema());
        }
        return false;
    }

    public Set<ConfigCanvasTable> getAllTables(String targetEndpointGuid) {
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link != null) {
            return link.getAllTables();
        }
        return new HashSet<ConfigCanvasTable>();
    }

    public ConfigCanvasLink.ConfigCanvasTableGroup getTableGroupForTable(String targetEndpointGuid, ConfigCanvasTable table) {
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link != null) {
            for (ConfigCanvasLink.ConfigCanvasTableGroup tableGroup : link.getTableGroupList()) {
                for (ConfigCanvasTable groupedTable : tableGroup.getTableSet()) {
                    if (!Strings.CS.equals(table.getCatalog(), groupedTable.getCatalog()) || !Strings.CS.equals(table.getSchema(), groupedTable.getSchema()) || !table.getName().equals(groupedTable.getName())) continue;
                    return tableGroup;
                }
            }
        }
        return null;
    }

    public int getTableCount(String targetEndpointGuid) {
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link != null) {
            return link.getOutgoingTableCount();
        }
        return 0;
    }

    public boolean areAnyTablesConfigured() {
        for (ConfigCanvasLink link : this.linkList) {
            if (link.getOutgoingTableCount() <= 0 && link.getIncomingTableCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public void setIncomingTableCountForLink(String targetEndpointGuid, int tableCount) {
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link != null) {
            link.setIncomingTableCount(tableCount);
        }
    }

    public void addTransforms(String targetEndpointGuid, Set<ConfigCanvasTransformTable> transformSet, int index) {
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link != null && !transformSet.isEmpty()) {
            link.addTransforms(transformSet, this.getDefaultCatalog(), this.getDefaultSchema(), index);
        }
    }

    public void removeTransforms(String targetEndpointGuid, int index) {
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link != null) {
            link.removeTransforms(index);
        }
    }

    public void setIncomingTransformedForLink(String targetEndpointGuid, boolean transformed) {
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link != null) {
            link.setIncomingTransformed(transformed);
        }
    }

    @JsonIgnore
    public ISymmetricEngine getSymmetricEngine() {
        return this.engine;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean endpointDetailsChanged() {
        return !this.deployed && !this.remote && this.endpointDetailsChanged;
    }

    public void setEndpointDetailsChanged(boolean endpointDetailsChanged) {
        this.endpointDetailsChanged = endpointDetailsChanged;
        if (endpointDetailsChanged) {
            this.connectionSuccessful = false;
            this.defaultCatalog = null;
            this.defaultSchema = null;
        }
    }

    public boolean isConnectionSuccessful() {
        return this.deployed || this.connectionSuccessful;
    }

    public void setConnectionSuccessful(boolean connectionSuccessful) {
        this.connectionSuccessful = connectionSuccessful;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public boolean isVisitedDefineEndpointScreen() {
        return this.visitedDefineEndpointScreen;
    }

    public void setVisitedDefineEndpointScreen(boolean visitedDefineEndpointScreen) {
        this.visitedDefineEndpointScreen = visitedDefineEndpointScreen;
    }

    public s.a getType() {
        return this.type;
    }

    public void setType(s.a type) {
        if (this.type == null || !this.type.equals(type)) {
            this.setEndpointDetailsChanged(true);
            this.captureType = s.getValidCaptureTypeList(type).get(0);
        }
        this.type = type;
    }

    @JsonIgnore
    public boolean isWriteOnly() {
        return this.type != null && this.type.isWriteOnly();
    }

    public boolean isUsingCustomUrl() {
        return this.usingCustomUrl;
    }

    public void setUsingCustomUrl(boolean usingCustomUrl) {
        if (this.usingCustomUrl != usingCustomUrl) {
            this.setEndpointDetailsChanged(true);
        }
        this.usingCustomUrl = usingCustomUrl;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (!Strings.CS.equals(this.host, host)) {
            this.setEndpointDetailsChanged(true);
        }
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        if (!Strings.CS.equals(this.port, port)) {
            this.setEndpointDetailsChanged(true);
        }
        this.port = port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        if (!Strings.CS.equals(this.databaseName, databaseName)) {
            this.setEndpointDetailsChanged(true);
        }
        this.databaseName = databaseName;
    }

    public Boolean isUseOracleServiceName() {
        return this.useOracleServiceName;
    }

    public void setUseOracleServiceName(Boolean useOracleServiceName) {
        if (Boolean.TRUE.equals(this.useOracleServiceName) != Boolean.TRUE.equals(useOracleServiceName)) {
            this.setEndpointDetailsChanged(true);
        }
        this.useOracleServiceName = useOracleServiceName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (!Strings.CS.equals(this.url, url)) {
            this.setEndpointDetailsChanged(true);
        }
        this.url = url;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        if (!Strings.CS.equals(this.userId, userId)) {
            this.setEndpointDetailsChanged(true);
        }
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (!Strings.CS.equals(this.password, password)) {
            this.setEndpointDetailsChanged(true);
        }
        this.password = password;
    }

    public TypedProperties getAdvancedProperties() {
        return this.advancedProperties;
    }

    public String getAdvancedProperty(String key) {
        return this.getAdvancedProperty(key, null);
    }

    public String getAdvancedProperty(String key, String defaultValue) {
        return this.advancedProperties.get(key, defaultValue);
    }

    public void setAdvancedProperty(String key, String value) {
        String currentValue = this.getAdvancedProperty(key);
        if (!Strings.CS.equals(currentValue, value)) {
            this.setEndpointDetailsChanged(true);
        }
        this.advancedProperties.setProperty(key, value);
    }

    public String getDefaultCatalog() {
        if (this.defaultCatalog == null && this.getDatabasePlatform() != null) {
            this.defaultCatalog = this.getDatabasePlatform().getDefaultCatalog();
        }
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    public String getDefaultSchema() {
        if (this.defaultSchema == null && this.getDatabasePlatform() != null) {
            this.defaultSchema = this.getDatabasePlatform().getDefaultSchema();
        }
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public String getCaptureType() {
        return this.captureType;
    }

    public void setCaptureType(String captureType) {
        this.captureType = captureType;
    }

    public boolean isRegistrationServer() {
        return this.registrationServer;
    }

    public void setRegistrationServer(boolean registrationServer) {
        this.registrationServer = registrationServer;
    }

    public String getRegistrationServerExternalId() {
        return this.registrationServerExternalId;
    }

    public void setRegistrationServerExternalId(String registrationServerExternalId) {
        this.registrationServerExternalId = registrationServerExternalId;
    }

    public String getRegistersWithGroupId() {
        return this.registersWithGroupId;
    }

    public void setRegistersWithGroupId(String registersWithGroupId) {
        this.registersWithGroupId = registersWithGroupId;
    }

    public String getSyncUrl() {
        if (this.engine != null) {
            return this.engine.getSyncUrl();
        }
        return this.syncUrl;
    }

    public List<ConfigCanvasLink.ConfigCanvasTableGroup> getTableGroupList(String targetEndpointGuid) {
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link != null) {
            return link.getTableGroupList();
        }
        return new ArrayList<ConfigCanvasLink.ConfigCanvasTableGroup>();
    }

    public List<AbstractSubsetRule> getSubsetRuleList(String targetEndpointGuid) {
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link != null) {
            return link.getSubsetRuleList();
        }
        return new ArrayList<AbstractSubsetRule>();
    }

    public List<Set<ConfigCanvasTransformTable>> getTransformList(String targetEndpointGuid) {
        ConfigCanvasLink link = this.getLink(targetEndpointGuid);
        if (link != null) {
            return link.getTransformList();
        }
        return new ArrayList<Set<ConfigCanvasTransformTable>>();
    }

    public boolean isRenamable() {
        return this.renamable;
    }

    public void setRenamable(boolean renamable) {
        this.renamable = renamable;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public void setDeployed(boolean deployed) {
        this.deployed = deployed;
    }

    @JsonIgnore
    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
        if (isNew) {
            this.setLinksNew(true);
            this.removed = false;
        }
    }

    private void setLinksNew(boolean isNew) {
        for (ConfigCanvasLink link : this.linkList) {
            link.setNew(isNew);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
        if (removed) {
            this.setNew(false);
            this.setLinksNew(false);
            for (ConfigCanvasLink link : this.linkList) {
                link.setTransformsNew(false);
            }
        }
    }

    public List<ConfigCanvasLink> getLinkList() {
        return this.linkList;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x2) {
        this.x = x2;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y2) {
        this.y = y2;
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public String getStateIconSrc() {
        return this.stateIconSrc;
    }

    public void setStateIconSrc(String stateIconSrc) {
        this.stateIconSrc = stateIconSrc;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.guid == null ? 0 : this.guid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConfigCanvasEndpoint)) {
            return false;
        }
        ConfigCanvasEndpoint other = (ConfigCanvasEndpoint)obj;
        return !(this.guid == null ? other.guid != null : !this.guid.equals(other.guid));
    }
}

