/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvas;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasDiagramDetail;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasEndpoint;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.internal.AllowInert;
import com.vaadin.flow.component.page.Page;
import elemental.json.JsonObject;
import java.io.Serializable;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CssImport(value="./config-canvas-diagram.css")
@JsModule.Container(value={@JsModule(value="./jsplumb.min.js"), @JsModule(value="./config-canvas-diagram.js")})
@JavaScript(value="./config-canvas-diagram.js")
public class ConfigCanvasDiagram
extends Div {
    private static final Logger log = LoggerFactory.getLogger(ConfigCanvasDiagram.class);
    private static final long serialVersionUID = 1L;
    private ConfigCanvasDiagramDetail detail;
    private ConfigCanvas canvas;

    public ConfigCanvasDiagram(ConfigCanvas canvas, ConfigCanvasDiagramDetail detail) {
        this.canvas = canvas;
        this.detail = detail != null ? detail : new ConfigCanvasDiagramDetail();
        this.setId("config-canvas-diagram");
        this.addClassName("canvas-diagram");
    }

    protected void onAttach(AttachEvent attachEvent) {
        Page page = UI.getCurrent().getPage();
        page.executeJs("window.com_jumpmind_symmetric_console_ui_screen_ConfigCanvasDiagram($0)", new Serializable[]{this.getElement()});
    }

    @ClientCallable
    private void onNodeSelected(JsonObject json) {
        String guid = null;
        if (json.hasKey("id")) {
            guid = json.getString("id");
        }
        if (!Strings.CS.equals(guid, this.detail.getSelectedEndpointGuid()) || this.detail.getSelectedLinkSourceGuid() != null) {
            this.detail.clearSelection();
            this.detail.setSelectedEndpointGuid(guid);
            this.canvas.endpointSelectedEvent(this.getEndpointByGuid(guid));
        }
    }

    @ClientCallable
    private void onConnectionSelected(JsonObject json) {
        String sourceGuid = json.getString("source");
        String targetGuid = json.getString("target");
        if (!Strings.CS.equals(sourceGuid, this.detail.getSelectedLinkSourceGuid()) || !Strings.CS.equals(targetGuid, this.detail.getSelectedLinkTargetGuid())) {
            this.detail.clearSelection();
            this.detail.setSelectedLinkSourceGuid(sourceGuid);
            this.detail.setSelectedLinkTargetGuid(targetGuid);
            this.canvas.linkSelectedEvent(this.getEndpointByGuid(sourceGuid), this.getEndpointByGuid(targetGuid));
        }
    }

    @ClientCallable
    private void onNodeMoved(JsonObject json) {
        String guid = json.getString("id");
        double x2 = json.getNumber("x");
        double y2 = json.getNumber("y");
        for (ConfigCanvasEndpoint endpoint : this.detail.getEndpointList()) {
            if (!endpoint.getGuid().equals(guid)) continue;
            endpoint.setX((int)x2);
            endpoint.setY((int)y2);
            this.canvas.getPosition().updateEndpointCoordinates(endpoint);
            return;
        }
    }

    @ClientCallable
    private void onConnection(JsonObject json) {
        String sourceDiagramEndpointUuid = null;
        if (json.hasKey("sourceEndpointUuid")) {
            sourceDiagramEndpointUuid = json.getString("sourceDiagramEndpointUuid");
        }
        String targetDiagramEndpointUuid = null;
        if (json.hasKey("targetEndpointUuid")) {
            targetDiagramEndpointUuid = json.getString("targetDiagramEndpointUuid");
        }
        this.canvas.linkCreatedEvent(this.getEndpointByGuid(json.getString("source")), this.getEndpointByGuid(json.getString("target")), sourceDiagramEndpointUuid, targetDiagramEndpointUuid);
    }

    @AllowInert
    @ClientCallable
    public String getCurState() {
        ObjectMapper om = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).build();
        try {
            return om.writeValueAsString((Object)this.detail);
        }
        catch (JsonProcessingException e2) {
            log.warn("Failed to convert Configure Canvas diagram state to JSON", (Throwable)e2);
            return null;
        }
    }

    private ConfigCanvasEndpoint getEndpointByGuid(String guid) {
        for (ConfigCanvasEndpoint endpoint : this.detail.getEndpointList()) {
            if (!endpoint.getGuid().equals(guid)) continue;
            return endpoint;
        }
        return null;
    }

    public ConfigCanvasDiagramDetail getDetail() {
        return this.detail;
    }
}

