/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.jumpmind.symmetric.console.impl.M;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasEndpoint;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasLink;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasTransformTable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCanvasContext {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private List<ConfigCanvasEndpoint> originalEndpointList = new ArrayList<ConfigCanvasEndpoint>();
    private List<ConfigCanvasEndpoint> savedEndpointList = new ArrayList<ConfigCanvasEndpoint>();
    private transient List<ConfigCanvasEndpoint> endpointList = new ArrayList<ConfigCanvasEndpoint>();
    private Map<String, Set<String>> requiredLinkMap = new HashMap<String, Set<String>>();
    private Set<String> requiredRouterIdSet = new HashSet<String>();
    private Set<String> importedChannelIdSet = new HashSet<String>();
    private Set<String> importedTransformColumnTypeSet = new HashSet<String>();
    private String importedFileName;
    private String importedLicenseKeyString;
    private transient M importedLicenseKey;
    private String documentVersion = Version.version();
    private Date created = new Date();
    private Date modified = new Date();

    public ConfigCanvasEndpoint addEndpoint() {
        int maxY = 112;
        for (ConfigCanvasEndpoint database : this.endpointList) {
            maxY = Math.max(maxY, database.getY() + 200);
        }
        ConfigCanvasEndpoint newDatabase = new ConfigCanvasEndpoint(160, maxY);
        String newId = newDatabase.getId();
        Object suffix = "";
        Set idSet = this.endpointList.stream().map(e2 -> e2.getId()).collect(Collectors.toSet());
        int i2 = 2;
        while (idSet.contains(newId + (String)suffix)) {
            suffix = "_" + i2;
            ++i2;
        }
        newDatabase.setId(newId + (String)suffix);
        newDatabase.setRenamable(true);
        this.endpointList.add(newDatabase);
        return newDatabase;
    }

    public void updateOriginalEndpointList(Gson gson) {
        Type databaseListType = this.getEndpointListType();
        this.originalEndpointList = (List)gson.fromJson(gson.toJson(this.endpointList, databaseListType), databaseListType);
    }

    public void updateSavedEndpointList(Gson gson) {
        Type databaseListType = this.getEndpointListType();
        this.savedEndpointList = (List)gson.fromJson(gson.toJson(this.endpointList, databaseListType), databaseListType);
    }

    public void updateEndpointList(Gson gson) {
        Type databaseListType = this.getEndpointListType();
        this.endpointList = (List)gson.fromJson(gson.toJson(this.savedEndpointList, databaseListType), databaseListType);
    }

    private Type getEndpointListType() {
        return new TypeToken<List<ConfigCanvasEndpoint>>(){}.getType();
    }

    public void encryptPasswords(ISecurityService securityService) {
        this.encryptPasswords(securityService, this.originalEndpointList);
        this.encryptPasswords(securityService, this.savedEndpointList);
    }

    private void encryptPasswords(ISecurityService securityService, List<ConfigCanvasEndpoint> endpointsToEncrypt) {
        for (ConfigCanvasEndpoint endpoint : endpointsToEncrypt) {
            String password = endpoint.getPassword();
            if (!StringUtils.isNotBlank((CharSequence)password) || password.startsWith("enc:")) continue;
            try {
                endpoint.setPassword("enc:" + securityService.encrypt(password));
            }
            catch (Exception e2) {
                this.log.warn("Could not encrypt password", (Throwable)e2);
            }
        }
    }

    public void decryptPasswords(ISecurityService securityService) {
        this.decryptPasswords(securityService, this.originalEndpointList);
        this.decryptPasswords(securityService, this.savedEndpointList);
    }

    private void decryptPasswords(ISecurityService securityService, List<ConfigCanvasEndpoint> endpointsToDecrypt) {
        for (ConfigCanvasEndpoint endpoint : endpointsToDecrypt) {
            String password = endpoint.getPassword();
            if (password == null || !password.startsWith("enc:")) continue;
            try {
                endpoint.setPassword(securityService.decrypt(password.substring("enc:".length())));
            }
            catch (Exception e2) {
                this.log.warn("Could not decrypt password", (Throwable)e2);
            }
        }
    }

    public ConfigCanvasEndpoint getOriginalEndpointByGuid(String guid) {
        return this.getEndpoint(this.originalEndpointList, guid, null);
    }

    public ConfigCanvasEndpoint getEndpointByGuid(String guid) {
        return this.getEndpoint(this.endpointList, guid, null);
    }

    public ConfigCanvasEndpoint getEndpointById(String id) {
        return this.getEndpoint(this.endpointList, null, id);
    }

    private ConfigCanvasEndpoint getEndpoint(List<ConfigCanvasEndpoint> endpointListToSearch, String guid, String id) {
        for (ConfigCanvasEndpoint endpoint : endpointListToSearch) {
            if ((guid == null || !guid.equals(endpoint.getGuid())) && (id == null || !id.equals(endpoint.getId()))) continue;
            return endpoint;
        }
        return null;
    }

    public Set<String> getAllTableNames() {
        HashSet<String> tableNameSet = new HashSet<String>();
        for (ConfigCanvasEndpoint endpoint : this.endpointList) {
            for (ConfigCanvasLink link : endpoint.getLinkList()) {
                tableNameSet.addAll(link.getAllTables().stream().map(t2 -> t2.getName()).collect(Collectors.toList()));
            }
        }
        return tableNameSet;
    }

    public Set<String> getAllTransformIds() {
        HashSet<String> transformIdSet = new HashSet<String>();
        for (ConfigCanvasEndpoint endpoint : this.endpointList) {
            for (ConfigCanvasLink link : endpoint.getLinkList()) {
                for (Set<ConfigCanvasTransformTable> transformSet : link.getTransformList()) {
                    transformIdSet.addAll(transformSet.stream().map(t2 -> t2.getId()).collect(Collectors.toList()));
                }
            }
        }
        return transformIdSet;
    }

    public void setLinkRequired(String sourceId, String targetId) {
        Set<String> targetIdSet = this.requiredLinkMap.get(sourceId);
        if (targetIdSet == null) {
            targetIdSet = new HashSet<String>();
        }
        targetIdSet.add(targetId);
        this.requiredLinkMap.put(sourceId, targetIdSet);
    }

    public boolean isLinkRequired(String sourceId, String targetId) {
        Set<String> targetIdSet = this.requiredLinkMap.get(sourceId);
        if (targetIdSet != null && targetIdSet.contains(targetId)) {
            return !this.isLinkUserCreated(sourceId, targetId);
        }
        targetIdSet = this.requiredLinkMap.get(targetId);
        if (targetIdSet != null && targetIdSet.contains(sourceId)) {
            return !this.isLinkUserCreated(sourceId, targetId);
        }
        return false;
    }

    public boolean isEndpointRequired(String endpointGuid) {
        ConfigCanvasEndpoint endpoint = this.getEndpointByGuid(endpointGuid);
        if (endpoint == null) {
            return false;
        }
        String id = endpoint.getId();
        for (Map.Entry<String, Set<String>> requiredLinkEntry : this.requiredLinkMap.entrySet()) {
            String sourceId = requiredLinkEntry.getKey();
            if (id.equals(sourceId)) {
                for (String targetId : requiredLinkEntry.getValue()) {
                    if (this.isLinkUserCreated(sourceId, targetId)) continue;
                    return true;
                }
                continue;
            }
            for (String targetId : requiredLinkEntry.getValue()) {
                if (!id.equals(targetId) || this.isLinkUserCreated(sourceId, targetId)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLinkUserCreated(String sourceId, String targetId) {
        ConfigCanvasEndpoint sourceEndpoint = this.getEndpointById(sourceId);
        if (sourceEndpoint == null) {
            return true;
        }
        ConfigCanvasEndpoint targetEndpoint = this.getEndpointById(targetId);
        if (targetEndpoint == null) {
            return true;
        }
        for (ConfigCanvasLink link : sourceEndpoint.getLinkList()) {
            if (!targetId.equals(link.getTargetEndpointId()) || !link.isUserCreated()) continue;
            return true;
        }
        for (ConfigCanvasLink link : targetEndpoint.getLinkList()) {
            if (!sourceId.equals(link.getTargetEndpointId()) || !link.isUserCreated()) continue;
            return true;
        }
        return false;
    }

    public void clearRequiredLinks() {
        this.requiredLinkMap.clear();
    }

    public void setRouterRequired(String routerId) {
        this.requiredRouterIdSet.add(routerId);
    }

    public boolean isRouterRequired(String routerId) {
        return this.requiredRouterIdSet.contains(routerId);
    }

    public void clearRequiredRouterIds() {
        this.requiredRouterIdSet.clear();
    }

    public List<ConfigCanvasEndpoint> getOriginalEndpointList() {
        return this.originalEndpointList;
    }

    public void setOriginalEndpointList(List<ConfigCanvasEndpoint> originalEndpointList) {
        this.originalEndpointList = originalEndpointList;
    }

    public List<ConfigCanvasEndpoint> getSavedEndpointList() {
        return this.savedEndpointList;
    }

    public void setSavedEndpointList(List<ConfigCanvasEndpoint> savedEndpointList) {
        this.savedEndpointList = savedEndpointList;
    }

    public List<ConfigCanvasEndpoint> getEndpointList() {
        return this.endpointList;
    }

    public void setEndpointList(List<ConfigCanvasEndpoint> endpointList) {
        this.endpointList = endpointList;
    }

    public Set<String> getImportedChannelIdSet() {
        return this.importedChannelIdSet;
    }

    public void setImportedChannelIdSet(Set<String> importedChannelIdSet) {
        this.importedChannelIdSet = importedChannelIdSet;
    }

    public Set<String> getImportedTransformColumnTypeSet() {
        return this.importedTransformColumnTypeSet;
    }

    public void setImportedTransformColumnTypeSet(Set<String> importedTransformColumnTypeSet) {
        this.importedTransformColumnTypeSet = importedTransformColumnTypeSet;
    }

    public String getImportedFileName() {
        return this.importedFileName;
    }

    public void setImportedFileName(String importedFileName) {
        this.importedFileName = importedFileName;
    }

    public String getImportedLicenseKeyString() {
        return this.importedLicenseKeyString;
    }

    public void setImportedLicenseKeyString(String importedLicenseKeyString) {
        this.importedLicenseKeyString = importedLicenseKeyString;
    }

    public M getImportedLicenseKey() {
        return this.importedLicenseKey;
    }

    public void setImportedLicenseKey(M importedLicenseKey) {
        this.importedLicenseKey = importedLicenseKey;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }
}

