/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.jumpmind.symmetric.console.authentication.ConsoleAuthenticationException;
import com.jumpmind.symmetric.console.service.IConsoleUserAuthentication;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import com.vaadin.flow.server.VaadinSession;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.service.IParameterService;

public class UserAuthenticationSAML
implements IConsoleUserAuthentication {
    @Override
    public IConsoleUserAuthentication.AuthenticationStatus authenticate(String userName, String password, ISymmetricEngine engine) throws ConsoleAuthenticationException {
        IConsoleUserService userService = (IConsoleUserService)engine.getExtensionService().getExtensionPoint(IConsoleUserService.class);
        if (!userService.findConsoleUser(userName).isEnabled()) {
            return IConsoleUserAuthentication.AuthenticationStatus.DISABLED;
        }
        return IConsoleUserAuthentication.AuthenticationStatus.VALID;
    }

    public String getRole(ISymmetricEngine engine) {
        return this.getRole(engine, null);
    }

    public String getRole(ISymmetricEngine engine, Map<String, List<String>> attributeMap) {
        IParameterService parameterService = engine.getParameterService();
        TypedProperties allProperties = parameterService.getAllParameters();
        String roleGroupMapString = allProperties.getProperty("console.auth.saml.role.group.map");
        if (StringUtils.isBlank((CharSequence)roleGroupMapString)) {
            return null;
        }
        LinkedHashMap<String, String> roleGroupMap = new LinkedHashMap<String, String>();
        for (String roleGroupEntryString : CsvUtils.tokenizeCsvData((String)roleGroupMapString)) {
            String[] roleGroup = roleGroupEntryString.split("==");
            if (roleGroup.length != 2) continue;
            roleGroupMap.put(roleGroup[0], roleGroup[1]);
        }
        if (roleGroupMap.isEmpty()) {
            return null;
        }
        if (attributeMap == null) {
            VaadinSession session = VaadinSession.getCurrent();
            if (session == null) {
                return null;
            }
            attributeMap = (Map)session.getSession().getAttribute("attributeMap");
        }
        if (attributeMap == null || attributeMap.isEmpty()) {
            return null;
        }
        String groupAttribute = allProperties.get("console.auth.saml.groupAttribute", "group");
        List attributeValue = (List)attributeMap.get(groupAttribute);
        if (attributeValue == null || attributeValue.isEmpty()) {
            return null;
        }
        for (String groupName : roleGroupMap.keySet()) {
            if (!attributeValue.contains(groupName)) continue;
            return (String)roleGroupMap.get(groupName);
        }
        return null;
    }
}

