/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.service.IConsoleUserAuthentication;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;

public class UserAuthenticationInternal
implements IConsoleUserAuthentication {
    @Override
    public IConsoleUserAuthentication.AuthenticationStatus authenticate(String userName, String password, ISymmetricEngine engine) {
        IConsoleUserService userService = (IConsoleUserService)engine.getExtensionService().getExtensionPoint(IConsoleUserService.class);
        ConsoleUser user = userService.findConsoleUser(userName);
        if (!user.isEnabled()) {
            return IConsoleUserAuthentication.AuthenticationStatus.DISABLED;
        }
        long time = new Date().getTime();
        if (user.isGlassBreakRequired() && (user.getBreakGlassStartTime() == null || user.getBreakGlassEndTime() == null || time < user.getBreakGlassStartTime().getTime() || time >= user.getBreakGlassEndTime().getTime())) {
            return IConsoleUserAuthentication.AuthenticationStatus.GLASS_BREAK_REQUIRED;
        }
        if (StringUtils.isBlank((CharSequence)user.getHashedPassword()) && StringUtils.isBlank((CharSequence)password) || user.getHashedPassword() != null && user.getHashedPassword().equals(ConsoleUser.hashPassword(password, user.getEncryptionMethod(), user.getSalt()))) {
            if (user.getFailedLoginAttempts() > 0) {
                user.setFailedLoginAttempts(0);
                userService.save(user);
            }
            if (userService.isUserPasswordExpired(user)) {
                return IConsoleUserAuthentication.AuthenticationStatus.EXPIRED;
            }
            if (user.isResetRequired()) {
                return IConsoleUserAuthentication.AuthenticationStatus.RESET_REQUIRED;
            }
            return IConsoleUserAuthentication.AuthenticationStatus.VALID;
        }
        int maxFailedLoginAttempts = engine.getParameterService().getInt("console.password.failed.attempts", 0);
        if (maxFailedLoginAttempts > 0) {
            int failedLoginAttempts = user.getFailedLoginAttempts() + 1;
            user.setFailedLoginAttempts(failedLoginAttempts);
            if (failedLoginAttempts >= maxFailedLoginAttempts) {
                user.setEnabled(false);
            }
            userService.save(user);
        }
        return IConsoleUserAuthentication.AuthenticationStatus.INVALID;
    }
}

