/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.jumpmind.symmetric.console.model.TableGroup;
import com.jumpmind.symmetric.console.model.TableGroupHier;
import com.jumpmind.symmetric.console.service.ITableGroupService;
import com.jumpmind.symmetric.console.service.impl.TableGroupServiceSqlMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.ISqlMap;
import org.jumpmind.util.LinkedCaseInsensitiveMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableGroupService
implements ITableGroupService,
ISymmetricEngineAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private IConfigurationService configurationService;
    private IParameterService parameterService;
    private ITriggerRouterService triggerRouterService;
    private IDatabasePlatform platform;
    private ISqlTemplate sqlTemplate;
    private ISqlMap sql;
    private List<TableGroup> tableGroups;
    private List<TableGroupHier> tableGroupHiers;
    private Map<String, Map<String, List<TableGroupHier>>> tableGroupHierMap;
    private long tableGroupsCacheTime;
    private long tableGroupHiersCacheTime;
    private long tableGroupHierMapCacheTime;

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.configurationService = engine.getConfigurationService();
        this.parameterService = engine.getParameterService();
        this.triggerRouterService = engine.getTriggerRouterService();
        this.platform = engine.getTargetDialect().getTargetPlatform();
        this.sqlTemplate = engine.getSqlTemplate();
        this.sql = new TableGroupServiceSqlMap(engine.getSymmetricDialect().getPlatform(), engine.getTablePrefix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableGroup> getTableGroups(boolean refreshCache) {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.transform.time.ms");
        if (refreshCache || System.currentTimeMillis() - this.tableGroupsCacheTime >= cacheTimeoutInMs || this.tableGroups == null) {
            TableGroupService tableGroupService = this;
            synchronized (tableGroupService) {
                if (refreshCache || System.currentTimeMillis() - this.tableGroupsCacheTime >= cacheTimeoutInMs || this.tableGroups == null) {
                    this.tableGroups = this.sqlTemplate.query(this.getSql("selectTableGroups"), (ISqlRowMapper)new TableGroupMapper(this.configurationService.getNodeGroupLinks(false)), new Object[0]);
                    this.tableGroupsCacheTime = System.currentTimeMillis();
                }
            }
        }
        return this.tableGroups;
    }

    protected Map<String, TableGroup> getTableGroupsMap(boolean refreshCache) {
        List<TableGroup> tableGroups = this.getTableGroups(refreshCache);
        HashMap<String, TableGroup> tableGroupsMap = new HashMap<String, TableGroup>();
        for (TableGroup tableGroup : tableGroups) {
            tableGroupsMap.put(tableGroup.getId(), tableGroup);
        }
        return tableGroupsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableGroupHier> getTableGroupHiers(boolean refreshCache) {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.transform.time.ms");
        if (refreshCache || System.currentTimeMillis() - this.tableGroupHiersCacheTime >= cacheTimeoutInMs || this.tableGroupHiers == null) {
            TableGroupService tableGroupService = this;
            synchronized (tableGroupService) {
                if (refreshCache || System.currentTimeMillis() - this.tableGroupHiersCacheTime >= cacheTimeoutInMs || this.tableGroupHiers == null) {
                    this.tableGroupHiers = this.sqlTemplate.query(this.getSql("selectTableGroupHiers"), (ISqlRowMapper)new TableGroupHierMapper(), new Object[0]);
                    Map<String, TableGroup> tableGroupsMap = this.getTableGroupsMap(refreshCache);
                    for (TableGroupHier tableGroupHier : this.tableGroupHiers) {
                        tableGroupHier.setTableGroup(tableGroupsMap.get(tableGroupHier.getTableGroupId()));
                    }
                    this.tableGroupHiersCacheTime = System.currentTimeMillis();
                }
            }
        }
        Map map = this.tableGroupHiers.stream().collect(Collectors.toMap(TableGroupHier::getId, Function.identity()));
        for (TableGroupHier tableGroupHier : map.values()) {
            tableGroupHier.setParent((TableGroupHier)map.get(tableGroupHier.getParentId()));
        }
        return this.tableGroupHiers;
    }

    @Override
    public List<TableGroupHier> getTableGroupHiers(TableGroup.WriterType writerType, boolean refreshCache) {
        List<TableGroupHier> list = this.getTableGroupHiers(refreshCache);
        ArrayList<TableGroupHier> filteredList = new ArrayList<TableGroupHier>();
        for (TableGroupHier tableGroupHier : list) {
            TableGroup tableGroup = tableGroupHier.getTableGroup();
            if (tableGroup == null || tableGroup.getWriterType() != writerType) continue;
            filteredList.add(tableGroupHier);
        }
        return filteredList;
    }

    @Override
    public List<TableGroupHier> getTableGroupHiersByParentId(String parentId, boolean refreshCache) {
        List<TableGroupHier> list = this.getTableGroupHiers(refreshCache);
        ArrayList<TableGroupHier> filteredList = new ArrayList<TableGroupHier>();
        for (TableGroupHier tableGroupHier : list) {
            if (!Strings.CS.equals(tableGroupHier.getParentId(), parentId)) continue;
            filteredList.add(tableGroupHier);
        }
        return filteredList;
    }

    @Override
    public List<TableGroupHier> getTableGroupHiersByTableGroupId(String tableGroupId, boolean refreshCache) {
        List<TableGroupHier> list = this.getTableGroupHiers(refreshCache);
        ArrayList<TableGroupHier> filteredList = new ArrayList<TableGroupHier>();
        for (TableGroupHier tableGroupHier : list) {
            if (!Strings.CS.equals(tableGroupHier.getTableGroupId(), tableGroupId)) continue;
            filteredList.add(tableGroupHier);
        }
        return filteredList;
    }

    @Override
    public List<TableGroupHier> getRootTableGroupHiers(boolean refreshCache) {
        ArrayList<TableGroupHier> roots = new ArrayList<TableGroupHier>();
        for (TableGroupHier tableGroupHier : this.getTableGroupHiers(refreshCache)) {
            TableGroupHier root = tableGroupHier.getRootParent();
            if (roots.contains(root)) continue;
            roots.add(root);
        }
        return roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<TableGroupHier>> getTableGroupHierByTableName(String sourceNodeGroupId, String targetNodeGroupId, boolean refreshCache) {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.transform.time.ms");
        if (System.currentTimeMillis() - this.tableGroupHierMapCacheTime >= cacheTimeoutInMs || this.tableGroupHierMap == null) {
            TableGroupService tableGroupService = this;
            synchronized (tableGroupService) {
                if (System.currentTimeMillis() - this.tableGroupHierMapCacheTime >= cacheTimeoutInMs || this.tableGroupHierMap == null) {
                    ArrayList<TableGroupHier> tableGroupHiers = new ArrayList<TableGroupHier>(this.getTableGroupHiers(refreshCache));
                    this.tableGroupHierMap = this.buildTableGroupHierMap(tableGroupHiers);
                    this.tableGroupHierMapCacheTime = System.currentTimeMillis();
                }
            }
        }
        return this.tableGroupHierMap.get(sourceNodeGroupId + ":" + targetNodeGroupId);
    }

    protected Map<String, Map<String, List<TableGroupHier>>> buildTableGroupHierMap(List<TableGroupHier> tableGroupHiers) {
        HashMap<String, Map<String, List<TableGroupHier>>> map = new HashMap<String, Map<String, List<TableGroupHier>>>();
        HashMap<String, TableGroupHier> tableGroupHiersById = new HashMap<String, TableGroupHier>();
        Map<String, TableGroup> tableGroupsMap = this.getTableGroupsMap(false);
        Iterator<TableGroupHier> iterator = tableGroupHiers.iterator();
        while (iterator.hasNext()) {
            TableGroupHier tableGroupHier = iterator.next();
            TableGroup tableGroup = tableGroupsMap.get(tableGroupHier.getTableGroupId());
            if (tableGroup != null) {
                String tableName;
                ArrayList<TableGroupHier> list;
                String key = tableGroup.getSourceNodeGroupId() + ":" + tableGroup.getTargetNodeGroupId();
                HashMap<String, ArrayList<TableGroupHier>> byTableNameMap = (HashMap<String, ArrayList<TableGroupHier>>)map.get(key);
                if (byTableNameMap == null) {
                    byTableNameMap = new HashMap<String, ArrayList<TableGroupHier>>();
                    map.put(key, byTableNameMap);
                }
                if ((list = (ArrayList<TableGroupHier>)byTableNameMap.get(tableName = Table.getFullyQualifiedTableName((String)tableGroupHier.getSourceCatalogName(), (String)tableGroupHier.getSourceSchemaName(), (String)tableGroupHier.getSourceTableName()).toLowerCase())) == null) {
                    list = new ArrayList<TableGroupHier>();
                    byTableNameMap.put(tableName, list);
                }
                list.add(tableGroupHier);
                tableGroupHiersById.put(tableGroupHier.getId(), tableGroupHier);
                tableGroupHier.setTableGroup(tableGroup);
                continue;
            }
            iterator.remove();
        }
        for (TableGroupHier tableGroupHier : tableGroupHiers) {
            tableGroupHier.setParent((TableGroupHier)tableGroupHiersById.get(tableGroupHier.getParentId()));
        }
        this.buildSql(tableGroupHiers);
        return map;
    }

    protected void buildSql(List<TableGroupHier> tableGroupHiers) {
        HashMap<String, ArrayList<TableGroupHier>> tableGroupHierByGroupId = new HashMap<String, ArrayList<TableGroupHier>>();
        for (TableGroupHier tableGroupHier : tableGroupHiers) {
            ArrayList<TableGroupHier> list = (ArrayList<TableGroupHier>)tableGroupHierByGroupId.get(tableGroupHier.getTableGroupId());
            if (list == null) {
                list = new ArrayList<TableGroupHier>();
                tableGroupHierByGroupId.put(tableGroupHier.getTableGroupId(), list);
            }
            list.add(tableGroupHier);
        }
        String myNodeGroupId = this.parameterService.getNodeGroupId();
        TableGroupHierComparator comparator = new TableGroupHierComparator();
        for (List list : tableGroupHierByGroupId.values()) {
            if (list.size() <= 0) continue;
            list.sort(comparator);
            if (!myNodeGroupId.equals(((TableGroupHier)list.get(0)).getTableGroup().getSourceNodeGroupId()) || !this.validateTableGroupHiers(list)) continue;
            this.populateGroupSql(list);
        }
    }

    protected boolean validateTableGroupHiers(List<TableGroupHier> tableGroupHiers) {
        boolean foundRoot = false;
        boolean isValid = true;
        int tableNum = 0;
        LinkedCaseInsensitiveMap tableAliasMap = new LinkedCaseInsensitiveMap();
        for (TableGroupHier tableGroupHier : tableGroupHiers) {
            Table table;
            if (tableGroupHier.getParent() == null) {
                if (foundRoot) {
                    this.log.warn("Found second root configured for table group hier {}", (Object)tableGroupHier.getId());
                    isValid = false;
                    continue;
                }
                foundRoot = true;
            }
            if ((table = this.platform.getTableFromCache(tableGroupHier.getSourceCatalogName(), tableGroupHier.getSourceSchemaName(), tableGroupHier.getSourceTableName(), false)) != null) {
                TriggerHistory triggerHistory = this.triggerRouterService.findTriggerHistory(table.getCatalog(), table.getSchema(), table.getName());
                if (triggerHistory != null) {
                    tableGroupHier.setTable(table);
                    tableGroupHier.setTableAlias("x" + tableNum++);
                    tableGroupHier.setTableAliasMap((Map<String, TableGroupHier>)tableAliasMap);
                    tableGroupHier.setTriggerHistory(triggerHistory);
                    tableAliasMap.put(tableGroupHier.getTableAlias(), tableGroupHier);
                    continue;
                }
                String tableName = Table.getFullyQualifiedTableName((String)tableGroupHier.getSourceCatalogName(), (String)tableGroupHier.getSourceSchemaName(), (String)tableGroupHier.getSourceTableName()).toLowerCase();
                this.log.warn("Missing trigger history {} for table group {}", (Object)tableName, (Object)tableGroupHier.getTableGroupId());
                isValid = false;
                continue;
            }
            String tableName = Table.getFullyQualifiedTableName((String)tableGroupHier.getSourceCatalogName(), (String)tableGroupHier.getSourceSchemaName(), (String)tableGroupHier.getSourceTableName()).toLowerCase();
            this.log.warn("Missing table {} for table group {}", (Object)tableName, (Object)tableGroupHier.getTableGroupId());
            isValid = false;
        }
        return isValid;
    }

    protected void populateGroupSql(List<TableGroupHier> tableGroupHiers) {
        StringBuilder sql = new StringBuilder("select ");
        DatabaseInfo info = this.platform.getDdlBuilder().getDatabaseInfo();
        String quote = "";
        if (!this.parameterService.is("db.metadata.ignore.case")) {
            quote = this.platform.getDdlBuilder().getDatabaseInfo().getDelimiterToken();
        }
        this.appendSelect(sql, tableGroupHiers, quote);
        this.appendFrom(sql, tableGroupHiers, info, quote);
        for (TableGroupHier tableGroupHier : tableGroupHiers) {
            String whereSql = this.buildWhereSql(tableGroupHier, info, quote);
            tableGroupHier.setGroupSql(sql.toString() + whereSql);
        }
    }

    protected String buildWhereSql(TableGroupHier tableGroupHier, DatabaseInfo info, String quote) {
        String alias = "x";
        StringBuilder sql = new StringBuilder(" where ");
        if (tableGroupHier.getParent() != null) {
            sql.append("exists (select 1");
            boolean isFirst = true;
            TableGroupHier thisTableGroupHier = tableGroupHier.getParent();
            TableGroupHier lastTableGroupHier = null;
            do {
                Table table = thisTableGroupHier.getTable();
                sql.append(isFirst ? " from " : " inner join ");
                String tableAlias = "x" + thisTableGroupHier.getTableAlias();
                this.appendFromTable(sql, table, tableAlias, info, quote);
                if (!isFirst) {
                    sql.append("on ");
                    this.appendJoin(sql, lastTableGroupHier.getParsedParentColumnNames(), tableAlias, lastTableGroupHier.getParsedLocalColumnNames(), "x" + lastTableGroupHier.getTableAlias(), quote);
                }
                lastTableGroupHier = thisTableGroupHier;
                thisTableGroupHier = thisTableGroupHier.getParent();
                isFirst = false;
            } while (thisTableGroupHier != null);
            sql.append(" where ");
            this.appendColumnsWithParameters(sql, tableGroupHier.getParsedParentColumnNames(), "x" + tableGroupHier.getParent().getTableAlias(), quote);
            sql.append(" and ");
            TableGroupHier root = tableGroupHier.getRootParent();
            this.appendJoin(sql, root.getParsedPrimaryColumnNames(), "x" + root.getTableAlias(), root.getParsedPrimaryColumnNames(), root.getTableAlias(), quote);
            sql.append(")");
        } else {
            this.appendColumnsWithParameters(sql, tableGroupHier.getParsedPrimaryColumnNames(), tableGroupHier.getTableAlias(), quote);
        }
        return sql.toString();
    }

    protected void appendSelect(StringBuilder sql, List<TableGroupHier> tableGroupHiers, String quote) {
        for (TableGroupHier tableGroupHier : tableGroupHiers) {
            for (String columnName : tableGroupHier.getTable().getColumnNames()) {
                sql.append(tableGroupHier.getTableAlias()).append(".");
                sql.append(quote).append(columnName).append(quote).append(" as ");
                sql.append(tableGroupHier.getTableAlias()).append("_").append(columnName).append(", ");
            }
        }
        sql.delete(sql.length() - 2, sql.length());
    }

    protected void appendFrom(StringBuilder sql, List<TableGroupHier> tableGroupHiers, DatabaseInfo info, String quote) {
        boolean isFirst = true;
        for (TableGroupHier tableGroupHier : tableGroupHiers) {
            Table table = tableGroupHier.getTable();
            sql.append(isFirst ? " from " : " left join ");
            this.appendFromTable(sql, table, tableGroupHier.getTableAlias(), info, quote);
            if (!isFirst) {
                sql.append("on ");
                this.appendJoin(sql, tableGroupHier.getParsedLocalColumnNames(), tableGroupHier.getTableAlias(), tableGroupHier.getParsedParentColumnNames(), tableGroupHier.getParent().getTableAlias(), quote);
            }
            isFirst = false;
        }
    }

    protected void appendFromTable(StringBuilder sql, Table table, String tableAlias, DatabaseInfo info, String quote) {
        sql.append(table.getQualifiedTableName(quote, info.getCatalogSeparator(), info.getSchemaSeparator()));
        sql.append(" as ").append(tableAlias).append(" ");
    }

    protected void appendJoin(StringBuilder sql, String[] fromColumns, String fromAlias, String[] toColumns, String toAlias, String quote) {
        for (int i2 = 0; i2 < fromColumns.length && i2 < toColumns.length; ++i2) {
            sql.append(fromAlias).append(".").append(quote).append(fromColumns[i2]).append(quote);
            sql.append(" = ").append(toAlias).append(".").append(quote).append(toColumns[i2]).append(quote);
            sql.append(" and ");
        }
        sql.delete(sql.length() - 5, sql.length());
    }

    protected void appendColumnsWithParameters(StringBuilder sql, String[] columnNames, String tableAlias, String quote) {
        for (String columnName : columnNames) {
            sql.append(tableAlias).append(".");
            sql.append(quote).append(columnName).append(quote).append(" = ? and ");
        }
        sql.delete(sql.length() - 5, sql.length());
    }

    @Override
    public Map<String, List<TableGroupHier>> getTableGroupHierByTableName(String sourceNodeGroupId, String targetNodeGroupId, TableGroup.WriterType writerType, boolean refreshCache) {
        Map<String, List<TableGroupHier>> map = this.getTableGroupHierByTableName(sourceNodeGroupId, targetNodeGroupId, refreshCache);
        HashMap<String, List<TableGroupHier>> filteredMap = new HashMap<String, List<TableGroupHier>>();
        if (map != null) {
            for (Map.Entry<String, List<TableGroupHier>> entry : map.entrySet()) {
                ArrayList<TableGroupHier> list = new ArrayList<TableGroupHier>();
                for (TableGroupHier tableGroupHier : entry.getValue()) {
                    TableGroup tableGroup = tableGroupHier.getTableGroup();
                    if (tableGroup == null || tableGroup.getWriterType() != writerType) continue;
                    list.add(tableGroupHier);
                }
                if (list.size() <= 0) continue;
                filteredMap.put(entry.getKey(), list);
            }
        }
        return filteredMap;
    }

    @Override
    public void saveTableGroup(TableGroup tableGroup) {
        tableGroup.setLastUpdateTime(new Date());
        if (this.sqlTemplate.update(this.getSql("updateTableGroupSql"), new Object[]{tableGroup.getSourceNodeGroupId(), tableGroup.getTargetNodeGroupId(), tableGroup.getDescription(), tableGroup.getWriterType() != null ? tableGroup.getWriterType().getCode() : null, tableGroup.getLastUpdateTime(), tableGroup.getLastUpdateBy(), tableGroup.getId()}) <= 0) {
            tableGroup.setCreateTime(new Date());
            this.sqlTemplate.update(this.getSql("insertTableGroupSql"), new Object[]{tableGroup.getId(), tableGroup.getSourceNodeGroupId(), tableGroup.getTargetNodeGroupId(), tableGroup.getDescription(), tableGroup.getWriterType() != null ? tableGroup.getWriterType().getCode() : null, tableGroup.getLastUpdateTime(), tableGroup.getLastUpdateBy(), tableGroup.getCreateTime(), tableGroup.getCreateBy()});
        }
    }

    @Override
    public void saveTableGroupAsCopy(String originalId, TableGroup tableGroup) {
        String newId = tableGroup.getId();
        List tableGroups = this.sqlTemplate.query(this.getSql("selectTableGroups", "whereIdLikeSql"), (ISqlRowMapper)new TableGroupMapper(this.configurationService.getNodeGroupLinks(false)), new Object[]{newId + "%"});
        List ids = tableGroups.stream().map(TableGroup::getId).collect(Collectors.toList());
        Object suffix = "";
        int i2 = 2;
        while (ids.contains(newId + (String)suffix)) {
            suffix = "_" + i2;
            ++i2;
        }
        tableGroup.setId(newId + (String)suffix);
        this.saveTableGroup(tableGroup);
        ArrayList<TableGroupHier> filteredRoots = new ArrayList<TableGroupHier>();
        for (TableGroupHier tableGroupHier : this.getRootTableGroupHiers(false)) {
            if (!Strings.CS.equals(tableGroupHier.getTableGroupId(), originalId)) continue;
            filteredRoots.add(tableGroupHier);
        }
        for (TableGroupHier tableGroupHier : filteredRoots) {
            this.saveTableGroupHierAsCopyWithTableGroupId(tableGroupHier.getId(), tableGroupHier, newId + (String)suffix);
        }
    }

    @Override
    public void renameTableGroup(String oldId, TableGroup tableGroup) {
        this.saveTableGroup(tableGroup);
        this.sqlTemplate.update(this.getSql("updateTableGroupIdSql"), new Object[]{tableGroup.getId(), oldId});
        this.deleteTableGroup(oldId);
    }

    @Override
    public void deleteTableGroup(String tableGroupId) {
        this.sqlTemplate.update(this.getSql("deleteTableGroupHiersByTableGroupIdSql"), new Object[]{tableGroupId});
        this.sqlTemplate.update(this.getSql("deleteTableGroupSql"), new Object[]{tableGroupId});
    }

    @Override
    public void saveTableGroupHier(TableGroupHier hier) {
        hier.setLastUpdateTime(new Date());
        if (this.sqlTemplate.update(this.getSql("updateTableGroupHierSql"), new Object[]{hier.getTableGroupId(), hier.getSourceCatalogName(), hier.getSourceSchemaName(), hier.getSourceTableName(), hier.getParentId(), hier.getRelationType() != null ? hier.getRelationType().getCode() : null, hier.getPrimaryColumnNames(), hier.getLocalColumnNames(), hier.getParentColumnNames(), hier.getLastUpdateTime(), hier.getLastUpdateBy(), hier.getId()}) <= 0) {
            hier.setCreateTime(new Date());
            this.sqlTemplate.update(this.getSql("insertTableGroupHierSql"), new Object[]{hier.getId(), hier.getTableGroupId(), hier.getSourceCatalogName(), hier.getSourceSchemaName(), hier.getSourceTableName(), hier.getParentId(), hier.getRelationType() != null ? hier.getRelationType().getCode() : null, hier.getPrimaryColumnNames(), hier.getLocalColumnNames(), hier.getParentColumnNames(), hier.getLastUpdateTime(), hier.getLastUpdateBy(), hier.getCreateTime(), hier.getCreateBy()});
        }
    }

    @Override
    public void saveTableGroupHierAsCopy(String originalId, TableGroupHier tableGroupHier) {
        String newId = this.getNewTableGroupHierId(tableGroupHier.getId());
        tableGroupHier.setId(newId);
        this.saveTableGroupHier(tableGroupHier);
        for (TableGroupHier childTableGroupHier : this.getTableGroupHiersByParentId(originalId, true)) {
            childTableGroupHier.setParentId(newId);
            this.saveTableGroupHierAsCopy(childTableGroupHier.getId(), childTableGroupHier);
        }
    }

    private void saveTableGroupHierAsCopyWithTableGroupId(String originalId, TableGroupHier tableGroupHier, String tableGroupId) {
        String newId = this.getNewTableGroupHierId(tableGroupHier.getId());
        tableGroupHier.setId(newId);
        tableGroupHier.setTableGroupId(tableGroupId);
        this.saveTableGroupHier(tableGroupHier);
        for (TableGroupHier childTableGroupHier : this.getTableGroupHiersByParentId(originalId, true)) {
            childTableGroupHier.setParentId(newId);
            this.saveTableGroupHierAsCopyWithTableGroupId(childTableGroupHier.getId(), childTableGroupHier, tableGroupId);
        }
    }

    private String getNewTableGroupHierId(String newId) {
        List tableGroupHiers = this.sqlTemplate.query(this.getSql("selectTableGroupHiers", "whereIdLikeSql"), (ISqlRowMapper)new TableGroupHierMapper(), new Object[]{newId + "%"});
        List ids = tableGroupHiers.stream().map(TableGroupHier::getId).collect(Collectors.toList());
        Object suffix = "";
        int i2 = 2;
        while (ids.contains(newId + (String)suffix)) {
            suffix = "_" + i2;
            ++i2;
        }
        return newId + (String)suffix;
    }

    @Override
    public void renameTableGroupHier(String oldId, TableGroupHier tableGroupHier) {
        this.saveTableGroupHier(tableGroupHier);
        this.sqlTemplate.update(this.getSql("updateTableGroupHierIdSql"), new Object[]{tableGroupHier.getId(), oldId});
        this.deleteTableGroupHier(oldId);
    }

    @Override
    public void deleteTableGroupHier(String tableGroupHierId) {
        this.sqlTemplate.update(this.getSql("deleteTableGroupHierSql"), new Object[]{tableGroupHierId});
        List childTableGroupHiers = this.sqlTemplate.query(this.getSql("selectTableGroupHiers", "whereParentIdEqualsSql"), (ISqlRowMapper)new TableGroupHierMapper(), new Object[]{tableGroupHierId});
        for (TableGroupHier childTableGroupHier : childTableGroupHiers) {
            this.deleteTableGroupHier(childTableGroupHier.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        TableGroupService tableGroupService = this;
        synchronized (tableGroupService) {
            this.tableGroupsCacheTime = 0L;
            this.tableGroupHiersCacheTime = 0L;
            this.tableGroupHierMapCacheTime = 0L;
        }
    }

    protected String getSql(String ... keys) {
        return this.sql.getSql(keys);
    }

    static class TableGroupMapper
    implements ISqlRowMapper<TableGroup> {
        List<NodeGroupLink> nodeGroupLinks;

        public TableGroupMapper(List<NodeGroupLink> nodeGroupLinks) {
            this.nodeGroupLinks = nodeGroupLinks;
        }

        private NodeGroupLink getNodeGroupLink(String sourceNodeGroupId, String targetNodeGroupId) {
            for (NodeGroupLink nodeGroupLink : this.nodeGroupLinks) {
                if (!nodeGroupLink.getSourceNodeGroupId().equals(sourceNodeGroupId) || !nodeGroupLink.getTargetNodeGroupId().equals(targetNodeGroupId)) continue;
                return nodeGroupLink;
            }
            return null;
        }

        public TableGroup mapRow(Row row) {
            TableGroup t2 = new TableGroup();
            t2.setId(row.getString("id"));
            t2.setNodeGroupLink(this.getNodeGroupLink(row.getString("source_node_group_id"), row.getString("target_node_group_id")));
            t2.setDescription(row.getString("description"));
            t2.setWriterType(TableGroup.WriterType.getWriterType(row.getString("writer_type")));
            t2.setCreateTime(row.getDateTime("create_time"));
            t2.setCreateBy(row.getString("create_by"));
            t2.setLastUpdateTime(row.getDateTime("last_update_time"));
            t2.setLastUpdateBy(row.getString("last_update_by"));
            return t2;
        }
    }

    static class TableGroupHierMapper
    implements ISqlRowMapper<TableGroupHier> {
        TableGroupHierMapper() {
        }

        public TableGroupHier mapRow(Row row) {
            TableGroupHier h2 = new TableGroupHier();
            h2.setId(row.getString("id"));
            h2.setTableGroupId(row.getString("table_group_id"));
            h2.setSourceCatalogName(row.getString("source_catalog_name"));
            h2.setSourceSchemaName(row.getString("source_schema_name"));
            h2.setSourceTableName(row.getString("source_table_name"));
            h2.setParentId(row.getString("parent_id"));
            h2.setRelationType(TableGroupHier.RelationType.getRelationType(row.getString("relation_type")));
            h2.setPrimaryColumnNames(row.getString("primary_column_names"));
            h2.setLocalColumnNames(row.getString("local_column_names"));
            h2.setParentColumnNames(row.getString("parent_column_names"));
            h2.setCreateTime(row.getDateTime("create_time"));
            h2.setCreateBy(row.getString("create_by"));
            h2.setLastUpdateTime(row.getDateTime("last_update_time"));
            h2.setLastUpdateBy(row.getString("last_update_by"));
            return h2;
        }
    }

    static class TableGroupHierComparator
    implements Comparator<TableGroupHier> {
        TableGroupHierComparator() {
        }

        @Override
        public int compare(TableGroupHier o1, TableGroupHier o2) {
            return Integer.valueOf(o1.getRootParentPathLength()).compareTo(o2.getRootParentPathLength());
        }
    }
}

