/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.jumpmind.symmetric.console.impl.L;
import com.jumpmind.symmetric.console.model.CompareRequest;
import com.jumpmind.symmetric.console.service.ICompareService;
import com.jumpmind.symmetric.console.service.IProDataRefreshService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TableReloadRequest;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProDataRefreshService
implements IProDataRefreshService,
ISymmetricEngineAware {
    protected final Logger log = LoggerFactory.getLogger(ProDataRefreshService.class);
    protected ISymmetricEngine engine;
    protected L licenseService;

    @Override
    public void process() {
        if (this.engine.getNodeService().findIdentity() == null) {
            return;
        }
        HashMap routerTriggerMap = new HashMap();
        List triggerRouters = this.engine.getTriggerRouterService().getAllTriggerRoutersForCurrentNode(this.engine.getNodeService().findIdentity().getNodeGroupId());
        for (TriggerRouter triggerRouter : triggerRouters) {
            if (!triggerRouter.isEnabled() || triggerRouter.getTrigger().getSourceTableName().startsWith(this.engine.getSymmetricDialect().getTablePrefix()) || !this.isReloadConfiguredTable(triggerRouter)) continue;
            if (routerTriggerMap.get(triggerRouter.getRouter()) == null) {
                routerTriggerMap.put(triggerRouter.getRouter(), new ArrayList());
            }
            ((List)routerTriggerMap.get(triggerRouter.getRouter())).add(triggerRouter);
        }
        for (Map.Entry entry : routerTriggerMap.entrySet()) {
            Router router = (Router)entry.getKey();
            Collection targetNodes = this.engine.getNodeService().findEnabledNodesFromNodeGroup(router.getNodeGroupLink().getTargetNodeGroupId());
            Iterator iterator = targetNodes.iterator();
            while (iterator.hasNext()) {
                this.createComparesAndReloads((List)entry.getValue(), ((Node)iterator.next()).getNodeId(), router);
            }
        }
    }

    protected void createComparesAndReloads(List<TriggerRouter> triggerRouters, String targetNodeId, Router router) {
        Date createTime = new Date();
        ICompareService compareService = (ICompareService)this.engine.getExtensionService().getExtensionPoint(ICompareService.class);
        for (TriggerRouter triggerRouter : triggerRouters) {
            if (triggerRouter.getDataRefreshType().equals("auto") || triggerRouter.getDataRefreshType().equals("differences")) {
                Trigger trigger = triggerRouter.getTrigger();
                Table table = this.engine.getTargetDialect().getTargetPlatform().getTableFromCache(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), false);
                if (this.isTableEligibleForCompare(table, trigger)) {
                    CompareRequest request = new CompareRequest();
                    request.setSourceNodeId(this.engine.getNodeId());
                    request.setTargetNodeId(targetNodeId);
                    request.setTriggerId(triggerRouter.getTriggerId());
                    request.setRouterId(router.getRouterId());
                    request.setCreateTime(createTime);
                    request.setChecksumAlgorithm("CRC32");
                    request.setUseRepair(true);
                    request.setDecimalScale(2);
                    request.setTimestampScale(3);
                    request.setRealScale(6);
                    request.setLastUpdateBy("Data Refresh Job");
                    request.setLastUpdateTime(createTime);
                    request.setNotBefore(DateUtils.addSeconds((Date)createTime, (int)30));
                    request.setUseInflight(false);
                    request.setUseChunking(true);
                    request.setUseRowLevel(true);
                    request.setUseTableChecksum(true);
                    compareService.insertCompareRequest(request);
                    continue;
                }
                this.createReload(targetNodeId, triggerRouter, createTime);
                continue;
            }
            this.createReload(targetNodeId, triggerRouter, createTime);
        }
    }

    protected void createReload(String targetNodeId, TriggerRouter triggerRouter, Date createTime) {
        TableReloadRequest request = new TableReloadRequest();
        request.setSourceNodeId(this.engine.getNodeId());
        request.setTargetNodeId(targetNodeId);
        request.setTriggerId(triggerRouter.getTriggerId());
        request.setRouterId(triggerRouter.getRouter().getRouterId());
        request.setDeleteFirst(true);
        request.setCreateTable(this.engine.getParameterService().is("data.refresh.create.first"));
        request.setCreateTime(createTime);
        request.setLastUpdateBy("Data Refresh Job");
        this.engine.getDataService().insertTableReloadRequest(request);
    }

    protected boolean isTableEligibleForCompare(Table table, Trigger trigger) {
        if (!this.getLicenseService().f()) {
            return false;
        }
        if (table == null) {
            return false;
        }
        return table.hasPrimaryKey() || table.getUniqueIndices().length != 0 || !StringUtils.isEmpty((CharSequence)trigger.getSyncKeyNames());
    }

    protected boolean isReloadConfiguredTable(TriggerRouter triggerRouter) {
        return StringUtils.isNotBlank((CharSequence)triggerRouter.getDataRefreshType());
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    protected L getLicenseService() {
        if (this.licenseService == null) {
            this.licenseService = (L)this.engine.getExtensionService().getExtensionPoint(L.class);
        }
        return this.licenseService;
    }
}

