/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.jumpmind.symmetric.console.impl.fs;
import com.jumpmind.symmetric.console.impl.fx;
import com.jumpmind.symmetric.console.impl.hh;
import com.jumpmind.symmetric.db.cosmos.e;
import com.jumpmind.symmetric.db.cosmos.g;
import com.jumpmind.symmetric.db.mongo.f;
import com.jumpmind.symmetric.db.mongo.i;
import com.jumpmind.symmetric.db.snowflake.a;
import com.jumpmind.symmetric.log.TimeBasedMiner;
import com.jumpmind.symmetric.log.h;
import com.jumpmind.symmetric.log.j;
import com.jumpmind.symmetric.log.k;
import com.jumpmind.symmetric.log.l;
import com.jumpmind.symmetric.log.o;
import com.jumpmind.symmetric.log.p;
import com.jumpmind.symmetric.log.u;
import com.jumpmind.symmetric.log.v;
import com.jumpmind.symmetric.log.w;
import com.jumpmind.symmetric.log.x;
import com.jumpmind.symmetric.log.y;
import com.jumpmind.symmetric.log.z;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2008DatabasePlatform;
import org.jumpmind.db.platform.postgresql.PostgreSqlDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.extension.IExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.mariadb.MariaDBSymmetricDialect;
import org.jumpmind.symmetric.db.mysql.MySqlSymmetricDialect;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.Lock;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.IIncomingBatchListener;
import org.jumpmind.symmetric.service.ILogMinerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerService
implements IBuiltInExtensionPoint,
ISymmetricEngineAware,
IIncomingBatchListener,
ILogMinerService {
    private final Logger log = LoggerFactory.getLogger((String)new hh(new long[]{-2718665930066417092L, 3962765473865876724L, 6508867197005074990L, -3558938335506093162L, 1968799547531790172L, -2754740186739489470L, -4001349594152836165L, 8260493406960194840L, 525070168144122797L}).toString());
    private static final String XID = "xid";
    protected ISymmetricEngine engine;
    protected h miner;
    protected boolean useIncomingBatches;
    protected Map<String, com.jumpmind.symmetric.log.i> incomingTransactions = new ConcurrentHashMap<String, com.jumpmind.symmetric.log.i>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long mineData(boolean force) {
        long dataCount = -1L;
        Node identity = this.engine.getNodeService().findIdentity();
        if (identity != null && (force || this.engine.getClusterService().lock("Log Miner"))) {
            ProcessInfo processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(identity.getNodeId(), null, ProcessType.LOG_MINER_JOB));
            processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
            try {
                long ts = System.currentTimeMillis();
                dataCount = this.mineDataForTables(processInfo);
                ts = System.currentTimeMillis() - ts;
                if (dataCount > 0L || ts > 30000L) {
                    this.log.info("Mined {} data events in {} ms", (Object)dataCount, (Object)ts);
                }
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
            }
            catch (Exception e2) {
                this.miner = null;
                processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
            }
            finally {
                if (!force) {
                    this.engine.getClusterService().unlock("Log Miner");
                }
            }
        }
        return dataCount;
    }

    protected long mineDataForTables(ProcessInfo processInfo) {
        long ts;
        JdbcSqlTransaction transaction = null;
        h miner = null;
        com.jumpmind.symmetric.log.e writer = this.getLogMinerWriter();
        int maxNumberOfEventsBeforeFlush = this.engine.getParameterService().getInt("log.miner.flush.commit.size");
        long startTime = ts = System.currentTimeMillis();
        long dataCount = 0L;
        long uncommittedCount = 0L;
        boolean isError = false;
        try {
            miner = this.getLogMiner();
            miner.setLogTriggerMap(this.getLogTriggerMap());
            transaction = (JdbcSqlTransaction)this.engine.getSqlTemplate().startSqlTransaction();
            if (transaction != null) {
                transaction.setInBatchMode(true);
                transaction.setBatchSize(((JdbcSqlTemplate)this.engine.getSqlTemplate()).getSettings().getBatchBulkLoaderSize());
            }
            miner.setTransaction((ISqlTransaction)transaction);
            Collection<j> openTransactions = miner.getOpenTransactions();
            if (this.log.isDebugEnabled() && openTransactions != null && openTransactions.size() > 0) {
                this.log.debug("Tracking {} open XIDs: {}", (Object)openTransactions.size(), (Object)j.b(openTransactions));
            }
            if (this.log.isDebugEnabled() && this.incomingTransactions != null && this.incomingTransactions.size() > 0) {
                this.log.debug("Tracking {} incoming XIDs: {}", (Object)this.incomingTransactions.size(), (Object)com.jumpmind.symmetric.log.i.b(this.incomingTransactions.values()));
            }
            long startId = 0L;
            if (!miner.handlesSaveOfNextID()) {
                startId = this.engine.getContextService().getLong("log.miner.next.id");
                this.log.debug("Obtained a start ID {} from sym_context", (Object)startId);
            } else {
                startId = 0L;
            }
            long endId = miner.getCurrentId();
            if (startId == 0L || startId > endId + 2L) {
                if (startId != 0L) {
                    this.log.error("Decreasing the next ID from {} to {} because it's greater than the current ID of {}", new Object[]{startId, endId, endId});
                }
                startId = endId;
                this.savePositionAndCommit((ISqlTransaction)transaction, startId, miner.getOpenTransactions());
            } else if (startId > endId) {
                this.log.debug("The next ID {} has not arrived yet, since current ID is {}", (Object)startId, (Object)endId);
                long l2 = dataCount;
                return l2;
            }
            miner.setStartId(startId);
            miner.setEndId(endId);
            this.log.debug("Opening miner with start ID {} and end ID {}", (Object)startId, (Object)endId);
            miner.open();
            String lastTransactionId = null;
            long lastId = 0L;
            HashSet<String> noLongerValidTables = new HashSet<String>();
            while (miner.hasData()) {
                Data data = miner.readData();
                ++dataCount;
                boolean isTransactionBoundary = lastTransactionId != null && !lastTransactionId.equals(data.getTransactionId());
                processInfo.setCurrentTableName(data.getTableName());
                processInfo.incrementCurrentDataCount();
                if (uncommittedCount >= (long)maxNumberOfEventsBeforeFlush && isTransactionBoundary) {
                    writer.a(transaction);
                    this.savePositionAndCommit((ISqlTransaction)transaction, miner.isWaitsForCommit() ? lastId : lastId + 1L, miner.getOpenTransactions());
                    uncommittedCount = 0L;
                }
                if (data.getTriggerHistory() != null) {
                    writer.a(transaction, data);
                    ++uncommittedCount;
                } else {
                    String tableName = data.getTableName();
                    if (!noLongerValidTables.contains(tableName)) {
                        this.log.warn("Skipping data for table {} that is no longer configured to sync", (Object)tableName);
                        noLongerValidTables.add(tableName);
                    }
                }
                lastTransactionId = data.getTransactionId();
                lastId = miner.getCurrentId();
                long logTs = System.currentTimeMillis() - ts;
                if (logTs <= 60000L) continue;
                this.engine.getClusterService().refreshLock("Log Miner");
                this.log.info("Mining log has been processing for {} seconds and {} total rows with {} matching rows", new Object[]{(System.currentTimeMillis() - startTime) / 1000L, miner.getTotalRowsScanned(), dataCount});
                ts = System.currentTimeMillis();
            }
            writer.a(transaction);
            if (miner.isWaitsForCommit()) {
                if (lastId != 0L) {
                    this.savePositionAndCommit((ISqlTransaction)transaction, endId, miner.getOpenTransactions());
                }
            } else {
                this.savePositionAndCommit((ISqlTransaction)transaction, endId + 1L, miner.getOpenTransactions());
            }
            this.log.debug("Closing miner with start ID {} and end ID {}", (Object)startId, (Object)endId);
        }
        catch (z ete) {
            this.log.info(ete.getMessage());
            writer.a(ete);
            if (transaction != null) {
                transaction.rollback();
            }
        }
        catch (Exception e2) {
            isError = true;
            this.log.error("Failed to mine the log", (Throwable)e2);
            writer.a(e2);
            if (transaction != null) {
                transaction.rollback();
            }
            throw e2;
        }
        finally {
            miner.close();
            if (isError) {
                miner = null;
            }
            if (transaction != null) {
                transaction.close();
            }
        }
        return dataCount;
    }

    protected void savePositionAndCommit(ISqlTransaction transaction, long nextId, Collection<j> openTransactions) {
        if (this.useIncomingBatches && this.incomingTransactions.size() > 0 && this.miner.getIncomingMinedTransactionIds().size() > 0) {
            this.incomingTransactions.keySet().removeAll(this.miner.getIncomingMinedTransactionIds());
            this.miner.getIncomingMinedTransactionIds().clear();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Saving {} incoming transactions: {}", (Object)this.incomingTransactions.size(), (Object)com.jumpmind.symmetric.log.i.b(this.incomingTransactions.values()));
            }
            this.engine.getContextService().save(transaction, "log.miner.incoming.transactions", com.jumpmind.symmetric.log.i.a(this.incomingTransactions.values()));
        }
        if (this.miner.handlesSaveOfNextID()) {
            this.miner.savePositionAndCommit(transaction);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Saving position at ID {} with {} open XIDs: {}", new Object[]{nextId, openTransactions.size(), j.b(openTransactions)});
            }
            this.engine.getContextService().save(transaction, "log.miner.next.id", String.valueOf(nextId));
            this.engine.getContextService().save(transaction, "log.miner.open.transactions", j.a(openTransactions));
            transaction.commit();
        }
    }

    protected h getLogMiner() {
        Lock lock = null;
        if (this.engine.getParameterService().is("cluster.lock.enabled")) {
            lock = (Lock)this.engine.getClusterService().findLocks().get("Log Miner");
        }
        if (this.miner == null || lock != null && (lock.getLastLockingServerId() == null || !lock.getLastLockingServerId().equals(lock.getLockingServerId()))) {
            IDatabasePlatform platform = this.engine.getTargetDialect().getPlatform();
            if (this.engine.getParameterService().is("time.based.capture")) {
                this.miner = new TimeBasedMiner(this.engine);
                this.log.debug("Time based miner used.");
            } else if (platform instanceof MsSql2008DatabasePlatform) {
                this.miner = new o(this.engine);
                this.log.debug("MsSqlTransactionMiner used.");
            } else if (this.engine.getTargetDialect().getTargetPlatform() instanceof f) {
                this.miner = new i(this.engine, this.engine.getParameterService());
                this.log.debug("MongoTransactionMiner used.");
            } else if (platform instanceof PostgreSqlDatabasePlatform) {
                this.miner = new v(this.engine);
                this.log.debug("PostgresTransactionMiner used.");
            } else if (platform instanceof e) {
                this.miner = new g(this.engine);
                this.log.debug("CosmosTransactionMinder used.");
            } else if (platform instanceof fs) {
                this.miner = new fx(this.engine);
                this.log.debug("SingleStoreTransactionMiner used.");
            } else if (platform instanceof a) {
                this.miner = new x(this.engine);
                this.log.debug("SnowflakeTransactionMiner used.");
            } else {
                this.miner = new y(this.engine);
                this.log.debug("TransactionMiner used.");
            }
            String openTransactions = this.engine.getContextService().getString("log.miner.open.transactions");
            this.miner.setOpenTransactions(j.a(openTransactions));
            if (this.useIncomingBatches) {
                this.incomingTransactions.putAll(com.jumpmind.symmetric.log.i.a(this.engine.getContextService().getString("log.miner.incoming.transactions")));
                this.miner.setIncomingTransactions(this.incomingTransactions);
            }
        }
        return this.miner;
    }

    protected com.jumpmind.symmetric.log.e getLogMinerWriter() {
        com.jumpmind.symmetric.log.e writer = null;
        IDatabasePlatform platform = this.engine.getDatabasePlatform();
        if (platform instanceof PostgreSqlDatabasePlatform) {
            writer = new u(this.engine);
            this.log.debug("PostgresLogMinerWriter used.");
        } else {
            writer = new k(this.engine);
            this.log.debug("LogMinerWriter used.");
        }
        return writer;
    }

    protected Map<String, l> getLogTriggerMap() {
        AbstractMap map = null;
        map = this.engine.getParameterService().is("db.metadata.ignore.case") ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : new HashMap();
        String prefix = this.engine.getParameterService().getTablePrefix();
        List histories = this.engine.getTriggerRouterService().getActiveTriggerHistoriesFromCache();
        int userTableCount = 0;
        for (TriggerHistory history : histories) {
            if (history.getSourceTableName().startsWith(prefix)) continue;
            Trigger trigger = this.engine.getTriggerRouterService().getTriggerById(history.getTriggerId(), false);
            if (trigger != null) {
                String schema;
                String tableName = history.getSourceTableName();
                String catalog = history.getSourceCatalogName();
                if (StringUtils.isBlank((CharSequence)catalog)) {
                    catalog = this.engine.getTargetDialect().getPlatform().getDefaultCatalog();
                }
                if (StringUtils.isBlank((CharSequence)(schema = history.getSourceSchemaName()))) {
                    schema = this.engine.getTargetDialect().getPlatform().getDefaultSchema();
                }
                String key = Table.getFullyQualifiedTableName((String)catalog, (String)schema, (String)tableName);
                map.put(key, new l(trigger, history));
            } else {
                this.log.debug("Trigger ID '{}' from trigger history {} was not found", (Object)history.getTriggerId(), (Object)history.getTriggerHistoryId());
            }
            ++userTableCount;
        }
        this.log.debug("Found {} active trigger histories, {} user tables, {} log triggers", new Object[]{histories.size(), userTableCount, map.size()});
        return map;
    }

    public boolean isInterestedInBatches() {
        return this.useIncomingBatches && this.getLogMiner().needsIncomingTransactions();
    }

    public void batchStarted(DataContext context, ISymmetricDialect dialect) {
        String xid = null;
        String channelId = context.getBatch().getChannelId();
        if (!(channelId == null || channelId.equals("config") || channelId.equals("filesync") || channelId.equals("filesync_reload") || channelId.equals("heartbeat") || channelId.equals("monitor") || channelId.equals("reload") || channelId.equals("system"))) {
            xid = dialect.getTargetDialect().getTransactionId(context.findTargetTransaction());
            context.put(XID, (Object)xid);
        } else {
            this.log.debug("Ignoring incoming transaction from channel {}", (Object)channelId);
            context.remove(XID);
        }
    }

    public void batchCommitted(DataContext context, ISymmetricDialect dialect) {
        String xid = (String)context.get(XID);
        if (xid != null) {
            if (this.engine.getTargetDialect() instanceof MariaDBSymmetricDialect) {
                xid = dialect.getTargetDialect().getTransactionId(context.findTargetTransaction());
            } else if (this.engine.getTargetDialect() instanceof MySqlSymmetricDialect) {
                String afterXid = this.massageMySqlXid(dialect.getTargetDialect().getTransactionId(context.findTargetTransaction()));
                try {
                    xid = this.massageMySqlXid(xid);
                    if (Integer.parseInt(xid) + 1 != Integer.parseInt(afterXid)) {
                        this.log.warn("Could not determine transaction ID because multiple executed IDs occurred from {} to {}", (Object)xid, (Object)afterXid);
                        return;
                    }
                }
                catch (RuntimeException e2) {
                    this.log.warn("Could not determine transaction ID from {} to {} because {}", new Object[]{xid, afterXid, e2.getClass().getName()});
                    return;
                }
                xid = afterXid;
            }
            this.incomingTransactions.put(xid, new com.jumpmind.symmetric.log.i(xid, context.getBatch().getSourceNodeId()));
            this.log.debug("Incoming transaction {} from node {} was observed", (Object)xid, (Object)context.getBatch().getSourceNodeId());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Saving {} incoming transactions: {}", (Object)this.incomingTransactions.size(), (Object)com.jumpmind.symmetric.log.i.b(this.incomingTransactions.values()));
            }
            this.engine.getContextService().save("log.miner.incoming.transactions", com.jumpmind.symmetric.log.i.a(this.incomingTransactions.values()));
        }
    }

    protected String massageMySqlXid(String xid) {
        int index = xid.indexOf("-");
        if (index != -1) {
            xid = xid.substring(index + 1);
        }
        return xid;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
        IDatabasePlatform platform = engine.getTargetDialect().getPlatform();
        if (engine.getParameterService().is("start.log.miner.job") && engine.getParameterService().is("load.only") && !engine.getParameterService().is("time.based.capture")) {
            this.useIncomingBatches = engine.getParameterService().is("log.miner.use.incoming.transactions");
            if (platform instanceof MsSql2008DatabasePlatform) {
                engine.getExtensionService().addExtensionPoint((IExtensionPoint)new p(engine));
            } else if (platform instanceof PostgreSqlDatabasePlatform) {
                engine.getExtensionService().addExtensionPoint((IExtensionPoint)new w(engine));
            }
        }
    }
}

