/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.model.ValidationResult;
import com.jumpmind.symmetric.console.service.impl.ConsoleUserService;
import java.io.ByteArrayOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ConsoleUserServiceHelper {
    public ValidationResult validatePasswordComplexity(ConsoleUser user, boolean containsSymbol, boolean containsNumber, boolean containsMixedCase, boolean containsCommonWord, int passwordLength) {
        int minLength = passwordLength;
        boolean symbol = containsSymbol;
        boolean alphanum = containsNumber;
        boolean mixedCase = containsMixedCase;
        boolean prohibitCommon = containsCommonWord;
        String symbolPattern = ".*[^\\w].*";
        String upperPattern = ".*[A-Z].*";
        String lowerPattern = ".*[a-z].*";
        String numberPattern = ".*[0-9].*";
        String letterPattern = ".*[A-Za-z].*";
        String userFirstName = null;
        String userLastName = null;
        if (user.getFirstName() == null) {
            userFirstName = "Administrator";
        } else {
            userFirstName = user.getFirstName();
            userFirstName = userFirstName.replaceAll("\\s", "");
        }
        if (user.getLastName() == null) {
            userLastName = "Administrator";
        } else {
            userLastName = user.getLastName();
            userLastName = userLastName.replaceAll("\\s", "");
        }
        ValidationResult result = new ValidationResult(ValidationResult.ValidationStatus.VALID, null);
        String password = user.getPassword();
        if (password == null) {
            result = new ValidationResult(ValidationResult.ValidationStatus.INVALID, "Password must not be blank ");
        } else if (minLength > 0 && password.length() < minLength) {
            result = new ValidationResult(ValidationResult.ValidationStatus.INVALID, "Password doesn't meet minimum length requirement");
        } else if (symbol && !password.matches(symbolPattern)) {
            result = new ValidationResult(ValidationResult.ValidationStatus.INVALID, "Password must contain a symbol");
        } else if (!(!alphanum || password.matches(letterPattern) && password.matches(numberPattern))) {
            result = new ValidationResult(ValidationResult.ValidationStatus.INVALID, "Password must contain both letters and numbers");
        } else if (!(!mixedCase || password.matches(upperPattern) && password.matches(lowerPattern))) {
            result = new ValidationResult(ValidationResult.ValidationStatus.INVALID, "Password must contain both lower and upper case");
        } else if (prohibitCommon && this.containsCommonWords(password)) {
            result = new ValidationResult(ValidationResult.ValidationStatus.INVALID, "Password must not contain common words");
        } else if (password.toLowerCase().contains(user.getUserId().toLowerCase())) {
            result = new ValidationResult(ValidationResult.ValidationStatus.INVALID, "Password must not contain User Id");
        } else if (prohibitCommon && Pattern.compile(Pattern.quote(userFirstName), 2).matcher(password).find()) {
            result = new ValidationResult(ValidationResult.ValidationStatus.INVALID, "Password must not contain User's first or last name");
        } else if (prohibitCommon && Pattern.compile(Pattern.quote(userLastName), 2).matcher(password).find()) {
            result = new ValidationResult(ValidationResult.ValidationStatus.INVALID, "Password must not contain User's first or last name");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsCommonWords(String password) {
        try (ZipInputStream zip = new ZipInputStream(ConsoleUserService.class.getResourceAsStream("/common-passwords.zip"));){
            ZipEntry entry = null;
            entry = zip.getNextEntry();
            while (entry != null) {
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    String[] wordsArray;
                    int readCount;
                    byte[] buffer = new byte[4096];
                    while ((readCount = zip.read(buffer)) > 0) {
                        os.write(buffer, 0, readCount);
                    }
                    String text = new String(os.toByteArray());
                    for (String word : wordsArray = text.split("\\r?\\n")) {
                        if (!password.contains(word)) continue;
                        boolean bl2 = true;
                        return bl2;
                    }
                }
                entry = zip.getNextEntry();
            }
            boolean bl3 = false;
            return bl3;
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }
}

