/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.jumpmind.symmetric.console.impl.F;
import com.jumpmind.symmetric.console.impl.M;
import com.jumpmind.symmetric.console.impl.c;
import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.service.IUpdateService;
import org.jumpmind.symmetric.service.impl.UpdateService;

public class ConsoleUpdateService
extends UpdateService
implements IUpdateService {
    public ConsoleUpdateService(ISymmetricEngine engine) {
        super(engine);
    }

    protected Map<String, Object> getProperties() {
        Map prop = super.getProperties();
        String keyStr = this.engine.getParameterService().getString(F.a);
        M key = c.a(keyStr, M.class);
        if (key != null) {
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat df22 = new SimpleDateFormat("yyyyMMdd");
            prop.put("lic_holder", key.d().toString().replaceAll("CN=", ""));
            prop.put("lic_start", df2.format(key.g()));
            prop.put("lic_end", df2.format(key.h()));
            prop.put("lic_tier", key.p());
            prop.put("lic_nodes", key.l());
            try {
                prop.put("lic_max_build", df2.format(df22.parse("" + key.i())));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return prop;
    }

    protected void addUsageProperties(Map<String, Object> prop) {
        super.addUsageProperties(prop);
        IConsoleUserService consoleUserService = (IConsoleUserService)this.engine.getExtensionService().getExtensionPoint(IConsoleUserService.class);
        List<ConsoleUser> users = consoleUserService.findConsoleUsers();
        int ldapUserCount = 0;
        int samlUserCount = 0;
        int oAuth2UserCount = 0;
        for (ConsoleUser user : users) {
            if (user.getAuthenticationMethod().equals("LDAP")) {
                ++ldapUserCount;
                continue;
            }
            if (user.getAuthenticationMethod().equals("SAML")) {
                ++samlUserCount;
                continue;
            }
            if (!user.getAuthenticationMethod().equals("OAUTH2")) continue;
            ++oAuth2UserCount;
        }
        prop.put("users", users.size());
        prop.put("users_ldap", ldapUserCount);
        prop.put("users_saml", samlUserCount);
        prop.put("users_oAuth2", oAuth2UserCount);
    }

    protected void parseHeaders(HttpURLConnection conn) {
    }

    protected URL getUpdateUrl() throws MalformedURLException {
        return new URL("https://status.jumpmind.com/api/getlatest.php");
    }
}

