/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service;

import com.jumpmind.symmetric.console.model.TableGroupHier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.mapper.RowMapper;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableGroupHelper {
    private static final Logger log = LoggerFactory.getLogger(TableGroupHelper.class);
    protected ISymmetricEngine engine;
    protected ITriggerRouterService triggerRouterService;
    protected IDatabasePlatform targetPlatform;
    BinaryEncoding binaryEncoding;

    public TableGroupHelper(ISymmetricEngine engine) {
        this.engine = engine;
        this.triggerRouterService = engine.getTriggerRouterService();
        this.targetPlatform = engine.getTargetDialect().getTargetPlatform();
        this.binaryEncoding = engine.getSymmetricDialect().getBinaryEncoding();
    }

    public Set<String> getTargetNodesForNewAssignment(List<TableGroupHier> tableGroupHierList, Map<String, List<TableGroupHier>> tableGroupHierMap, SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed) {
        Table rootTable = tableGroupHierList.get(0).getRootParent().getTable();
        Data rootData = this.processTableGroupHier(tableGroupHierList, dataMetaData.getData(), false);
        Set triggerRouters = this.triggerRouterService.getTriggerRouterForTableForCurrentNode(rootTable.getCatalog(), rootTable.getSchema(), rootTable.getName(), false);
        HashSet<String> returnNodes = new HashSet<String>();
        for (TriggerRouter tr : triggerRouters) {
            String routerType = tr.getRouter().getRouterType();
            IDataRouter rootRouter = this.getTableGroupRootRouter(routerType);
            dataMetaData.setRouter(tr.getRouter());
            rootData.setDataId(dataMetaData.getData().getDataId());
            dataMetaData.setData(rootData);
            Set destinationNodes = rootRouter.routeToNodes(context, dataMetaData, nodes, initialLoad, initialLoadSelectUsed, tr);
            if (destinationNodes == null) continue;
            returnNodes.addAll(destinationNodes);
        }
        return returnNodes;
    }

    public Set<String> getTargetNodesForAssignmentRemoval(List<TableGroupHier> tableGroupHierList, Map<String, List<TableGroupHier>> tableGroupHierMap, SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed) {
        HashSet<String> returnNodes = new HashSet<String>();
        Table rootTable = tableGroupHierList.get(0).getRootParent().getTable();
        Data oldRootData = this.processTableGroupHier(tableGroupHierList, dataMetaData.getData(), true);
        if (oldRootData == null) {
            return returnNodes;
        }
        Set triggerRouters = this.triggerRouterService.getTriggerRouterForTableForCurrentNode(rootTable.getCatalog(), rootTable.getSchema(), rootTable.getName(), false);
        for (TriggerRouter tr : triggerRouters) {
            String routerType = tr.getRouter().getRouterType();
            IDataRouter rootRouter = this.getTableGroupRootRouter(routerType);
            dataMetaData.setRouter(tr.getRouter());
            dataMetaData.setData(oldRootData);
            Set destinationNodes = rootRouter.routeToNodes(context, dataMetaData, nodes, initialLoad, initialLoadSelectUsed, tr);
            if (destinationNodes == null) continue;
            returnNodes.addAll(destinationNodes);
        }
        return returnNodes;
    }

    protected Data processTableGroupHier(List<TableGroupHier> tableGroupHierList, Data data, boolean useOldDataForUpdate) {
        Iterator<TableGroupHier> iterator = tableGroupHierList.iterator();
        if (iterator.hasNext()) {
            TableGroupHier tableGroupHier = iterator.next();
            Object[] keyValues = null;
            if (tableGroupHier.getTable() == null) {
                tableGroupHier.setTable(this.targetPlatform.getTableFromCache(tableGroupHier.getSourceCatalogName(), tableGroupHier.getSourceSchemaName(), tableGroupHier.getSourceTableName(), false));
            }
            keyValues = tableGroupHier.getParent() == null ? this.convertToArray(data, tableGroupHier.getTable(), tableGroupHier.getTable().getPrimaryKeyColumnNames(), useOldDataForUpdate) : this.convertToArray(data, tableGroupHier.getTable(), tableGroupHier.getParsedLocalColumnNames(), useOldDataForUpdate);
            return this.queryForChildren(tableGroupHier.getGroupSql(), tableGroupHier.getTableAliasMap(), data, keyValues);
        }
        return null;
    }

    protected Object[] convertToArray(Data data, Table table, String[] columnNames, boolean useOldDataForUpdate) {
        Object[] values = null;
        if (columnNames != null) {
            Map parsedMap = data.getDataEventType() == DataEventType.DELETE ? data.toColumnNameValuePairs(data.getTriggerHistory().getParsedColumnNames(), "oldData") : data.toColumnNameValuePairs(data.getTriggerHistory().getParsedColumnNames(), useOldDataForUpdate ? "oldData" : "rowData");
            String[] parsedValues = new String[columnNames.length];
            for (int i2 = 0; i2 < columnNames.length; ++i2) {
                parsedValues[i2] = (String)parsedMap.get(columnNames[i2]);
            }
            values = this.targetPlatform.getObjectValues(this.binaryEncoding, table, columnNames, parsedValues);
        }
        return values;
    }

    protected Data queryForChildren(String sql, Map<String, TableGroupHier> tableGroupHiersByAlias, Data origData, Object[] keyValues) {
        if (log.isDebugEnabled()) {
            log.debug("Group SQL: {} {}", (Object)sql, (Object)ArrayUtils.toString((Object)keyValues));
        }
        List rows = this.targetPlatform.getSqlTemplate().query(sql, (ISqlRowMapper)new RowMapper(), keyValues);
        HashMap lastRowMapByAlias = new HashMap();
        for (Row row : rows) {
            LinkedHashMap<String, Row> rowMapByAlias = new LinkedHashMap<String, Row>();
            for (String string : row.keySet()) {
                int index = string.indexOf("_");
                if (index == -1) continue;
                String tableAlias = string.substring(0, index);
                String columnName = string.substring(index + 1);
                Row cleanRow = (Row)rowMapByAlias.get(tableAlias);
                if (cleanRow == null) {
                    cleanRow = new Row(10);
                    rowMapByAlias.put(tableAlias, cleanRow);
                }
                cleanRow.put(columnName, row.get((Object)string));
            }
            for (Map.Entry entry : rowMapByAlias.entrySet()) {
                DataEventType eventType;
                String tableAlias = (String)entry.getKey();
                Row thisRow = (Row)entry.getValue();
                Row lastRow = (Row)lastRowMapByAlias.get(tableAlias);
                TableGroupHier depTableGroupHier = tableGroupHiersByAlias.get(tableAlias);
                boolean isNulled = true;
                for (Object value : thisRow.values()) {
                    isNulled &= value == null;
                }
                if (isNulled || depTableGroupHier == null || lastRow != null && lastRow.equals((Object)thisRow)) continue;
                String rowData = this.targetPlatform.getCsvStringValue(this.binaryEncoding, depTableGroupHier.getTable().getColumns(), thisRow, new boolean[depTableGroupHier.getTable().getColumnCount()]);
                String pkData = null;
                DataEventType dataEventType = eventType = origData.getDataEventType() == DataEventType.DELETE ? DataEventType.UPDATE : origData.getDataEventType();
                if (eventType == DataEventType.UPDATE) {
                    pkData = this.targetPlatform.getCsvStringValue(this.binaryEncoding, depTableGroupHier.getTable().getPrimaryKeyColumns(), this.getPkRow(thisRow, depTableGroupHier.getTable()), new boolean[depTableGroupHier.getTable().getPrimaryKeyColumnCount()]);
                }
                Data data = new Data(depTableGroupHier.getSourceTableName(), eventType, rowData, pkData, depTableGroupHier.getTriggerHistory(), origData.getChannelId(), origData.getTransactionId(), origData.getSourceNodeId());
                return data;
            }
        }
        return null;
    }

    protected Row getPkRow(Row row, Table table) {
        Row pkRow = new Row(table.getPrimaryKeyColumnCount());
        for (String name : table.getPrimaryKeyColumnNames()) {
            pkRow.put(name, row.get((Object)name));
        }
        return pkRow;
    }

    protected IDataRouter getTableGroupRootRouter(String routerType) {
        IRouterService routerService = this.engine.getRouterService();
        IDataRouter dataRouter = null;
        Map routers = routerService.getRouters();
        if (StringUtils.isNotBlank((CharSequence)routerType)) {
            dataRouter = (IDataRouter)routers.get(routerType);
        }
        if (dataRouter == null) {
            dataRouter = (IDataRouter)routers.get("default");
        }
        return dataRouter;
    }

    public boolean isOverlap(Set<String> insertNodes, Set<String> deleteNodes) {
        if (insertNodes.size() == 0 && deleteNodes.size() == 0) {
            return true;
        }
        for (String nodeId : deleteNodes) {
            if (!insertNodes.contains(nodeId)) continue;
            return true;
        }
        return false;
    }
}

