/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.IOException;
import org.jumpmind.symmetric.model.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketSession;

public abstract class SessionEndpoint
extends Endpoint {
    private static final Logger log = LoggerFactory.getLogger(SessionEndpoint.class);
    static final int WEB_SOCKET_ERROR_MESSAGE_MAX_LENGTH = 123;
    private Node me;
    private Session session;
    private EndpointConfig config;

    public void onOpen(Session session, EndpointConfig config) {
        log.debug("WebSocket open: {} - {}", (Object)session, (Object)config);
        this.session = session;
        this.config = config;
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.session = null;
        log.debug("WebSocket Close: {} - {}", (Object)closeReason.getCloseCode(), (Object)closeReason.getReasonPhrase());
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public WebSocketSession getSession(String nodeId) {
        return null;
    }

    public EndpointConfig getConfig() {
        return this.config;
    }

    public void setConfig(EndpointConfig config) {
        this.config = config;
    }

    protected boolean checkStatus() {
        return this.getSession() != null && this.getSession().isOpen();
    }

    public Node getMe() {
        return this.me;
    }

    public void setMe(Node me) {
        this.me = me;
    }

    public void close() {
        try {
            this.session.close();
        }
        catch (IOException ex2) {
            log.debug("Exception while closing session.", (Throwable)ex2);
        }
    }
}

