/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.jumpmind.symmetric.console.remote.IRemoteStatusService;
import com.jumpmind.symmetric.console.remote.SessionEndpoint;
import com.jumpmind.symmetric.console.remote.WsMessageHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.service.INodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.util.UriComponentsBuilder;

public class ServerEndpoint
extends SessionEndpoint
implements WebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(ServerEndpoint.class);
    private Map<WebSocketSession, State> sessions = new ConcurrentHashMap<WebSocketSession, State>();

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        String sourceNodeId = null;
        String targetNodeId = null;
        try {
            URI uri = session.getUri();
            log.debug("WebSocket Session opened {}", (Object)uri);
            MultiValueMap queryParams = UriComponentsBuilder.fromUri((URI)uri).build().getQueryParams();
            sourceNodeId = this.getQueryParam(uri, (MultiValueMap<String, String>)queryParams, "sourceNodeId");
            targetNodeId = this.getQueryParam(uri, (MultiValueMap<String, String>)queryParams, "targetNodeId");
            String securityToken = this.getQueryParam(uri, (MultiValueMap<String, String>)queryParams, "securityToken");
            if (StringUtils.isEmpty((CharSequence)securityToken) || StringUtils.isEmpty((CharSequence)sourceNodeId)) {
                throw new SymmetricException("Failed to authenticate node due to missing sourceNodeId or securityToken " + String.valueOf(uri), new Object[0]);
            }
            ISymmetricEngine engine = this.getSymmetricEngine(targetNodeId);
            if (engine == null) {
                return;
            }
            INodeService.AuthenticationStatus status = engine.getNodeService().getAuthenticationStatus(sourceNodeId, securityToken);
            if (!INodeService.AuthenticationStatus.ACCEPTED.equals((Object)status)) {
                SymmetricException ex2 = new SymmetricException("Failed to authenticate node " + sourceNodeId + " due to: " + String.valueOf(status), new Object[0]);
                log.debug("Exception while opening websocket session " + String.valueOf(session), (Throwable)ex2);
                throw ex2;
            }
            log.debug("WebSocket connected: {}<->{} on node {} session: {}", new Object[]{sourceNodeId, targetNodeId, engine.getNodeId(), session});
            IRemoteStatusService remoteStatusService = (IRemoteStatusService)engine.getExtensionService().getExtensionPoint(IRemoteStatusService.class);
            remoteStatusService.registerEndpoint(sourceNodeId, this);
            State state = new State();
            state.handler = new WsMessageHandler(engine, remoteStatusService, sourceNodeId, targetNodeId, session);
            state.session = session;
            state.sourceNodeId = sourceNodeId;
            state.targetNodeId = targetNodeId;
            this.sessions.put(session, state);
        }
        catch (Exception ex3) {
            String msg = "Unable to open websocket session " + sourceNodeId + "<->" + targetNodeId + " " + String.valueOf(session);
            log.debug(msg);
            this.close(session, ex3);
        }
    }

    @Override
    public WebSocketSession getSession(String nodeId) {
        for (State state : this.sessions.values()) {
            if (!state.sourceNodeId.equals(nodeId)) continue;
            return state.session;
        }
        return null;
    }

    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        if (!(message instanceof TextMessage)) {
            throw new IllegalStateException("Unexpected WebSocket message type: " + String.valueOf(message));
        }
        TextMessage textMessage = (TextMessage)message;
        this.handleTextMessage(session, textMessage);
    }

    public void handleTextMessage(WebSocketSession session, TextMessage message) {
        log.debug("TextMessage Received = {}, {}, {}", new Object[]{message.getPayload(), session.getAttributes(), session.getUri()});
        State state = this.sessions.get(session);
        if (state != null) {
            state.handler.onMessage((String)message.getPayload());
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        this.sessions.remove(session);
        log.debug("WebSocket Connection Closed");
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        ISymmetricEngine engine;
        this.setSession(null);
        State state = this.sessions.get(session);
        if (state != null && state.targetNodeId != null && (engine = this.getSymmetricEngine(state.targetNodeId)) != null) {
            IRemoteStatusService remoteStatusService = (IRemoteStatusService)engine.getExtensionService().getExtensionPoint(IRemoteStatusService.class);
            remoteStatusService.deRegisterEndpoint(state.sourceNodeId);
        }
        log.debug("WebSocket exception", exception);
        this.close(session, exception);
    }

    public boolean supportsPartialMessages() {
        return false;
    }

    protected void close(WebSocketSession session, Throwable ex2) {
        try {
            session.close(CloseStatus.PROTOCOL_ERROR);
        }
        catch (IOException ex1) {
            log.debug("Failed to close socket after error.", (Throwable)ex1);
        }
    }

    protected ISymmetricEngine getSymmetricEngine(String nodeId) {
        ISymmetricEngine engine = null;
        for (ISymmetricEngine potentialEngine : AbstractSymmetricEngine.findEngines()) {
            if (!nodeId.equals(potentialEngine.getNodeService().findIdentityNodeId())) continue;
            engine = potentialEngine;
            break;
        }
        if (engine == null) {
            log.debug("Could not find engine for node id: '" + nodeId + "'");
        }
        return engine;
    }

    protected String getQueryParam(URI uri, MultiValueMap<String, String> queryParams, String queryParam) {
        if (!queryParams.containsKey((Object)queryParam)) {
            throw new SymmetricException("URL must contain query param " + queryParam + ", but does not. (" + String.valueOf(uri) + ")", new Object[0]);
        }
        String param = (String)((List)queryParams.get((Object)queryParam)).get(0);
        if (!StringUtils.isEmpty((CharSequence)param)) {
            try {
                return URLDecoder.decode(param, "UTF8");
            }
            catch (UnsupportedEncodingException ex2) {
                throw new SymmetricException("Failed to decode value '" + param + "'", (Throwable)ex2);
            }
        }
        return param;
    }

    static class State {
        WsMessageHandler handler;
        WebSocketSession session;
        String sourceNodeId;
        String targetNodeId;

        State() {
        }
    }
}

