/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jumpmind.symmetric.console.remote.ClientEndpoint;
import com.jumpmind.symmetric.console.remote.DefaultMessageHandler;
import com.jumpmind.symmetric.console.remote.IMessageHandler;
import com.jumpmind.symmetric.console.remote.IRemoteStatusService;
import com.jumpmind.symmetric.console.remote.MessageContext;
import com.jumpmind.symmetric.console.remote.MessageDirection;
import com.jumpmind.symmetric.console.remote.RemoteStatusMessageSender;
import com.jumpmind.symmetric.console.remote.RemoteStatusOfflineCheck;
import com.jumpmind.symmetric.console.remote.ServerEndpoint;
import com.jumpmind.symmetric.console.remote.SessionEndpoint;
import com.jumpmind.symmetric.console.remote.TimeoutException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transport.http.HttpConnection;
import org.jumpmind.util.CustomizableThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteStatusService
implements IRemoteStatusService {
    static final Logger log = LoggerFactory.getLogger(RemoteStatusService.class);
    private static final boolean USE_CACHE = true;
    private Map<String, MessageContext> messageContexts = new ConcurrentHashMap<String, MessageContext>();
    private ISymmetricEngine engine;
    private IConfigurationService configurationService;
    private INodeService nodeService;
    private IParameterService parameterService;
    private Map<String, SessionEndpoint> sessions = new ConcurrentHashMap<String, SessionEndpoint>();
    private Set<String> connectionRequests = ConcurrentHashMap.newKeySet();
    private Gson gson = new GsonBuilder().create();
    private Gson gsonPrettyPrint = new GsonBuilder().setPrettyPrinting().create();
    private ThreadPoolExecutor executor;
    private AtomicInteger connectFailureCount = new AtomicInteger(0);
    final RemoteStatusOfflineCheck offlineCheck = new RemoteStatusOfflineCheck();

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
        this.nodeService = engine.getNodeService();
        this.configurationService = engine.getConfigurationService();
        this.parameterService = engine.getParameterService();
        int remoteStatusThreadCount = this.parameterService.getInt("remote.status.max.threads");
        this.executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(remoteStatusThreadCount, (ThreadFactory)new CustomizableThreadFactory("remote-status-worker"));
        this.executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        this.executor.allowCoreThreadTimeOut(true);
    }

    @Override
    public void sendMessage(String nodeId, String message, IMessageHandler messageHandler) {
        if (this.parameterService.is("remote.status.enabled", true)) {
            RemoteStatusMessageSender messageSender = new RemoteStatusMessageSender(this, this.messageContexts, this.nodeService.findIdentityNodeId(), nodeId, message, messageHandler);
            this.executor.submit(messageSender);
        }
    }

    @Override
    public void sendMessage(String nodeId, String message) {
        if (this.parameterService.is("remote.status.enabled", true)) {
            RemoteStatusMessageSender messageSender = new RemoteStatusMessageSender(this, this.messageContexts, this.nodeService.findIdentityNodeId(), nodeId, message, new DefaultMessageHandler());
            this.executor.submit(messageSender);
        }
    }

    @Override
    public String getMessageJsonPretty(MessageContext messageContext, MessageDirection direction, String payload) {
        return this.getMessageJson(messageContext.getMessageId(), direction, payload, true, false);
    }

    @Override
    public String getMessageJson(MessageContext messageContext, MessageDirection direction, String payload) {
        return this.getMessageJson(messageContext.getMessageId(), direction, payload, false, false);
    }

    @Override
    public String getMessageJson(String messageId, MessageDirection direction, String payload) {
        return this.getMessageJson(messageId, direction, payload, false, false);
    }

    @Override
    public String getMessageJson(String messageId, MessageDirection direction, String payload, boolean errorFlag, boolean prettyPrint) {
        JsonObject json = new JsonObject();
        json.addProperty("id", messageId);
        json.addProperty("dir", direction.toString());
        json.addProperty("payload", payload);
        if (errorFlag) {
            json.addProperty("error", "1");
        }
        if (prettyPrint) {
            return this.gsonPrettyPrint.toJson((JsonElement)json);
        }
        return this.gson.toJson((JsonElement)json);
    }

    @Override
    public SessionEndpoint connect(String nodeId) {
        SessionEndpoint socket = this.sessions.get(nodeId);
        Node targetNode = this.getNode(nodeId);
        if ((socket == null || socket.getSession() == null || !socket.getSession().isOpen()) && targetNode != null && targetNode.isVersionGreaterThanOrEqualTo(new int[]{3, 9, 0}) && "professional".equals(targetNode.getDeploymentType())) {
            String sourceNodeId;
            NodeGroupLink link;
            boolean followGroupLinkDirection = this.engine.getParameterService().is("remote.status.follow.group.link.direction", false);
            if (this.connectFailureCount.get() > this.engine.getParameterService().getInt("remote.status.follow.group.link.fallback.count")) {
                followGroupLinkDirection = true;
            }
            if ((link = this.getGroupLink(sourceNodeId = this.nodeService.findIdentityNodeId(), nodeId)) != null) {
                if (!followGroupLinkDirection || link.getDataEventAction() == NodeGroupLinkAction.P) {
                    try {
                        socket = this.createNewSocket(nodeId);
                        if (!socket.checkStatus()) {
                            this.connectFailureCount.incrementAndGet();
                        }
                    }
                    catch (Exception ex2) {
                        if (link.getDataEventAction() == NodeGroupLinkAction.W) {
                            this.connectFailureCount.incrementAndGet();
                        }
                        throw ex2;
                    }
                    this.sessions.put(nodeId, socket);
                } else {
                    this.connectionRequests.add(nodeId);
                    long start = System.currentTimeMillis();
                    long timeout = this.engine.getParameterService().getLong("remote.status.connect.timeout.ms");
                    while (System.currentTimeMillis() - start < timeout) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ex3) {
                            log.debug("Remote status connect interrupted. " + String.valueOf(ex3));
                            break;
                        }
                        socket = this.sessions.get(nodeId);
                        if (socket == null) continue;
                    }
                    if (socket == null) {
                        long elapsed = System.currentTimeMillis() - start;
                        throw new TimeoutException("Timeout while connecting " + sourceNodeId + "->" + nodeId + " after " + elapsed + " ms.", new Object[0]);
                    }
                }
            } else {
                log.debug("Could not find a group link for the source node of {} and a target node of {}", (Object)sourceNodeId, (Object)nodeId);
            }
        }
        return socket;
    }

    private ClientEndpoint createNewSocket(String targetNodeId) {
        ClientEndpoint socket = new ClientEndpoint(this.engine, this, targetNodeId);
        socket.connect(this.getWebSocketUrl(targetNodeId));
        return socket;
    }

    private NodeGroupLink getGroupLink(String sourceNodeId, String targetNodeId) {
        Node sourceNode = this.getNode(sourceNodeId);
        Node targetNode = this.getNode(targetNodeId);
        if (sourceNode != null && targetNode != null) {
            String sourceNodeGroupId = sourceNode.getNodeGroupId();
            String targetNodeGroupId = targetNode.getNodeGroupId();
            return this.configurationService.getNodeGroupLinkFor(sourceNodeGroupId, targetNodeGroupId, false);
        }
        return null;
    }

    @Override
    public String getWebSocketUrl(String nodeId) {
        Node node = this.getNode(nodeId);
        if (node == null) {
            log.debug("No node found for nodeId {}", (Object)nodeId);
            return null;
        }
        return this.getWebSocketUrl(node);
    }

    @Override
    public String getWebSocketUrl(Node node) {
        Object websocketURL = node.getSyncUrl();
        if (StringUtils.isBlank((CharSequence)websocketURL)) {
            websocketURL = this.engine.getParameterService().getRegistrationUrl();
        }
        if (((String)websocketURL).startsWith("https:")) {
            websocketURL = ((String)websocketURL).replaceFirst("https", "wss");
        } else if (((String)websocketURL).startsWith("http:")) {
            websocketURL = ((String)websocketURL).replaceFirst("http", "ws");
        }
        websocketURL = ((String)websocketURL).replaceFirst("/sync/.*", "/control");
        String localNodeId = this.nodeService.findIdentity().getNodeId();
        NodeSecurity nodeSecurity = this.nodeService.findNodeSecurity(localNodeId, true);
        if (nodeSecurity == null) {
            throw new SymmetricException("Could not find node security entry for node " + localNodeId, new Object[0]);
        }
        try {
            websocketURL = (String)websocketURL + String.format("?sourceNodeId=%s&targetNodeId=%s&securityToken=%s", URLEncoder.encode(localNodeId, "UTF-8"), URLEncoder.encode(node.getNodeId(), "UTF-8"), nodeSecurity.getNodePassword());
        }
        catch (UnsupportedEncodingException ex2) {
            throw new SymmetricException("Failed to construct sync URL from websocketURL=" + (String)websocketURL + " localNodeId=" + localNodeId + " node.getNodeId()=" + node.getNodeId(), (Throwable)ex2);
        }
        return websocketURL;
    }

    @Override
    public void registerEndpoint(String sourceNodeId, ServerEndpoint serverEndpoint) {
        this.sessions.put(sourceNodeId, serverEndpoint);
    }

    @Override
    public void deRegisterEndpoint(String nodeId) {
        this.sessions.remove(nodeId);
    }

    public ISymmetricEngine getEngine() {
        return this.engine;
    }

    @Override
    public Map<String, SessionEndpoint> getSessions() {
        return new LinkedHashMap<String, SessionEndpoint>(this.sessions);
    }

    @Override
    public MessageContext getAndRemoveMessageContext(String messageId) {
        return this.messageContexts.remove(messageId);
    }

    @Override
    public Set<String> getConnectionRequests() {
        return this.connectionRequests;
    }

    @Override
    public void checkForRemoteStatusRequest(HttpConnection connection) {
        final String remoteStatusHeader = connection.getHeaderField("Remote-Status-Request");
        if (!StringUtils.isEmpty((CharSequence)remoteStatusHeader)) {
            log.debug("Node {} header {} found on {}", new Object[]{this.engine.getNodeId(), remoteStatusHeader, connection.getURL()});
            this.executor.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    try {
                        RemoteStatusService.this.connect(remoteStatusHeader);
                    }
                    catch (Exception ex2) {
                        log.debug("Exception while connecting to '" + remoteStatusHeader + "'", (Throwable)ex2);
                    }
                    return null;
                }
            });
        }
    }

    protected Node getNode(String nodeId) {
        Node node = this.nodeService.findNode(nodeId, true);
        if (node == null) {
            node = this.nodeService.findNode(nodeId);
        }
        return node;
    }
}

