/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.jumpmind.symmetric.console.remote.IRemoteStatusService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.web.IInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteStatusInterceptor
implements IInterceptor {
    protected static final Logger log = LoggerFactory.getLogger(RemoteStatusInterceptor.class);
    private ISymmetricEngine engine;

    public RemoteStatusInterceptor(ISymmetricEngine engine) {
        this.engine = engine;
    }

    public boolean before(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String nodeId = req.getParameter("nodeId");
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            log.debug("Could not determine node id from request {}" + String.valueOf(req));
            return true;
        }
        IRemoteStatusService remoteStatusService = (IRemoteStatusService)this.engine.getExtensionService().getExtensionPoint(IRemoteStatusService.class);
        boolean requestWasPresent = remoteStatusService.getConnectionRequests().remove(nodeId);
        if (requestWasPresent) {
            res.setHeader("Remote-Status-Request", this.engine.getNodeId());
            log.debug("Node {} responding with {} to nodeId {} on URL {}", new Object[]{this.engine.getNodeId(), "Remote-Status-Request", nodeId, req.getRequestURL()});
        }
        return true;
    }

    public void after(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
    }
}

