/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.jumpmind.symmetric.console.remote.IRemoteStatusService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.http.HttpOutgoingTransport;

public class RemoteStatusHttpOutgoingTransport
implements IOutgoingWithResponseTransport {
    private HttpOutgoingTransport transport;
    private IRemoteStatusService remoteStatusService;

    public RemoteStatusHttpOutgoingTransport(HttpOutgoingTransport transport, IRemoteStatusService remoteStatusService) {
        this.transport = transport;
        this.remoteStatusService = remoteStatusService;
    }

    public BufferedWriter openWriter() {
        return this.transport.openWriter();
    }

    public BufferedWriter getWriter() {
        return this.transport.getWriter();
    }

    public OutputStream openStream() {
        OutputStream stream = this.transport.openStream();
        return stream;
    }

    public BufferedReader readResponse() throws IOException {
        BufferedReader reader = this.transport.readResponse();
        this.checkForRemoteStatusRequest();
        return reader;
    }

    public void close() {
        this.transport.close();
    }

    public boolean isOpen() {
        return this.transport.isOpen();
    }

    public ChannelMap getSuspendIgnoreChannelLists(IConfigurationService configurationService, String queue, Node targetNode) {
        return this.transport.getSuspendIgnoreChannelLists(configurationService, queue, targetNode);
    }

    protected void checkForRemoteStatusRequest() {
        this.remoteStatusService.checkForRemoteStatusRequest(this.transport.getConnection());
    }
}

