/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.jumpmind.symmetric.console.remote.IRemoteStatusService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.http.HttpIncomingTransport;

public class RemoteStatusHttpIncomingTransport
implements IIncomingTransport {
    private HttpIncomingTransport transport;
    private IRemoteStatusService remoteStatusService;

    public RemoteStatusHttpIncomingTransport(HttpIncomingTransport transport, IRemoteStatusService remoteStatusService) {
        this.transport = transport;
        this.remoteStatusService = remoteStatusService;
    }

    public BufferedReader openReader() throws IOException {
        BufferedReader reader = this.transport.openReader();
        this.checkForRemoteStatusRequest();
        return reader;
    }

    public InputStream openStream() throws IOException {
        InputStream stream = this.transport.openStream();
        this.checkForRemoteStatusRequest();
        return stream;
    }

    public void close() {
        this.transport.close();
    }

    public boolean isOpen() {
        return this.transport.isOpen();
    }

    public String getRedirectionUrl() {
        return this.transport.getRedirectionUrl();
    }

    public String getUrl() {
        return this.transport.getUrl();
    }

    public Map<String, String> getHeaders() {
        return this.transport.getHeaders();
    }

    protected void checkForRemoteStatusRequest() {
        this.remoteStatusService.checkForRemoteStatusRequest(this.transport.getConnection());
    }
}

