/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import bsh.Interpreter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jumpmind.symmetric.console.remote.RemoteBatchPsCommand;
import com.jumpmind.symmetric.console.remote.RemoteBatchStatusCommand;
import com.jumpmind.symmetric.console.remote.RemoteProcessStatusCommand;
import com.jumpmind.symmetric.console.remote.RemoteTableMetaDataCommand;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.h2.tools.Shell;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteStatusCommand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new GsonBuilder().create();
    private ISymmetricEngine engine;
    private String command;
    private String remoteNodeId;

    public RemoteStatusCommand(ISymmetricEngine engine, String remoteNodeId, String command) {
        this.engine = engine;
        this.remoteNodeId = remoteNodeId;
        this.command = command;
    }

    public String execute() throws Exception {
        String commandLowerCase = this.command.toLowerCase();
        try {
            if (commandLowerCase.startsWith("help")) {
                return this.help();
            }
            if (commandLowerCase.startsWith("ping")) {
                return this.pong();
            }
            if (commandLowerCase.startsWith("ayt")) {
                return this.ayt();
            }
            if (commandLowerCase.startsWith("sql")) {
                return this.sql();
            }
            if (commandLowerCase.startsWith("bsh")) {
                return this.bsh();
            }
            if (commandLowerCase.startsWith("batchstatus")) {
                return new RemoteBatchStatusCommand(this).execute();
            }
            if (commandLowerCase.startsWith("batchps")) {
                return new RemoteBatchPsCommand(this).execute();
            }
            if (commandLowerCase.startsWith("batchstop")) {
                long batchId = Long.parseLong(this.command.substring(10));
                StringBuilder sb = new StringBuilder();
                List infos = this.engine.getStatisticManager().getProcessInfos();
                for (ProcessInfo info : infos) {
                    if (info.getCurrentBatchId() != batchId) continue;
                    String msg = "Sending interrupt to " + info.getKey().toString();
                    this.logger.info(msg);
                    sb.append(msg + "\n");
                    info.getThread().interrupt();
                }
                return sb.toString();
            }
            if (commandLowerCase.startsWith("processstatus")) {
                return new RemoteProcessStatusCommand(this).execute();
            }
            if (commandLowerCase.startsWith("meta")) {
                return new RemoteTableMetaDataCommand(this).execute();
            }
            return "Unrecognized command: '" + this.command + "'";
        }
        catch (Exception ex2) {
            this.logger.warn("Failed to executed command '" + this.command + "'", (Throwable)ex2);
            return ExceptionUtils.getStackTrace((Throwable)ex2);
        }
    }

    private String sql() throws SQLException {
        String sql = this.command.substring(3);
        Shell shell = new Shell();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(outputStream);
        shell.setOut(ps);
        JdbcSqlTemplate template = (JdbcSqlTemplate)this.engine.getSqlTemplate();
        shell.runTool(template.getDataSource().getConnection(), new String[]{"-sql", sql});
        String result = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
        return result;
    }

    private String bsh() {
        String bsh = this.command.substring(3);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            Interpreter interpreter = new Interpreter(null, ps, ps, false);
            interpreter.set("engine", (Object)this.engine);
            interpreter.set("sqlTemplate", (Object)this.engine.getDatabasePlatform().getSqlTemplate());
            interpreter.set("log", (Object)this.logger);
            interpreter.eval(bsh);
            String result = new String(baos.toByteArray(), StandardCharsets.UTF_8);
            return result;
        }
        catch (Exception ex2) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception during bsh  '" + bsh + "'", (Throwable)ex2);
            }
            return ex2.toString();
        }
    }

    private String ayt() {
        return "node " + this.engine.getNodeId() + " is here.";
    }

    private String pong() {
        return "pong from " + this.engine.getNodeId();
    }

    private String help() {
        return "Usage: \n\tping - sends a ping to the remote node.\n\tayt - sends an 'are you there' test to remote node.\n\tsql - sends a sql statement to be run against remote node.\n\tbsh - sends a beanshell script to run against remote node.\n\tbatchstatus - returns batch information based on additional options.\n\t\t[-b] option to provide comma separated list of batches to return status on.\n\t\t[-p] option to return unsent batch information.\n\tbatchps - list of batches currently being processed for the calling node.\n\tbatchstop - interrupt any process working on the batch ID given.\n\tmeta - returns catalog, schema, table meta data based on additional options.\n\t\t[-l] option to return only catalogs.\n\t\t[-c] option to return only schemas based on catalog provided.\n\t\t[-s] opiton to return tables based on catalog(-c) and schema(-s) options";
    }

    public Gson getGson() {
        return this.gson;
    }

    public ISymmetricEngine getEngine() {
        return this.engine;
    }

    public String getCommand() {
        return this.command;
    }

    public String getRemoteNodeId() {
        return this.remoteNodeId;
    }
}

