/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jumpmind.symmetric.console.remote.AbstractBatchStatusCommand;
import com.jumpmind.symmetric.console.remote.BatchStatus;
import com.jumpmind.symmetric.console.remote.RemoteStatusCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.OutgoingBatchSummary;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBatchStatusCommand
extends AbstractBatchStatusCommand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    public RemoteBatchStatusCommand(RemoteStatusCommand remoteStatusCommand) {
        super(remoteStatusCommand);
    }

    public String execute() throws Exception {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("f", "format", true, "The format to receive the response.");
        options.addOption("b", "batchIds", true, "Comma-seperated list of batch ids to inquire about.");
        CommandLine cmd = parser.parse(options, this.remoteStatusCommand.getCommand().split(" "));
        String format = cmd.getOptionValue('f');
        String batchId = cmd.getOptionValue('b');
        long[] batchIds = this.parseBatchIds(batchId);
        boolean jsonFormat = false;
        if ("json".equals(format)) {
            jsonFormat = true;
        }
        if (batchId != null && batchId.length() > 0) {
            List<BatchStatus> batchStatuses = this.getBatchStatuses(batchIds);
            return this.formatResponse(batchStatuses, jsonFormat);
        }
        return this.formatPendingResponse(jsonFormat);
    }

    protected String formatPendingResponse(boolean jsonFormat) {
        IOutgoingBatchService service = this.remoteStatusCommand.getEngine().getOutgoingBatchService();
        List summaries = service.findOutgoingBatchSummaryByChannel(new AbstractBatch.Status[]{AbstractBatch.Status.NE, AbstractBatch.Status.LD, AbstractBatch.Status.QY, AbstractBatch.Status.ER, AbstractBatch.Status.SE, AbstractBatch.Status.RS});
        HashMap<String, Object> byChannel = new HashMap<String, Object>();
        long unsentBatchCount = 0L;
        long unsentRowCount = 0L;
        for (OutgoingBatchSummary outgoingBatchSummary : summaries) {
            Object combined = (OutgoingBatchSummary)byChannel.get(outgoingBatchSummary.getChannel());
            if (combined == null) {
                combined = new OutgoingBatchSummary();
                combined.setChannel(outgoingBatchSummary.getChannel());
                byChannel.put(outgoingBatchSummary.getChannel(), combined);
            }
            combined.setBatchCount(combined.getBatchCount() + outgoingBatchSummary.getBatchCount());
            combined.setDataCount(combined.getDataCount() + outgoingBatchSummary.getDataCount());
            unsentBatchCount += (long)outgoingBatchSummary.getBatchCount();
            unsentRowCount += (long)outgoingBatchSummary.getDataCount();
        }
        if (jsonFormat) {
            JsonObject json = new JsonObject();
            if (unsentBatchCount == 0L) {
                json.addProperty("message", "No batches to send.");
            } else {
                json.addProperty("batches", (Number)unsentBatchCount);
                json.addProperty("rows", (Number)unsentRowCount);
            }
            JsonArray byChannelArray = new JsonArray();
            for (OutgoingBatchSummary outgoingBatchSummary : byChannel.values()) {
                JsonObject jsonBatch = new JsonObject();
                jsonBatch.addProperty("channelId", outgoingBatchSummary.getChannel());
                jsonBatch.addProperty("batches", (Number)outgoingBatchSummary.getBatchCount());
                jsonBatch.addProperty("rows", (Number)outgoingBatchSummary.getDataCount());
                byChannelArray.add((JsonElement)jsonBatch);
            }
            json.add("byChannel", (JsonElement)byChannelArray);
            return this.remoteStatusCommand.getGson().toJson((JsonElement)json);
        }
        StringBuilder buff = new StringBuilder();
        if (unsentBatchCount == 0L) {
            buff.append("No batches to send.");
        } else {
            buff.append("Channel | Unsent Batch Count | Unsent Row Count\n");
            buff.append("ALL | ").append(unsentBatchCount).append(" | ").append(unsentRowCount).append("\n");
            for (OutgoingBatchSummary outgoingBatchSummary : byChannel.values()) {
                buff.append(outgoingBatchSummary.getChannel()).append(" | ").append(outgoingBatchSummary.getBatchCount()).append(" | ").append(outgoingBatchSummary.getDataCount()).append("\n");
            }
        }
        return buff.toString();
    }

    protected List<BatchStatus> getBatchStatuses(long[] batchIds) {
        ArrayList<BatchStatus> batchStatuses = new ArrayList<BatchStatus>();
        ISymmetricEngine engine = this.remoteStatusCommand.getEngine();
        List<ProcessInfo> processInfos = this.filterForBatches(engine.getStatisticManager().getProcessInfosThatHaveDoneWork());
        if (batchIds == null) {
            for (ProcessInfo info : processInfos) {
                String mappedStatus = this.mapStatus(info.getStatus()).name();
                batchStatuses.add(new BatchStatus(info.getCurrentBatchId(), mappedStatus, info.getCurrentDataCount(), this.getProcessedMillis(info)));
            }
        } else {
            for (long batchId : batchIds) {
                boolean found = false;
                for (ProcessInfo info : processInfos) {
                    if (info.getCurrentBatchId() != batchId) continue;
                    String mappedStatus = this.mapStatus(info.getStatus()).name();
                    batchStatuses.add(new BatchStatus(info.getCurrentBatchId(), mappedStatus, info.getCurrentDataCount(), this.getProcessedMillis(info)));
                    found = true;
                    break;
                }
                if (found) continue;
                IncomingBatch batch = engine.getIncomingBatchService().findIncomingBatch(batchId, this.remoteStatusCommand.getRemoteNodeId());
                if (batch != null) {
                    batchStatuses.add(new BatchStatus(batchId, batch.getStatus().name(), batch.getLoadRowCount(), batch.getLoadMillis(), batch.getSqlMessage()));
                    continue;
                }
                batchStatuses.add(new BatchStatus(batchId, AbstractBatch.Status.XX.name(), 0L, 0L));
            }
        }
        return batchStatuses;
    }

    protected long getUnsentRowCount() {
        ISymmetricEngine engine = this.remoteStatusCommand.getEngine();
        return engine.getOutgoingBatchService().countUnsentRowsByTargetNode(this.remoteStatusCommand.getRemoteNodeId());
    }

    protected int getUnsentBatchCount() {
        ISymmetricEngine engine = this.remoteStatusCommand.getEngine();
        return engine.getOutgoingBatchService().countUnsentBatchesByTargetNode(this.remoteStatusCommand.getRemoteNodeId(), false);
    }

    private AbstractBatch.Status mapStatus(ProcessInfo.ProcessStatus status) {
        switch (status) {
            case NEW: {
                return AbstractBatch.Status.NE;
            }
            case PROCESSING: 
            case TRANSFERRING: 
            case LOADING: 
            case ACKING: 
            case QUERYING: {
                return AbstractBatch.Status.LD;
            }
            case ERROR: {
                return AbstractBatch.Status.ER;
            }
            case OK: {
                return AbstractBatch.Status.OK;
            }
        }
        return AbstractBatch.Status.XX;
    }

    protected List<ProcessInfo> filterForBatches(List<ProcessInfo> processInfos) {
        ArrayList<ProcessInfo> batchProcessInfos = new ArrayList<ProcessInfo>();
        for (ProcessInfo info : processInfos) {
            if (info.getCurrentBatchId() == 0L) continue;
            batchProcessInfos.add(info);
        }
        return batchProcessInfos;
    }
}

