/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.jumpmind.symmetric.console.remote.IRemoteStatusService;
import com.jumpmind.symmetric.console.remote.SessionEndpoint;
import com.jumpmind.symmetric.console.remote.WsMessageHandler;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientEndpoint
extends SessionEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ClientEndpoint.class);
    private IRemoteStatusService remoteStatusService;
    private ISymmetricEngine engine;
    private String targetNodeId;
    private static AtomicReference<WebSocketContainer> container = new AtomicReference<Object>(null);

    public ClientEndpoint(ISymmetricEngine engine, IRemoteStatusService remoteStatusService, String targetNodeId) {
        this.engine = engine;
        this.remoteStatusService = remoteStatusService;
        this.targetNodeId = targetNodeId;
        this.configureWebSocketContainer();
    }

    public Session connect(String uri) {
        try {
            Session session = container.get().connectToServer((Endpoint)this, null, URI.create(uri));
            this.setSession(session);
            return session;
        }
        catch (Exception ex2) {
            log.debug("Failed to connect to " + uri, (Throwable)ex2);
            return null;
        }
    }

    @Override
    public void onOpen(Session session, EndpointConfig ec2) {
        super.onOpen(session, ec2);
        String sourceNodeId = this.engine.getNodeService().findIdentityNodeId();
        log.debug("WebSocket Session opened {}->{} {}", new Object[]{sourceNodeId, this.targetNodeId, session});
        WsMessageHandler handler = new WsMessageHandler(this.engine, this.remoteStatusService, sourceNodeId, this.targetNodeId, null);
        session.addMessageHandler((MessageHandler)handler);
    }

    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    protected void configureWebSocketContainer() {
        if (container.get() == null) {
            try {
                WebSocketContainer newWebSocketContainer = ContainerProvider.getWebSocketContainer();
                if (container.compareAndSet(null, newWebSocketContainer)) {
                    container.get().setDefaultMaxBinaryMessageBufferSize(Integer.MAX_VALUE);
                    container.get().setDefaultMaxTextMessageBufferSize(Integer.MAX_VALUE);
                    container.get().setDefaultMaxSessionIdleTimeout((long)this.engine.getParameterService().getInt("remote.status.idle.timeout.ms"));
                    container.get().setAsyncSendTimeout((long)this.engine.getParameterService().getInt("remote.status.send.timeout.ms"));
                }
            }
            catch (Exception ex2) {
                log.error("Failed to create web socket container.", (Throwable)ex2);
            }
        }
    }
}

