/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jumpmind.symmetric.console.remote.BatchStatus;
import com.jumpmind.symmetric.console.remote.RemoteStatusCommand;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractBatchStatusCommand {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected RemoteStatusCommand remoteStatusCommand;
    protected Gson gsonPretty = new GsonBuilder().setPrettyPrinting().create();

    public AbstractBatchStatusCommand(RemoteStatusCommand remoteStatusCommand) {
        this.remoteStatusCommand = remoteStatusCommand;
    }

    protected long[] parseBatchIds(String batchId) {
        if (StringUtils.isEmpty((CharSequence)batchId)) {
            return null;
        }
        String[] batchIdStrings = batchId.split(",");
        long[] batchIds = new long[batchIdStrings.length];
        int i2 = 0;
        for (String batchIdString : batchIdStrings) {
            batchIds[i2++] = Long.parseLong(batchIdString.trim());
        }
        return batchIds;
    }

    protected String formatResponse(List<BatchStatus> batchStatuses, boolean jsonFormat) {
        if (jsonFormat) {
            JsonObject json = new JsonObject();
            if (batchStatuses.isEmpty()) {
                json.addProperty("message", "No batches processing.");
            } else {
                JsonArray batchesArray = new JsonArray();
                for (BatchStatus batchStatus : batchStatuses) {
                    JsonObject jsonBatch = new JsonObject();
                    jsonBatch.addProperty("nodeId", this.remoteStatusCommand.getEngine().getNodeId());
                    jsonBatch.addProperty("batchId", (Number)batchStatus.getBatchId());
                    jsonBatch.addProperty("status", batchStatus.getStatus());
                    jsonBatch.addProperty("processedRowCount", (Number)batchStatus.getProcessedRowCount());
                    jsonBatch.addProperty("processedMillis", (Number)batchStatus.getProcessedMillis());
                    if (!StringUtils.isEmpty((CharSequence)batchStatus.getSqlMessage())) {
                        jsonBatch.addProperty("sqlMessage", batchStatus.getSqlMessage());
                    }
                    batchesArray.add((JsonElement)jsonBatch);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Add batch {}", (Object)this.gsonPretty.toJson((JsonElement)jsonBatch));
                }
                json.add("batches", (JsonElement)batchesArray);
            }
            return this.remoteStatusCommand.getGson().toJson((JsonElement)json);
        }
        StringBuilder buff = new StringBuilder();
        if (batchStatuses.isEmpty()) {
            buff.append("No batches processing.");
        } else {
            buff.append("Batch Id | Status | Rows Processed | SQL Message\n");
            for (BatchStatus batchStatus : batchStatuses) {
                buff.append(batchStatus.getBatchId()).append(" | ").append(batchStatus.getStatus()).append(" | ").append(batchStatus.getProcessedRowCount());
                if (!StringUtils.isEmpty((CharSequence)batchStatus.getSqlMessage())) {
                    buff.append(" | ").append(batchStatus.getSqlMessage());
                }
                buff.append("\n");
            }
        }
        return buff.toString();
    }

    protected long getProcessedMillis(ProcessInfo info) {
        Date startDate = info.getStartTime();
        Date endDate = info.getEndTime();
        if (endDate == null) {
            endDate = new Date();
        }
        return endDate.getTime() - startDate.getTime();
    }
}

