/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.e;
import com.jumpmind.symmetric.console.impl.g;
import com.jumpmind.symmetric.console.impl.h;
import com.jumpmind.symmetric.console.model.CompareTableStatus;
import com.jumpmind.symmetric.console.service.ICompareService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.csv.CsvWriter;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class w
extends e {
    protected final Logger a = LoggerFactory.getLogger(w.class);

    public w(ISymmetricEngine engine, ICompareService compareService) {
        this.engine = engine;
        this.compareService = compareService;
    }

    public void a(CompareTableStatus status, boolean isSource, ProcessInfo processInfo) {
        IStagedResource resourceChunks = this.findResource(status, "chunk");
        if (resourceChunks == null || !resourceChunks.exists() || resourceChunks.getState() != IStagedResource.State.DONE) {
            this.a.warn("Compare request {} is missing chunk file to filter rows", (Object)status.getNodeCompareIdStep());
            if (isSource) {
                status.setLevel("C");
                status.setStatus("NE");
                this.compareService.updateCompareTableStatus(status);
            }
        } else {
            processInfo.setStatus(ProcessInfo.ProcessStatus.EXTRACTING);
            ArrayList<h> chunks = new ArrayList<h>();
            try {
                ArrayList<h> allChunks = new ArrayList<h>();
                h.a(resourceChunks, allChunks, null);
                int offset = -1;
                for (String chunkItem : status.getChunkDiffList().split(",")) {
                    try {
                        int chunkNum = Integer.parseInt(chunkItem);
                        chunks.add((h)allChunks.get(chunkNum + offset));
                    }
                    catch (NumberFormatException e2) {
                        if (!isSource) continue;
                        if (chunkItem.equals("B")) {
                            chunks.add((h)allChunks.get(0));
                            ++offset;
                            continue;
                        }
                        if (!chunkItem.equals("E")) continue;
                        chunks.add((h)allChunks.get(allChunks.size() - 1));
                    }
                }
            }
            catch (IOException e3) {
                throw new IoException((Exception)e3);
            }
            this.a.info("Filtering rows by {} chunks for compare request {}", (Object)chunks.size(), (Object)status.getNodeCompareIdStep());
            IStagedResource resourceIn = this.findResource(status, "row");
            IStagedResource resourceOut = this.createResource(status, "row-filtered");
            long ts = System.currentTimeMillis();
            long rowFilterMillis = 0L;
            long count = 0L;
            try (CsvReader reader = CsvUtils.getCsvReaderDquote((Reader)new InputStreamReader(resourceIn.getInputStream()));
                 CsvWriter writer = new CsvWriter(resourceOut.getOutputStream(), ',', Charset.defaultCharset());){
                count = this.a(reader, writer, chunks, processInfo);
                rowFilterMillis = System.currentTimeMillis() - ts;
                writer.write("stats_columns");
                if (isSource) {
                    status.setSourceRowFilterMillis(rowFilterMillis);
                    writer.writeRecord(new String[]{"sourceRowFilterMillis"});
                    writer.write("stats");
                    writer.writeRecord(new String[]{String.valueOf(status.getSourceRowFilterMillis())});
                } else {
                    status.setTargetRowFilterMillis(rowFilterMillis);
                    writer.writeRecord(new String[]{"targetRowFilterMillis"});
                    writer.write("stats");
                    writer.writeRecord(new String[]{String.valueOf(status.getTargetRowFilterMillis())});
                }
            }
            catch (IOException e4) {
                throw new IoException((Exception)e4);
            }
            finally {
                resourceIn.close();
                resourceOut.close();
            }
            resourceOut.setState(IStagedResource.State.DONE);
            this.a.info("Filtered {} rows for compare request {} in {} seconds", new Object[]{count, status.getNodeCompareIdStep(), rowFilterMillis / 1000L});
        }
    }

    protected long a(CsvReader reader, CsvWriter writer, List<h> chunks, ProcessInfo processInfo) throws IOException {
        long count = 0L;
        g comparator = new g(0);
        Iterator<h> iterator = chunks.iterator();
        h chunk = iterator.hasNext() ? iterator.next() : null;
        reader.readRecord();
        Object[] tokens = reader.getValues();
        boolean foundStats = false;
        while (tokens.length != 0 && chunk != null) {
            if (tokens.length > 2 && (tokens[0].equals("cs") || tokens[0].equals("if"))) {
                String[] pkValues = (String[])ArrayUtils.subarray((Object[])tokens, (int)2, (int)tokens.length);
                int compareStart = Objects.compare(pkValues, chunk.a(), comparator);
                int compareEnd = Objects.compare(pkValues, chunk.b(), comparator);
                if (compareStart < 0) {
                    reader.readRecord();
                    tokens = reader.getValues();
                    ++count;
                    processInfo.incrementCurrentDataCount();
                    continue;
                }
                if (compareEnd <= 0) {
                    writer.writeRecord((String[])tokens);
                    reader.readRecord();
                    tokens = reader.getValues();
                    ++count;
                    processInfo.incrementCurrentDataCount();
                    if (compareEnd != 0) continue;
                    chunk = iterator.hasNext() ? iterator.next() : null;
                    continue;
                }
                chunk = iterator.hasNext() ? iterator.next() : null;
                continue;
            }
            if (tokens[0].equals("stats_columns") || tokens[0].equals("stats")) {
                writer.writeRecord((String[])tokens);
                foundStats = true;
            }
            reader.readRecord();
            tokens = reader.getValues();
        }
        if (!foundStats) {
            while (tokens.length > 0) {
                if (tokens[0].equals("stats_columns") || tokens[0].equals("stats")) {
                    writer.writeRecord((String[])tokens);
                }
                reader.readRecord();
                tokens = reader.getValues();
            }
        }
        return count;
    }
}

