/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.github.davidmoten.bigsorter.Serializer;
import com.github.davidmoten.bigsorter.Sorter;
import com.jumpmind.symmetric.console.impl.e;
import com.jumpmind.symmetric.console.impl.g;
import com.jumpmind.symmetric.console.impl.gV;
import com.jumpmind.symmetric.console.impl.t;
import com.jumpmind.symmetric.console.model.CompareTableStatus;
import com.jumpmind.symmetric.console.service.ICompareService;
import com.jumpmind.symmetric.console.service.impl.CompareServiceSqlMap;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.Checksum;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.mapper.RowMapper;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.csv.CsvWriter;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.impl.ISqlMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class v
extends e {
    protected final Logger a = LoggerFactory.getLogger(v.class);
    protected ISqlMap b;

    public v(ISymmetricEngine engine, ICompareService compareService) {
        this.engine = engine;
        this.compareService = compareService;
        this.b = new CompareServiceSqlMap(engine.getSymmetricDialect().getPlatform(), engine.getTablePrefix());
    }

    public long a(CompareTableStatus status, boolean isSource, ProcessInfo processInfo) {
        long ts;
        processInfo.setStatus(ProcessInfo.ProcessStatus.QUERYING);
        Table table = this.getTable(status, isSource);
        Set<String> inflightPks = null;
        if (status.getCompareRequest().isUseInflight()) {
            inflightPks = this.a(status, table, isSource);
        }
        IDatabasePlatform platform = this.engine.getTargetDialect().getTargetPlatform();
        DmlStatement st = platform.createDmlStatement(DmlStatement.DmlType.SELECT, table.getCatalog(), table.getSchema(), table.getName(), null, table.getColumns(), null, null);
        StringBuilder sql = new StringBuilder(st.getSql());
        sql.replace(sql.length() - 6, sql.length(), "t where ");
        sql.append(this.getInitialLoadSelect(status, isSource, table));
        this.a.info("Querying row extract for compare request {} for table {}: {}", new Object[]{status.getNodeCompareIdStep(), table.getName(), sql});
        ISqlReadCursor cursor = platform.getSqlTemplate().queryForCursor(sql.toString(), (ISqlRowMapper)new RowMapper());
        String[] pks = table.getPrimaryKeyColumnNames();
        String[] names = table.getColumnNames();
        IStagedResource resourceUnsorted = this.createResource(status, "row-unsorted");
        Checksum checksumAlgo = this.getChecksumAlgo(status.getCompareRequest());
        long extractTs = ts = System.currentTimeMillis();
        long checksumMillis = 0L;
        long count = 0L;
        int decimalScale = status.getCompareRequest().getDecimalScale();
        int timestampScale = status.getCompareRequest().getTimestampScale();
        int realScale = status.getCompareRequest().getRealScale();
        processInfo.setStatus(ProcessInfo.ProcessStatus.EXTRACTING);
        try (CsvWriter writer = new CsvWriter(resourceUnsorted.getOutputStream(), ',', Charset.defaultCharset());){
            Row row = null;
            while ((row = (Row)cursor.next()) != null) {
                int n2;
                boolean isInflight = false;
                if (inflightPks != null) {
                    StringBuilder pkString = new StringBuilder();
                    String[] stringArray = pks;
                    int n3 = stringArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        String pk = stringArray[n2];
                        pkString.append(row.getString(pk));
                        pkString.append("|");
                    }
                    isInflight = inflightPks.contains(pkString.toString());
                }
                if (isInflight) {
                    writer.write("if");
                    writer.write("0");
                } else {
                    writer.write("cs");
                    long checksumTs = System.currentTimeMillis();
                    String[] stringArray = names;
                    n2 = stringArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String name = stringArray[i2];
                        String value = this.a(row, name, decimalScale, timestampScale, realScale);
                        this.updateChecksum(checksumAlgo, value);
                    }
                    checksumMillis += System.currentTimeMillis() - checksumTs;
                    writer.write(String.valueOf(checksumAlgo.getValue()));
                    checksumAlgo.reset();
                }
                for (String pk : pks) {
                    writer.write(row.getString(pk));
                }
                writer.endRecord();
                ++count;
                processInfo.incrementCurrentDataCount();
                this.checkInterrupted();
                if (System.currentTimeMillis() - extractTs <= 60000L) continue;
                this.engine.getClusterService().refreshLock("Compare");
                this.a.info("Extracting rows for compare request {} for table {} for {} seconds and {} rows", new Object[]{status.getNodeCompareIdStep(), isSource ? status.getSourceTableName() : status.getTargetTableName(), (System.currentTimeMillis() - ts) / 1000L, count});
                extractTs = System.currentTimeMillis();
            }
        }
        catch (IOException e2) {
            throw new IoException((Exception)e2);
        }
        finally {
            cursor.close();
        }
        resourceUnsorted.setState(IStagedResource.State.DONE);
        long extractMillis = System.currentTimeMillis() - ts - checksumMillis;
        ts = System.currentTimeMillis();
        IStagedResource resourceRowChecksum = this.createResource(status, "row");
        this.checkInterrupted();
        Sorter.serializer((Serializer)new gV()).comparator((Comparator)new g(2)).input(new File[]{resourceUnsorted.getFile()}).output(resourceRowChecksum.getFile()).sort();
        long extractSize = resourceRowChecksum.getSize();
        long sortMillis = System.currentTimeMillis() - ts;
        if (isSource) {
            status.setSourceRowCount(count);
            status.setSourceRowExtractMillis(extractMillis);
            status.setSourceRowExtractSize(extractSize);
            status.setSourceRowChecksumMillis(checksumMillis);
            status.setSourceRowSortMillis(sortMillis);
        } else {
            status.setTargetRowCount(count);
            status.setTargetRowExtractMillis(extractMillis);
            status.setTargetRowExtractSize(extractSize);
            status.setTargetRowChecksumMillis(checksumMillis);
            status.setTargetRowSortMillis(sortMillis);
        }
        this.checkInterrupted();
        this.a(resourceRowChecksum, status, isSource);
        resourceRowChecksum.setState(IStagedResource.State.DONE);
        resourceUnsorted.delete();
        this.a.info("Extracted {} rows for compare request {} for table {} in {} seconds", new Object[]{count, status.getNodeCompareIdStep(), table.getName(), extractMillis / 1000L});
        return count;
    }

    protected String a(Row row, String columnName, int decimalScale, int timestampScale, int realScale) {
        Object obj = row.get((Object)columnName);
        if (obj != null) {
            if (obj instanceof String) {
                return ((String)obj).trim();
            }
            if (obj instanceof BigDecimal) {
                BigDecimal b2 = (BigDecimal)obj;
                if (decimalScale > 0) {
                    b2 = b2.setScale(decimalScale, RoundingMode.HALF_UP);
                }
                return b2.toPlainString();
            }
            if (obj instanceof Timestamp || obj instanceof LocalDateTime) {
                Timestamp ts = obj instanceof LocalDateTime ? Timestamp.valueOf((LocalDateTime)obj) : (Timestamp)obj;
                if (timestampScale >= 0 && timestampScale < 9) {
                    double pow = Math.pow(10.0, 9 - timestampScale);
                    int nanos = (int)((double)Math.round((double)ts.getNanos() / pow) * pow);
                    if (nanos < 1000000000) {
                        ts.setNanos(nanos);
                    } else {
                        ts.setNanos(0);
                        ts.setTime(ts.getTime() + 1000L);
                    }
                }
                return ts.toString();
            }
            if (obj instanceof byte[]) {
                return Hex.encodeHexString((byte[])((byte[])obj));
            }
            if ((obj instanceof Float || obj instanceof Double) && realScale > 1) {
                DecimalFormat df2 = new DecimalFormat("#." + StringUtils.repeat((String)"#", (int)(realScale - 1)) + "E0");
                return df2.format(obj);
            }
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? "1" : "0";
            }
            return obj.toString();
        }
        return null;
    }

    protected void a(IStagedResource resourceRowChecksum, CompareTableStatus status, boolean isSource) {
        try (CsvWriter writer = new CsvWriter(resourceRowChecksum.getOutputStream(true), ',', Charset.defaultCharset());){
            writer.write("stats_columns");
            if (isSource) {
                writer.writeRecord(new String[]{"sourceRowCount", "sourceRowExtractMillis", "sourceRowChecksumMillis", "sourceRowExtractSize", "sourceRowSortMillis", "sourceInflightCount", "sourceInflightMillis"});
            } else {
                writer.writeRecord(new String[]{"targetRowCount", "targetRowExtractMillis", "targetRowChecksumMillis", "targetRowExtractSize", "targetRowSortMillis", "targetInflightCount", "targetInflightMillis"});
            }
            writer.write("stats");
            if (isSource) {
                writer.writeRecord(new String[]{String.valueOf(status.getSourceRowCount()), String.valueOf(status.getSourceRowExtractMillis()), String.valueOf(status.getSourceRowChecksumMillis()), String.valueOf(status.getSourceRowExtractSize()), String.valueOf(status.getSourceRowSortMillis()), String.valueOf(status.getSourceInflightCount()), String.valueOf(status.getSourceInflightMillis())});
            } else {
                writer.writeRecord(new String[]{String.valueOf(status.getTargetRowCount()), String.valueOf(status.getTargetRowExtractMillis()), String.valueOf(status.getTargetRowChecksumMillis()), String.valueOf(status.getTargetRowExtractSize()), String.valueOf(status.getTargetRowSortMillis()), String.valueOf(status.getTargetInflightCount()), String.valueOf(status.getTargetInflightMillis())});
            }
        }
        catch (IOException e2) {
            throw new IoException((Exception)e2);
        }
        finally {
            resourceRowChecksum.close();
        }
    }

    protected Set<String> a(CompareTableStatus tableStatus, Table table, boolean isSource) {
        long ts = System.currentTimeMillis();
        HashSet<String> inflightPks = new HashSet<String>();
        String channelId = this.b(tableStatus, table, isSource);
        if (channelId != null) {
            List gaps;
            long minDataId;
            this.a.info("Querying inflight data for compare request {} for table {}", (Object)tableStatus.getNodeCompareIdStep(), (Object)table.getName());
            int maxCount = this.engine.getParameterService().getInt("compare.max.inflight.count", 10000);
            t mapper = new t(table.getName(), maxCount);
            IDatabasePlatform platform = this.engine.getDatabasePlatform();
            long minBatchId = this.engine.getSqlTemplate().queryForLong(this.b.getSql(new String[]{"inflightMinBatchId"}), new Object[]{isSource ? tableStatus.getTargetNodeId() : tableStatus.getSourceNodeId(), channelId});
            if (minBatchId > 0L && (minDataId = this.engine.getSqlTemplate().queryForLong(this.b.getSql(new String[]{"inflightMinDataId"}), new Object[]{minBatchId})) > 0L) {
                List datas = this.engine.getSqlTemplate().query(this.b.getSql(new String[]{"inflightData"}), (ISqlRowMapper)mapper, new Object[]{minDataId, tableStatus.getTargetTableName()}, new int[]{this.engine.getSymmetricDialect().getSqlTypeForIds(), 12});
                this.a.info("Found {} inflight data in batches for table {}", (Object)datas.size(), (Object)table.getName());
                this.a(inflightPks, datas, table);
            }
            if ((gaps = this.engine.getRouterService().getDataGaps()) != null && gaps.size() > 0) {
                long minStartId = ((DataGap)gaps.get(0)).getStartId();
                Object selectDataUnroutedKey = "selectDataUnrouted";
                if (platform.getDdlBuilder().getDatabaseInfo().canDeleteUsingExists()) {
                    selectDataUnroutedKey = (String)selectDataUnroutedKey + "NotExists";
                }
                List datas = this.engine.getSqlTemplate().query(this.b.getSql(new String[]{selectDataUnroutedKey}), (ISqlRowMapper)mapper, new Object[]{table.getName(), minStartId}, new int[]{12, this.engine.getSymmetricDialect().getSqlTypeForIds()});
                this.a.info("Found {} unrouted data for table {}", (Object)datas.size(), (Object)table.getName());
                this.a(inflightPks, datas, table);
            }
            if (isSource) {
                tableStatus.setSourceInflightMillis(System.currentTimeMillis() - ts);
                tableStatus.setSourceInflightCount(inflightPks.size());
            } else {
                tableStatus.setTargetInflightMillis(System.currentTimeMillis() - ts);
                tableStatus.setTargetInflightCount(inflightPks.size());
            }
        }
        return inflightPks;
    }

    protected String b(CompareTableStatus tableStatus, Table table, boolean isSource) {
        TriggerRouter triggerRouter = null;
        String channelId = null;
        if (isSource) {
            triggerRouter = this.engine.getTriggerRouterService().findTriggerRouterById(tableStatus.getCompareRequest().getTriggerId(), tableStatus.getCompareRequest().getRouterId(), false);
        } else {
            Node sourceNode;
            TriggerHistory triggerHist = this.engine.getTriggerRouterService().findTriggerHistory(tableStatus.getTargetCatalogName(), tableStatus.getTargetSchemaName(), tableStatus.getTargetTableName());
            if (triggerHist != null && (sourceNode = this.engine.getNodeService().findNode(tableStatus.getSourceNodeId())) != null) {
                Map map = this.engine.getTriggerRouterService().getTriggerRoutersByTriggerHist(sourceNode.getNodeGroupId(), false);
                triggerRouter = (TriggerRouter)map.get(triggerHist.getTriggerHistoryId());
            }
        }
        if (triggerRouter != null) {
            channelId = triggerRouter.getTrigger().getChannelId();
        }
        return channelId;
    }

    protected void a(Set<String> inflightPks, List<CsvData> datas, Table table) {
        IDatabasePlatform platform = this.engine.getDatabasePlatform();
        BinaryEncoding encoding = this.engine.getSymmetricDialect().getBinaryEncoding();
        Column[] pkColumns = table.getPrimaryKeyColumns();
        for (CsvData data : datas) {
            String[] rowData;
            String[] pkData = data.getParsedData("pkData");
            if (pkData == null && (rowData = data.getParsedData("rowData")) != null && rowData.length >= pkColumns.length) {
                pkData = (String[])ArrayUtils.subarray((Object[])data.getParsedData("rowData"), (int)0, (int)pkColumns.length);
            }
            if (pkData == null) continue;
            Object[] values = platform.getObjectValues(encoding, pkData, pkColumns);
            StringBuilder pkString = new StringBuilder();
            for (Object value : values) {
                pkString.append(this.a(value));
                pkString.append("|");
            }
            inflightPks.add(pkString.toString());
        }
    }

    protected String a(Object obj) {
        if (obj != null) {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof BigDecimal) {
                return ((BigDecimal)obj).toPlainString();
            }
            if (obj instanceof byte[]) {
                return Hex.encodeHexString((byte[])((byte[])obj));
            }
            return obj.toString();
        }
        return null;
    }
}

