/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.e;
import com.jumpmind.symmetric.console.impl.g;
import com.jumpmind.symmetric.console.impl.h;
import com.jumpmind.symmetric.console.impl.v;
import com.jumpmind.symmetric.console.model.CompareTableStatus;
import com.jumpmind.symmetric.console.service.ICompareService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.zip.Checksum;
import org.apache.commons.lang3.ArrayUtils;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.csv.CsvWriter;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class u
extends e {
    protected final Logger a = LoggerFactory.getLogger(u.class);
    protected v b;

    public u(ISymmetricEngine engine, ICompareService compareService) {
        this.engine = engine;
        this.compareService = compareService;
        this.b = new v(engine, compareService);
    }

    public void a(CompareTableStatus status, List<h> remoteChunks, boolean isSource, ProcessInfo processInfo) {
        processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
        IStagedResource resourceIn = this.findResource(status, "row");
        if (resourceIn == null || !resourceIn.exists() || resourceIn.getState() != IStagedResource.State.DONE) {
            this.b.a(status, isSource, processInfo);
            resourceIn = this.findResource(status, "row");
            processInfo.setCurrentDataCount(0L);
            processInfo.incrementBatchCount();
        }
        String tableName = isSource ? status.getSourceTableName() : status.getTargetTableName();
        IStagedResource resourceOut = this.createResource(status, "chunk");
        long rowCount = isSource ? status.getSourceRowCount() : status.getTargetRowCount();
        long chunkSize = this.getChunkSize(rowCount);
        long ts = System.currentTimeMillis();
        long count = 0L;
        this.a.info("Chunking compare request {} for table {} using chunk size {}", new Object[]{status.getNodeCompareIdStep(), tableName, chunkSize});
        try (CsvReader reader = CsvUtils.getCsvReaderDquote((Reader)new InputStreamReader(resourceIn.getInputStream()));
             CsvWriter writer = new CsvWriter(resourceOut.getOutputStream(), ',', Charset.defaultCharset());){
            Checksum checksum = this.getChecksumAlgo(status.getCompareRequest());
            count = remoteChunks != null && remoteChunks.size() > 0 ? this.a(reader, writer, checksum, chunkSize, remoteChunks, processInfo) : this.a(reader, writer, checksum, chunkSize, processInfo);
            writer.write("stats_columns");
            if (isSource) {
                writer.writeRecord(new String[]{"sourceChunkMillis"});
            } else {
                writer.writeRecord(new String[]{"targetChunkMillis"});
            }
            writer.write("stats");
            if (isSource) {
                writer.writeRecord(new String[]{String.valueOf(status.getSourceChunkMillis())});
            } else {
                writer.writeRecord(new String[]{String.valueOf(status.getTargetChunkMillis())});
            }
        }
        catch (IOException e2) {
            throw new IoException((Exception)e2);
        }
        finally {
            resourceIn.close();
            resourceOut.close();
        }
        resourceOut.setState(IStagedResource.State.DONE);
        long chunkMillis = System.currentTimeMillis() - ts;
        if (isSource) {
            status.setSourceChunkMillis(chunkMillis);
        } else {
            status.setTargetChunkMillis(chunkMillis);
        }
        this.a.info("Chunked {} rows for compare request {} for table {} in {} seconds", new Object[]{count, status.getNodeCompareIdStep(), tableName, chunkMillis / 1000L});
    }

    protected long a(CsvReader reader, CsvWriter writer, Checksum checksum, long maxChunkSize, ProcessInfo processInfo) throws IOException {
        long count = 0L;
        long chunkCount = 1L;
        long currentChunkSize = 0L;
        String[] startTokens = null;
        String[] lastTokens = null;
        while (reader.readRecord()) {
            String[] tokens = reader.getValues();
            if (!tokens[0].equals("cs")) continue;
            this.updateChecksum(checksum, tokens[1]);
            if (++currentChunkSize == maxChunkSize && chunkCount < 200L) {
                this.a(writer, checksum, startTokens, tokens, 2);
                checksum.reset();
                ++chunkCount;
                currentChunkSize = 0L;
            } else if (currentChunkSize == 1L) {
                startTokens = tokens;
            }
            ++count;
            processInfo.incrementCurrentDataCount();
            lastTokens = tokens;
        }
        if (currentChunkSize > 0L) {
            this.a(writer, checksum, startTokens, lastTokens, 2);
        }
        return count;
    }

    protected long a(CsvReader reader, CsvWriter writer, Checksum checksum, long maxChunkSize, List<h> remoteChunks, ProcessInfo processInfo) throws IOException {
        g comparator = new g(0);
        Iterator<h> iterator = remoteChunks.iterator();
        h chunk = iterator.hasNext() ? iterator.next() : null;
        String[] extraChunkStartPkValues = null;
        String[] extraChunkEndPkValues = null;
        reader.readRecord();
        Object[] tokens = reader.getValues();
        boolean inChunk = false;
        long count = 0L;
        while (true) {
            if (tokens.length == 0 && chunk == null) {
                if (extraChunkStartPkValues == null) break;
                this.a(writer, checksum, extraChunkStartPkValues, extraChunkEndPkValues, 0);
                break;
            }
            if (tokens.length > 2 && tokens[0].equals("cs")) {
                int compare;
                String[] pkValues = (String[])ArrayUtils.subarray((Object[])tokens, (int)2, (int)tokens.length);
                if (inChunk) {
                    compare = Objects.compare(pkValues, chunk.b(), comparator);
                    if (compare <= 0) {
                        this.updateChecksum(checksum, (String)tokens[1]);
                        reader.readRecord();
                        tokens = reader.getValues();
                        ++count;
                        processInfo.incrementCurrentDataCount();
                    }
                    if (compare < 0) continue;
                    this.a(writer, checksum, chunk.a(), chunk.b(), 0);
                    checksum.reset();
                    chunk = iterator.hasNext() ? iterator.next() : null;
                    inChunk = false;
                    continue;
                }
                int n2 = compare = chunk == null ? -1 : Objects.compare(pkValues, chunk.a(), comparator);
                if (compare < 0) {
                    if (extraChunkStartPkValues == null) {
                        extraChunkStartPkValues = pkValues;
                    }
                    extraChunkEndPkValues = pkValues;
                    reader.readRecord();
                    tokens = reader.getValues();
                    ++count;
                    processInfo.incrementCurrentDataCount();
                    continue;
                }
                inChunk = true;
                if (extraChunkStartPkValues == null) continue;
                this.a(writer, checksum, extraChunkStartPkValues, extraChunkEndPkValues, 0);
                extraChunkEndPkValues = null;
                extraChunkStartPkValues = null;
                continue;
            }
            reader.readRecord();
            tokens = reader.getValues();
        }
        return count;
    }

    protected void a(CsvWriter writer, Checksum checksum, String[] startPkValues, String[] endPkValues, int pkValuesIndex) throws IOException {
        writer.write("cs");
        writer.write(String.valueOf(checksum.getValue()));
        this.a(writer, startPkValues, pkValuesIndex);
        this.a(writer, endPkValues, pkValuesIndex);
        writer.endRecord();
    }

    protected void a(CsvWriter writer, String[] tokens, int index) throws IOException {
        for (int i2 = index; i2 < tokens.length; ++i2) {
            writer.write(tokens[i2]);
        }
    }
}

