/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.B;
import com.jumpmind.symmetric.console.impl.D;
import com.jumpmind.symmetric.console.impl.e;
import com.jumpmind.symmetric.console.impl.f;
import com.jumpmind.symmetric.console.impl.g;
import com.jumpmind.symmetric.console.impl.l;
import com.jumpmind.symmetric.console.impl.r;
import com.jumpmind.symmetric.console.impl.v;
import com.jumpmind.symmetric.console.impl.w;
import com.jumpmind.symmetric.console.model.CompareTableStatus;
import com.jumpmind.symmetric.console.service.ICompareService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class o
extends e {
    protected final Logger a = LoggerFactory.getLogger(o.class);
    protected r b;
    protected v c;
    protected w d;

    public o(ISymmetricEngine engine, ICompareService compareService) {
        this.engine = engine;
        this.compareService = compareService;
        this.b = new r(engine, compareService);
        this.c = new v(engine, compareService);
        this.d = new w(engine, compareService);
    }

    public void a(CompareTableStatus status, ProcessInfo processInfo) {
        IStagedResource resourceRemote;
        boolean statusNeedsUpdate = false;
        String resourceName = this.getResourceName(status);
        IStagedResource resource = this.findResource(status, resourceName);
        if (resource == null || !resource.exists() || resource.getState() != IStagedResource.State.DONE) {
            if (status.getChunkDiffCount() > 0L) {
                this.d.a(status, this.isSource(status), processInfo);
                statusNeedsUpdate = true;
            } else if (this.isInitiator(status.getCompareRequest())) {
                this.b.a(status);
                this.c.a(status, this.isSource(status), processInfo);
                if (status.getSourceNodeId().equals(this.engine.getNodeId())) {
                    this.compareService.updateCompareTableStatus(status);
                }
            } else if (status.getStatus().equals("NE") || status.getStatus().equals("SE")) {
                this.c.a(status, this.isSource(status), processInfo);
                statusNeedsUpdate = true;
            }
            resource = this.findResource(status, resourceName);
        }
        RuntimeException e2 = null;
        if (status.getStatus().equals("NE")) {
            try {
                this.b.a(status, resourceName, status.getTargetNodeId(), status.getSourceNodeId());
            }
            catch (RuntimeException ex2) {
                e2 = ex2;
            }
        }
        if (this.isSource(status) && (resourceRemote = this.findResource(status, resourceName + "-remote")) != null && resourceRemote.exists() && resourceRemote.getState() == IStagedResource.State.DONE && resource != null && resource.exists() && resource.getState() == IStagedResource.State.DONE) {
            this.setStatusIfNotSet(status, "SE");
            this.a(status, resource, resourceRemote, true, processInfo);
            statusNeedsUpdate = false;
        }
        if (this.isSource(status) && statusNeedsUpdate) {
            this.compareService.updateCompareTableStatus(status);
        }
        if (e2 != null) {
            throw e2;
        }
    }

    protected void a(CompareTableStatus status, IStagedResource resourceSrc, IStagedResource resourceTgt, boolean isSource, ProcessInfo processInfo) {
        long ts;
        processInfo.setCurrentDataCount(0L);
        processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
        long compareTs = ts = System.currentTimeMillis();
        long count = 0L;
        HashMap<String, Object> statMap = new HashMap<String, Object>();
        String[] statColumnsSrc = null;
        String[] statColumnsTgt = null;
        IStagedResource resourceRepair = null;
        Table table = null;
        if (status.getCompareRequest().isUseScript() || status.getCompareRequest().isUseRepair()) {
            table = this.getTable(status, isSource);
            resourceRepair = this.createResource(status, "repair");
        }
        Node targetNode = this.findNode(status.getTargetNodeId(), status.getCompareRequest());
        f writer = null;
        writer = this.engine.getParameterService().is("compare.repair.batch.csv") ? new B(this.engine, status, table, targetNode.getDatabaseName(), resourceRepair) : new D(this.engine, status, table, targetNode.getDatabaseName(), resourceRepair);
        try (CsvReader readerSrc = CsvUtils.getCsvReaderDquote((Reader)new InputStreamReader(resourceSrc.getInputStream()));
             CsvReader readerTgt = CsvUtils.getCsvReaderDquote((Reader)new InputStreamReader(resourceTgt.getInputStream()));){
            g comparator = new g(2);
            readerSrc.readRecord();
            readerTgt.readRecord();
            Object[] tokensSrc = readerSrc.getValues();
            Object[] tokensTgt = readerTgt.getValues();
            Object[] tokensSrcLastDiff = null;
            writer.a();
            while (tokensSrc.length != 0 || tokensTgt.length != 0) {
                if ((tokensSrc.length == 0 || tokensSrc[0].equals("cs")) && (tokensTgt.length == 0 || tokensTgt[0].equals("cs"))) {
                    int compareTo = Objects.compare(tokensSrc, tokensTgt, comparator);
                    if (compareTo == 0) {
                        if (tokensSrc[1].equals(tokensTgt[1]) || tokensSrc[0].equals("if") || ((String)tokensTgt[0]).equals("if")) {
                            status.incrementRowMatchCount();
                        } else {
                            status.incrementRowDiffCount();
                            writer.a((String[])ArrayUtils.subarray((Object[])tokensSrc, (int)2, (int)tokensSrc.length));
                            tokensSrcLastDiff = tokensSrc;
                        }
                        readerSrc.readRecord();
                        readerTgt.readRecord();
                        tokensSrc = readerSrc.getValues();
                        tokensTgt = readerTgt.getValues();
                    } else if (compareTo < 0) {
                        if (tokensSrcLastDiff != null && Objects.compare(tokensSrc, tokensSrcLastDiff, comparator) == 0) {
                            throw new l("Table " + status.getSourceTableName() + " with pk columns of " + ArrayUtils.toString((Object)table.getPrimaryKeyColumnNames()) + " cannot be compared because it has multiple rows for the same pk value of " + ArrayUtils.toString((Object)ArrayUtils.subarray((Object[])tokensSrc, (int)2, (int)tokensSrc.length)));
                        }
                        status.incrementRowMissingCount();
                        writer.b((String[])ArrayUtils.subarray((Object[])tokensSrc, (int)2, (int)tokensSrc.length));
                        readerSrc.readRecord();
                        tokensSrc = readerSrc.getValues();
                    } else if (compareTo > 0) {
                        status.incrementRowExtraCount();
                        writer.c((String[])ArrayUtils.subarray((Object[])tokensTgt, (int)2, (int)tokensTgt.length));
                        readerTgt.readRecord();
                        tokensTgt = readerTgt.getValues();
                    }
                } else {
                    if (tokensSrc.length > 0 && !tokensSrc[0].equals("cs")) {
                        statColumnsSrc = this.a((String[])tokensSrc, statColumnsSrc, statMap);
                        readerSrc.readRecord();
                        tokensSrc = readerSrc.getValues();
                    }
                    if (tokensTgt.length > 0 && !tokensTgt[0].equals("cs")) {
                        statColumnsTgt = this.a((String[])tokensTgt, statColumnsTgt, statMap);
                        readerTgt.readRecord();
                        tokensTgt = readerTgt.getValues();
                    }
                }
                ++count;
                processInfo.incrementCurrentDataCount();
                if (Thread.currentThread().isInterrupted()) {
                    throw new IoException("This thread was interrupted", new Object[0]);
                }
                if (System.currentTimeMillis() - compareTs <= 60000L) continue;
                this.engine.getClusterService().refreshLock("Compare");
                this.a.info("Comparing rows for compare request {} for table {} for {} seconds and {} rows", new Object[]{status.getNodeCompareIdStep(), status.getTargetTableName(), (System.currentTimeMillis() - ts) / 1000L, count});
                compareTs = System.currentTimeMillis();
            }
        }
        catch (IOException e2) {
            writer.a(true);
            throw new IoException((Exception)e2);
        }
        finally {
            try {
                writer.b();
                resourceSrc.close();
                resourceTgt.close();
            }
            catch (IOException e3) {
                throw new IoException((Exception)e3);
            }
        }
        try {
            BeanUtils.populate((Object)status, statMap);
        }
        catch (Exception e4) {
            this.a.warn("Unable to update statistics for compare request {}-{} step {} because: {}: {}", new Object[]{status.getSourceNodeId(), status.getCompareId(), status.getStepNumber(), e4.getClass().getName(), e4.getMessage()});
        }
        status.setRowCompareMillis(System.currentTimeMillis() - ts - writer.c());
        status.setRepairQueryMillis(writer.c());
        status.setMatchFlag(status.getRowDiffCount() == 0L && status.getRowMissingCount() == 0L && status.getRowExtraCount() == 0L);
        if (status.isMatchFlag() || !status.getCompareRequest().isUseRepair() && !status.getCompareRequest().isUseScript()) {
            status.setStatus("CO");
            this.cleanUp(status);
        } else {
            status.setLevel("F");
            status.setStatus("NE");
        }
        this.compareService.updateCompareTableStatus(status);
        this.a.info("Compared {} rows for compare request {} for table {} in {} seconds: match={} diff={} miss={} extra={}", new Object[]{count, status.getNodeCompareIdStep(), status.getTargetTableName(), (System.currentTimeMillis() - ts) / 1000L, status.getRowMatchCount(), status.getRowDiffCount(), status.getRowMissingCount(), status.getRowExtraCount()});
    }

    protected String[] a(String[] tokens, String[] statColumns, Map<String, Object> statMap) {
        if (tokens[0].equals("stats_columns")) {
            statColumns = tokens;
        } else if (tokens[0].equals("stats") && statColumns != null) {
            for (int i2 = 1; i2 < statColumns.length; ++i2) {
                statMap.put(statColumns[i2], tokens[i2]);
            }
        }
        return statColumns;
    }
}

