/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.A;
import com.jumpmind.symmetric.console.impl.C;
import com.jumpmind.symmetric.console.impl.e;
import com.jumpmind.symmetric.console.impl.r;
import com.jumpmind.symmetric.console.impl.y;
import com.jumpmind.symmetric.console.model.CompareTableStatus;
import com.jumpmind.symmetric.console.service.ICompareService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class m
extends e {
    protected final Logger a = LoggerFactory.getLogger(m.class);
    protected r b;

    public m(ISymmetricEngine engine, ICompareService compareService) {
        this.engine = engine;
        this.compareService = compareService;
        this.b = new r(engine, compareService);
    }

    public void a(CompareTableStatus status, ProcessInfo processInfo) {
        IStagedResource resource;
        if (this.isSource(status) && status.getStatus().equals("FI")) {
            this.cleanUp(status);
            status.setStatus("OK");
            status.setEndTime(new Date());
            this.compareService.updateCompareTableStatus(status);
        }
        if (status.getStatus().equals("NE")) {
            this.b.a(status, "repair", status.getSourceNodeId(), status.getTargetNodeId());
        }
        if (this.isTarget(status) && !status.getStatus().equals("FI") && (resource = this.findResource(status, "repair-remote")) != null && resource.exists() && resource.getState() == IStagedResource.State.DONE) {
            if (status.getCompareRequest().isUseRepair()) {
                this.setStatusIfNotSet(status, "SE");
                this.a(status, processInfo, resource);
            } else {
                status.setStatus("FI");
                this.compareService.updateCompareTableStatus(status);
                this.cleanUp(status);
            }
        }
    }

    protected void a(CompareTableStatus status, ProcessInfo processInfo, IStagedResource resource) {
        boolean retryRejects;
        int attemptCount;
        long ts = System.currentTimeMillis();
        this.a.info("Repairing data for compare request {} for table {}", (Object)status.getNodeCompareIdStep(), (Object)status.getTargetTableName());
        String name = "repair-remote";
        IStagedResource nextResource = null;
        for (attemptCount = 1; attemptCount <= 10; ++attemptCount) {
            String nextName = name + "-" + attemptCount;
            nextResource = this.findResource(status, nextName);
            if (nextResource == null || !nextResource.exists() || nextResource.getState() != IStagedResource.State.DONE) {
                nextResource = this.createResource(status, nextName);
                break;
            }
            resource = nextResource;
            this.a.info("Resuming repair for compare request {} for table {} with {}", new Object[]{status.getNodeCompareIdStep(), status.getTargetTableName(), resource.getFile().getName()});
        }
        int appliedCount = 0;
        int rejectedCount = 0;
        Exception exception = null;
        try {
            y loader = null;
            loader = this.a(resource) ? new A() : new C();
            loader.a(this.engine, status, processInfo, resource, nextResource, attemptCount);
            appliedCount = loader.a();
            rejectedCount = loader.b();
        }
        catch (Exception e2) {
            status.setErrorFlag(true);
            status.setErrorMessage(e2.getClass().getName() + (String)(e2.getMessage() != null ? ": " + e2.getMessage() : ""));
            exception = e2;
        }
        if (exception == null && rejectedCount > 0) {
            nextResource.setState(IStagedResource.State.DONE);
        }
        long repairMillis = System.currentTimeMillis() - ts;
        status.setRepairLoadMillis(repairMillis);
        status.setRepairRejectCount(rejectedCount);
        if (exception != null) {
            this.a.error("Failed to repair compare request " + status.getNodeCompareIdStep() + " for table " + status.getTargetTableName(), (Throwable)exception);
        } else {
            this.a.info("Repaired data for compare request {} for table {} with {} rows applied {}in {} seconds", new Object[]{status.getNodeCompareIdStep(), status.getTargetTableName(), appliedCount, rejectedCount == 0 ? "" : "and " + rejectedCount + " rows rejected ", repairMillis / 1000L});
        }
        boolean bl2 = retryRejects = rejectedCount > 0 && (attemptCount == 1 || appliedCount > 0) && attemptCount < 10;
        if (exception != null || !retryRejects) {
            status.setStatus("FI");
            this.cleanUp(status);
        }
        this.compareService.updateCompareTableStatus(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean a(IStagedResource resource) throws IOException {
        boolean isBatchCsv = false;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));){
            String line = reader.readLine();
            isBatchCsv = line != null && line.startsWith("nodeid");
        }
        finally {
            resource.close();
        }
        return isBatchCsv;
    }
}

