/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.ui.common.I;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IParameterService;

public class ha {
    public static void a(I controller, Collection<Node> nodes, Function<Object, Object> getParent) {
        ha.a(controller, null, nodes, getParent);
    }

    public static void a(I controller, Collection<String> certs, Collection<Node> nodes, Function<Object, Object> getParent) {
        ISymmetricEngine engine = controller.getSymmetricEngine();
        IDatabasePlatform platform = engine.getDatabasePlatform();
        IDataService dataService = engine.getDataService();
        ISqlTransaction transaction = null;
        Node identity = controller.getSymmetricEngine().getNodeService().findIdentity();
        if (identity == null) {
            IParameterService parameterService = controller.getSymmetricEngine().getParameterService();
            identity = new Node("", parameterService.getNodeGroupId());
            identity.setSyncUrl(parameterService.getSyncUrl());
            identity.setExternalId(parameterService.getExternalId());
        }
        String currentNodeId = identity.getNodeId();
        if (certs == null) {
            certs = new ArrayList<String>();
        }
        if (certs.isEmpty()) {
            certs.add(engine.getSecurityService().exportCurrentSslCert(false));
        }
        try {
            transaction = platform.getSqlTemplate().startSqlTransaction();
            String userId = controller.getConsoleUser().getUserId();
            String twoTierScript = ha.a(engine, certs);
            String threeTierScript = ha.a(engine, certs, userId);
            ArrayList<String> secondTierTargetNodeIdList = new ArrayList<String>();
            ArrayList<String> secondTierMiddleNodeIdList = new ArrayList<String>();
            block6: for (Node targetNode : nodes) {
                if (Version.isOlderThanVersion((String)targetNode.getSymmetricVersion(), (String)"3.12.2")) continue;
                String targetNodeId = targetNode.getNodeId();
                int tiersAway = ha.a(identity, targetNode, getParent);
                if (tiersAway == 1) {
                    dataService.insertScriptEvent(transaction, "config", targetNode, twoTierScript, false, -1L, userId);
                    transaction.commit();
                    secondTierTargetNodeIdList.add(targetNodeId);
                    continue;
                }
                if (tiersAway != 2) continue;
                Object parent = getParent.apply(targetNode);
                while (parent != null) {
                    if (parent instanceof Node) {
                        Node middleNode = (Node)parent;
                        dataService.insertScriptEvent(transaction, "config", middleNode, String.format(threeTierScript, StringEscapeUtils.escapeJava((String)targetNodeId)), false, -1L, userId);
                        String middleNodeId = middleNode.getNodeId();
                        secondTierMiddleNodeIdList.add(middleNodeId);
                        controller.getConsoleEventService().addEvent(new ConsoleEvent(userId, "Send bsh", currentNodeId, middleNodeId, targetNodeId, "Sent CA certificate"));
                        continue block6;
                    }
                    parent = getParent.apply(parent);
                }
            }
            String messagePrefix = "Sent CA certificate" + (certs.size() > 1 ? "s" : "");
            if (!secondTierTargetNodeIdList.isEmpty()) {
                controller.getConsoleEventService().addEvent(new ConsoleEvent(userId, "Send bsh", currentNodeId, currentNodeId, null, messagePrefix + " to nodes: " + StringUtils.join(secondTierTargetNodeIdList, (String)", ")));
            }
            if (!secondTierMiddleNodeIdList.isEmpty()) {
                controller.getConsoleEventService().addEvent(new ConsoleEvent(userId, "Send bsh", currentNodeId, currentNodeId, null, messagePrefix + " through nodes: " + StringUtils.join(secondTierMiddleNodeIdList, (String)", ")));
            }
        }
        catch (Error ex2) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex2;
        }
        catch (RuntimeException ex3) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex3;
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    public static String a(ISymmetricEngine engine, Collection<String> certs) {
        Object script = "byte[][] certData = new byte[][] {";
        for (String cert : certs) {
            script = (String)script + " \"" + StringEscapeUtils.escapeJava((String)cert) + "\".getBytes(),";
        }
        script = ((String)script).substring(0, ((String)script).length() - 1) + " };";
        return (String)script + "for (int i = 0; i < certData.length; i++) {    java.security.KeyStore.TrustedCertificateEntry cert = engine.getSecurityService().createTrustedCert(            certData[i], \"pem\", null, null);    if (cert != null) {        engine.getSecurityService().installTrustedCert(cert);    } else {        log.error(\"Failed to import CA certificate because ISecurityService.createTrustedCert() returned null. Check the {} parameter.\",                org.jumpmind.security.SecurityConstants.CLASS_NAME_SECURITY_SERVICE);    }}";
    }

    public static String a(ISymmetricEngine engine, Collection<String> certs, String userId) {
        String twoTierScript = ha.a(engine, certs);
        return "org.jumpmind.db.sql.ISqlTransaction transaction = null;try {    transaction = engine.getDatabasePlatform().getSqlTemplate().startSqlTransaction();    org.jumpmind.symmetric.model.Node targetNode = new org.jumpmind.symmetric.model.Node(\"%s\", \"\");    String script = \"" + StringEscapeUtils.escapeJava((String)twoTierScript) + "\";    String userId = \"" + StringEscapeUtils.escapeJava((String)userId) + "\";    engine.getDataService().insertScriptEvent(transaction, org.jumpmind.symmetric.common.Constants.CHANNEL_CONFIG,            targetNode, script, false, -1, userId);} catch (java.lang.Error ex) {    if (transaction != null) {        transaction.rollback();    }    throw ex;} catch (java.lang.RuntimeException ex) {    if (transaction != null) {        transaction.rollback();    }    throw ex;} finally {    if (transaction != null) {        transaction.close();    }}";
    }

    public static int a(Node currentNode, Node node, Function<Object, Object> getParent) {
        int tierCount = 0;
        Object parent = node;
        while (!currentNode.equals(parent)) {
            if ((parent = getParent.apply(parent)) == null) {
                tierCount = -1;
                break;
            }
            if (!(parent instanceof Node)) continue;
            ++tierCount;
        }
        return tierCount;
    }
}

