/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.ui.common.as;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.service.IConfigurationService;

public class gs
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private ISymmetricEngine a;

    @Override
    public MonitorEvent a(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        ArrayList<String> channelIdList = new ArrayList<String>();
        Map channelMap = this.a.getConfigurationService().getChannels(false);
        int minMaxDataToRoute = Integer.MAX_VALUE;
        long threshold = monitor.getThreshold();
        for (Channel channel : channelMap.values()) {
            String channelId = channel.getChannelId();
            if (channelId.equals("config") || channelId.equals("dynamic") || channelId.equals("filesync") || channelId.equals("filesync_reload") || channelId.equals("heartbeat") || channelId.equals("monitor") || channelId.equals("reload") || channelId.equals("system")) continue;
            int maxDataToRoute = channel.getMaxDataToRoute();
            if (maxDataToRoute < minMaxDataToRoute) {
                minMaxDataToRoute = maxDataToRoute;
            }
            if ((long)channel.getMaxDataToRoute() > threshold) continue;
            channelIdList.add(channelId);
            String problemDescription = "Channel '" + channelId + "' has a low max data to route of " + maxDataToRoute + ".  This can make routing less efficient and slower in some cases.  It is usually set to 100,000 or higher.";
            String actionDescription = "Increase the max data to route to 100,000 or more.";
            gR recommendation = new gR(problemDescription, actionDescription, true);
            recommendation.a("channelId", channelId);
            ArrayList<gR.a> options = new ArrayList<gR.a>();
            gR gR2 = recommendation;
            Objects.requireNonNull(gR2);
            options.add(gR2.new gR.a(1, "Increase the max data to route to " + (threshold + 1L) + " for the '" + channelId + "' channel", threshold + 1L));
            recommendation.a(options);
        }
        event.setValue(minMaxDataToRoute);
        int channelIdCount = channelIdList.size();
        if (channelIdCount > 0) {
            String problemDescription = channelIdCount == 1 ? "The '" + (String)channelIdList.get(0) + "' channel has a low max data to route of " + minMaxDataToRoute : "The following channels have a low max data to route: " + String.valueOf(channelIdList);
            problemDescription = problemDescription + ".  This can make routing less efficient and slower in some cases.";
            String actionDescription = "Increase the max data to route to " + (threshold + 1L) + " or more.";
            gR recommendation = new gR(problemDescription, actionDescription, true);
            ArrayList<gR.a> options = new ArrayList<gR.a>();
            gR gR3 = recommendation;
            Objects.requireNonNull(gR3);
            options.add(gR3.new gR.a(1, "Increase the max data to route to a minimum of " + (threshold + 1L) + " for all channels", threshold + 1L));
            recommendation.a(options);
            event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
        }
        return event;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        int minMaxDataToRoute = (int)event.getThreshold() + 1;
        if (event.getApprovedOption() == 1) {
            minMaxDataToRoute = (int)recommendation.a(1);
        }
        ArrayList<String> modifiedChannelIdList = new ArrayList<String>();
        IConfigurationService configService = this.a.getConfigurationService();
        for (Channel channel : configService.getChannels(true).values()) {
            if (channel.getMaxDataToRoute() >= minMaxDataToRoute) continue;
            channel.setMaxDataToRoute(minMaxDataToRoute);
            configService.saveChannel(channel, true);
            modifiedChannelIdList.add(channel.getChannelId());
        }
        IConsoleEventService consoleEventService = (IConsoleEventService)this.a.getExtensionService().getExtensionPoint(IConsoleEventService.class);
        String nodeId = this.a.getNodeId();
        consoleEventService.addEvent(new ConsoleEvent(event.getApprovedBy(), "Channel Modified", nodeId, nodeId, null, ((Object)modifiedChannelIdList).toString()));
        return true;
    }

    @Override
    public String b() {
        return "maxDataToRoute";
    }

    @Override
    public boolean a() {
        return true;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
    }
}

