/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.ui.common.as;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.FileTrigger;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IFileSyncService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.DataLoaderService;

public class gr
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private ISymmetricEngine a;

    @Override
    public MonitorEvent a(Monitor monitor) {
        boolean tooManyFileSyncChannels;
        int fileSyncChannelCount;
        MonitorEvent event = new MonitorEvent();
        ArrayList<Channel> dataChannelList = new ArrayList<Channel>();
        ArrayList<Channel> fileSyncChannelList = new ArrayList<Channel>();
        for (Channel channel : this.a.getConfigurationService().getChannels(false).values()) {
            String channelId = channel.getChannelId();
            if (channelId.equals("config") || channelId.equals("default") || channelId.equals("dynamic") || channelId.equals("filesync") || channelId.equals("filesync_reload") || channelId.equals("heartbeat") || channelId.equals("monitor") || channelId.equals("reload") || channelId.equals("system")) continue;
            if (channel.isFileSyncFlag()) {
                fileSyncChannelList.add(channel);
                continue;
            }
            dataChannelList.add(channel);
        }
        int dataChannelCount = dataChannelList.size() + 2;
        event.setValue(dataChannelCount > (fileSyncChannelCount = fileSyncChannelList.size() + 2) ? (long)dataChannelCount : (long)fileSyncChannelCount);
        long threshold = monitor.getThreshold();
        boolean tooManyDataChannels = (long)dataChannelCount >= threshold;
        boolean bl2 = tooManyFileSyncChannels = (long)fileSyncChannelCount >= threshold;
        if (tooManyDataChannels || tooManyFileSyncChannels) {
            int i2;
            Object problemDescription = "There are ";
            if (tooManyDataChannels) {
                problemDescription = (String)problemDescription + dataChannelCount + " data channels";
                if (tooManyFileSyncChannels) {
                    problemDescription = (String)problemDescription + " and " + fileSyncChannelCount + " file sync channels";
                }
            } else {
                problemDescription = (String)problemDescription + fileSyncChannelCount + " file sync channels";
            }
            problemDescription = (String)problemDescription + ".  A large number of channels can slow down routing.";
            String actionDescription = "Consolidate capture to a smaller number of channels.";
            gR recommendation = new gR((String)problemDescription, actionDescription, true);
            ArrayList<gR.a> options = new ArrayList<gR.a>();
            Object optionDescription = "";
            if (tooManyDataChannels) {
                ArrayList<String> dataChannelIdsToReplaceList = new ArrayList<String>();
                ArrayList<String> dataReloadChannelIdsToReplaceList = new ArrayList<String>();
                dataChannelList.sort((c0, c1) -> Integer.compare(c1.getProcessingOrder(), c0.getProcessingOrder()));
                for (i2 = 0; (long)i2 <= (long)dataChannelCount - threshold && i2 < dataChannelList.size(); ++i2) {
                    Channel dataChannel = (Channel)dataChannelList.get(i2);
                    if (dataChannel.isReloadFlag()) {
                        dataReloadChannelIdsToReplaceList.add(dataChannel.getChannelId());
                        continue;
                    }
                    dataChannelIdsToReplaceList.add(dataChannel.getChannelId());
                }
                if (!dataChannelIdsToReplaceList.isEmpty()) {
                    optionDescription = "Replace the following channels with the 'default' channel: " + String.valueOf(dataChannelIdsToReplaceList) + ". ";
                    recommendation.a("dataChannelIds", dataChannelIdsToReplaceList);
                }
                if (!dataReloadChannelIdsToReplaceList.isEmpty()) {
                    optionDescription = (String)optionDescription + "Replace the following channels with the 'reload' channel: " + String.valueOf(dataReloadChannelIdsToReplaceList) + ". ";
                    recommendation.a("dataReloadChannelIds", dataReloadChannelIdsToReplaceList);
                }
            }
            if (tooManyFileSyncChannels) {
                ArrayList<String> fileSyncChannelIdsToReplaceList = new ArrayList<String>();
                ArrayList<String> fileSyncReloadChannelIdsToReplaceList = new ArrayList<String>();
                fileSyncChannelList.sort((c0, c1) -> Integer.compare(c1.getProcessingOrder(), c0.getProcessingOrder()));
                for (i2 = 0; (long)i2 <= (long)fileSyncChannelCount - threshold && i2 < fileSyncChannelList.size(); ++i2) {
                    Channel fileSyncChannel = (Channel)fileSyncChannelList.get(i2);
                    if (fileSyncChannel.isReloadFlag()) {
                        fileSyncReloadChannelIdsToReplaceList.add(fileSyncChannel.getChannelId());
                        continue;
                    }
                    fileSyncChannelIdsToReplaceList.add(fileSyncChannel.getChannelId());
                }
                if (!fileSyncChannelIdsToReplaceList.isEmpty()) {
                    optionDescription = (String)optionDescription + "Replace the following channels with the 'filesync' channel: " + String.valueOf(fileSyncChannelIdsToReplaceList) + ". ";
                    recommendation.a("fileSyncChannelIds", fileSyncChannelIdsToReplaceList);
                }
                if (!fileSyncReloadChannelIdsToReplaceList.isEmpty()) {
                    optionDescription = (String)optionDescription + "Replace the following channels with the 'filesync_reload' channel: " + String.valueOf(fileSyncReloadChannelIdsToReplaceList) + ".";
                    recommendation.a("fileSyncReloadChannelIds", fileSyncReloadChannelIdsToReplaceList);
                }
            }
            gR gR2 = recommendation;
            Objects.requireNonNull(gR2);
            options.add(gR2.new gR.a(1, ((String)optionDescription).trim()));
            recommendation.a(options);
            event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
        }
        return event;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        List dataChannelIdsToReplaceList = (List)recommendation.c("dataChannelIds");
        List dataReloadChannelIdsToReplaceList = (List)recommendation.c("dataReloadChannelIds");
        List fileSyncChannelIdsToReplaceList = (List)recommendation.c("fileSyncChannelIds");
        List fileSyncReloadChannelIdsToReplaceList = (List)recommendation.c("fileSyncReloadChannelIds");
        List conflictList = this.a.getDataLoaderService().getConflictSettingsNodeGroupLinks();
        List triggerList = this.a.getTriggerRouterService().getTriggers();
        List fileTriggerList = this.a.getFileSyncService().getFileTriggers();
        this.a(dataChannelIdsToReplaceList, "default", conflictList, triggerList, null, event.getApprovedBy());
        this.a(dataReloadChannelIdsToReplaceList, "reload", conflictList, triggerList, null, event.getApprovedBy());
        this.a(fileSyncChannelIdsToReplaceList, "filesync", conflictList, null, fileTriggerList, event.getApprovedBy());
        this.a(fileSyncReloadChannelIdsToReplaceList, "filesync_reload", conflictList, null, fileTriggerList, event.getApprovedBy());
        return true;
    }

    private void a(List<String> channelIdsToReplaceList, String replacementChannelId, List<DataLoaderService.ConflictNodeGroupLink> conflictList, List<Trigger> triggerList, List<FileTrigger> fileTriggerList, String userId) {
        if (channelIdsToReplaceList != null) {
            IDataLoaderService dataLoaderService = this.a.getDataLoaderService();
            ITriggerRouterService triggerRouterService = this.a.getTriggerRouterService();
            IFileSyncService fileSyncService = this.a.getFileSyncService();
            IConfigurationService configService = this.a.getConfigurationService();
            ArrayList<String> modifiedConflictIdList = new ArrayList<String>();
            ArrayList<String> modifiedTriggerIdList = new ArrayList<String>();
            ArrayList<String> modifiedFileTriggerIdList = new ArrayList<String>();
            for (String channelId : channelIdsToReplaceList) {
                Channel channel;
                for (DataLoaderService.ConflictNodeGroupLink conflict : conflictList) {
                    if (!channelId.equals(conflict.getTargetChannelId())) continue;
                    conflict.setTargetChannelId(replacementChannelId);
                    dataLoaderService.save(conflict);
                    modifiedConflictIdList.add(conflict.getConflictId());
                }
                if (triggerList != null) {
                    for (Trigger trigger : triggerList) {
                        boolean triggerModified = false;
                        if (trigger.getChannelId().equals(channelId)) {
                            trigger.setChannelId(replacementChannelId);
                            triggerModified = true;
                        }
                        if (trigger.getReloadChannelId().equals(channelId)) {
                            trigger.setReloadChannelId(replacementChannelId);
                            triggerModified = true;
                        }
                        if (!triggerModified) continue;
                        triggerRouterService.saveTrigger(trigger);
                        modifiedTriggerIdList.add(trigger.getTriggerId());
                    }
                }
                if (fileTriggerList != null) {
                    for (FileTrigger fileTrigger : fileTriggerList) {
                        boolean fileTriggerModified = false;
                        if (fileTrigger.getChannelId().equals(channelId)) {
                            fileTrigger.setChannelId(replacementChannelId);
                            fileTriggerModified = true;
                        }
                        if (fileTrigger.getReloadChannelId().equals(channelId)) {
                            fileTrigger.setReloadChannelId(replacementChannelId);
                            fileTriggerModified = true;
                        }
                        if (!fileTriggerModified) continue;
                        fileSyncService.saveFileTrigger(fileTrigger);
                        modifiedFileTriggerIdList.add(fileTrigger.getTriggerId());
                    }
                }
                if ((channel = configService.getChannel(channelId)) == null) continue;
                configService.deleteChannel(channel);
            }
            IConsoleEventService consoleEventService = (IConsoleEventService)this.a.getExtensionService().getExtensionPoint(IConsoleEventService.class);
            String nodeId = this.a.getNodeId();
            if (!modifiedConflictIdList.isEmpty()) {
                consoleEventService.addEvent(new ConsoleEvent(userId, "Conflict Modified", nodeId, nodeId, null, ((Object)modifiedConflictIdList).toString()));
            }
            if (!modifiedTriggerIdList.isEmpty()) {
                consoleEventService.addEvent(new ConsoleEvent(userId, "Table Capture Modified", nodeId, nodeId, null, ((Object)modifiedTriggerIdList).toString()));
            }
            if (!modifiedFileTriggerIdList.isEmpty()) {
                consoleEventService.addEvent(new ConsoleEvent(userId, "File Capture Modified", nodeId, nodeId, null, ((Object)modifiedFileTriggerIdList).toString()));
            }
            consoleEventService.addEvent(new ConsoleEvent(userId, "Channel Deleted", nodeId, nodeId, null, channelIdsToReplaceList.toString()));
        }
    }

    @Override
    public String b() {
        return "maxChannels";
    }

    @Override
    public boolean a() {
        return true;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
    }
}

