/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.ui.common.as;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.db2.Db2SymmetricDialect;
import org.jumpmind.symmetric.db.firebird.FirebirdSymmetricDialect;
import org.jumpmind.symmetric.db.interbase.InterbaseSymmetricDialect;
import org.jumpmind.symmetric.db.mysql.MySqlSymmetricDialect;
import org.jumpmind.symmetric.db.oracle.OracleSymmetricDialect;
import org.jumpmind.symmetric.db.postgresql.PostgreSqlSymmetricDialect;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.util.SnapshotUtil;

public class go
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private ISymmetricEngine a;

    @Override
    public MonitorEvent a(Monitor monitor) {
        int maxWidth = 8000;
        ISymmetricDialect dialect = this.a.getTargetDialect();
        if (dialect instanceof PostgreSqlSymmetricDialect) {
            maxWidth = 1000000000;
        } else if (dialect instanceof OracleSymmetricDialect) {
            maxWidth = 4000;
        } else if (dialect instanceof MySqlSymmetricDialect) {
            maxWidth = 65535;
        } else if (dialect instanceof Db2SymmetricDialect) {
            maxWidth = Short.MAX_VALUE;
        }
        boolean isContainsBigLobSupported = dialect instanceof OracleSymmetricDialect || dialect instanceof FirebirdSymmetricDialect || dialect instanceof InterbaseSymmetricDialect;
        IConfigurationService configService = this.a.getConfigurationService();
        HashMap tablesMap = SnapshotUtil.getTablesForCaptureByCatalogSchema((ISymmetricEngine)this.a);
        List historyList = this.a.getTriggerRouterService().getActiveTriggerHistories();
        HashSet<String> wideTableNameSet = new HashSet<String>();
        HashSet<String> wideTriggerIdSet = new HashSet<String>();
        HashSet<String> lobTableNameSet = new HashSet<String>();
        HashSet<String> lobTriggerIdSet = new HashSet<String>();
        for (List tableList : tablesMap.values()) {
            for (Table table : tableList) {
                Trigger trigger;
                int width = 0;
                boolean hasLobs = false;
                for (Column column : table.getColumns()) {
                    int type = column.getMappedTypeCode();
                    if (type == 2005 || type == 2004 || type == -1 || type == -16 || type == -4 || type == 2011 || type == 2009) {
                        hasLobs = true;
                        continue;
                    }
                    if (type == -2 || type == -3) {
                        width += column.getSizeAsInt() * 2;
                        continue;
                    }
                    if (type == 16 || type == -7) {
                        width += 2;
                        continue;
                    }
                    if (type == 92) {
                        width += 12;
                        continue;
                    }
                    if (type == 2013) {
                        width += 18;
                        continue;
                    }
                    if (type == 93) {
                        width += 24;
                        continue;
                    }
                    if (type == 2014) {
                        width += 30;
                        continue;
                    }
                    width += column.getSizeAsInt() + 1;
                }
                if (width <= maxWidth && !hasLobs || (trigger = this.a(table.getFullyQualifiedTableName(), historyList)) == null) continue;
                if (isContainsBigLobSupported) {
                    Channel channel = configService.getChannel(trigger.getChannelId());
                    if (channel == null || trigger.isUseCaptureLobs() && channel.isContainsBigLob()) continue;
                    if (width > maxWidth) {
                        wideTableNameSet.add(table.getQualifiedTableName());
                        wideTriggerIdSet.add(trigger.getTriggerId());
                        continue;
                    }
                    if (trigger.isUseStreamLobs()) continue;
                    lobTableNameSet.add(table.getQualifiedTableName());
                    lobTriggerIdSet.add(trigger.getTriggerId());
                    continue;
                }
                if (trigger.isUseCaptureLobs()) continue;
                if (width > maxWidth) {
                    wideTableNameSet.add(table.getQualifiedTableName());
                    wideTriggerIdSet.add(trigger.getTriggerId());
                    continue;
                }
                if (trigger.isUseStreamLobs()) continue;
                lobTableNameSet.add(table.getQualifiedTableName());
                lobTriggerIdSet.add(trigger.getTriggerId());
            }
        }
        int wideTableCount = wideTableNameSet.size();
        int lobTableCount = lobTableNameSet.size();
        int tableCount = wideTableCount + lobTableCount;
        MonitorEvent event = new MonitorEvent();
        event.setValue(tableCount);
        if (tableCount > 0) {
            String tableName;
            Object problemDescription = "";
            Object optionDescription = "";
            if (wideTableCount > 0) {
                if (wideTableCount == 1) {
                    tableName = (String)wideTableNameSet.iterator().next();
                    problemDescription = (String)problemDescription + "Table " + tableName + " could store a row that is wider than " + maxWidth + " bytes, which is the limit for data capture.";
                    optionDescription = (String)optionDescription + "Enable \"Capture Row As LOB\" for the " + tableName + " table's trigger";
                    if (isContainsBigLobSupported) {
                        optionDescription = (String)optionDescription + " and \"Contains Lob or Wide Row Data\" for its channel";
                    }
                } else {
                    problemDescription = (String)problemDescription + "The following tables could store rows that are wider than " + maxWidth + " bytes, which is the limit for data capture: " + String.valueOf(wideTableNameSet) + ".";
                    optionDescription = (String)optionDescription + "Enable \"Capture Row As LOB\" for the LOB tables' triggers";
                    if (isContainsBigLobSupported) {
                        optionDescription = (String)optionDescription + " and \"Contains Lob or Wide Row Data\" for their channel(s)";
                    }
                }
                optionDescription = (String)optionDescription + ". ";
            }
            if (lobTableCount > 0) {
                if (lobTableCount == 1) {
                    tableName = (String)lobTableNameSet.iterator().next();
                    problemDescription = wideTableCount > 0 ? (String)problemDescription + " Table " + (String)lobTableNameSet.iterator().next() + " has large object data that could store a row that is wider than the limit for data capture." : (String)problemDescription + "Table " + (String)lobTableNameSet.iterator().next() + " has large object data that could store a row that is wider than " + maxWidth + " bytes, which is the limit for data capture.";
                    optionDescription = (String)optionDescription + "Enable \"Stream LOBs\" for the " + tableName + " table's trigger. ";
                } else {
                    problemDescription = wideTableCount > 0 ? (String)problemDescription + " The following tables have large object data that could store rows that are wider than the limit for data capture: " + String.valueOf(lobTableNameSet) + "." : (String)problemDescription + "The following tables have large object data that could store rows that are wider than " + maxWidth + " bytes, which is the limit for data capture: " + String.valueOf(lobTableNameSet) + ".";
                    optionDescription = (String)optionDescription + "Enable \"Stream LOBs\" for the wide tables' triggers. ";
                }
            }
            String actionDescription = "Adjust your configuration to account for wide rows.";
            gR recommendation = new gR((String)problemDescription, actionDescription, true);
            ArrayList<gR.a> options = new ArrayList<gR.a>();
            gR gR2 = recommendation;
            Objects.requireNonNull(gR2);
            options.add(gR2.new gR.a(1, ((String)optionDescription).trim()));
            recommendation.a(options);
            if (wideTableCount > 0) {
                recommendation.a("wideTriggerIdSet", wideTriggerIdSet);
            }
            if (lobTableCount > 0) {
                recommendation.a("lobTriggerIdSet", lobTriggerIdSet);
            }
            event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
        }
        return event;
    }

    private Trigger a(String tableName, List<TriggerHistory> historyList) {
        IDatabasePlatform platform = this.a.getDatabasePlatform();
        String triggerId = null;
        for (TriggerHistory history : historyList) {
            String schemaName;
            String catalogName = history.getSourceCatalogName() != null ? history.getSourceCatalogName() : platform.getDefaultCatalog();
            if (!Table.getFullyQualifiedTableName((String)catalogName, (String)(schemaName = history.getSourceSchemaName() != null ? history.getSourceSchemaName() : platform.getDefaultSchema()), (String)history.getSourceTableName()).equalsIgnoreCase(tableName)) continue;
            triggerId = history.getTriggerId();
            break;
        }
        if (triggerId != null) {
            return this.a.getTriggerRouterService().getTriggerById(triggerId);
        }
        return null;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        Collection lobTriggerIdSet;
        Trigger trigger;
        ISymmetricDialect dialect = this.a.getTargetDialect();
        boolean isContainsBigLobSupported = dialect instanceof OracleSymmetricDialect || dialect instanceof FirebirdSymmetricDialect || dialect instanceof InterbaseSymmetricDialect;
        ITriggerRouterService triggerRouterService = this.a.getTriggerRouterService();
        IConfigurationService configService = this.a.getConfigurationService();
        IConsoleEventService consoleEventService = (IConsoleEventService)this.a.getExtensionService().getExtensionPoint(IConsoleEventService.class);
        String nodeId = this.a.getNodeId();
        HashSet<String> modifiedTriggerIdSet = new HashSet<String>();
        Collection wideTriggerIdSet = (Collection)recommendation.c("wideTriggerIdSet");
        if (wideTriggerIdSet != null) {
            HashSet<String> modifiedChannelIdSet = new HashSet<String>();
            for (String triggerId : wideTriggerIdSet) {
                Channel channel;
                trigger = triggerRouterService.getTriggerById(triggerId);
                if (trigger == null) continue;
                if (!trigger.isUseCaptureLobs()) {
                    trigger.setUseCaptureLobs(true);
                    triggerRouterService.saveTrigger(trigger);
                    modifiedTriggerIdSet.add(triggerId);
                }
                String channelId = trigger.getChannelId();
                if (!isContainsBigLobSupported || modifiedChannelIdSet.contains(channelId) || (channel = configService.getChannel(channelId)) == null || channel.isContainsBigLob()) continue;
                channel.setContainsBigLob(true);
                configService.saveChannel(channel, true);
                modifiedChannelIdSet.add(channelId);
            }
            if (!modifiedChannelIdSet.isEmpty()) {
                consoleEventService.addEvent(new ConsoleEvent(event.getApprovedBy(), "Channel Modified", nodeId, nodeId, null, ((Object)modifiedChannelIdSet).toString().toString()));
            }
        }
        if ((lobTriggerIdSet = (Collection)recommendation.c("lobTriggerIdSet")) != null) {
            for (String triggerId : lobTriggerIdSet) {
                trigger = triggerRouterService.getTriggerById(triggerId);
                if (trigger == null || trigger.isUseStreamLobs()) continue;
                trigger.setUseStreamLobs(true);
                triggerRouterService.saveTrigger(trigger);
                modifiedTriggerIdSet.add(triggerId);
            }
        }
        if (!modifiedTriggerIdSet.isEmpty()) {
            consoleEventService.addEvent(new ConsoleEvent(event.getApprovedBy(), "Table Capture Modified", nodeId, nodeId, null, ((Object)modifiedTriggerIdSet).toString()));
        }
        return true;
    }

    @Override
    public String b() {
        return "lob";
    }

    @Override
    public boolean a() {
        return true;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
    }
}

